/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.wizard.column.pages;

import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.user.client.ui.ListBox;
import java.util.List;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.AttributeColumnPage;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.common.DecisionTableColumnViewUtils;
import org.jboss.errai.common.client.dom.Div;
import org.jboss.errai.ui.client.local.api.IsElement;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.Templated;

@Dependent
@Templated
public class AttributeColumnPageView
implements IsElement,
AttributeColumnPage.View {
    private AttributeColumnPage page;
    @DataField(value="attributeList")
    private ListBox attributeList;
    @DataField(value="attributeDescription")
    private Div attributeDescription;

    @Inject
    public AttributeColumnPageView(ListBox attributeList, Div attributeDescription) {
        this.attributeList = attributeList;
        this.attributeDescription = attributeDescription;
    }

    public void init(AttributeColumnPage page) {
        this.page = page;
        this.hideAttributeDescription();
    }

    @EventHandler(value={"attributeList"})
    public void onSelectAttribute(ChangeEvent event) {
        this.page.selectItem(this.attributeList.getSelectedItemText());
        this.attributeDescription.setAttribute("data-enabled", this.attributeList.getSelectedValue());
        if (this.isAttributeDescriptionHidden()) {
            this.showAttributeDescription();
        }
    }

    @Override
    public void setupAttributeList(List<String> attributes) {
        this.attributeList.clear();
        attributes.forEach(arg_0 -> ((ListBox)this.attributeList).addItem(arg_0));
        this.attributeList.setVisibleItemCount(this.attributeList.getItemCount());
        this.attributeList.setSelectedIndex(this.attributeIndex());
    }

    @Override
    public boolean isAttributeDescriptionHidden() {
        return this.attributeDescription.getHidden();
    }

    @Override
    public void hideAttributeDescription() {
        this.attributeDescription.setHidden(true);
    }

    @Override
    public void showAttributeDescription() {
        this.attributeDescription.setHidden(false);
    }

    private int attributeIndex() {
        return DecisionTableColumnViewUtils.getCurrentIndexFromListWithoutDefaultSelect(this.page.selectedAttribute(), this.attributeList);
    }
}

