/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.wizard.column.plugins.commons;

import org.drools.workbench.models.datamodel.rule.FactPattern;
import org.drools.workbench.screens.guided.dtable.client.resources.i18n.GuidedDecisionTableConstants;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.common.DecisionTableColumnViewUtils;

public class PatternWrapper {
    public static final PatternWrapper DEFAULT = new PatternWrapper();
    private String boundName = "";
    private String factType = "";
    private Boolean negated = null;
    private String entryPointName = "";

    public PatternWrapper(String factType, String boundName) {
        this(factType, boundName, null);
    }

    public PatternWrapper(String factType, String boundName, Boolean negated) {
        this(factType, boundName, null, negated);
    }

    public PatternWrapper(String factType, String boundName, String entryPointName, Boolean negated) {
        this.factType = factType;
        this.boundName = boundName;
        this.entryPointName = entryPointName;
        this.negated = negated;
    }

    public PatternWrapper() {
    }

    private static String not() {
        return GuidedDecisionTableConstants.INSTANCE.negatedPattern();
    }

    public String key() {
        if (DecisionTableColumnViewUtils.nil(this.factType)) {
            return "";
        }
        return this.factType + " " + this.boundName + " " + this.negateAsString(this.negated);
    }

    public String name() {
        if (DecisionTableColumnViewUtils.nil(this.factType)) {
            return "";
        }
        return this.prefix() + this.factType + " [" + this.boundName + "]";
    }

    public boolean isNegated() {
        if (this.negated == null) {
            return false;
        }
        return this.negated;
    }

    private String negateAsString(Boolean negated) {
        if (negated == null) {
            return "";
        }
        return String.valueOf(negated);
    }

    private String prefix() {
        if (this.negated == null) {
            return "";
        }
        return this.negated != false ? PatternWrapper.not() + " " : "";
    }

    public String getEntryPointName() {
        return this.entryPointName;
    }

    public void setEntryPointName(String entryPointName) {
        this.entryPointName = entryPointName;
    }

    public String getFactType() {
        return this.factType;
    }

    public String getBoundName() {
        return this.boundName;
    }

    public FactPattern makeFactPattern() {
        FactPattern factPattern = new FactPattern();
        factPattern.setBoundName(this.getBoundName());
        factPattern.setFactType(this.getFactType());
        return factPattern;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PatternWrapper that = (PatternWrapper)o;
        if (!this.boundName.equals(that.boundName)) {
            return false;
        }
        if (!this.factType.equals(that.factType)) {
            return false;
        }
        if (this.negated != null ? !this.negated.equals(that.negated) : that.negated != null) {
            return false;
        }
        return this.entryPointName != null ? this.entryPointName.equals(that.entryPointName) : that.entryPointName == null;
    }

    public int hashCode() {
        int result = this.boundName.hashCode();
        result = ~(~result);
        result = 31 * result + this.factType.hashCode();
        result = ~(~result);
        result = 31 * result + (this.negated != null ? this.negated.hashCode() : 0);
        result = ~(~result);
        result = 31 * result + (this.entryPointName != null ? this.entryPointName.hashCode() : 0);
        result = ~(~result);
        return result;
    }
}

