/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.editor.page;

import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.drools.workbench.models.guided.dtable.shared.model.ActionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.AttributeCol52;
import org.drools.workbench.models.guided.dtable.shared.model.BaseColumn;
import org.drools.workbench.models.guided.dtable.shared.model.CompositeColumn;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.models.guided.dtable.shared.model.MetadataCol52;
import org.drools.workbench.screens.guided.dtable.client.editor.page.accordion.GuidedDecisionTableAccordion;
import org.drools.workbench.screens.guided.dtable.client.editor.page.accordion.GuidedDecisionTableAccordionItem;
import org.drools.workbench.screens.guided.dtable.client.resources.GuidedDecisionTableResources;
import org.drools.workbench.screens.guided.dtable.client.resources.i18n.GuidedDecisionTableConstants;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableModellerView;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableView;
import org.drools.workbench.screens.guided.dtable.client.widget.table.columns.control.AttributeColumnConfigRow;
import org.drools.workbench.screens.guided.dtable.client.widget.table.columns.control.ColumnLabelWidget;
import org.drools.workbench.screens.guided.dtable.client.widget.table.columns.control.ColumnManagementView;
import org.drools.workbench.screens.guided.dtable.client.widget.table.columns.control.DeleteColumnManagementAnchorWidget;
import org.drools.workbench.screens.guided.dtable.client.widget.table.events.cdi.DecisionTableSelectedEvent;
import org.drools.workbench.screens.guided.dtable.client.widget.table.events.cdi.RefreshActionsPanelEvent;
import org.drools.workbench.screens.guided.dtable.client.widget.table.events.cdi.RefreshAttributesPanelEvent;
import org.drools.workbench.screens.guided.dtable.client.widget.table.events.cdi.RefreshConditionsPanelEvent;
import org.drools.workbench.screens.guided.dtable.client.widget.table.events.cdi.RefreshMetaDataPanelEvent;
import org.drools.workbench.screens.guided.dtable.client.widget.table.model.synchronizers.ModelSynchronizer;
import org.drools.workbench.screens.guided.dtable.client.widget.table.utilities.ColumnUtilities;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.NewGuidedDecisionTableColumnWizard;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.common.DecisionTableColumnViewUtils;
import org.gwtbootstrap3.client.ui.CheckBox;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.kie.workbench.common.widgets.client.ruleselector.RuleSelector;
import org.uberfire.backend.vfs.ObservablePath;
import org.uberfire.client.mvp.UberElement;
import org.uberfire.client.mvp.UpdatedLockStatusEvent;
import org.uberfire.ext.widgets.common.client.common.popups.errors.ErrorPopup;
import org.uberfire.mvp.ParameterizedCommand;

public class ColumnsPagePresenter {
    private final View view;
    private final GuidedDecisionTableAccordion accordion;
    private final ManagedInstance<NewGuidedDecisionTableColumnWizard> wizardManagedInstance;
    private final TranslationService translationService;
    private final ManagedInstance<DeleteColumnManagementAnchorWidget> deleteColumnManagementAnchorWidgets;
    private final ManagedInstance<AttributeColumnConfigRow> attributeColumnConfigRow;
    private final ColumnManagementView conditionsPanel;
    private final ColumnManagementView actionsPanel;
    private GuidedDecisionTableModellerView.Presenter modeller;
    private RuleSelector ruleSelector;
    private VerticalPanel attributeWidget;
    private VerticalPanel metaDataWidget;
    private VerticalPanel conditionsWidget;
    private VerticalPanel actionsWidget;

    @Inject
    public ColumnsPagePresenter(View view, GuidedDecisionTableAccordion accordion, ManagedInstance<NewGuidedDecisionTableColumnWizard> wizardManagedInstance, TranslationService translationService, ManagedInstance<DeleteColumnManagementAnchorWidget> deleteColumnManagementAnchorWidgets, ManagedInstance<AttributeColumnConfigRow> attributeColumnConfigRow, ColumnManagementView conditionsPanel, ColumnManagementView actionsPanel) {
        this.view = view;
        this.accordion = accordion;
        this.wizardManagedInstance = wizardManagedInstance;
        this.translationService = translationService;
        this.deleteColumnManagementAnchorWidgets = deleteColumnManagementAnchorWidgets;
        this.attributeColumnConfigRow = attributeColumnConfigRow;
        this.conditionsPanel = conditionsPanel;
        this.actionsPanel = actionsPanel;
    }

    @PostConstruct
    public void setup() {
        this.view.init(this);
    }

    public View getView() {
        return this.view;
    }

    public void init(GuidedDecisionTableModellerView.Presenter modeller) {
        this.modeller = modeller;
        this.setupAccordion();
        this.setupRuleInheritance();
        this.setupColumnsNoteInfo(modeller);
        this.setupConditionsPanel(modeller);
        this.setupActionsPanel(modeller);
    }

    void setupConditionsPanel(GuidedDecisionTableModellerView.Presenter modeller) {
        this.getConditionsPanel().init(modeller);
    }

    void setupActionsPanel(GuidedDecisionTableModellerView.Presenter modeller) {
        this.getActionsPanel().init(modeller);
    }

    void setupAccordionWidgets() {
        this.setupAccordionWidget(GuidedDecisionTableAccordionItem.Type.ATTRIBUTE, this::setAttributeWidget);
        this.setupAccordionWidget(GuidedDecisionTableAccordionItem.Type.METADATA, this::setMetaDataWidget);
        this.setupAccordionWidget(GuidedDecisionTableAccordionItem.Type.CONDITION, this::setConditionsWidget);
        this.setupAccordionWidget(GuidedDecisionTableAccordionItem.Type.ACTION, this::setActionsWidget);
    }

    void setupAccordionWidget(GuidedDecisionTableAccordionItem.Type accordionType, Consumer<VerticalPanel> setWidget) {
        VerticalPanel defaultPanel = this.makeDefaultPanel();
        setWidget.accept(defaultPanel);
        this.accordion.addItem(accordionType, (Widget)defaultPanel);
    }

    VerticalPanel getAttributeWidget() {
        return this.attributeWidget;
    }

    private void setAttributeWidget(VerticalPanel attributeWidget) {
        this.attributeWidget = attributeWidget;
    }

    VerticalPanel getMetaDataWidget() {
        return this.metaDataWidget;
    }

    private void setMetaDataWidget(VerticalPanel metaDataWidget) {
        this.metaDataWidget = metaDataWidget;
    }

    VerticalPanel getConditionsWidget() {
        return this.conditionsWidget;
    }

    private void setConditionsWidget(VerticalPanel conditionsWidget) {
        this.conditionsWidget = conditionsWidget;
    }

    VerticalPanel getActionsWidget() {
        return this.actionsWidget;
    }

    private void setActionsWidget(VerticalPanel actionsWidget) {
        this.actionsWidget = actionsWidget;
    }

    VerticalPanel makeDefaultPanel() {
        VerticalPanel verticalPanel = new VerticalPanel();
        verticalPanel.add((Widget)this.blankSlate());
        return verticalPanel;
    }

    Label blankSlate() {
        String disabledLabelStyle = "text-muted";
        final String noColumns = GuidedDecisionTableConstants.INSTANCE.NoColumnsAvailable();
        return new Label(){
            {
                this.setText(noColumns);
                this.setStyleName("text-muted");
            }
        };
    }

    void refreshAttributeWidget(List<AttributeCol52> attributeColumns) {
        Optional<GuidedDecisionTableModellerView.Presenter> optionalModeller = Optional.ofNullable(this.getModeller());
        VerticalPanel attributeWidget = this.getAttributeWidget();
        if (!optionalModeller.isPresent()) {
            return;
        }
        GuidedDecisionTableModellerView.Presenter modeller = optionalModeller.get();
        attributeWidget.clear();
        if (attributeColumns.isEmpty()) {
            attributeWidget.add((Widget)this.blankSlate());
            return;
        }
        for (AttributeCol52 attributeColumn : attributeColumns) {
            AttributeColumnConfigRow columnConfigRow = (AttributeColumnConfigRow)this.attributeColumnConfigRow.get();
            columnConfigRow.init(attributeColumn, modeller);
            attributeWidget.add(columnConfigRow.getView());
        }
    }

    void refreshMetaDataWidget(List<MetadataCol52> metaDataColumns) {
        Optional<GuidedDecisionTableModellerView.Presenter> optionalModeller = Optional.ofNullable(this.getModeller());
        VerticalPanel metaDataWidget = this.getMetaDataWidget();
        if (!optionalModeller.isPresent()) {
            return;
        }
        GuidedDecisionTableModellerView.Presenter modeller = optionalModeller.get();
        metaDataWidget.clear();
        if (metaDataColumns.isEmpty()) {
            metaDataWidget.add((Widget)this.blankSlate());
            return;
        }
        for (MetadataCol52 metaDataColumn : metaDataColumns) {
            metaDataWidget.add((Widget)this.makeMetaDataWidget(modeller, metaDataColumn));
        }
    }

    HorizontalPanel makeMetaDataWidget(GuidedDecisionTableModellerView.Presenter modeller, MetadataCol52 metaDataColumn) {
        HorizontalPanel horizontalPanel = this.makeHorizontalPanel();
        ColumnLabelWidget label = this.makeColumnLabel(metaDataColumn);
        boolean isEditable = modeller.isActiveDecisionTableEditable();
        horizontalPanel.setVerticalAlignment(HasVerticalAlignment.ALIGN_MIDDLE);
        horizontalPanel.add((Widget)label);
        horizontalPanel.add((Widget)this.hideColumnCheckBox(modeller, metaDataColumn));
        if (isEditable) {
            horizontalPanel.add((Widget)this.deleteMetaDataColumnAnchor(modeller, metaDataColumn));
        }
        return horizontalPanel;
    }

    HorizontalPanel makeHorizontalPanel() {
        return new HorizontalPanel();
    }

    DeleteColumnManagementAnchorWidget deleteMetaDataColumnAnchor(GuidedDecisionTableModellerView.Presenter modeller, MetadataCol52 metaDataColumn) {
        DeleteColumnManagementAnchorWidget deleteWidget = (DeleteColumnManagementAnchorWidget)((Object)this.deleteColumnManagementAnchorWidgets.get());
        Command deleteMetadataCommand = this.deleteMetadataCommand(modeller, metaDataColumn);
        deleteWidget.init(metaDataColumn.getMetadata(), deleteMetadataCommand);
        return deleteWidget;
    }

    Command deleteMetadataCommand(GuidedDecisionTableModellerView.Presenter modeller, MetadataCol52 metaDataColumn) {
        return () -> {
            try {
                Optional<GuidedDecisionTableView.Presenter> dtPresenter = modeller.getActiveDecisionTable();
                if (dtPresenter.isPresent()) {
                    dtPresenter.get().deleteColumn(metaDataColumn);
                }
            }
            catch (ModelSynchronizer.VetoException veto) {
                this.showGenericVetoMessage();
            }
        };
    }

    GuidedDecisionTableModellerView.Presenter getModeller() {
        return this.modeller;
    }

    CheckBox hideColumnCheckBox(GuidedDecisionTableModellerView.Presenter modeller, MetadataCol52 metaDataColumn) {
        String label = GuidedDecisionTableConstants.INSTANCE.HideThisColumn() + ":";
        CheckBox hideColumnCheckBox = this.makeCheckBox(label);
        hideColumnCheckBox.setValue(Boolean.valueOf(metaDataColumn.isHideColumn()));
        hideColumnCheckBox.addClickHandler(this.hideMetadataClickHandler(modeller, hideColumnCheckBox, metaDataColumn));
        return hideColumnCheckBox;
    }

    CheckBox makeCheckBox(String label) {
        return new CheckBox(label);
    }

    ClickHandler hideMetadataClickHandler(GuidedDecisionTableModellerView.Presenter modeller, CheckBox chkHideColumn, MetadataCol52 metaDataColumn) {
        return event -> {
            MetadataCol52 editedColumn = metaDataColumn.cloneColumn();
            editedColumn.setHideColumn(chkHideColumn.getValue().booleanValue());
            try {
                Optional<GuidedDecisionTableView.Presenter> dtPresenter = modeller.getActiveDecisionTable();
                if (dtPresenter.isPresent()) {
                    dtPresenter.get().updateColumn(metaDataColumn, editedColumn);
                }
            }
            catch (ModelSynchronizer.VetoException veto) {
                this.showGenericVetoMessage();
            }
        };
    }

    void refreshConditionsWidget(List<CompositeColumn<? extends BaseColumn>> conditionColumns) {
        VerticalPanel conditionsWidget = this.getConditionsWidget();
        conditionsWidget.clear();
        if (conditionColumns.isEmpty()) {
            this.getAccordion().getItem(GuidedDecisionTableAccordionItem.Type.CONDITION).setOpen(false);
            conditionsWidget.add((Widget)this.blankSlate());
            return;
        }
        conditionsWidget.add((Widget)this.getConditionsPanel());
        Map<String, List<BaseColumn>> columnGroups = this.groupByTitle(conditionColumns);
        this.getConditionsPanel().renderColumns(columnGroups);
    }

    <T extends BaseColumn> Map<String, List<BaseColumn>> groupByTitle(List<T> columns) {
        return columns.stream().collect(Collectors.groupingBy(DecisionTableColumnViewUtils::getColumnManagementGroupTitle, Collectors.toList()));
    }

    ColumnManagementView getConditionsPanel() {
        return this.conditionsPanel;
    }

    void refreshActionsWidget(List<ActionCol52> actionColumns) {
        VerticalPanel actionsWidget = this.getActionsWidget();
        actionsWidget.clear();
        if (actionColumns.isEmpty()) {
            this.getAccordion().getItem(GuidedDecisionTableAccordionItem.Type.ACTION).setOpen(false);
            actionsWidget.add((Widget)this.blankSlate());
            return;
        }
        actionsWidget.add((Widget)this.getActionsPanel());
        Map<String, List<BaseColumn>> columnGroups = this.groupByTitle(actionColumns);
        this.getActionsPanel().renderColumns(columnGroups);
    }

    ColumnManagementView getActionsPanel() {
        return this.actionsPanel;
    }

    public void onUpdatedLockStatusEvent(@Observes UpdatedLockStatusEvent event) {
        if (!this.hasActiveDecisionTable()) {
            return;
        }
        this.getActiveDecisionTable().ifPresent(dt -> {
            ObservablePath currentPath = dt.getCurrentPath();
            if (currentPath.equals(event.getFile())) {
                this.refresh();
            }
        });
    }

    private Optional<GuidedDecisionTableView.Presenter> getActiveDecisionTable() {
        return this.getModeller().getActiveDecisionTable();
    }

    boolean hasActiveDecisionTable() {
        Optional<GuidedDecisionTableModellerView.Presenter> modeller = Optional.ofNullable(this.getModeller());
        if (!modeller.isPresent()) {
            return false;
        }
        return Optional.ofNullable(this.getActiveDecisionTable()).isPresent();
    }

    public void onRefreshAttributesPanelEvent(@Observes RefreshAttributesPanelEvent event) {
        this.refreshAttributeWidget(event.getColumns());
        this.refreshColumnsNoteInfo(event.getPresenter());
    }

    public void onRefreshMetaDataPanelEvent(@Observes RefreshMetaDataPanelEvent event) {
        this.refreshMetaDataWidget(event.getColumns());
        this.refreshColumnsNoteInfo(event.getPresenter());
    }

    public void onRefreshConditionsPanelEvent(@Observes RefreshConditionsPanelEvent event) {
        this.refreshConditionsWidget(event.getColumns());
        this.refreshColumnsNoteInfo(event.getPresenter());
    }

    public void onRefreshActionsPanelEvent(@Observes RefreshActionsPanelEvent event) {
        this.refreshActionsWidget(event.getColumns());
        this.refreshColumnsNoteInfo(event.getPresenter());
    }

    void showGenericVetoMessage() {
        ErrorPopup.showMessage((String)this.translate("NewGuidedDecisionTableColumnWizard.GenericVetoError", new Object[0]));
    }

    ColumnLabelWidget makeColumnLabel(MetadataCol52 metaDataColumn) {
        ColumnLabelWidget label = new ColumnLabelWidget(metaDataColumn.getMetadata());
        ColumnUtilities.setColumnLabelStyleWhenHidden(label, metaDataColumn.isHideColumn());
        return label;
    }

    private String translate(String key, Object ... args) {
        return this.translationService.format(key, args);
    }

    Optional<GuidedDecisionTable52> getGuidedDecisionTable52() {
        Optional<GuidedDecisionTableView.Presenter> activeDecisionTable = this.getActiveDecisionTable();
        if (activeDecisionTable.isPresent()) {
            return Optional.of(activeDecisionTable.get().getModel());
        }
        return Optional.empty();
    }

    public GuidedDecisionTableAccordion getAccordion() {
        return this.accordion;
    }

    void setupColumnsNoteInfo(GuidedDecisionTableModellerView.Presenter modeller) {
        Optional<GuidedDecisionTableView.Presenter> activeDecisionTable = modeller.getActiveDecisionTable();
        if (activeDecisionTable.isPresent()) {
            if (activeDecisionTable.get().hasColumnDefinitions()) {
                this.view.setColumnsNoteInfoAsHidden();
            } else {
                this.view.setColumnsNoteInfoAsVisible();
            }
        } else {
            this.view.setColumnsNoteInfoAsVisible();
        }
    }

    void refreshColumnsNoteInfo(GuidedDecisionTableView.Presenter presenter) {
        this.setupColumnsNoteInfo(presenter.getModellerPresenter());
    }

    void setupAccordion() {
        this.accordion.clear();
        this.setupAccordionWidgets();
        this.view.setAccordion(this.accordion);
    }

    void setupRuleInheritance() {
        this.view.setRuleInheritanceWidget((IsWidget)new FlowPanel(){
            {
                this.add(ColumnsPagePresenter.this.ruleInheritanceWidget());
            }
        });
    }

    Widget ruleInheritanceWidget() {
        FlowPanel result = this.makeFlowPanel();
        result.setStyleName(GuidedDecisionTableResources.INSTANCE.css().ruleInheritance());
        result.add((Widget)this.ruleInheritanceLabel());
        result.add(this.ruleSelector());
        return result;
    }

    FlowPanel makeFlowPanel() {
        return new FlowPanel();
    }

    Widget ruleSelector() {
        this.ruleSelector = this.makeRuleSelector();
        this.ruleSelector.addValueChangeHandler(e -> this.getActiveDecisionTable().ifPresent(dt -> dt.setParentRuleName((String)e.getValue())));
        this.getActiveDecisionTable().ifPresent(this::setupRuleSelector);
        return this.ruleSelector;
    }

    Label ruleInheritanceLabel() {
        Label label = new Label(GuidedDecisionTableConstants.INSTANCE.AllTheRulesInherit());
        label.setStyleName(GuidedDecisionTableResources.INSTANCE.css().ruleInheritanceLabel());
        return label;
    }

    RuleSelector makeRuleSelector() {
        return new RuleSelector();
    }

    void setupRuleSelector(GuidedDecisionTableView.Presenter presenter) {
        if (presenter == null) {
            return;
        }
        GuidedDecisionTable52 model = presenter.getModel();
        String ruleName = model.getParentName();
        presenter.getPackageParentRuleNames((ParameterizedCommand<Collection<String>>)((ParameterizedCommand)availableParentRuleNames -> {
            this.ruleSelector.setRuleName(ruleName);
            this.ruleSelector.setRuleNames(availableParentRuleNames);
        }));
    }

    void openNewGuidedDecisionTableColumnWizard() {
        if (!this.isColumnCreationEnabledToActiveDecisionTable()) {
            return;
        }
        this.getActiveDecisionTable().ifPresent(dt -> {
            NewGuidedDecisionTableColumnWizard wizard = (NewGuidedDecisionTableColumnWizard)((Object)((Object)this.wizardManagedInstance.get()));
            wizard.init((GuidedDecisionTableView.Presenter)dt);
            wizard.start();
        });
    }

    boolean isColumnCreationEnabledToActiveDecisionTable() {
        return this.hasActiveDecisionTable() && this.isColumnCreationEnabled(this.getActiveDecisionTable());
    }

    boolean isColumnCreationEnabled(Optional<GuidedDecisionTableView.Presenter> dtPresenter) {
        if (!dtPresenter.isPresent()) {
            return false;
        }
        GuidedDecisionTableView.Presenter dt = dtPresenter.get();
        boolean decisionTableIsEditable = !dt.isReadOnly();
        boolean decisionTableHasEditableColumns = dt.hasEditableColumns();
        return decisionTableHasEditableColumns && decisionTableIsEditable;
    }

    public void onDecisionTableSelected(@Observes DecisionTableSelectedEvent event) {
        if (!this.hasActiveDecisionTable()) {
            return;
        }
        Optional<GuidedDecisionTableView.Presenter> dtPresenter = event.getPresenter();
        if (!dtPresenter.isPresent()) {
            return;
        }
        GuidedDecisionTableView.Presenter presenter = dtPresenter.get();
        this.getActiveDecisionTable().ifPresent(dt -> {
            if (!presenter.equals(dt)) {
                this.setupRuleSelector(presenter);
            }
        });
    }

    public void refresh() {
        this.getGuidedDecisionTable52().ifPresent(model -> {
            this.refreshAttributeWidget(model.getAttributeCols());
            this.refreshMetaDataWidget(model.getMetadataCols());
            this.refreshConditionsWidget(model.getConditions());
            this.refreshActionsWidget(model.getActionCols());
        });
    }

    public static interface View
    extends UberElement<ColumnsPagePresenter> {
        public void setAccordion(GuidedDecisionTableAccordion var1);

        public void setRuleInheritanceWidget(IsWidget var1);

        public void setColumnsNoteInfoAsVisible();

        public void setColumnsNoteInfoAsHidden();
    }
}

