/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.analysis;

import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.DTableUpdateManager;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.DecisionTableAnalyzer;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.FieldTypeProducer;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.Poster;
import org.drools.workbench.services.verifier.plugin.client.api.DrlInitialize;
import org.drools.workbench.services.verifier.plugin.client.builders.ModelMetaDataEnhancer;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.kie.workbench.common.services.shared.preferences.ApplicationPreferences;
import org.kie.workbench.common.services.verifier.api.client.api.Initialize;
import org.kie.workbench.common.services.verifier.reporting.client.analysis.AnalysisReporter;
import org.kie.workbench.common.services.verifier.reporting.client.analysis.Receiver;
import org.kie.workbench.common.services.verifier.reporting.client.analysis.VerifierWebWorkerConnection;
import org.kie.workbench.common.services.verifier.reporting.client.analysis.VerifierWebWorkerConnectionImpl;
import org.kie.workbench.common.services.verifier.reporting.client.panel.AnalysisReportScreen;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracle;
import org.uberfire.commons.uuid.UUID;
import org.uberfire.mvp.PlaceRequest;

public class DecisionTableAnalyzerBuilder {
    protected PlaceRequest placeRequest;
    protected AsyncPackageDataModelOracle oracle;
    protected GuidedDecisionTable52 model;
    protected AnalysisReportScreen analysisReportScreen;
    protected DTableUpdateManager updateManager;
    private AnalysisReporter analysisReporter;
    private DecisionTableAnalyzer decisionTableAnalyzer;
    private VerifierWebWorkerConnectionImpl webWorker;
    private FieldTypeProducer fieldTypeProducer;
    private Poster poster;

    public DecisionTableAnalyzerBuilder withPlaceRequest(PlaceRequest placeRequest) {
        this.placeRequest = placeRequest;
        return this;
    }

    public DecisionTableAnalyzerBuilder withOracle(AsyncPackageDataModelOracle oracle) {
        this.oracle = oracle;
        this.fieldTypeProducer = new FieldTypeProducer(oracle);
        return this;
    }

    public DecisionTableAnalyzerBuilder withModel(GuidedDecisionTable52 model) {
        this.model = model;
        return this;
    }

    public DecisionTableAnalyzerBuilder withReportScreen(AnalysisReportScreen analysisReportScreen) {
        this.analysisReportScreen = analysisReportScreen;
        return this;
    }

    public DecisionTableAnalyzer build() {
        PortablePreconditions.checkNotNull((String)"placeRequest", (Object)this.placeRequest);
        PortablePreconditions.checkNotNull((String)"oracle", (Object)this.oracle);
        PortablePreconditions.checkNotNull((String)"model", (Object)this.model);
        PortablePreconditions.checkNotNull((String)"analysisReportScreen", (Object)this.analysisReportScreen);
        return this.getDTableAnalyzer();
    }

    private VerifierWebWorkerConnectionImpl getWebWorker() {
        if (this.webWorker == null) {
            this.webWorker = new VerifierWebWorkerConnectionImpl((Initialize)new DrlInitialize(UUID.uuid(), this.model, new ModelMetaDataEnhancer(this.model).getHeaderMetaData(), this.fieldTypeProducer.getFactTypes(), ApplicationPreferences.getDroolsDateFormat()), "verifier/dtableVerifier/dtableVerifier.nocache.js", (org.kie.workbench.common.services.verifier.reporting.client.analysis.Poster)this.getPoster(), new Receiver(this.getAnalysisReporter()));
        }
        return this.webWorker;
    }

    private Poster getPoster() {
        if (this.poster == null) {
            this.poster = new Poster();
        }
        return this.poster;
    }

    protected AnalysisReporter getAnalysisReporter() {
        if (this.analysisReporter == null) {
            this.analysisReporter = new AnalysisReporter(this.placeRequest, this.analysisReportScreen);
        }
        return this.analysisReporter;
    }

    private DTableUpdateManager getUpdateManager() {
        if (this.updateManager == null) {
            this.updateManager = new DTableUpdateManager(this.getPoster(), this.fieldTypeProducer);
        }
        return this.updateManager;
    }

    private DecisionTableAnalyzer getDTableAnalyzer() {
        if (this.decisionTableAnalyzer == null) {
            this.reset();
            this.decisionTableAnalyzer = new DecisionTableAnalyzer(this.model, this.getUpdateManager(), (VerifierWebWorkerConnection)this.getWebWorker());
        }
        return this.decisionTableAnalyzer;
    }

    private void reset() {
        this.poster = null;
    }
}

