/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.table.utilities;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.drools.workbench.models.guided.dtable.shared.model.ActionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.ActionInsertFactCol52;
import org.drools.workbench.models.guided.dtable.shared.model.ActionSetFieldCol52;
import org.drools.workbench.models.guided.dtable.shared.model.BaseColumn;
import org.drools.workbench.models.guided.dtable.shared.model.ConditionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.DTCellValue52;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.models.guided.dtable.shared.model.LimitedEntryCol;
import org.drools.workbench.models.guided.dtable.shared.model.Pattern52;
import org.drools.workbench.screens.guided.dtable.client.widget.table.utilities.CellUtilities;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracle;
import org.kie.workbench.common.widgets.decoratedgrid.client.widget.DropDownDataValueMapProvider;

public class LimitedEntryDropDownManager
implements DropDownDataValueMapProvider<Context> {
    protected final GuidedDecisionTable52 model;
    protected final AsyncPackageDataModelOracle oracle;
    protected final CellUtilities utilities;

    public LimitedEntryDropDownManager(GuidedDecisionTable52 model, AsyncPackageDataModelOracle oracle) {
        this.model = (GuidedDecisionTable52)PortablePreconditions.checkNotNull((String)"model", (Object)model);
        this.oracle = (AsyncPackageDataModelOracle)PortablePreconditions.checkNotNull((String)"oracle", (Object)oracle);
        this.utilities = new CellUtilities();
    }

    public Map<String, String> getCurrentValueMap(Context context) {
        HashMap<String, String> currentValueMap;
        block4: {
            BaseColumn baseColumn;
            block5: {
                block3: {
                    currentValueMap = new HashMap<String, String>();
                    Pattern52 basePattern = context.getBasePattern();
                    baseColumn = context.getBaseColumn();
                    if (!(baseColumn instanceof ConditionCol52) || basePattern == null) break block3;
                    for (ConditionCol52 cc : basePattern.getChildColumns()) {
                        if (!(cc instanceof LimitedEntryCol)) continue;
                        currentValueMap.put(cc.getFactField(), this.getValue((LimitedEntryCol)cc));
                    }
                    break block4;
                }
                if (!(baseColumn instanceof ActionSetFieldCol52)) break block5;
                ActionSetFieldCol52 baseActionColumn = (ActionSetFieldCol52)baseColumn;
                String binding = baseActionColumn.getBoundName();
                for (ActionCol52 ac : this.model.getActionCols()) {
                    ActionSetFieldCol52 asf;
                    if (!(ac instanceof ActionSetFieldCol52) || !(asf = (ActionSetFieldCol52)ac).getBoundName().equals(binding) || !(asf instanceof LimitedEntryCol)) continue;
                    currentValueMap.put(asf.getFactField(), this.getValue((LimitedEntryCol)asf));
                }
                break block4;
            }
            if (!(baseColumn instanceof ActionInsertFactCol52)) break block4;
            ActionInsertFactCol52 baseActionColumn = (ActionInsertFactCol52)baseColumn;
            String binding = baseActionColumn.getBoundName();
            for (ActionCol52 ac : this.model.getActionCols()) {
                ActionInsertFactCol52 aif;
                if (!(ac instanceof ActionInsertFactCol52) || !(aif = (ActionInsertFactCol52)ac).getBoundName().equals(binding) || !(aif instanceof LimitedEntryCol)) continue;
                currentValueMap.put(aif.getFactField(), this.getValue((LimitedEntryCol)aif));
            }
        }
        return currentValueMap;
    }

    private String getValue(LimitedEntryCol lec) {
        if (lec == null || lec.getValue() == null) {
            return "";
        }
        DTCellValue52 lev = lec.getValue();
        return this.utilities.asString(lev);
    }

    public Set<Integer> getDependentColumnIndexes(Context context) {
        HashSet<Integer> dependentColumnIndexes;
        block4: {
            BaseColumn baseColumn;
            block5: {
                Pattern52 basePattern;
                block3: {
                    dependentColumnIndexes = new HashSet<Integer>();
                    basePattern = context.getBasePattern();
                    baseColumn = context.getBaseColumn();
                    if (!(baseColumn instanceof ConditionCol52) || basePattern == null) break block3;
                    ConditionCol52 baseConditionColumn = (ConditionCol52)baseColumn;
                    for (ConditionCol52 cc : basePattern.getChildColumns()) {
                        if (!this.oracle.isDependentEnum(basePattern.getFactType(), baseConditionColumn.getFactField(), cc.getFactField())) continue;
                        dependentColumnIndexes.add(this.model.getExpandedColumns().indexOf(cc));
                    }
                    break block4;
                }
                if (!(baseColumn instanceof ActionSetFieldCol52) || basePattern == null) break block5;
                ActionSetFieldCol52 baseActionColumn = (ActionSetFieldCol52)baseColumn;
                String binding = baseActionColumn.getBoundName();
                for (ActionCol52 ac : this.model.getActionCols()) {
                    ActionSetFieldCol52 asf;
                    if (!(ac instanceof ActionSetFieldCol52) || !(asf = (ActionSetFieldCol52)ac).getBoundName().equals(binding) || !this.oracle.isDependentEnum(basePattern.getFactType(), baseActionColumn.getFactField(), asf.getFactField())) continue;
                    dependentColumnIndexes.add(this.model.getExpandedColumns().indexOf(ac));
                }
                break block4;
            }
            if (!(baseColumn instanceof ActionInsertFactCol52)) break block4;
            ActionInsertFactCol52 baseActionColumn = (ActionInsertFactCol52)baseColumn;
            String binding = baseActionColumn.getBoundName();
            for (ActionCol52 ac : this.model.getActionCols()) {
                ActionInsertFactCol52 aif;
                if (!(ac instanceof ActionInsertFactCol52) || !(aif = (ActionInsertFactCol52)ac).getBoundName().equals(binding) || !this.oracle.isDependentEnum(baseActionColumn.getFactType(), baseActionColumn.getFactField(), aif.getFactField())) continue;
                dependentColumnIndexes.add(this.model.getExpandedColumns().indexOf(ac));
            }
        }
        return dependentColumnIndexes;
    }

    public static class Context {
        private final Pattern52 basePattern;
        private final BaseColumn baseColumn;

        public Context(Pattern52 basePattern, BaseColumn baseColumn) {
            this.basePattern = basePattern;
            this.baseColumn = baseColumn;
        }

        public Context(BaseColumn baseColumn) {
            this.basePattern = null;
            this.baseColumn = baseColumn;
        }

        public Pattern52 getBasePattern() {
            return this.basePattern;
        }

        public BaseColumn getBaseColumn() {
            return this.baseColumn;
        }
    }
}

