/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.table;

import com.ait.lienzo.client.core.event.NodeMouseMoveHandler;
import com.ait.lienzo.client.core.types.Point2D;
import com.google.gwt.event.dom.client.KeyDownHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.Command;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.drools.workbench.screens.guided.dtable.client.editor.menu.RadarMenuBuilder;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableModellerContextMenuSupport;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableModellerView;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableView;
import org.drools.workbench.screens.guided.dtable.client.widget.table.events.cdi.DecisionTableColumnSelectedEvent;
import org.drools.workbench.screens.guided.dtable.client.widget.table.events.cdi.DecisionTablePinnedEvent;
import org.drools.workbench.screens.guided.dtable.client.widget.table.events.cdi.DecisionTableSelectedEvent;
import org.drools.workbench.screens.guided.dtable.client.widget.table.keyboard.DeleteAndEditCell;
import org.drools.workbench.screens.guided.dtable.client.widget.table.keyboard.DeleteCell;
import org.drools.workbench.screens.guided.dtable.client.widget.table.keyboard.EditCell;
import org.drools.workbench.screens.guided.dtable.client.widget.table.keyboard.GotoBeginningOfData;
import org.drools.workbench.screens.guided.dtable.client.widget.table.keyboard.GotoBeginningOfRow;
import org.drools.workbench.screens.guided.dtable.client.widget.table.keyboard.GotoEndOfData;
import org.drools.workbench.screens.guided.dtable.client.widget.table.keyboard.GotoEndOfRow;
import org.drools.workbench.screens.guided.dtable.client.widget.table.keyboard.SelectNextCellOnRow;
import org.drools.workbench.screens.guided.dtable.client.widget.table.keyboard.SelectPriorCellOnRow;
import org.drools.workbench.screens.guided.dtable.client.widget.table.keyboard.SelectionCopy;
import org.drools.workbench.screens.guided.dtable.client.widget.table.keyboard.SelectionCut;
import org.drools.workbench.screens.guided.dtable.client.widget.table.keyboard.SelectionPaste;
import org.drools.workbench.screens.guided.dtable.client.widget.table.popovers.ColumnHeaderPopOver;
import org.drools.workbench.screens.guided.dtable.client.widget.table.popovers.ColumnHeaderPopOverHandler;
import org.drools.workbench.screens.guided.dtable.model.GuidedDecisionTableEditorContent;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.kie.workbench.common.services.verifier.reporting.client.panel.AnalysisReportScreen;
import org.uberfire.backend.vfs.ObservablePath;
import org.uberfire.ext.wires.core.grids.client.model.Bounds;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;
import org.uberfire.ext.wires.core.grids.client.widget.grid.impl.BaseGridWidgetKeyboardHandler;
import org.uberfire.ext.wires.core.grids.client.widget.grid.impl.KeyboardOperation;
import org.uberfire.ext.wires.core.grids.client.widget.grid.impl.KeyboardOperationEditCell;
import org.uberfire.ext.wires.core.grids.client.widget.grid.impl.KeyboardOperationMoveDown;
import org.uberfire.ext.wires.core.grids.client.widget.grid.impl.KeyboardOperationMoveLeft;
import org.uberfire.ext.wires.core.grids.client.widget.grid.impl.KeyboardOperationMoveRight;
import org.uberfire.ext.wires.core.grids.client.widget.grid.impl.KeyboardOperationMoveUp;
import org.uberfire.ext.wires.core.grids.client.widget.layer.GridLayer;
import org.uberfire.ext.wires.core.grids.client.widget.layer.pinning.GridPinnedModeManager;
import org.uberfire.ext.wires.core.grids.client.widget.layer.pinning.TransformMediator;
import org.uberfire.mvp.PlaceRequest;

@Dependent
public class GuidedDecisionTableModellerPresenter
implements GuidedDecisionTableModellerView.Presenter {
    private final GuidedDecisionTableModellerView view;
    private final ManagedInstance<GuidedDecisionTableView.Presenter> dtPresenterProvider;
    private final Event<RadarMenuBuilder.UpdateRadarEvent> updateRadarEvent;
    private final Event<DecisionTablePinnedEvent> pinnedEvent;
    private final ColumnHeaderPopOver columnHeaderPopOver;
    private GuidedDecisionTableView.Presenter activeDecisionTable = null;
    private Set<GuidedDecisionTableView.Presenter> availableDecisionTables = new HashSet<GuidedDecisionTableView.Presenter>();
    private Set<HandlerRegistration> handlerRegistrations = new HashSet<HandlerRegistration>();
    private AnalysisReportScreen analysisReportScreen;

    @Inject
    public GuidedDecisionTableModellerPresenter(GuidedDecisionTableModellerView view, ManagedInstance<GuidedDecisionTableView.Presenter> dtPresenterProvider, GuidedDecisionTableModellerContextMenuSupport contextMenuSupport, Event<RadarMenuBuilder.UpdateRadarEvent> updateRadarEvent, Event<DecisionTablePinnedEvent> pinnedEvent, ColumnHeaderPopOver columnHeaderPopOver) {
        this.view = view;
        this.dtPresenterProvider = dtPresenterProvider;
        this.updateRadarEvent = updateRadarEvent;
        this.pinnedEvent = pinnedEvent;
        this.columnHeaderPopOver = columnHeaderPopOver;
        this.view.init(this);
        this.handlerRegistrations.add(view.getGridLayerView().addNodeMouseMoveHandler((NodeMouseMoveHandler)new ColumnHeaderPopOverHandler(this, columnHeaderPopOver)));
        this.handlerRegistrations.add(view.getGridLayerView().addNodeMouseOutHandler(e -> columnHeaderPopOver.hide()));
        GridLayer layer = view.getGridLayerView();
        BaseGridWidgetKeyboardHandler handler = new BaseGridWidgetKeyboardHandler(layer);
        handler.addOperation(new KeyboardOperation[]{new DeleteAndEditCell(layer), new DeleteCell(layer), new EditCell(layer), new KeyboardOperationEditCell(layer), new KeyboardOperationMoveLeft(layer), new KeyboardOperationMoveRight(layer), new KeyboardOperationMoveUp(layer), new KeyboardOperationMoveDown(layer), new SelectionCut(layer), new SelectionCopy(layer), new SelectionPaste(layer), new GotoBeginningOfRow(layer), new GotoEndOfRow(layer), new GotoBeginningOfData(layer), new GotoEndOfData(layer), new SelectNextCellOnRow(layer), new SelectPriorCellOnRow(layer)});
        this.handlerRegistrations.add(view.addKeyDownHandler((KeyDownHandler)handler));
        this.handlerRegistrations.add(view.addContextMenuHandler(contextMenuSupport.getContextMenuHandler(this)));
        this.handlerRegistrations.add(view.addMouseDownHandler(contextMenuSupport.getContextMenuMouseDownHandler()));
    }

    @Override
    public void onClose() {
        this.view.clear();
        this.releaseDecisionTables();
        this.releaseHandlerRegistrations();
    }

    @Override
    public void releaseDecisionTables() {
        this.availableDecisionTables.forEach(GuidedDecisionTableView.Presenter::onClose);
        this.availableDecisionTables.clear();
    }

    @Override
    public void releaseHandlerRegistrations() {
        this.handlerRegistrations.forEach(com.google.web.bindery.event.shared.HandlerRegistration::removeHandler);
        this.handlerRegistrations.clear();
    }

    @Override
    public GuidedDecisionTableView.Presenter addDecisionTable(ObservablePath path, PlaceRequest placeRequest, GuidedDecisionTableEditorContent content, boolean isReadOnly, Double x, Double y) {
        GuidedDecisionTableView.Presenter dtPresenter = (GuidedDecisionTableView.Presenter)this.dtPresenterProvider.get();
        dtPresenter.setContent(path, placeRequest, this.analysisReportScreen, content, this, isReadOnly);
        double dtViewX = x == null ? this.getDecisionTableX(dtPresenter) : x.doubleValue();
        double dtViewY = y == null ? this.getDecisionTableY(dtPresenter) : y.doubleValue();
        dtPresenter.getView().setLocation(dtViewX, dtViewY);
        this.availableDecisionTables.add(dtPresenter);
        this.updateLinks();
        this.view.addDecisionTable(dtPresenter.getView());
        return dtPresenter;
    }

    private double getDecisionTableX(GuidedDecisionTableView.Presenter dtPresenter) {
        Bounds bounds = this.getView().getBounds();
        double x = bounds.getX() + (bounds.getWidth() - dtPresenter.getView().getWidth()) / 2.0;
        return x;
    }

    private double getDecisionTableY(GuidedDecisionTableView.Presenter dtPresenter) {
        Bounds bounds = this.getView().getBounds();
        double y = bounds.getY() + bounds.getHeight() * 0.25;
        for (GuidedDecisionTableView.Presenter p : this.availableDecisionTables) {
            y = y + p.getView().getHeight() + 200.0;
        }
        return y;
    }

    @Override
    public GuidedDecisionTableView.Presenter refreshDecisionTable(GuidedDecisionTableView.Presenter dtPresenter, ObservablePath path, PlaceRequest placeRequest, GuidedDecisionTableEditorContent content, boolean isReadOnly) {
        Point2D oldLocation = dtPresenter.getView().getLocation();
        this.view.removeDecisionTable(dtPresenter.getView(), () -> {
            dtPresenter.refreshContent(path, placeRequest, content, isReadOnly);
            dtPresenter.getView().setLocation(oldLocation);
            this.view.addDecisionTable(dtPresenter.getView());
        });
        return dtPresenter;
    }

    @Override
    public void removeDecisionTable(GuidedDecisionTableView.Presenter dtPresenter) {
        Command afterRemovalCommand = () -> {
            this.availableDecisionTables.remove(dtPresenter);
            if (dtPresenter.equals(this.activeDecisionTable)) {
                this.activeDecisionTable = null;
            }
            dtPresenter.onClose();
            this.removeLinksForDecisionTable(dtPresenter);
        };
        this.view.removeDecisionTable(dtPresenter.getView(), afterRemovalCommand);
    }

    void removeLinksForDecisionTable(GuidedDecisionTableView.Presenter dtPresenter) {
        this.getAvailableDecisionTables().stream().map(other -> other.getView().getModel().getColumns()).forEach(columns -> columns.stream().filter(GridColumn::isLinked).filter(column -> dtPresenter.getView().getModel().getColumns().contains(column.getLink())).forEach(column -> column.setLink(null)));
    }

    @Override
    public Optional<GuidedDecisionTableView.Presenter> getActiveDecisionTable() {
        return Optional.ofNullable(this.activeDecisionTable);
    }

    @Override
    public Set<GuidedDecisionTableView.Presenter> getAvailableDecisionTables() {
        return Collections.unmodifiableSet(this.availableDecisionTables);
    }

    @Override
    public boolean isDecisionTableAvailable(GuidedDecisionTableView.Presenter dtPresenter) {
        return this.availableDecisionTables.contains(dtPresenter);
    }

    @Override
    public boolean isActiveDecisionTableEditable() {
        Optional<GuidedDecisionTableView.Presenter> dtPresenter = this.getActiveDecisionTable();
        if (dtPresenter.isPresent()) {
            return dtPresenter.get().getAccess().isEditable();
        }
        return false;
    }

    @Override
    public GuidedDecisionTableModellerView getView() {
        return this.view;
    }

    @Override
    public void setZoom(int zoom) {
        this.view.setZoom(zoom);
    }

    public void enterPinnedMode(GridWidget gridWidget, Command onStartCommand) {
        this.columnHeaderPopOver.hide();
        this.view.getGridLayerView().enterPinnedMode(gridWidget, onStartCommand);
    }

    public void exitPinnedMode(Command onCompleteCommand) {
        this.columnHeaderPopOver.hide();
        this.view.getGridLayerView().exitPinnedMode(onCompleteCommand);
    }

    public void updatePinnedContext(GridWidget gridWidget) throws IllegalStateException {
        this.columnHeaderPopOver.hide();
        this.view.getGridLayerView().updatePinnedContext(gridWidget);
    }

    public GridPinnedModeManager.PinnedContext getPinnedContext() {
        return this.view.getGridLayerView().getPinnedContext();
    }

    public boolean isGridPinned() {
        return this.view.getGridLayerView().isGridPinned();
    }

    public TransformMediator getDefaultTransformMediator() {
        return this.view.getGridLayerView().getDefaultTransformMediator();
    }

    public void addOnEnterPinnedModeCommand(Command command) {
        this.view.getGridLayerView().addOnEnterPinnedModeCommand(command);
    }

    public void addOnExitPinnedModeCommand(Command command) {
        this.view.getGridLayerView().addOnExitPinnedModeCommand(command);
    }

    @Override
    public void onDecisionTableSelected(@Observes DecisionTableSelectedEvent event) {
        Optional<GuidedDecisionTableView.Presenter> dtPresenter = event.getPresenter();
        if (!dtPresenter.isPresent()) {
            this.activeDecisionTable = null;
            return;
        }
        GuidedDecisionTableView.Presenter presenter = dtPresenter.get();
        if (!this.isDecisionTableAvailable(presenter)) {
            return;
        }
        Optional<GuidedDecisionTableView.Presenter> activeDecisionTable = this.getActiveDecisionTable();
        if (activeDecisionTable.isPresent() && presenter.equals(activeDecisionTable.get())) {
            return;
        }
        this.doDecisionTableSelected(presenter);
    }

    void doDecisionTableSelected(GuidedDecisionTableView.Presenter dtPresenter) {
        this.activeDecisionTable = dtPresenter;
        for (GuidedDecisionTableView.Presenter p : this.getAvailableDecisionTables()) {
            if (!p.equals(dtPresenter)) continue;
            p.initialiseAnalysis();
        }
        this.view.select(dtPresenter.getView());
        if (this.isGridPinned()) {
            this.view.getGridLayerView().flipToGridWidget((GridWidget)dtPresenter.getView());
        }
    }

    @Override
    public void onDecisionTableLinkedColumnSelected(@Observes DecisionTableColumnSelectedEvent event) {
        if (event.getColumn() == null) {
            return;
        }
        this.view.selectLinkedColumn(event.getColumn());
    }

    @Override
    public void updateRadar() {
        this.updateRadarEvent.fire((Object)new RadarMenuBuilder.UpdateRadarEvent(this));
    }

    @Override
    public void onViewPinned(boolean isPinned) {
        this.pinnedEvent.fire((Object)new DecisionTablePinnedEvent(this, isPinned));
        this.view.setPinnedModeIndicatorVisibility(isPinned);
    }

    @Override
    public void refreshScrollPosition() {
        this.view.refreshScrollPosition();
    }

    @Override
    public void updateLinks() {
        for (GuidedDecisionTableView.Presenter dtPresenter : this.getAvailableDecisionTables()) {
            dtPresenter.link(this.getAvailableDecisionTables());
        }
        this.getView().getGridLayerView().refreshGridWidgetConnectors();
    }

    @Override
    public void analysisReportScreen(AnalysisReportScreen analysisReportScreen) {
        this.analysisReportScreen = analysisReportScreen;
    }
}

