/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.modals;

import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.ListBox;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.modals.NewPatternPresenter;
import org.gwtbootstrap3.client.ui.ModalFooter;
import org.gwtbootstrap3.client.ui.constants.ButtonType;
import org.gwtbootstrap3.client.ui.constants.IconType;
import org.jboss.errai.common.client.dom.Div;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.common.client.dom.Span;
import org.jboss.errai.ui.client.local.api.IsElement;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.kie.workbench.common.widgets.client.widget.BindingTextBox;
import org.uberfire.ext.editor.commons.client.file.popups.CommonModalBuilder;
import org.uberfire.ext.widgets.common.client.common.popups.BaseModal;
import org.uberfire.ext.widgets.common.client.common.popups.footers.GenericModalFooter;

@Dependent
@Templated
public class NewPatternView
implements NewPatternPresenter.View,
IsElement {
    private static final String WIDTH = "550px";
    @DataField(value="body")
    private Div body;
    @DataField(value="factTypeList")
    private ListBox factTypeList;
    @DataField(value="binding")
    private BindingTextBox binding;
    @DataField(value="negatePatternMatch")
    private CheckBox negatePatternMatch;
    @DataField(value="negatePatternContainer")
    private Div negatePatternContainer;
    @DataField(value="warning")
    private Div warning;
    @DataField(value="warningMessage")
    private Span warningMessage;
    private TranslationService translationService;
    private NewPatternPresenter presenter;
    private BaseModal modal;

    @Inject
    public NewPatternView(Div body, ListBox factTypeList, BindingTextBox binding, CheckBox negatePatternMatch, Div negatePatternContainer, Div warning, Span warningMessage, TranslationService translationService) {
        this.body = body;
        this.factTypeList = factTypeList;
        this.binding = binding;
        this.negatePatternMatch = negatePatternMatch;
        this.negatePatternContainer = negatePatternContainer;
        this.warning = warning;
        this.warningMessage = warningMessage;
        this.translationService = translationService;
    }

    public void init(NewPatternPresenter presenter) {
        this.presenter = presenter;
    }

    @Override
    public void show() {
        this.setupModal();
        this.showModal();
    }

    @Override
    public void hide() {
        this.modal.hide();
    }

    @Override
    public void clear() {
        this.factTypeList.setSelectedIndex(0);
        this.binding.setText("");
        this.binding.setEnabled(true);
        this.negatePatternMatch.setValue(Boolean.valueOf(false));
        this.negatePatternContainer.setHidden(false);
        this.hideError();
    }

    @Override
    public boolean isNegatePatternMatch() {
        return this.negatePatternMatch.getValue();
    }

    @Override
    public String getSelectedFactType() {
        return this.factTypeList.getSelectedItemText();
    }

    @Override
    public String getBindingText() {
        return this.binding.getText().trim();
    }

    @Override
    public void showError(String errorMessage) {
        this.warningMessage.setTextContent(errorMessage);
        this.warning.setHidden(false);
    }

    @Override
    public void hideError() {
        this.warningMessage.setTextContent("");
        this.warning.setHidden(true);
    }

    @Override
    public void disableNegatedPattern() {
        this.negatePatternContainer.setHidden(true);
    }

    @EventHandler(value={"binding"})
    public void onBindingChange(KeyUpEvent event) {
        this.binding.setText(this.binding.getText().trim());
    }

    @EventHandler(value={"negatePatternMatch"})
    public void onNegatePatternMatchChange(ChangeEvent event) {
        boolean isPatternNegated = this.negatePatternMatch.getValue();
        this.binding.setEnabled(!isPatternNegated);
    }

    private void setupModal() {
        this.createModal();
        this.factTypesSetup();
    }

    private void createModal() {
        this.modal = new CommonModalBuilder().addHeader(this.translate("NewPatternView.CreateANewFact", new Object[0])).addBody((HTMLElement)this.body).addFooter(this.footer()).build();
        this.modal.setWidth(WIDTH);
    }

    private ModalFooter footer() {
        GenericModalFooter footer = new GenericModalFooter();
        footer.addButton(this.translate("NewPatternView.Cancel", new Object[0]), this.presenter::cancel, ButtonType.DEFAULT);
        footer.addButton(this.translate("NewPatternView.OK", new Object[0]), this.presenter::addPattern, IconType.PLUS, ButtonType.PRIMARY);
        return footer;
    }

    private void factTypesSetup() {
        this.factTypeList.clear();
        this.presenter.getFactTypes().forEach(arg_0 -> ((ListBox)this.factTypeList).addItem(arg_0));
    }

    private void showModal() {
        this.modal.show();
    }

    private String translate(String key, Object ... args) {
        return this.translationService.format(key, args);
    }
}

