/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.editor;

import com.google.gwt.core.client.Scheduler;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import javax.enterprise.event.Event;
import org.drools.workbench.models.guided.dtable.shared.model.DTCellValue52;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.screens.guided.dtable.client.editor.BaseGuidedDecisionTableEditorPresenter;
import org.drools.workbench.screens.guided.dtable.client.editor.BaseGuidedDecisionTablePresenterTest;
import org.drools.workbench.screens.guided.dtable.client.editor.GuidedDecisionTableDocksHandler;
import org.drools.workbench.screens.guided.dtable.client.editor.GuidedDecisionTableEditorPresenter;
import org.drools.workbench.screens.guided.dtable.client.editor.search.GuidedDecisionTableEditorSearchIndex;
import org.drools.workbench.screens.guided.dtable.client.editor.search.GuidedDecisionTableSearchableElement;
import org.drools.workbench.screens.guided.dtable.client.type.GuidedDTableResourceType;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableView;
import org.drools.workbench.screens.guided.dtable.client.widget.table.events.cdi.DecisionTableSelectedEvent;
import org.drools.workbench.screens.guided.dtable.model.GuidedDecisionTableEditorContent;
import org.drools.workbench.screens.guided.dtable.service.GuidedDecisionTableEditorService;
import org.drools.workbench.screens.guided.dtable.shared.XLSConversionResult;
import org.guvnor.common.services.project.categories.Decision;
import org.guvnor.common.services.project.client.context.WorkspaceProjectContext;
import org.guvnor.common.services.project.client.security.ProjectController;
import org.guvnor.common.services.project.model.WorkspaceProject;
import org.guvnor.common.services.shared.metadata.model.Metadata;
import org.guvnor.common.services.shared.metadata.model.Overview;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.soup.project.datamodel.imports.Imports;
import org.kie.workbench.common.services.verifier.reporting.client.panel.AnalysisReportScreen;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracle;
import org.kie.workbench.common.widgets.client.menu.FileMenuBuilder;
import org.kie.workbench.common.widgets.client.search.common.EditorSearchIndex;
import org.kie.workbench.common.widgets.client.search.common.HasSearchableElements;
import org.kie.workbench.common.widgets.client.search.common.SearchPerformedEvent;
import org.kie.workbench.common.widgets.client.search.component.SearchBarComponent;
import org.kie.workbench.common.widgets.configresource.client.widget.bound.ImportsWidgetPresenter;
import org.kie.workbench.common.widgets.metadata.client.KieDocument;
import org.kie.workbench.common.widgets.metadata.client.KieMultipleDocumentEditorWrapperView;
import org.kie.workbench.common.workbench.client.docks.AuthoringWorkbenchDocks;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.backend.vfs.ObservablePath;
import org.uberfire.backend.vfs.Path;
import org.uberfire.client.mvp.PerspectiveManager;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.workbench.widgets.multipage.MultiPageEditor;
import org.uberfire.ext.editor.commons.client.menu.BasicFileMenuBuilder;
import org.uberfire.ext.editor.commons.client.menu.DownloadMenuItemBuilder;
import org.uberfire.ext.editor.commons.client.menu.common.SaveAndRenameCommandBuilder;
import org.uberfire.ext.editor.commons.client.validation.Validator;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;
import org.uberfire.ext.wires.core.grids.client.widget.layer.impl.GridLienzoPanel;
import org.uberfire.mocks.EventSourceMock;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.workbench.model.menu.MenuItem;

@RunWith(value=GwtMockitoTestRunner.class)
public class GuidedDecisionTableEditorPresenterTest
extends BaseGuidedDecisionTablePresenterTest<GuidedDecisionTableEditorPresenter> {
    @Mock
    protected AuthoringWorkbenchDocks docks;
    private GuidedDTableResourceType resourceType = new GuidedDTableResourceType(new Decision());
    @Mock
    private SaveAndRenameCommandBuilder<GuidedDecisionTable52, Metadata> saveAndRenameCommandBuilder;
    @Mock
    private EventSourceMock<SearchPerformedEvent> searchPerformedEvent;

    @Override
    protected GuidedDecisionTableEditorPresenter getPresenter() {
        return new GuidedDecisionTableEditorPresenter(this.view, this.dtServiceCaller, this.docks, (PerspectiveManager)Mockito.mock(PerspectiveManager.class), this.notification, this.decisionTableSelectedEvent, (GuidedDecisionTableDocksHandler)Mockito.mock(GuidedDecisionTableDocksHandler.class), (AnalysisReportScreen)Mockito.mock(AnalysisReportScreen.class), this.validationPopup, this.resourceType, this.editMenuBuilder, this.viewMenuBuilder, this.insertMenuBuilder, this.radarMenuBuilder, this.modeller, this.beanManager, this.placeManager, this.columnsPage, (SaveAndRenameCommandBuilder)this.saveAndRenameCommandBuilder, this.alertsButtonMenuItemBuilder, this.downloadMenuItemBuilder, this.editorSearchIndex, this.searchBarComponent, this.searchableElementFactory, (Event)this.searchPerformedEvent){
            {
                this.workbenchContext = GuidedDecisionTableEditorPresenterTest.this.workbenchContext;
                this.projectController = GuidedDecisionTableEditorPresenterTest.this.projectController;
                this.promises = GuidedDecisionTableEditorPresenterTest.this.promises;
            }

            protected Command getSaveAndRenameCommand() {
                return (Command)Mockito.mock(Command.class);
            }
        };
    }

    @Test
    public void testInit() {
        Supplier<Boolean> isDirty = () -> true;
        Supplier<Integer> currentHashCode = () -> 123;
        Command noResultsFoundCallback = () -> {};
        ((GuidedDecisionTableEditorPresenter)Mockito.doReturn(isDirty).when((Object)this.presenter)).getIsDirtySupplier();
        ((GuidedDecisionTableEditorPresenter)Mockito.doReturn((Object)noResultsFoundCallback).when((Object)this.presenter)).getNoResultsFoundCallback();
        ((GuidedDecisionTableEditorPresenter)Mockito.doReturn(currentHashCode).when((Object)this.presenter)).getCurrentHashCodeSupplier();
        ((GuidedDecisionTableEditorPresenter)this.presenter).init();
        ((GuidedDecisionTableEditorSearchIndex)Mockito.verify((Object)this.editorSearchIndex)).setNoResultsFoundCallback(noResultsFoundCallback);
        ((GuidedDecisionTableEditorSearchIndex)Mockito.verify((Object)this.editorSearchIndex)).setCurrentAssetHashcodeSupplier(currentHashCode);
        ((GuidedDecisionTableEditorSearchIndex)Mockito.verify((Object)this.editorSearchIndex, (VerificationMode)Mockito.times((int)2))).registerSubIndex((HasSearchableElements)this.presenter);
        ((SearchBarComponent)Mockito.verify((Object)this.searchBarComponent, (VerificationMode)Mockito.times((int)2))).init((EditorSearchIndex)this.editorSearchIndex);
        ((MultiPageEditor)Mockito.verify((Object)this.multiPageEditor, (VerificationMode)Mockito.times((int)2))).addTabBarWidget((IsWidget)this.searchBarComponentWidget);
    }

    @Test
    public void testGetCurrentHashCode() {
        GuidedDecisionTableView.Presenter activeDocument = (GuidedDecisionTableView.Presenter)Mockito.mock(GuidedDecisionTableView.Presenter.class);
        Integer expectedHashcode = 123;
        ((GuidedDecisionTableEditorPresenter)Mockito.doReturn((Object)activeDocument).when((Object)this.presenter)).getActiveDocument();
        ((GuidedDecisionTableEditorPresenter)Mockito.doReturn((Object)expectedHashcode).when((Object)this.presenter)).currentHashCode(activeDocument);
        Integer actualHashcode = (Integer)((GuidedDecisionTableEditorPresenter)this.presenter).getCurrentHashCodeSupplier().get();
        Assert.assertEquals((Object)expectedHashcode, (Object)actualHashcode);
    }

    @Test
    public void testGetNoResultsFoundCallback() {
        GridWidget gridWidget = (GridWidget)Mockito.mock(GridWidget.class);
        GridData gridData = (GridData)Mockito.mock(GridData.class);
        Mockito.when((Object)this.modellerView.getGridWidgets()).thenReturn(new HashSet<GridWidget>(Collections.singletonList(gridWidget)));
        Mockito.when((Object)gridWidget.getModel()).thenReturn((Object)gridData);
        ((GuidedDecisionTableEditorPresenter)this.presenter).getNoResultsFoundCallback().execute();
        ((GridData)Mockito.verify((Object)gridData)).clearSelections();
        ((GridWidget)Mockito.verify((Object)gridWidget)).draw();
    }

    @Test
    public void testGetSearchPerformedCallback() {
        ArgumentCaptor captor = ArgumentCaptor.forClass(SearchPerformedEvent.class);
        GuidedDecisionTableSearchableElement currentResult = (GuidedDecisionTableSearchableElement)Mockito.mock(GuidedDecisionTableSearchableElement.class);
        Mockito.when((Object)this.editorSearchIndex.getCurrentResult()).thenReturn(Optional.of(currentResult));
        ((GuidedDecisionTableEditorPresenter)this.presenter).getSearchPerformedCallback().execute();
        ((EventSourceMock)Mockito.verify(this.searchPerformedEvent)).fire(captor.capture());
        SearchPerformedEvent value = (SearchPerformedEvent)captor.getValue();
        Assert.assertEquals((Object)value.getCurrentElement(), (Object)currentResult);
    }

    @Test
    public void testGetModellerView() {
        Assert.assertEquals((Object)this.modellerView, (Object)((GuidedDecisionTableEditorPresenter)this.presenter).getModellerView());
    }

    @Test
    public void testGetSearchableElements() {
        GuidedDecisionTable52 model = (GuidedDecisionTable52)Mockito.mock(GuidedDecisionTable52.class);
        Supplier<GuidedDecisionTable52> modelSupplier = () -> model;
        List<DTCellValue52> row1 = Arrays.asList(new DTCellValue52("cell 1"), new DTCellValue52("cell 2"));
        List<DTCellValue52> row2 = Arrays.asList(new DTCellValue52("cell 3"), new DTCellValue52("cell 4"));
        List<List> data = Arrays.asList(row1, row2);
        ((GuidedDecisionTableEditorPresenter)Mockito.doReturn(modelSupplier).when((Object)this.presenter)).getContentSupplier();
        Mockito.when((Object)model.getData()).thenReturn(data);
        List elements = ((GuidedDecisionTableEditorPresenter)this.presenter).getSearchableElements();
        Assert.assertEquals((long)4L, (long)elements.size());
        Assert.assertEquals((Object)"cell 1", (Object)((GuidedDecisionTableSearchableElement)elements.get(0)).getValue());
        Assert.assertEquals((Object)"cell 2", (Object)((GuidedDecisionTableSearchableElement)elements.get(1)).getValue());
        Assert.assertEquals((Object)"cell 3", (Object)((GuidedDecisionTableSearchableElement)elements.get(2)).getValue());
        Assert.assertEquals((Object)"cell 4", (Object)((GuidedDecisionTableSearchableElement)elements.get(3)).getValue());
        Assert.assertEquals((long)0L, (long)((GuidedDecisionTableSearchableElement)elements.get(0)).getRow());
        Assert.assertEquals((long)0L, (long)((GuidedDecisionTableSearchableElement)elements.get(1)).getRow());
        Assert.assertEquals((long)1L, (long)((GuidedDecisionTableSearchableElement)elements.get(2)).getRow());
        Assert.assertEquals((long)1L, (long)((GuidedDecisionTableSearchableElement)elements.get(3)).getRow());
        Assert.assertEquals((long)0L, (long)((GuidedDecisionTableSearchableElement)elements.get(0)).getColumn());
        Assert.assertEquals((long)1L, (long)((GuidedDecisionTableSearchableElement)elements.get(1)).getColumn());
        Assert.assertEquals((long)0L, (long)((GuidedDecisionTableSearchableElement)elements.get(2)).getColumn());
        Assert.assertEquals((long)1L, (long)((GuidedDecisionTableSearchableElement)elements.get(3)).getColumn());
        Assert.assertEquals((Object)this.modeller, (Object)((GuidedDecisionTableSearchableElement)elements.get(0)).getModeller());
        Assert.assertEquals((Object)this.modeller, (Object)((GuidedDecisionTableSearchableElement)elements.get(1)).getModeller());
        Assert.assertEquals((Object)this.modeller, (Object)((GuidedDecisionTableSearchableElement)elements.get(2)).getModeller());
        Assert.assertEquals((Object)this.modeller, (Object)((GuidedDecisionTableSearchableElement)elements.get(3)).getModeller());
    }

    @Test
    public void testSetupMenuBar() {
        ((FileMenuBuilder)Mockito.verify((Object)this.fileMenuBuilder, (VerificationMode)Mockito.times((int)1))).addSave((MenuItem)Mockito.any(MenuItem.class));
        ((FileMenuBuilder)Mockito.verify((Object)this.fileMenuBuilder, (VerificationMode)Mockito.times((int)1))).addCopy((BasicFileMenuBuilder.PathProvider)Mockito.any(BasicFileMenuBuilder.PathProvider.class), (Validator)Mockito.eq((Object)this.assetUpdateValidator));
        ((FileMenuBuilder)Mockito.verify((Object)this.fileMenuBuilder, (VerificationMode)Mockito.times((int)1))).addRename((Command)Mockito.any(Command.class));
        ((FileMenuBuilder)Mockito.verify((Object)this.fileMenuBuilder, (VerificationMode)Mockito.times((int)1))).addDelete((BasicFileMenuBuilder.PathProvider)Mockito.any(BasicFileMenuBuilder.PathProvider.class), (Validator)Mockito.eq((Object)this.assetUpdateValidator));
        ((FileMenuBuilder)Mockito.verify((Object)this.fileMenuBuilder, (VerificationMode)Mockito.times((int)1))).addValidate((Command)Mockito.any(Command.class));
        ((FileMenuBuilder)Mockito.verify((Object)this.fileMenuBuilder, (VerificationMode)Mockito.times((int)1))).addNewTopLevelMenu((MenuItem)Mockito.eq((Object)this.editMenuItem));
        ((FileMenuBuilder)Mockito.verify((Object)this.fileMenuBuilder, (VerificationMode)Mockito.times((int)1))).addNewTopLevelMenu((MenuItem)Mockito.eq((Object)this.viewMenuItem));
        ((FileMenuBuilder)Mockito.verify((Object)this.fileMenuBuilder, (VerificationMode)Mockito.times((int)1))).addNewTopLevelMenu((MenuItem)Mockito.eq((Object)this.insertMenuItem));
        ((FileMenuBuilder)Mockito.verify((Object)this.fileMenuBuilder, (VerificationMode)Mockito.times((int)1))).addNewTopLevelMenu((MenuItem)Mockito.eq((Object)this.radarMenuItem));
        ((FileMenuBuilder)Mockito.verify((Object)this.fileMenuBuilder, (VerificationMode)Mockito.times((int)1))).addNewTopLevelMenu((MenuItem)Mockito.eq((Object)this.versionManagerMenuItem));
        ((FileMenuBuilder)Mockito.verify((Object)this.fileMenuBuilder)).addNewTopLevelMenu(this.alertsButtonMenuItem);
    }

    @Test
    public void testDownloads() {
        ((GuidedDecisionTableEditorPresenter)this.presenter).makeMenuBar();
        ((GuidedDecisionTableEditorPresenter)this.presenter).makeMenuBar();
        ((DownloadMenuItemBuilder)Mockito.verify((Object)this.downloadMenuItemBuilder)).build((Supplier)Mockito.any());
    }

    @Test
    public void testMakeMenuBarWithoutUpdateProjectPermission() {
        Mockito.reset((Object[])new FileMenuBuilder[]{this.fileMenuBuilder});
        ((WorkspaceProjectContext)Mockito.doReturn(Optional.of(Mockito.mock(WorkspaceProject.class))).when((Object)this.workbenchContext)).getActiveWorkspaceProject();
        ((ProjectController)Mockito.doReturn((Object)this.promises.resolve((Object)false)).when((Object)this.projectController)).canUpdateProject((WorkspaceProject)Mockito.any());
        ((GuidedDecisionTableEditorPresenter)this.presenter).makeMenuBar();
        ((FileMenuBuilder)Mockito.verify((Object)this.fileMenuBuilder, (VerificationMode)Mockito.never())).addSave((MenuItem)Mockito.any(MenuItem.class));
        ((FileMenuBuilder)Mockito.verify((Object)this.fileMenuBuilder, (VerificationMode)Mockito.never())).addCopy((BasicFileMenuBuilder.PathProvider)Mockito.any(BasicFileMenuBuilder.PathProvider.class), (Validator)Mockito.eq((Object)this.assetUpdateValidator));
        ((FileMenuBuilder)Mockito.verify((Object)this.fileMenuBuilder, (VerificationMode)Mockito.never())).addRename((BasicFileMenuBuilder.PathProvider)Mockito.any(BasicFileMenuBuilder.PathProvider.class), (Validator)Mockito.eq((Object)this.assetUpdateValidator));
        ((FileMenuBuilder)Mockito.verify((Object)this.fileMenuBuilder, (VerificationMode)Mockito.never())).addDelete((BasicFileMenuBuilder.PathProvider)Mockito.any(BasicFileMenuBuilder.PathProvider.class), (Validator)Mockito.eq((Object)this.assetUpdateValidator));
        ((FileMenuBuilder)Mockito.verify((Object)this.fileMenuBuilder)).addNewTopLevelMenu(this.alertsButtonMenuItem);
    }

    @Test
    public void startUpSelectsDecisionTable() {
        ObservablePath path = (ObservablePath)Mockito.mock(ObservablePath.class);
        PlaceRequest placeRequest = (PlaceRequest)Mockito.mock(PlaceRequest.class);
        GuidedDecisionTableEditorContent content = this.makeDecisionTableContent();
        GuidedDecisionTableView.Presenter dtPresenter = this.makeDecisionTable((Path)path, path, placeRequest, content);
        ((GuidedDecisionTableEditorPresenter)this.presenter).onStartup(path, placeRequest);
        ((Event)Mockito.verify((Object)this.decisionTableSelectedEvent, (VerificationMode)Mockito.times((int)1))).fire(this.dtSelectedEventCaptor.capture());
        DecisionTableSelectedEvent dtSelectedEvent = (DecisionTableSelectedEvent)this.dtSelectedEventCaptor.getValue();
        Assert.assertNotNull((Object)dtSelectedEvent);
        Assert.assertTrue((boolean)dtSelectedEvent.getPresenter().isPresent());
        Assert.assertEquals((Object)dtPresenter, dtSelectedEvent.getPresenter().get());
        ((GridLienzoPanel)Mockito.verify((Object)this.modellerGridPanel)).setFocus(Mockito.eq((boolean)true));
    }

    @Test
    public void checkGetAvailableDocumentPaths() {
        ((GuidedDecisionTableEditorPresenter)this.presenter).getAvailableDocumentPaths(result -> Assert.assertTrue((boolean)result.isEmpty()));
    }

    @Test
    public void checkOnOpenDocumentsInEditor() {
        this.exception.expect(UnsupportedOperationException.class);
        ((GuidedDecisionTableEditorPresenter)this.presenter).onOpenDocumentsInEditor(Collections.emptyList());
    }

    @Test
    public void checkRemoveDocumentClosesEditor() {
        PlaceRequest placeRequest = (PlaceRequest)Mockito.mock(PlaceRequest.class);
        GuidedDecisionTableView.Presenter dtPresenter = (GuidedDecisionTableView.Presenter)Mockito.mock(GuidedDecisionTableView.Presenter.class);
        ((GuidedDecisionTableEditorPresenter)this.presenter).editorPlaceRequest = placeRequest;
        ((GuidedDecisionTableEditorPresenter)this.presenter).removeDocument(dtPresenter);
        ArgumentCaptor commandCaptor = ArgumentCaptor.forClass(Scheduler.ScheduledCommand.class);
        ((GuidedDecisionTableEditorPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.times((int)1))).scheduleClosure((Scheduler.ScheduledCommand)commandCaptor.capture());
        Scheduler.ScheduledCommand command = (Scheduler.ScheduledCommand)commandCaptor.getValue();
        Assert.assertNotNull((Object)command);
        command.execute();
        ((PlaceManager)Mockito.verify((Object)this.placeManager, (VerificationMode)Mockito.times((int)1))).forceClosePlace((PlaceRequest)Mockito.eq((Object)placeRequest));
    }

    @Test
    public void testGetMetadataSupplier() {
        GuidedDecisionTableView.Presenter document = (GuidedDecisionTableView.Presenter)Mockito.mock(GuidedDecisionTableView.Presenter.class);
        Overview overview = (Overview)Mockito.mock(Overview.class);
        Metadata expectedMetadata = (Metadata)Mockito.mock(Metadata.class);
        ((GuidedDecisionTableEditorPresenter)Mockito.doReturn((Object)document).when((Object)this.presenter)).getActiveDocument();
        ((GuidedDecisionTableView.Presenter)Mockito.doReturn((Object)overview).when((Object)document)).getOverview();
        ((Overview)Mockito.doReturn((Object)expectedMetadata).when((Object)overview)).getMetadata();
        Metadata actualMetadata = (Metadata)((GuidedDecisionTableEditorPresenter)this.presenter).getMetadataSupplier().get();
        Assert.assertEquals((Object)expectedMetadata, (Object)actualMetadata);
    }

    @Test
    public void testGetContentSupplier() {
        GuidedDecisionTableView.Presenter presenter = (GuidedDecisionTableView.Presenter)Mockito.mock(GuidedDecisionTableView.Presenter.class);
        GuidedDecisionTable52 expected = (GuidedDecisionTable52)Mockito.mock(GuidedDecisionTable52.class);
        ((GuidedDecisionTableView.Presenter)Mockito.doReturn((Object)expected).when((Object)presenter)).getModel();
        ((GuidedDecisionTableEditorPresenter)Mockito.doReturn((Object)presenter).when((Object)this.presenter)).getActiveDocument();
        GuidedDecisionTable52 actual = (GuidedDecisionTable52)((GuidedDecisionTableEditorPresenter)this.presenter).getContentSupplier().get();
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testGetIsDirtySupplierWhenItIsDirty() {
        GuidedDecisionTableView.Presenter presenter = (GuidedDecisionTableView.Presenter)Mockito.mock(GuidedDecisionTableView.Presenter.class);
        GuidedDecisionTable52 model = (GuidedDecisionTable52)Mockito.mock(GuidedDecisionTable52.class);
        int currentHash = 456;
        int originalHash = 123;
        ((GuidedDecisionTableEditorPresenter)Mockito.doReturn((Object)456).when((Object)this.presenter)).currentHashCode(presenter);
        ((GuidedDecisionTableEditorPresenter)Mockito.doReturn((Object)123).when((Object)this.presenter)).originalHashCode(presenter);
        ((GuidedDecisionTableView.Presenter)Mockito.doReturn((Object)model).when((Object)presenter)).getModel();
        ((GuidedDecisionTableEditorPresenter)Mockito.doReturn((Object)presenter).when((Object)this.presenter)).getActiveDocument();
        boolean isDirty = (Boolean)((GuidedDecisionTableEditorPresenter)this.presenter).getIsDirtySupplier().get();
        Assert.assertTrue((boolean)isDirty);
    }

    @Test
    public void testGetIsDirtySupplierWhenItIsNotDirty() {
        GuidedDecisionTableView.Presenter presenter = (GuidedDecisionTableView.Presenter)Mockito.mock(GuidedDecisionTableView.Presenter.class);
        GuidedDecisionTable52 model = (GuidedDecisionTable52)Mockito.mock(GuidedDecisionTable52.class);
        int currentHash = 123;
        int originalHash = 123;
        ((GuidedDecisionTableEditorPresenter)Mockito.doReturn((Object)123).when((Object)this.presenter)).currentHashCode(presenter);
        ((GuidedDecisionTableEditorPresenter)Mockito.doReturn((Object)123).when((Object)this.presenter)).originalHashCode(presenter);
        ((GuidedDecisionTableView.Presenter)Mockito.doReturn((Object)model).when((Object)presenter)).getModel();
        ((GuidedDecisionTableEditorPresenter)Mockito.doReturn((Object)presenter).when((Object)this.presenter)).getActiveDocument();
        boolean isDirty = (Boolean)((GuidedDecisionTableEditorPresenter)this.presenter).getIsDirtySupplier().get();
        Assert.assertFalse((boolean)isDirty);
    }

    @Test
    public void testImportsTabIsAdded() {
        ObservablePath path = (ObservablePath)Mockito.mock(ObservablePath.class);
        PlaceRequest placeRequest = (PlaceRequest)Mockito.mock(PlaceRequest.class);
        GuidedDecisionTableEditorContent content = this.makeDecisionTableContent();
        GuidedDecisionTableView.Presenter dtDocument = this.makeDecisionTable((Path)path, path, placeRequest, content);
        ((GuidedDecisionTableEditorPresenter)this.presenter).registerDocument((KieDocument)dtDocument);
        ((GuidedDecisionTableEditorPresenter)this.presenter).refreshDocument(dtDocument);
        ((KieMultipleDocumentEditorWrapperView)Mockito.verify((Object)this.kieEditorWrapperView)).addImportsTab((IsWidget)Mockito.eq((Object)this.importsWidget));
        AsyncPackageDataModelOracle oracle = dtDocument.getDataModelOracle();
        Imports imports = dtDocument.getModel().getImports();
        ((ImportsWidgetPresenter)Mockito.verify((Object)this.importsWidget)).setContent((AsyncPackageDataModelOracle)Matchers.same((Object)oracle), (Imports)Matchers.same((Object)imports), Mockito.eq((boolean)false));
    }

    @Test
    public void showConversionSuccess() {
        ((GuidedDecisionTableEditorService)Mockito.doReturn((Object)new XLSConversionResult()).when((Object)this.dtService)).convert((Path)Mockito.any());
        ((GuidedDecisionTableEditorPresenter)this.presenter).onConvert();
        ((BaseGuidedDecisionTableEditorPresenter.View)Mockito.verify((Object)this.view)).showConversionSuccess();
        ((BaseGuidedDecisionTableEditorPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).showConversionMessage((String)Mockito.any());
    }

    @Test
    public void showConversionMessage() {
        ((GuidedDecisionTableEditorService)Mockito.doReturn((Object)new XLSConversionResult("failed")).when((Object)this.dtService)).convert((Path)Mockito.any());
        ((GuidedDecisionTableEditorPresenter)this.presenter).onConvert();
        ((BaseGuidedDecisionTableEditorPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).showConversionSuccess();
        ((BaseGuidedDecisionTableEditorPresenter.View)Mockito.verify((Object)this.view)).showConversionMessage("failed");
    }
}

