/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.editor.menu;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.drools.workbench.models.guided.dtable.shared.model.DTCellValue52;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.models.guided.dtable.shared.model.MetadataCol52;
import org.drools.workbench.screens.guided.dtable.client.editor.clipboard.Clipboard;
import org.drools.workbench.screens.guided.dtable.client.editor.clipboard.impl.DefaultClipboard;
import org.drools.workbench.screens.guided.dtable.client.editor.menu.CellContextMenu;
import org.drools.workbench.screens.guided.dtable.client.editor.menu.CellContextMenuView;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTablePresenter;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableView;
import org.drools.workbench.screens.guided.dtable.client.widget.table.events.cdi.DecisionTableSelectedEvent;
import org.drools.workbench.screens.guided.dtable.client.widget.table.events.cdi.DecisionTableSelectionsChangedEvent;
import org.drools.workbench.screens.guided.dtable.client.widget.table.events.cdi.RefreshMenusEvent;
import org.drools.workbench.screens.guided.dtable.client.widget.table.model.GuidedDecisionTableUiModel;
import org.drools.workbench.screens.guided.dtable.client.widget.table.model.synchronizers.ModelSynchronizer;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridRow;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridColumn;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridRow;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.columns.GridColumnRenderer;

@RunWith(value=MockitoJUnitRunner.class)
public class CellContextMenuTest {
    private CellContextMenu menu;
    private GuidedDecisionTable52 model;
    private GuidedDecisionTableUiModel uiModel;
    private Clipboard clipboard;
    @Mock
    private CellContextMenuView view;
    @Mock
    private GuidedDecisionTableView.Presenter dtPresenter;
    private GuidedDecisionTablePresenter.Access access = new GuidedDecisionTablePresenter.Access();
    @Mock
    private GuidedDecisionTableView dtPresenterView;

    @Before
    public void setup() {
        this.model = new GuidedDecisionTable52();
        this.uiModel = new GuidedDecisionTableUiModel((ModelSynchronizer)Mockito.mock(ModelSynchronizer.class));
        this.clipboard = new DefaultClipboard();
        Mockito.when((Object)this.dtPresenter.getView()).thenReturn((Object)this.dtPresenterView);
        Mockito.when((Object)this.dtPresenter.getModel()).thenReturn((Object)this.model);
        Mockito.when((Object)this.dtPresenter.getAccess()).thenReturn((Object)this.access);
        Mockito.when((Object)this.dtPresenterView.getModel()).thenReturn((Object)this.uiModel);
        this.uiModel.appendColumn((GridColumn)new BaseGridColumn((GridColumn.HeaderMetaData)Mockito.mock(GridColumn.HeaderMetaData.class), (GridColumnRenderer)Mockito.mock(GridColumnRenderer.class), 100.0));
        this.uiModel.appendColumn((GridColumn)new BaseGridColumn((GridColumn.HeaderMetaData)Mockito.mock(GridColumn.HeaderMetaData.class), (GridColumnRenderer)Mockito.mock(GridColumnRenderer.class), 100.0));
        this.uiModel.appendColumn((GridColumn)new BaseGridColumn((GridColumn.HeaderMetaData)Mockito.mock(GridColumn.HeaderMetaData.class), (GridColumnRenderer)Mockito.mock(GridColumnRenderer.class), 100.0));
        this.uiModel.appendRow((GridRow)new BaseGridRow());
        this.menu = (CellContextMenu)Mockito.spy((Object)new CellContextMenu(this.view, this.clipboard));
        this.menu.setup();
    }

    @Test
    public void testOnDecisionTableSelectedEventWithNoSelections() {
        this.menu.onDecisionTableSelectedEvent(new DecisionTableSelectedEvent(this.dtPresenter));
        ((CellContextMenuView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).enableCutMenuItem(Mockito.eq((boolean)false));
        ((CellContextMenuView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).enableCopyMenuItem(Mockito.eq((boolean)false));
        ((CellContextMenuView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).enablePasteMenuItem(Mockito.eq((boolean)false));
        ((CellContextMenuView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).enableDeleteCellMenuItem(Mockito.eq((boolean)false));
    }

    @Test
    public void testOnDecisionTableSelectedEventWithSelections() {
        this.model.getMetadataCols().add(new MetadataCol52());
        this.model.getData().add(new ArrayList<DTCellValue52>(){
            {
                this.add(new DTCellValue52(Integer.valueOf(1)));
                this.add(new DTCellValue52("descr"));
                this.add(new DTCellValue52("md"));
            }
        });
        this.uiModel.selectCell(0, 2);
        this.menu.onDecisionTableSelectedEvent(new DecisionTableSelectedEvent(this.dtPresenter));
        ((CellContextMenuView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).enableCutMenuItem(Mockito.eq((boolean)true));
        ((CellContextMenuView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).enableCopyMenuItem(Mockito.eq((boolean)true));
        ((CellContextMenuView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).enablePasteMenuItem(Mockito.eq((boolean)false));
        ((CellContextMenuView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).enableDeleteCellMenuItem(Mockito.eq((boolean)true));
    }

    @Test
    public void testOnDecisionTableSelectedEventWithSelectionsWithClipboardPopulated() {
        this.model.getMetadataCols().add(new MetadataCol52());
        this.model.getData().add(new ArrayList<DTCellValue52>(){
            {
                this.add(new DTCellValue52(Integer.valueOf(1)));
                this.add(new DTCellValue52("descr"));
                this.add(new DTCellValue52("md"));
            }
        });
        this.uiModel.selectCell(0, 2);
        this.clipboard.setData((Set)new HashSet<Clipboard.ClipboardData>(){
            {
                this.add(new DefaultClipboard.ClipboardDataImpl(0, 2, (DTCellValue52)((List)CellContextMenuTest.this.model.getData().get(0)).get(2)));
            }
        });
        this.menu.onDecisionTableSelectedEvent(new DecisionTableSelectedEvent(this.dtPresenter));
        ((CellContextMenuView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).enableCutMenuItem(Mockito.eq((boolean)true));
        ((CellContextMenuView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).enableCopyMenuItem(Mockito.eq((boolean)true));
        ((CellContextMenuView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).enablePasteMenuItem(Mockito.eq((boolean)true));
        ((CellContextMenuView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).enableDeleteCellMenuItem(Mockito.eq((boolean)true));
    }

    @Test
    public void testOnDecisionTableSelectionsChangedEventWithNoSelections() {
        this.menu.onDecisionTableSelectionsChangedEvent(new DecisionTableSelectionsChangedEvent(this.dtPresenter));
        ((CellContextMenuView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).enableCutMenuItem(Mockito.eq((boolean)false));
        ((CellContextMenuView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).enableCopyMenuItem(Mockito.eq((boolean)false));
        ((CellContextMenuView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).enablePasteMenuItem(Mockito.eq((boolean)false));
        ((CellContextMenuView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).enableDeleteCellMenuItem(Mockito.eq((boolean)false));
    }

    @Test
    public void testOnDecisionTableSelectionsChangedEventWithSelections() {
        this.model.getMetadataCols().add(new MetadataCol52());
        this.model.getData().add(new ArrayList<DTCellValue52>(){
            {
                this.add(new DTCellValue52(Integer.valueOf(1)));
                this.add(new DTCellValue52("descr"));
                this.add(new DTCellValue52("md"));
            }
        });
        this.uiModel.selectCell(0, 2);
        this.menu.onDecisionTableSelectionsChangedEvent(new DecisionTableSelectionsChangedEvent(this.dtPresenter));
        ((CellContextMenuView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).enableCutMenuItem(Mockito.eq((boolean)true));
        ((CellContextMenuView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).enableCopyMenuItem(Mockito.eq((boolean)true));
        ((CellContextMenuView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).enablePasteMenuItem(Mockito.eq((boolean)false));
        ((CellContextMenuView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).enableDeleteCellMenuItem(Mockito.eq((boolean)true));
    }

    @Test
    public void testOnDecisionTableSelectionsChangedEventWithSelectionsWithClipboardPopulated() {
        this.model.getMetadataCols().add(new MetadataCol52());
        this.model.getData().add(new ArrayList<DTCellValue52>(){
            {
                this.add(new DTCellValue52(Integer.valueOf(1)));
                this.add(new DTCellValue52("descr"));
                this.add(new DTCellValue52("md"));
            }
        });
        this.uiModel.selectCell(0, 2);
        this.clipboard.setData((Set)new HashSet<Clipboard.ClipboardData>(){
            {
                this.add(new DefaultClipboard.ClipboardDataImpl(0, 2, (DTCellValue52)((List)CellContextMenuTest.this.model.getData().get(0)).get(2)));
            }
        });
        this.menu.onDecisionTableSelectionsChangedEvent(new DecisionTableSelectionsChangedEvent(this.dtPresenter));
        ((CellContextMenuView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).enableCutMenuItem(Mockito.eq((boolean)true));
        ((CellContextMenuView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).enableCopyMenuItem(Mockito.eq((boolean)true));
        ((CellContextMenuView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).enablePasteMenuItem(Mockito.eq((boolean)true));
        ((CellContextMenuView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).enableDeleteCellMenuItem(Mockito.eq((boolean)true));
    }

    @Test
    public void testOnDecisionTableSelectedEventReadOnly() {
        this.dtPresenter.getAccess().setReadOnly(true);
        this.menu.onDecisionTableSelectedEvent(new DecisionTableSelectedEvent(this.dtPresenter));
        ((CellContextMenuView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).enableCutMenuItem(Mockito.eq((boolean)false));
        ((CellContextMenuView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).enableCopyMenuItem(Mockito.eq((boolean)false));
        ((CellContextMenuView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).enablePasteMenuItem(Mockito.eq((boolean)false));
        ((CellContextMenuView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).enableDeleteCellMenuItem(Mockito.eq((boolean)false));
    }

    @Test
    public void testOnRefreshMenusEvent() {
        this.menu.onRefreshMenusEvent(new RefreshMenusEvent());
        ((CellContextMenu)Mockito.verify((Object)this.menu)).initialise();
    }
}

