/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.editor.menu;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.drools.workbench.models.guided.dtable.shared.model.ConditionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.DTCellValue52;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.models.guided.dtable.shared.model.Pattern52;
import org.drools.workbench.screens.guided.dtable.client.editor.menu.InsertMenuBuilder;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableModellerView;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTablePresenter;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableView;
import org.drools.workbench.screens.guided.dtable.client.widget.table.events.cdi.DecisionTableSelectedEvent;
import org.drools.workbench.screens.guided.dtable.client.widget.table.events.cdi.DecisionTableSelectionsChangedEvent;
import org.drools.workbench.screens.guided.dtable.client.widget.table.events.cdi.RefreshMenusEvent;
import org.drools.workbench.screens.guided.dtable.client.widget.table.model.GuidedDecisionTableUiModel;
import org.drools.workbench.screens.guided.dtable.client.widget.table.model.synchronizers.ModelSynchronizer;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.NewGuidedDecisionTableColumnWizard;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.widgets.common.client.menu.MenuItemFactory;
import org.uberfire.ext.widgets.common.client.menu.MenuItemView;
import org.uberfire.ext.widgets.common.client.menu.MenuItemWithIconView;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridRow;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridColumn;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridRow;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.columns.GridColumnRenderer;

@RunWith(value=GwtMockitoTestRunner.class)
public class InsertMenuBuilderTest {
    private InsertMenuBuilder builder;
    private GuidedDecisionTable52 model;
    private GuidedDecisionTableUiModel uiModel;
    private GuidedDecisionTablePresenter.Access access = new GuidedDecisionTablePresenter.Access();
    @Mock
    private TranslationService translationService;
    @Mock
    private ManagedInstance<MenuItemView> menuItemViewProducer;
    @Mock
    private GuidedDecisionTableView.Presenter dtPresenter;
    @Mock
    private GridColumnRenderer<String> gridColumnRenderer;
    @Mock
    private GridColumn.HeaderMetaData headerMetaData;
    @Mock
    private GuidedDecisionTableView dtPresenterView;
    @Mock
    private GuidedDecisionTableModellerView.Presenter modeller;
    @Mock
    private ManagedInstance<NewGuidedDecisionTableColumnWizard> wizardManagedInstance;

    @Before
    public void setup() {
        this.model = new GuidedDecisionTable52();
        this.uiModel = new GuidedDecisionTableUiModel((ModelSynchronizer)Mockito.mock(ModelSynchronizer.class));
        MenuItemFactory menuItemFactory = new MenuItemFactory(this.menuItemViewProducer);
        Mockito.when((Object)this.dtPresenter.hasEditableColumns()).thenReturn((Object)true);
        Mockito.when((Object)this.dtPresenter.getView()).thenReturn((Object)this.dtPresenterView);
        Mockito.when((Object)this.dtPresenter.getModel()).thenReturn((Object)this.model);
        Mockito.when((Object)this.dtPresenter.getAccess()).thenReturn((Object)this.access);
        Mockito.when((Object)this.dtPresenterView.getModel()).thenReturn((Object)this.uiModel);
        Mockito.when((Object)this.translationService.getTranslation((String)Mockito.any(String.class))).thenReturn((Object)"i18n");
        Mockito.when((Object)this.menuItemViewProducer.select(new Annotation[]{(Annotation)Mockito.any(Annotation.class)})).thenReturn(this.menuItemViewProducer);
        Mockito.when((Object)this.menuItemViewProducer.get()).thenReturn(Mockito.mock(MenuItemWithIconView.class));
        this.uiModel.appendColumn((GridColumn)new BaseGridColumn(this.headerMetaData, this.gridColumnRenderer, 100.0));
        this.uiModel.appendColumn((GridColumn)new BaseGridColumn(this.headerMetaData, this.gridColumnRenderer, 100.0));
        this.uiModel.appendColumn((GridColumn)new BaseGridColumn(this.headerMetaData, this.gridColumnRenderer, 100.0));
        this.uiModel.appendRow((GridRow)new BaseGridRow());
        this.uiModel.appendRow((GridRow)new BaseGridRow());
        this.builder = (InsertMenuBuilder)Mockito.spy((Object)new InsertMenuBuilder(this.translationService, menuItemFactory, this.wizardManagedInstance));
        this.builder.setup();
        this.builder.setModeller(this.modeller);
    }

    @Test
    public void testOnDecisionTableSelectedEventWithNoSelectionsAndItHasEditableColumns() {
        this.builder.onDecisionTableSelectedEvent(new DecisionTableSelectedEvent(this.dtPresenter));
        Assert.assertTrue((boolean)this.builder.miAppendRow.getMenuItem().isEnabled());
        Assert.assertFalse((boolean)this.builder.miInsertRowAbove.getMenuItem().isEnabled());
        Assert.assertFalse((boolean)this.builder.miInsertRowBelow.getMenuItem().isEnabled());
        Assert.assertTrue((boolean)this.builder.miInsertColumn.getMenuItem().isEnabled());
    }

    @Test
    public void testOnDecisionTableSelectedEventWithNoSelectionsAndItDoesNotHaveEditableColumns() {
        Mockito.when((Object)this.dtPresenter.hasEditableColumns()).thenReturn((Object)false);
        this.builder.onDecisionTableSelectedEvent(new DecisionTableSelectedEvent(this.dtPresenter));
        Assert.assertTrue((boolean)this.builder.miAppendRow.getMenuItem().isEnabled());
        Assert.assertFalse((boolean)this.builder.miInsertRowAbove.getMenuItem().isEnabled());
        Assert.assertFalse((boolean)this.builder.miInsertRowBelow.getMenuItem().isEnabled());
        Assert.assertFalse((boolean)this.builder.miInsertColumn.getMenuItem().isEnabled());
    }

    @Test
    public void testOnDecisionTableSelectedEventWithSingleRowSelectedAndItHasEditableColumns() {
        this.model.getConditions().add(this.makePattern52());
        this.model.getData().add(this.makeDTCellValue52List());
        this.uiModel.selectCell(0, 2);
        this.builder.onDecisionTableSelectedEvent(new DecisionTableSelectedEvent(this.dtPresenter));
        Assert.assertTrue((boolean)this.builder.miAppendRow.getMenuItem().isEnabled());
        Assert.assertTrue((boolean)this.builder.miInsertRowAbove.getMenuItem().isEnabled());
        Assert.assertTrue((boolean)this.builder.miInsertRowBelow.getMenuItem().isEnabled());
        Assert.assertTrue((boolean)this.builder.miInsertColumn.getMenuItem().isEnabled());
    }

    @Test
    public void testOnDecisionTableSelectedEventWithSingleRowSelectedAndItDoesNotHaveEditableColumns() {
        Mockito.when((Object)this.dtPresenter.hasEditableColumns()).thenReturn((Object)false);
        this.model.getConditions().add(this.makePattern52());
        this.model.getData().add(this.makeDTCellValue52List());
        this.uiModel.selectCell(0, 2);
        this.builder.onDecisionTableSelectedEvent(new DecisionTableSelectedEvent(this.dtPresenter));
        Assert.assertTrue((boolean)this.builder.miAppendRow.getMenuItem().isEnabled());
        Assert.assertTrue((boolean)this.builder.miInsertRowAbove.getMenuItem().isEnabled());
        Assert.assertTrue((boolean)this.builder.miInsertRowBelow.getMenuItem().isEnabled());
        Assert.assertFalse((boolean)this.builder.miInsertColumn.getMenuItem().isEnabled());
    }

    @Test
    public void testOnDecisionTableSelectedEventWithMultipleRowsSelectedAndItHasEditableColumns() {
        this.model.getConditions().add(this.makePattern52());
        this.model.getData().add(this.makeDTCellValue52List());
        this.model.getData().add(this.makeDTCellValue52List());
        this.uiModel.selectCells(0, 2, 1, 2);
        this.builder.onDecisionTableSelectedEvent(new DecisionTableSelectedEvent(this.dtPresenter));
        Assert.assertTrue((boolean)this.builder.miAppendRow.getMenuItem().isEnabled());
        Assert.assertFalse((boolean)this.builder.miInsertRowAbove.getMenuItem().isEnabled());
        Assert.assertFalse((boolean)this.builder.miInsertRowBelow.getMenuItem().isEnabled());
        Assert.assertTrue((boolean)this.builder.miInsertColumn.getMenuItem().isEnabled());
    }

    @Test
    public void testOnDecisionTableSelectedEventWithMultipleRowsSelectedAndItDoesNotHaveEditableColumns() {
        Mockito.when((Object)this.dtPresenter.hasEditableColumns()).thenReturn((Object)false);
        this.model.getConditions().add(this.makePattern52());
        this.model.getData().add(this.makeDTCellValue52List());
        this.model.getData().add(this.makeDTCellValue52List());
        this.uiModel.selectCells(0, 2, 1, 2);
        this.builder.onDecisionTableSelectedEvent(new DecisionTableSelectedEvent(this.dtPresenter));
        Assert.assertTrue((boolean)this.builder.miAppendRow.getMenuItem().isEnabled());
        Assert.assertFalse((boolean)this.builder.miInsertRowAbove.getMenuItem().isEnabled());
        Assert.assertFalse((boolean)this.builder.miInsertRowBelow.getMenuItem().isEnabled());
        Assert.assertFalse((boolean)this.builder.miInsertColumn.getMenuItem().isEnabled());
    }

    @Test
    public void testOnDecisionTableSelectionsChangedEventWithNoSelectionsAndItHasEditableColumns() {
        this.builder.onDecisionTableSelectionsChangedEvent(new DecisionTableSelectionsChangedEvent(this.dtPresenter));
        Assert.assertTrue((boolean)this.builder.miAppendRow.getMenuItem().isEnabled());
        Assert.assertFalse((boolean)this.builder.miInsertRowAbove.getMenuItem().isEnabled());
        Assert.assertFalse((boolean)this.builder.miInsertRowBelow.getMenuItem().isEnabled());
        Assert.assertTrue((boolean)this.builder.miInsertColumn.getMenuItem().isEnabled());
    }

    @Test
    public void testOnDecisionTableSelectionsChangedEventWithNoSelectionsAndItDoesNotHaveEditableColumns() {
        Mockito.when((Object)this.dtPresenter.hasEditableColumns()).thenReturn((Object)false);
        this.builder.onDecisionTableSelectionsChangedEvent(new DecisionTableSelectionsChangedEvent(this.dtPresenter));
        Assert.assertTrue((boolean)this.builder.miAppendRow.getMenuItem().isEnabled());
        Assert.assertFalse((boolean)this.builder.miInsertRowAbove.getMenuItem().isEnabled());
        Assert.assertFalse((boolean)this.builder.miInsertRowBelow.getMenuItem().isEnabled());
        Assert.assertFalse((boolean)this.builder.miInsertColumn.getMenuItem().isEnabled());
    }

    @Test
    public void testOnDecisionTableSelectionsChangedEventWithSingleRowSelectedAndItHasEditableColumns() {
        this.model.getConditions().add(this.makePattern52());
        this.model.getData().add(this.makeDTCellValue52List());
        this.uiModel.selectCell(0, 2);
        this.builder.onDecisionTableSelectionsChangedEvent(new DecisionTableSelectionsChangedEvent(this.dtPresenter));
        Assert.assertTrue((boolean)this.builder.miAppendRow.getMenuItem().isEnabled());
        Assert.assertTrue((boolean)this.builder.miInsertRowAbove.getMenuItem().isEnabled());
        Assert.assertTrue((boolean)this.builder.miInsertRowBelow.getMenuItem().isEnabled());
        Assert.assertTrue((boolean)this.builder.miInsertColumn.getMenuItem().isEnabled());
    }

    @Test
    public void testOnDecisionTableSelectionsChangedEventWithSingleRowSelectedAndItDoesNotHaveEditableColumns() {
        Mockito.when((Object)this.dtPresenter.hasEditableColumns()).thenReturn((Object)false);
        this.model.getConditions().add(this.makePattern52());
        this.model.getData().add(this.makeDTCellValue52List());
        this.uiModel.selectCell(0, 2);
        this.builder.onDecisionTableSelectionsChangedEvent(new DecisionTableSelectionsChangedEvent(this.dtPresenter));
        Assert.assertTrue((boolean)this.builder.miAppendRow.getMenuItem().isEnabled());
        Assert.assertTrue((boolean)this.builder.miInsertRowAbove.getMenuItem().isEnabled());
        Assert.assertTrue((boolean)this.builder.miInsertRowBelow.getMenuItem().isEnabled());
        Assert.assertFalse((boolean)this.builder.miInsertColumn.getMenuItem().isEnabled());
    }

    @Test
    public void testOnDecisionTableSelectionsChangedEventWithMultipleRowsSelectedAndItHasEditableColumns() {
        this.model.getConditions().add(this.makePattern52());
        this.model.getData().add(this.makeDTCellValue52List());
        this.model.getData().add(this.makeDTCellValue52List());
        this.uiModel.selectCells(0, 2, 1, 2);
        this.builder.onDecisionTableSelectionsChangedEvent(new DecisionTableSelectionsChangedEvent(this.dtPresenter));
        Assert.assertTrue((boolean)this.builder.miAppendRow.getMenuItem().isEnabled());
        Assert.assertFalse((boolean)this.builder.miInsertRowAbove.getMenuItem().isEnabled());
        Assert.assertFalse((boolean)this.builder.miInsertRowBelow.getMenuItem().isEnabled());
        Assert.assertTrue((boolean)this.builder.miInsertColumn.getMenuItem().isEnabled());
    }

    @Test
    public void testOnDecisionTableSelectionsChangedEventWithMultipleRowsSelectedAndItDoesNotHaveEditableColumns() {
        Mockito.when((Object)this.dtPresenter.hasEditableColumns()).thenReturn((Object)false);
        this.model.getConditions().add(this.makePattern52());
        this.model.getData().add(this.makeDTCellValue52List());
        this.model.getData().add(this.makeDTCellValue52List());
        this.uiModel.selectCells(0, 2, 1, 2);
        this.builder.onDecisionTableSelectionsChangedEvent(new DecisionTableSelectionsChangedEvent(this.dtPresenter));
        Assert.assertTrue((boolean)this.builder.miAppendRow.getMenuItem().isEnabled());
        Assert.assertFalse((boolean)this.builder.miInsertRowAbove.getMenuItem().isEnabled());
        Assert.assertFalse((boolean)this.builder.miInsertRowBelow.getMenuItem().isEnabled());
        Assert.assertFalse((boolean)this.builder.miInsertColumn.getMenuItem().isEnabled());
    }

    @Test
    public void testOnDecisionTableSelectedEventReadOnly() {
        this.dtPresenter.getAccess().setReadOnly(true);
        this.builder.onDecisionTableSelectedEvent(new DecisionTableSelectedEvent(this.dtPresenter));
        Assert.assertFalse((boolean)this.builder.miAppendRow.getMenuItem().isEnabled());
        Assert.assertFalse((boolean)this.builder.miInsertRowAbove.getMenuItem().isEnabled());
        Assert.assertFalse((boolean)this.builder.miInsertRowBelow.getMenuItem().isEnabled());
        Assert.assertFalse((boolean)this.builder.miInsertColumn.getMenuItem().isEnabled());
    }

    @Test
    public void testOpenNewGuidedDecisionTableColumnWizard() {
        GuidedDecisionTableModellerView.Presenter modeller = (GuidedDecisionTableModellerView.Presenter)Mockito.mock(GuidedDecisionTableModellerView.Presenter.class);
        GuidedDecisionTableView.Presenter activeDecisionTable = (GuidedDecisionTableView.Presenter)Mockito.mock(GuidedDecisionTableView.Presenter.class);
        NewGuidedDecisionTableColumnWizard wizard = (NewGuidedDecisionTableColumnWizard)Mockito.mock(NewGuidedDecisionTableColumnWizard.class);
        ((ManagedInstance)Mockito.doReturn((Object)wizard).when(this.wizardManagedInstance)).get();
        ((GuidedDecisionTableModellerView.Presenter)Mockito.doReturn(Optional.of(activeDecisionTable)).when((Object)modeller)).getActiveDecisionTable();
        this.builder.openNewGuidedDecisionTableColumnWizard(modeller);
        ((NewGuidedDecisionTableColumnWizard)Mockito.verify((Object)wizard)).init(activeDecisionTable);
        ((NewGuidedDecisionTableColumnWizard)Mockito.verify((Object)wizard)).start();
    }

    @Test
    public void testOnAppendColumnWhenModellerIsPresent() {
        NewGuidedDecisionTableColumnWizard wizard = (NewGuidedDecisionTableColumnWizard)Mockito.mock(NewGuidedDecisionTableColumnWizard.class);
        ((ManagedInstance)Mockito.doReturn((Object)wizard).when(this.wizardManagedInstance)).get();
        Mockito.when((Object)this.modeller.getActiveDecisionTable()).thenReturn(Optional.of(this.dtPresenter));
        this.builder.setModeller(this.modeller);
        this.builder.onAppendColumn();
        ((InsertMenuBuilder)Mockito.verify((Object)this.builder)).openNewGuidedDecisionTableColumnWizard(this.modeller);
    }

    @Test
    public void testOnAppendColumnWhenModellerIsNotPresent() {
        NewGuidedDecisionTableColumnWizard wizard = (NewGuidedDecisionTableColumnWizard)Mockito.mock(NewGuidedDecisionTableColumnWizard.class);
        ((ManagedInstance)Mockito.doReturn((Object)wizard).when(this.wizardManagedInstance)).get();
        this.builder.setModeller(null);
        this.builder.onAppendColumn();
        ((InsertMenuBuilder)Mockito.verify((Object)this.builder, (VerificationMode)Mockito.never())).openNewGuidedDecisionTableColumnWizard((GuidedDecisionTableModellerView.Presenter)Mockito.any());
    }

    @Test
    public void testOnAppendColumnWhenActiveDecisionTableIsNotPresent() {
        NewGuidedDecisionTableColumnWizard wizard = (NewGuidedDecisionTableColumnWizard)Mockito.mock(NewGuidedDecisionTableColumnWizard.class);
        Mockito.when((Object)this.wizardManagedInstance.get()).thenReturn((Object)wizard);
        Mockito.when((Object)this.modeller.getActiveDecisionTable()).thenReturn(Optional.empty());
        this.builder.setModeller(this.modeller);
        this.builder.onAppendColumn();
        ((NewGuidedDecisionTableColumnWizard)Mockito.verify((Object)wizard, (VerificationMode)Mockito.never())).init((GuidedDecisionTableView.Presenter)Mockito.any(GuidedDecisionTableView.Presenter.class));
        ((NewGuidedDecisionTableColumnWizard)Mockito.verify((Object)wizard, (VerificationMode)Mockito.never())).start();
    }

    @Test
    public void testOnRefreshMenusEvent() {
        this.builder.onRefreshMenusEvent(new RefreshMenusEvent());
        ((InsertMenuBuilder)Mockito.verify((Object)this.builder)).initialise();
    }

    private Pattern52 makePattern52() {
        return new Pattern52(){
            {
                this.setFactType("Fact");
                this.getChildColumns().add(new ConditionCol52(){
                    {
                        this.setFactType("Fact");
                        this.setFactField("field1");
                        this.setFieldType("String");
                        this.setOperator("==");
                    }
                });
            }
        };
    }

    private List<DTCellValue52> makeDTCellValue52List() {
        return new ArrayList<DTCellValue52>(){
            {
                this.add(new DTCellValue52(Integer.valueOf(1)));
                this.add(new DTCellValue52("descr"));
                this.add(new DTCellValue52("md"));
            }
        };
    }
}

