/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.analysis;

import com.google.gwt.event.shared.EventBus;
import java.util.HashMap;
import java.util.Map;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.DecisionTableAnalyzerProvider;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.services.shared.preferences.ApplicationPreferences;
import org.kie.workbench.common.services.verifier.reporting.client.controller.AnalyzerController;
import org.kie.workbench.common.services.verifier.reporting.client.controller.AnalyzerControllerImpl;
import org.kie.workbench.common.services.verifier.reporting.client.panel.AnalysisReportScreen;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracle;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracleImpl;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.mvp.PlaceRequest;

@RunWith(value=MockitoJUnitRunner.class)
public class DecisionTableAnalyzerProviderTest {
    @Mock
    private AnalysisReportScreen analysisReportScreen;

    @Test
    public void defaultAnalyserSetting() throws Exception {
        HashMap<String, String> preferences = new HashMap<String, String>();
        preferences.put("drools.dateformat", "dd-MMM-yyyy");
        ApplicationPreferences.setUp(preferences);
        Assert.assertTrue((boolean)(this.constructAnalyzer() instanceof AnalyzerControllerImpl));
    }

    @Test
    public void verificationDisabledWithSetting() throws Exception {
        HashMap<String, String> preferences = new HashMap<String, String>(){
            {
                this.put("org.kie.verification.disable-dtable-realtime-verification", "true");
                this.put("drools.dateformat", "dd-MMM-yyyy");
            }
        };
        ApplicationPreferences.setUp((Map)preferences);
        Assert.assertFalse((boolean)(this.constructAnalyzer() instanceof AnalyzerControllerImpl));
    }

    @Test
    public void verificationEnabledByWrongSetting() throws Exception {
        HashMap<String, String> preferences = new HashMap<String, String>(){
            {
                this.put("org.kie.verification.disable-dtable-realtime-verification", "nonBooleanValue");
                this.put("drools.dateformat", "dd-MMM-yyyy");
            }
        };
        ApplicationPreferences.setUp((Map)preferences);
        Assert.assertTrue((boolean)(this.constructAnalyzer() instanceof AnalyzerControllerImpl));
    }

    @Test
    public void verificationEnabledWithSetting() throws Exception {
        HashMap<String, String> preferences = new HashMap<String, String>(){
            {
                this.put("org.kie.verification.disable-dtable-realtime-verification", "false");
                this.put("drools.dateformat", "dd-MMM-yyyy");
            }
        };
        ApplicationPreferences.setUp((Map)preferences);
        Assert.assertTrue((boolean)(this.constructAnalyzer() instanceof AnalyzerControllerImpl));
    }

    private AnalyzerController constructAnalyzer() {
        return new DecisionTableAnalyzerProvider().newAnalyzer((AnalysisReportScreen)Mockito.mock(AnalysisReportScreen.class), (PlaceRequest)Mockito.mock(PlaceRequest.class), (AsyncPackageDataModelOracle)Mockito.mock(AsyncPackageDataModelOracleImpl.class), (GuidedDecisionTable52)Mockito.mock(GuidedDecisionTable52.class), (EventBus)Mockito.mock(EventBus.class));
    }
}

