/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.table;

import com.ait.lienzo.client.core.event.NodeMouseMoveHandler;
import com.ait.lienzo.client.core.event.NodeMouseOutHandler;
import com.ait.lienzo.client.core.types.Point2D;
import com.ait.lienzo.test.LienzoMockitoTestRunner;
import com.google.gwt.event.dom.client.ContextMenuHandler;
import com.google.gwt.event.dom.client.KeyDownHandler;
import com.google.gwt.event.dom.client.MouseDownHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.Command;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import javax.enterprise.event.Event;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.screens.guided.dtable.client.editor.menu.RadarMenuBuilder;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableModellerContextMenuSupport;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableModellerPresenter;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableModellerView;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTablePresenter;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableView;
import org.drools.workbench.screens.guided.dtable.client.widget.table.events.cdi.DecisionTableColumnSelectedEvent;
import org.drools.workbench.screens.guided.dtable.client.widget.table.events.cdi.DecisionTablePinnedEvent;
import org.drools.workbench.screens.guided.dtable.client.widget.table.events.cdi.DecisionTableSelectedEvent;
import org.drools.workbench.screens.guided.dtable.client.widget.table.popovers.ColumnHeaderPopOver;
import org.drools.workbench.screens.guided.dtable.client.widget.table.themes.GuidedDecisionTableRenderer;
import org.drools.workbench.screens.guided.dtable.model.GuidedDecisionTableEditorContent;
import org.guvnor.common.services.shared.metadata.model.Overview;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.services.datamodel.model.PackageDataModelOracleBaselinePayload;
import org.mockito.ArgumentCaptor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.backend.vfs.ObservablePath;
import org.uberfire.ext.wires.core.grids.client.model.Bounds;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseBounds;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridColumn;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridData;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.columns.GridColumnRenderer;
import org.uberfire.ext.wires.core.grids.client.widget.layer.GridLayer;
import org.uberfire.mocks.EventSourceMock;
import org.uberfire.mvp.PlaceRequest;

@RunWith(value=LienzoMockitoTestRunner.class)
public class GuidedDecisionTableModellerPresenterTest {
    @Mock
    private GuidedDecisionTableModellerView view;
    @Mock
    private GridLayer gridLayer;
    private Event<RadarMenuBuilder.UpdateRadarEvent> updateRadarEvent = (Event)Mockito.spy((Object)new EventSourceMock<RadarMenuBuilder.UpdateRadarEvent>(){

        public void fire(RadarMenuBuilder.UpdateRadarEvent event) {
        }
    });
    private Event<DecisionTablePinnedEvent> pinnedEvent = (Event)Mockito.spy((Object)new EventSourceMock<DecisionTablePinnedEvent>(){

        public void fire(DecisionTablePinnedEvent event) {
        }
    });
    private Bounds bounds = new BaseBounds(-1000.0, -1000.0, 2000.0, 2000.0);
    @Mock
    private ManagedInstance<GuidedDecisionTableView.Presenter> dtablePresenterProvider;
    @Mock
    private GuidedDecisionTableView.Presenter dtablePresenter;
    @Mock
    private GuidedDecisionTable52 model;
    @Mock
    private GuidedDecisionTableView dtableView;
    @Mock
    private GuidedDecisionTableModellerContextMenuSupport contextMenuSupport;
    @Mock
    private ColumnHeaderPopOver columnHeaderPopOver;
    private GuidedDecisionTableModellerPresenter presenter;

    @Before
    public void setup() {
        Mockito.when((Object)this.gridLayer.addNodeMouseMoveHandler((NodeMouseMoveHandler)Mockito.any(NodeMouseMoveHandler.class))).thenReturn(Mockito.mock(HandlerRegistration.class));
        Mockito.when((Object)this.gridLayer.addNodeMouseOutHandler((NodeMouseOutHandler)Mockito.any(NodeMouseOutHandler.class))).thenReturn(Mockito.mock(HandlerRegistration.class));
        Mockito.when((Object)this.view.addKeyDownHandler((KeyDownHandler)Mockito.any(KeyDownHandler.class))).thenReturn(Mockito.mock(HandlerRegistration.class));
        Mockito.when((Object)this.view.addContextMenuHandler((ContextMenuHandler)Mockito.any(ContextMenuHandler.class))).thenReturn(Mockito.mock(HandlerRegistration.class));
        Mockito.when((Object)this.view.addMouseDownHandler((MouseDownHandler)Mockito.any(MouseDownHandler.class))).thenReturn(Mockito.mock(HandlerRegistration.class));
        Mockito.when((Object)this.view.getGridLayerView()).thenReturn((Object)this.gridLayer);
        Mockito.when((Object)this.view.getBounds()).thenReturn((Object)this.bounds);
        GuidedDecisionTableModellerPresenter wrapped = new GuidedDecisionTableModellerPresenter(this.view, this.dtablePresenterProvider, this.contextMenuSupport, this.updateRadarEvent, this.pinnedEvent, this.columnHeaderPopOver);
        this.presenter = (GuidedDecisionTableModellerPresenter)Mockito.spy((Object)wrapped);
        Mockito.when((Object)this.dtablePresenterProvider.get()).thenReturn((Object)this.dtablePresenter);
        Mockito.when((Object)this.dtablePresenter.getView()).thenReturn((Object)this.dtableView);
        Mockito.when((Object)this.dtableView.getModel()).thenReturn((Object)new BaseGridData());
    }

    private GuidedDecisionTableView.Presenter makeDecisionTable() {
        GuidedDecisionTableView.Presenter dtPresenter = (GuidedDecisionTableView.Presenter)Mockito.mock(GuidedDecisionTableView.Presenter.class);
        GuidedDecisionTableView dtView = (GuidedDecisionTableView)Mockito.mock(GuidedDecisionTableView.class);
        GuidedDecisionTableRenderer renderer = (GuidedDecisionTableRenderer)Mockito.mock(GuidedDecisionTableRenderer.class);
        BaseGridData dtData = new BaseGridData();
        Mockito.when((Object)dtPresenter.getView()).thenReturn((Object)dtView);
        Mockito.when((Object)dtPresenter.getAccess()).thenReturn(Mockito.mock(GuidedDecisionTablePresenter.Access.class));
        Mockito.when((Object)dtPresenter.getModel()).thenReturn(Mockito.mock(GuidedDecisionTable52.class));
        Mockito.when((Object)dtView.getModel()).thenReturn((Object)dtData);
        Mockito.when((Object)dtView.getRenderer()).thenReturn((Object)renderer);
        Mockito.when((Object)renderer.getHeaderCaptionWidth()).thenReturn((Object)200.0);
        return dtPresenter;
    }

    private GuidedDecisionTableEditorContent makeDecisionTableContent() {
        GuidedDecisionTable52 model = (GuidedDecisionTable52)Mockito.mock(GuidedDecisionTable52.class);
        PackageDataModelOracleBaselinePayload dmoBaseline = (PackageDataModelOracleBaselinePayload)Mockito.mock(PackageDataModelOracleBaselinePayload.class);
        Set workItemDefinitions = Collections.emptySet();
        Overview overview = (Overview)Mockito.mock(Overview.class);
        GuidedDecisionTableEditorContent dtContent = new GuidedDecisionTableEditorContent(model, workItemDefinitions, overview, dmoBaseline);
        return dtContent;
    }

    private GridColumn makeUiColumn() {
        return (GridColumn)Mockito.spy((Object)new BaseGridColumn((GridColumn.HeaderMetaData)Mockito.mock(GridColumn.HeaderMetaData.class), (GridColumnRenderer)Mockito.mock(GridColumnRenderer.class), 100.0));
    }

    @Test
    public void onClose() {
        this.presenter.onClose();
        ((GuidedDecisionTableModellerView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).clear();
        ((GuidedDecisionTableModellerPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.times((int)1))).releaseDecisionTables();
        ((GuidedDecisionTableModellerPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.times((int)1))).releaseHandlerRegistrations();
    }

    @Test
    public void addDecisionTable() {
        ObservablePath path = (ObservablePath)Mockito.mock(ObservablePath.class);
        PlaceRequest placeRequest = (PlaceRequest)Mockito.mock(PlaceRequest.class);
        GuidedDecisionTableEditorContent dtContent = this.makeDecisionTableContent();
        this.presenter.addDecisionTable(path, placeRequest, dtContent, false, null, null);
        ((GuidedDecisionTableModellerPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.times((int)1))).updateLinks();
        ((GridLayer)Mockito.verify((Object)this.gridLayer, (VerificationMode)Mockito.times((int)1))).refreshGridWidgetConnectors();
        ((GuidedDecisionTableModellerView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).addDecisionTable((GuidedDecisionTableView)Mockito.eq((Object)this.dtableView));
    }

    @Test
    public void refreshDecisionTable() {
        GuidedDecisionTableView.Presenter dtPresenter = this.makeDecisionTable();
        GuidedDecisionTableEditorContent dtContent = this.makeDecisionTableContent();
        GuidedDecisionTableView dtView = dtPresenter.getView();
        ObservablePath path = (ObservablePath)Mockito.mock(ObservablePath.class);
        PlaceRequest placeRequest = (PlaceRequest)Mockito.mock(PlaceRequest.class);
        ArgumentCaptor afterRemovalCommandCaptor = ArgumentCaptor.forClass(Command.class);
        this.presenter.refreshDecisionTable(dtPresenter, path, placeRequest, dtContent, false);
        ((GuidedDecisionTableModellerView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).removeDecisionTable((GuidedDecisionTableView)Mockito.eq((Object)dtView), (Command)afterRemovalCommandCaptor.capture());
        Command afterRemovalCommand = (Command)afterRemovalCommandCaptor.getValue();
        Assert.assertNotNull((Object)afterRemovalCommand);
        afterRemovalCommand.execute();
        ((GuidedDecisionTableModellerView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).addDecisionTable((GuidedDecisionTableView)Mockito.eq((Object)dtView));
    }

    @Test
    public void refreshingDecisionTableRetainsExistingLocation() {
        GuidedDecisionTableView.Presenter dtPresenter = this.makeDecisionTable();
        GuidedDecisionTableEditorContent dtContent = this.makeDecisionTableContent();
        GuidedDecisionTableView dtView = dtPresenter.getView();
        ObservablePath path = (ObservablePath)Mockito.mock(ObservablePath.class);
        PlaceRequest placeRequest = (PlaceRequest)Mockito.mock(PlaceRequest.class);
        Point2D dtLocation = new Point2D(100.0, 100.0);
        Mockito.when((Object)dtView.getLocation()).thenReturn((Object)dtLocation);
        ArgumentCaptor afterRemovalCommandCaptor = ArgumentCaptor.forClass(Command.class);
        this.presenter.refreshDecisionTable(dtPresenter, path, placeRequest, dtContent, false);
        ((GuidedDecisionTableView)Mockito.verify((Object)dtView, (VerificationMode)Mockito.times((int)1))).getLocation();
        ((GuidedDecisionTableModellerView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).removeDecisionTable((GuidedDecisionTableView)Mockito.eq((Object)dtView), (Command)afterRemovalCommandCaptor.capture());
        Command afterRemovalCommand = (Command)afterRemovalCommandCaptor.getValue();
        Assert.assertNotNull((Object)afterRemovalCommand);
        afterRemovalCommand.execute();
        ((GuidedDecisionTableView)Mockito.verify((Object)dtView, (VerificationMode)Mockito.times((int)1))).setLocation((Point2D)Mockito.eq((Object)dtLocation));
    }

    @Test
    public void removeDecisionTable() {
        GuidedDecisionTableView.Presenter dtPresenter = this.makeDecisionTable();
        ArgumentCaptor afterRemovalCommandCaptor = ArgumentCaptor.forClass(Command.class);
        this.presenter.removeDecisionTable(dtPresenter);
        ((GuidedDecisionTableModellerView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).removeDecisionTable((GuidedDecisionTableView)Mockito.eq((Object)dtPresenter.getView()), (Command)afterRemovalCommandCaptor.capture());
        Command afterRemovalCommand = (Command)afterRemovalCommandCaptor.getValue();
        Assert.assertNotNull((Object)afterRemovalCommand);
        afterRemovalCommand.execute();
        ((GuidedDecisionTableView.Presenter)Mockito.verify((Object)dtPresenter, (VerificationMode)Mockito.times((int)1))).onClose();
        ((GuidedDecisionTableModellerPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.times((int)1))).removeLinksForDecisionTable((GuidedDecisionTableView.Presenter)Mockito.eq((Object)dtPresenter));
    }

    @Test
    public void isActiveDecisionTableEditableIsReadOnly() {
        GuidedDecisionTableView.Presenter dtPresenter = this.makeDecisionTable();
        GuidedDecisionTablePresenter.Access access = new GuidedDecisionTablePresenter.Access();
        access.setReadOnly(true);
        Mockito.when((Object)this.presenter.getActiveDecisionTable()).thenReturn(Optional.of(dtPresenter));
        Mockito.when((Object)dtPresenter.getAccess()).thenReturn((Object)access);
        Assert.assertFalse((boolean)this.presenter.isActiveDecisionTableEditable());
    }

    @Test
    public void isActiveDecisionTableEditableNotReadOnly() {
        GuidedDecisionTableView.Presenter dtPresenter = this.makeDecisionTable();
        GuidedDecisionTablePresenter.Access access = new GuidedDecisionTablePresenter.Access();
        access.setReadOnly(false);
        Mockito.when((Object)this.presenter.getActiveDecisionTable()).thenReturn(Optional.of(dtPresenter));
        Mockito.when((Object)dtPresenter.getAccess()).thenReturn((Object)access);
        Assert.assertTrue((boolean)this.presenter.isActiveDecisionTableEditable());
    }

    @Test
    public void isActiveDecisionTableEditableLockedByCurrentUser() {
        GuidedDecisionTableView.Presenter dtPresenter = this.makeDecisionTable();
        GuidedDecisionTablePresenter.Access access = new GuidedDecisionTablePresenter.Access();
        access.setLock(GuidedDecisionTablePresenter.Access.LockedBy.CURRENT_USER);
        Mockito.when((Object)this.presenter.getActiveDecisionTable()).thenReturn(Optional.of(dtPresenter));
        Mockito.when((Object)dtPresenter.getAccess()).thenReturn((Object)access);
        Assert.assertTrue((boolean)this.presenter.isActiveDecisionTableEditable());
    }

    @Test
    public void isActiveDecisionTableEditableLockedByOtherUser() {
        GuidedDecisionTableView.Presenter dtPresenter = this.makeDecisionTable();
        GuidedDecisionTablePresenter.Access access = new GuidedDecisionTablePresenter.Access();
        access.setLock(GuidedDecisionTablePresenter.Access.LockedBy.OTHER_USER);
        Mockito.when((Object)this.presenter.getActiveDecisionTable()).thenReturn(Optional.of(dtPresenter));
        Mockito.when((Object)dtPresenter.getAccess()).thenReturn((Object)access);
        Assert.assertFalse((boolean)this.presenter.isActiveDecisionTableEditable());
    }

    @Test
    public void isActiveDecisionTableEditableWhenNoActiveDecisionTale() {
        Mockito.when((Object)this.presenter.getActiveDecisionTable()).thenReturn(Optional.empty());
        Assert.assertFalse((boolean)this.presenter.isActiveDecisionTableEditable());
    }

    @Test
    public void setZoom() {
        this.presenter.setZoom(100);
        ((GuidedDecisionTableModellerView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setZoom(Mockito.eq((int)100));
    }

    @Test
    public void enterPinnedMode() {
        GuidedDecisionTableView.Presenter dtPresenter = this.makeDecisionTable();
        Command command = (Command)Mockito.mock(Command.class);
        this.presenter.enterPinnedMode((GridWidget)dtPresenter.getView(), command);
        ((GridLayer)Mockito.verify((Object)this.gridLayer, (VerificationMode)Mockito.times((int)1))).enterPinnedMode((GridWidget)Mockito.eq((Object)dtPresenter.getView()), (Command)Mockito.eq((Object)command));
        ((ColumnHeaderPopOver)Mockito.verify((Object)this.columnHeaderPopOver, (VerificationMode)Mockito.times((int)1))).hide();
    }

    @Test
    public void exitPinnedMode() {
        Command command = (Command)Mockito.mock(Command.class);
        this.presenter.exitPinnedMode(command);
        ((GridLayer)Mockito.verify((Object)this.gridLayer, (VerificationMode)Mockito.times((int)1))).exitPinnedMode((Command)Mockito.eq((Object)command));
        ((ColumnHeaderPopOver)Mockito.verify((Object)this.columnHeaderPopOver, (VerificationMode)Mockito.times((int)1))).hide();
    }

    @Test
    public void updatePinnedContext() {
        GuidedDecisionTableView.Presenter dtPresenter = this.makeDecisionTable();
        this.presenter.updatePinnedContext((GridWidget)dtPresenter.getView());
        ((GridLayer)Mockito.verify((Object)this.gridLayer, (VerificationMode)Mockito.times((int)1))).updatePinnedContext((GridWidget)Mockito.eq((Object)dtPresenter.getView()));
        ((ColumnHeaderPopOver)Mockito.verify((Object)this.columnHeaderPopOver, (VerificationMode)Mockito.times((int)1))).hide();
    }

    @Test
    public void getPinnedContext() {
        this.presenter.getPinnedContext();
        ((GridLayer)Mockito.verify((Object)this.gridLayer, (VerificationMode)Mockito.times((int)1))).getPinnedContext();
    }

    @Test
    public void isGridPinned() {
        this.presenter.isGridPinned();
        ((GridLayer)Mockito.verify((Object)this.gridLayer, (VerificationMode)Mockito.times((int)1))).isGridPinned();
    }

    @Test
    public void getDefaultTransformMediator() {
        this.presenter.getDefaultTransformMediator();
        ((GridLayer)Mockito.verify((Object)this.gridLayer, (VerificationMode)Mockito.times((int)1))).getDefaultTransformMediator();
    }

    @Test
    public void onDecisionTableSelectedWhenInPinnedMode() {
        final GuidedDecisionTableView.Presenter dtPresenter1 = this.makeDecisionTable();
        final GuidedDecisionTableView.Presenter dtPresenter2 = this.makeDecisionTable();
        DecisionTableSelectedEvent event = new DecisionTableSelectedEvent(dtPresenter1);
        Mockito.when((Object)this.gridLayer.isGridPinned()).thenReturn((Object)true);
        Mockito.when((Object)this.presenter.isDecisionTableAvailable((GuidedDecisionTableView.Presenter)Mockito.eq((Object)dtPresenter1))).thenReturn((Object)true);
        Mockito.when((Object)this.presenter.getAvailableDecisionTables()).thenReturn((Object)new HashSet<GuidedDecisionTableView.Presenter>(){
            {
                this.add(dtPresenter1);
                this.add(dtPresenter2);
            }
        });
        this.presenter.onDecisionTableSelected(event);
        ((GuidedDecisionTableView.Presenter)Mockito.verify((Object)dtPresenter1, (VerificationMode)Mockito.times((int)1))).initialiseAnalysis();
        ((GuidedDecisionTableModellerView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).select((GridWidget)dtPresenter1.getView());
        ((GridLayer)Mockito.verify((Object)this.gridLayer, (VerificationMode)Mockito.times((int)1))).flipToGridWidget((GridWidget)Mockito.eq((Object)dtPresenter1.getView()));
    }

    @Test
    public void onDecisionTableSelectedWhenNotInPinnedMode() {
        final GuidedDecisionTableView.Presenter dtPresenter1 = this.makeDecisionTable();
        final GuidedDecisionTableView.Presenter dtPresenter2 = this.makeDecisionTable();
        DecisionTableSelectedEvent event = new DecisionTableSelectedEvent(dtPresenter1);
        Mockito.when((Object)this.presenter.isDecisionTableAvailable((GuidedDecisionTableView.Presenter)Mockito.eq((Object)dtPresenter1))).thenReturn((Object)true);
        Mockito.when((Object)this.presenter.getAvailableDecisionTables()).thenReturn((Object)new HashSet<GuidedDecisionTableView.Presenter>(){
            {
                this.add(dtPresenter1);
                this.add(dtPresenter2);
            }
        });
        this.presenter.onDecisionTableSelected(event);
        ((GuidedDecisionTableView.Presenter)Mockito.verify((Object)dtPresenter1, (VerificationMode)Mockito.times((int)1))).initialiseAnalysis();
        ((GuidedDecisionTableModellerView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).select((GridWidget)dtPresenter1.getView());
        ((GridLayer)Mockito.verify((Object)this.gridLayer, (VerificationMode)Mockito.never())).flipToGridWidget((GridWidget)Mockito.any(GuidedDecisionTableView.class));
    }

    @Test
    public void onDecisionTableSelectedWithOtherActiveDecisionTable() {
        final GuidedDecisionTableView.Presenter dtPresenter1 = this.makeDecisionTable();
        final GuidedDecisionTableView.Presenter dtPresenter2 = this.makeDecisionTable();
        DecisionTableSelectedEvent event = new DecisionTableSelectedEvent(dtPresenter1);
        Mockito.when((Object)this.presenter.isDecisionTableAvailable((GuidedDecisionTableView.Presenter)Mockito.eq((Object)dtPresenter1))).thenReturn((Object)true);
        Mockito.when((Object)this.presenter.getActiveDecisionTable()).thenReturn(Optional.of(dtPresenter2));
        Mockito.when((Object)this.presenter.getAvailableDecisionTables()).thenReturn((Object)new HashSet<GuidedDecisionTableView.Presenter>(){
            {
                this.add(dtPresenter1);
                this.add(dtPresenter2);
            }
        });
        this.presenter.onDecisionTableSelected(event);
        ((GuidedDecisionTableView.Presenter)Mockito.verify((Object)dtPresenter1, (VerificationMode)Mockito.times((int)1))).initialiseAnalysis();
        ((GuidedDecisionTableModellerView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).select((GridWidget)dtPresenter1.getView());
    }

    @Test
    public void onDecisionTableSelectedWithSameActiveDecisionTable() {
        GuidedDecisionTableView.Presenter dtPresenter = this.makeDecisionTable();
        DecisionTableSelectedEvent event = new DecisionTableSelectedEvent(dtPresenter);
        Mockito.when((Object)this.presenter.isDecisionTableAvailable((GuidedDecisionTableView.Presenter)Mockito.eq((Object)dtPresenter))).thenReturn((Object)true);
        Mockito.when((Object)this.presenter.getActiveDecisionTable()).thenReturn(Optional.of(dtPresenter));
        Mockito.when((Object)this.presenter.getAvailableDecisionTables()).thenReturn(Collections.singleton(dtPresenter));
        this.presenter.onDecisionTableSelected(event);
        ((GuidedDecisionTableView.Presenter)Mockito.verify((Object)dtPresenter, (VerificationMode)Mockito.never())).initialiseAnalysis();
        ((GuidedDecisionTableModellerView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).select((GridWidget)Mockito.any(GuidedDecisionTableView.class));
    }

    @Test
    public void onDecisionTableSelectedNoneSelected() {
        DecisionTableSelectedEvent event = DecisionTableSelectedEvent.NONE;
        this.presenter.onDecisionTableSelected(event);
        Assert.assertFalse((boolean)this.presenter.getActiveDecisionTable().isPresent());
        ((GuidedDecisionTableModellerPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.never())).doDecisionTableSelected((GuidedDecisionTableView.Presenter)Mockito.any(GuidedDecisionTableView.Presenter.class));
    }

    @Test
    public void onDecisionTableSelectedNotAvailable() {
        GuidedDecisionTableView.Presenter dtPresenter1 = this.makeDecisionTable();
        GuidedDecisionTableView.Presenter dtPresenter2 = this.makeDecisionTable();
        DecisionTableSelectedEvent event = new DecisionTableSelectedEvent(dtPresenter1);
        Mockito.when((Object)this.presenter.getAvailableDecisionTables()).thenReturn(Collections.singleton(dtPresenter2));
        this.presenter.onDecisionTableSelected(event);
        Assert.assertFalse((boolean)this.presenter.getActiveDecisionTable().isPresent());
        ((GuidedDecisionTableModellerPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.never())).doDecisionTableSelected((GuidedDecisionTableView.Presenter)Mockito.any(GuidedDecisionTableView.Presenter.class));
    }

    @Test
    public void onDecisionTableLinkedColumnSelected() {
        GridColumn gridColumn = (GridColumn)Mockito.mock(GridColumn.class);
        DecisionTableColumnSelectedEvent event = new DecisionTableColumnSelectedEvent(gridColumn);
        this.presenter.onDecisionTableLinkedColumnSelected(event);
        ((GuidedDecisionTableModellerView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).selectLinkedColumn((GridColumn)Mockito.eq((Object)gridColumn));
    }

    @Test
    public void updateRadar() {
        this.presenter.updateRadar();
        ((Event)Mockito.verify(this.updateRadarEvent, (VerificationMode)Mockito.times((int)1))).fire(Mockito.any(RadarMenuBuilder.UpdateRadarEvent.class));
    }

    @Test
    public void onViewPinnedIsPinned() {
        ArgumentCaptor pinnedEventCaptor = ArgumentCaptor.forClass(DecisionTablePinnedEvent.class);
        GuidedDecisionTableView.Presenter value = this.makeDecisionTable();
        Mockito.when((Object)this.presenter.getActiveDecisionTable()).thenReturn(Optional.of(value));
        this.presenter.onViewPinned(true);
        ((Event)Mockito.verify(this.pinnedEvent, (VerificationMode)Mockito.times((int)1))).fire(pinnedEventCaptor.capture());
        DecisionTablePinnedEvent pinnedEvent = (DecisionTablePinnedEvent)pinnedEventCaptor.getValue();
        Assert.assertNotNull((Object)pinnedEvent);
        Assert.assertEquals((Object)this.presenter, (Object)pinnedEvent.getPresenter());
        Assert.assertTrue((boolean)pinnedEvent.isPinned());
        ((GuidedDecisionTableModellerView)Mockito.verify((Object)this.view)).setPinnedModeIndicatorVisibility(true, 210.0);
    }

    @Test
    public void onViewPinnedIsNotPinned() {
        GuidedDecisionTableView.Presenter dtPresenter = this.makeDecisionTable();
        ArgumentCaptor pinnedEventCaptor = ArgumentCaptor.forClass(DecisionTablePinnedEvent.class);
        Mockito.when((Object)this.presenter.getActiveDecisionTable()).thenReturn(Optional.of(dtPresenter));
        this.presenter.onViewPinned(false);
        ((Event)Mockito.verify(this.pinnedEvent, (VerificationMode)Mockito.times((int)1))).fire(pinnedEventCaptor.capture());
        DecisionTablePinnedEvent pinnedEvent = (DecisionTablePinnedEvent)pinnedEventCaptor.getValue();
        Assert.assertNotNull((Object)pinnedEvent);
        Assert.assertEquals((Object)this.presenter, (Object)pinnedEvent.getPresenter());
        Assert.assertFalse((boolean)pinnedEvent.isPinned());
        ((GuidedDecisionTableModellerView)Mockito.verify((Object)this.view)).setPinnedModeIndicatorVisibility(false, 210.0);
    }

    @Test
    public void testAddOnEnterPinnedModeCommand() {
        Command command = (Command)Mockito.mock(Command.class);
        GridLayer gridLayer = (GridLayer)Mockito.mock(GridLayer.class);
        ((GuidedDecisionTableModellerView)Mockito.doReturn((Object)gridLayer).when((Object)this.view)).getGridLayerView();
        this.presenter.addOnEnterPinnedModeCommand(command);
        ((GridLayer)Mockito.verify((Object)gridLayer)).addOnEnterPinnedModeCommand(command);
    }

    @Test
    public void testAddOnExitPinnedModeCommand() {
        Command command = (Command)Mockito.mock(Command.class);
        GridLayer gridLayer = (GridLayer)Mockito.mock(GridLayer.class);
        ((GuidedDecisionTableModellerView)Mockito.doReturn((Object)gridLayer).when((Object)this.view)).getGridLayerView();
        this.presenter.addOnExitPinnedModeCommand(command);
        ((GridLayer)Mockito.verify((Object)gridLayer)).addOnExitPinnedModeCommand(command);
    }

    @Test
    public void updateLinks() {
        final GuidedDecisionTableView.Presenter dtPresenter1 = this.makeDecisionTable();
        final GuidedDecisionTableView.Presenter dtPresenter2 = this.makeDecisionTable();
        HashSet<GuidedDecisionTableView.Presenter> availableDecisionTables = new HashSet<GuidedDecisionTableView.Presenter>(){
            {
                this.add(dtPresenter1);
                this.add(dtPresenter2);
            }
        };
        Mockito.when((Object)this.presenter.isDecisionTableAvailable((GuidedDecisionTableView.Presenter)Mockito.eq((Object)dtPresenter1))).thenReturn((Object)true);
        Mockito.when((Object)this.presenter.getAvailableDecisionTables()).thenReturn((Object)availableDecisionTables);
        this.presenter.updateLinks();
        ((GuidedDecisionTableView.Presenter)Mockito.verify((Object)dtPresenter1, (VerificationMode)Mockito.times((int)1))).link((Set)Mockito.eq((Object)availableDecisionTables));
        ((GuidedDecisionTableView.Presenter)Mockito.verify((Object)dtPresenter2, (VerificationMode)Mockito.times((int)1))).link((Set)Mockito.eq((Object)availableDecisionTables));
        ((GridLayer)Mockito.verify((Object)this.gridLayer, (VerificationMode)Mockito.times((int)1))).refreshGridWidgetConnectors();
    }

    @Test
    public void checkRemoveLinksPreservesOtherTables() {
        GuidedDecisionTableView.Presenter dtPresenter1 = this.makeDecisionTable();
        final GuidedDecisionTableView.Presenter dtPresenter2 = this.makeDecisionTable();
        HashSet<GuidedDecisionTableView.Presenter> availableDecisionTables = new HashSet<GuidedDecisionTableView.Presenter>(){
            {
                this.add(dtPresenter2);
            }
        };
        GridColumn dtPresenter1Column1 = this.makeUiColumn();
        GridColumn dtPresenter1Column2 = this.makeUiColumn();
        GridColumn dtPresenter2Column1 = this.makeUiColumn();
        GridColumn dtPresenter2Column2 = this.makeUiColumn();
        dtPresenter1.getView().getModel().appendColumn(dtPresenter1Column1);
        dtPresenter1.getView().getModel().appendColumn(dtPresenter1Column2);
        dtPresenter2.getView().getModel().appendColumn(dtPresenter2Column1);
        dtPresenter2.getView().getModel().appendColumn(dtPresenter2Column2);
        dtPresenter1Column2.setLink(dtPresenter2Column2);
        dtPresenter2Column1.setLink(dtPresenter1Column1);
        Mockito.when((Object)this.presenter.getAvailableDecisionTables()).thenReturn((Object)availableDecisionTables);
        ((GridColumn)Mockito.verify((Object)dtPresenter1Column2, (VerificationMode)Mockito.times((int)1))).setLink((GridColumn)Mockito.eq((Object)dtPresenter2Column2));
        ((GridColumn)Mockito.verify((Object)dtPresenter2Column1, (VerificationMode)Mockito.times((int)1))).setLink((GridColumn)Mockito.eq((Object)dtPresenter1Column1));
        Mockito.reset((Object[])new GridColumn[]{dtPresenter1Column1, dtPresenter1Column2, dtPresenter2Column1, dtPresenter2Column2});
        this.presenter.removeLinksForDecisionTable(dtPresenter1);
        ((GridColumn)Mockito.verify((Object)dtPresenter1Column1, (VerificationMode)Mockito.never())).setLink((GridColumn)Mockito.any());
        ((GridColumn)Mockito.verify((Object)dtPresenter1Column2, (VerificationMode)Mockito.never())).setLink((GridColumn)Mockito.any());
        ((GridColumn)Mockito.verify((Object)dtPresenter2Column1, (VerificationMode)Mockito.times((int)1))).setLink((GridColumn)Mockito.eq(null));
        ((GridColumn)Mockito.verify((Object)dtPresenter2Column2, (VerificationMode)Mockito.never())).setLink((GridColumn)Mockito.any());
    }
}

