/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.table;

import com.google.gwt.event.shared.EventBus;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.ArrayList;
import org.drools.workbench.models.guided.dtable.shared.model.ActionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.ActionInsertFactCol52;
import org.drools.workbench.models.guided.dtable.shared.model.ActionRetractFactCol52;
import org.drools.workbench.models.guided.dtable.shared.model.ActionSetFieldCol52;
import org.drools.workbench.models.guided.dtable.shared.model.ActionWorkItemCol52;
import org.drools.workbench.models.guided.dtable.shared.model.ActionWorkItemInsertFactCol52;
import org.drools.workbench.models.guided.dtable.shared.model.ActionWorkItemSetFieldCol52;
import org.drools.workbench.models.guided.dtable.shared.model.BRLActionColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BRLConditionColumn;
import org.drools.workbench.models.guided.dtable.shared.model.ConditionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.DTColumnConfig52;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.models.guided.dtable.shared.model.LimitedEntryBRLActionColumn;
import org.drools.workbench.models.guided.dtable.shared.model.LimitedEntryBRLConditionColumn;
import org.drools.workbench.models.guided.dtable.shared.model.Pattern52;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableView;
import org.drools.workbench.screens.guided.dtable.client.widget.table.PluginHandler;
import org.drools.workbench.screens.guided.dtable.client.widget.table.popovers.MockInstanceImpl;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.NewGuidedDecisionTableColumnWizard;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.AdditionalInfoPage;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.CalculationTypePage;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.DefaultValuesPage;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.FieldPage;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.OperatorPage;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.PatternPage;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.PatternToDeletePage;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.RuleModellerPage;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.SummaryPage;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.ValueOptionsPage;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.WorkItemPage;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.common.DecisionTablePopoverUtils;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.plugins.ActionRetractFactPlugin;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.plugins.ActionSetFactPlugin;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.plugins.ActionWorkItemPlugin;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.plugins.ActionWorkItemSetFieldPlugin;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.plugins.BRLActionColumnPlugin;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.plugins.BRLConditionColumnPlugin;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.plugins.ConditionColumnPlugin;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.plugins.commons.BaseDecisionTableColumnPlugin;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.plugins.commons.DecisionTableColumnPlugin;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracle;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.widgets.core.client.wizards.WizardPageStatusChangeEvent;
import org.uberfire.ext.widgets.core.client.wizards.WizardView;
import org.uberfire.mocks.EventSourceMock;

@RunWith(value=GwtMockitoTestRunner.class)
public class PluginHandlerTest {
    @Mock
    private TranslationService translationService;
    @Mock
    private RuleModellerPage ruleModellerPage;
    @Mock
    private SummaryPage summaryPage;
    @Mock
    private PatternToDeletePage patternToDeletePage;
    @Mock
    private WorkItemPage workItemPage;
    @Mock
    private PatternPage patternPage;
    @Mock
    private CalculationTypePage calculationTypePage;
    @Mock
    private FieldPage fieldPage;
    @Mock
    private OperatorPage operatorPage;
    @Mock
    private ValueOptionsPage valueOptionsPage;
    @Mock
    private AdditionalInfoPage additionalInfoPage;
    @Mock
    private DefaultValuesPage defaultValuesPage;
    @Mock
    private ManagedInstance<NewGuidedDecisionTableColumnWizard> wizardManagedInstance;
    @Mock
    private ManagedInstance<BRLConditionColumnPlugin> brlConditionColumnPlugin;
    @Mock
    private ManagedInstance<ConditionColumnPlugin> conditionColumnPlugin;
    @Mock
    private ManagedInstance<ActionRetractFactPlugin> actionRetractFactPlugin;
    @Mock
    private ManagedInstance<ActionSetFactPlugin> actionSetFactPlugin;
    @Mock
    private ManagedInstance<ActionWorkItemSetFieldPlugin> actionWorkItemSetFieldPlugin;
    @Mock
    private ManagedInstance<ActionWorkItemPlugin> actionWorkItemPlugin;
    @Mock
    private ManagedInstance<BRLActionColumnPlugin> brlActionColumnPlugin;
    @Mock
    private GuidedDecisionTableView.Presenter presenter;
    @Mock
    private GuidedDecisionTable52 model;
    @Mock
    private EventBus eventBus;
    @Mock
    private AsyncPackageDataModelOracle oracle;
    @Mock
    private EventSourceMock<WizardPageStatusChangeEvent> event;
    @Mock
    private DecisionTablePopoverUtils popoverUtils;
    private PluginHandler pluginHandler;
    private NewGuidedDecisionTableColumnWizard wizard;

    @Before
    public void setup() {
        this.pluginHandler = (PluginHandler)Mockito.spy((Object)new PluginHandler(this.wizardManagedInstance, this.brlConditionColumnPlugin, this.conditionColumnPlugin, this.actionRetractFactPlugin, this.actionSetFactPlugin, this.actionWorkItemSetFieldPlugin, this.actionWorkItemPlugin, this.brlActionColumnPlugin));
        this.pluginHandler.init(this.presenter);
        this.wizard = (NewGuidedDecisionTableColumnWizard)Mockito.spy((Object)new NewGuidedDecisionTableColumnWizard((WizardView)Mockito.mock(WizardView.class), this.summaryPage, this.translationService, this.popoverUtils));
        ((GuidedDecisionTable52)Mockito.doReturn((Object)GuidedDecisionTable52.TableFormat.EXTENDED_ENTRY).when((Object)this.model)).getTableFormat();
        ((GuidedDecisionTableView.Presenter)Mockito.doReturn((Object)this.model).when((Object)this.presenter)).getModel();
        ((GuidedDecisionTableView.Presenter)Mockito.doReturn((Object)this.eventBus).when((Object)this.presenter)).getEventBus();
        ((GuidedDecisionTableView.Presenter)Mockito.doReturn((Object)this.oracle).when((Object)this.presenter)).getDataModelOracle();
    }

    @Test
    public void testEditWhenColumnIsAnActionWorkItemSetFieldCol52() {
        ActionWorkItemSetFieldCol52 originalColumn = (ActionWorkItemSetFieldCol52)Mockito.mock(ActionWorkItemSetFieldCol52.class);
        ActionWorkItemSetFieldPlugin plugin = (ActionWorkItemSetFieldPlugin)Mockito.spy((Object)new ActionWorkItemSetFieldPlugin(this.patternPage, this.fieldPage, this.additionalInfoPage, this.workItemPage, this.event, this.translationService));
        ((ManagedInstance)Mockito.doReturn((Object)this.wizard).when(this.wizardManagedInstance)).get();
        ((ManagedInstance)Mockito.doReturn((Object)plugin).when(this.actionWorkItemSetFieldPlugin)).get();
        this.pluginHandler.edit((ActionCol52)originalColumn);
        ((ActionWorkItemSetFieldPlugin)Mockito.verify((Object)plugin)).setOriginalColumnConfig52((DTColumnConfig52)originalColumn);
        ((PluginHandler)Mockito.verify((Object)this.pluginHandler)).openWizard((DecisionTableColumnPlugin)plugin);
        ((NewGuidedDecisionTableColumnWizard)Mockito.verify((Object)this.wizard)).start((DecisionTableColumnPlugin)plugin);
    }

    @Test
    public void testEditWhenColumnIsAnActionWorkItemInsertFactCol52() {
        ActionWorkItemInsertFactCol52 originalColumn = (ActionWorkItemInsertFactCol52)Mockito.mock(ActionWorkItemInsertFactCol52.class);
        ActionWorkItemSetFieldPlugin plugin = (ActionWorkItemSetFieldPlugin)Mockito.spy((Object)new ActionWorkItemSetFieldPlugin(this.patternPage, this.fieldPage, this.additionalInfoPage, this.workItemPage, this.event, this.translationService));
        ((ManagedInstance)Mockito.doReturn((Object)this.wizard).when(this.wizardManagedInstance)).get();
        ((ManagedInstance)Mockito.doReturn((Object)plugin).when(this.actionWorkItemSetFieldPlugin)).get();
        this.pluginHandler.edit((ActionCol52)originalColumn);
        ((ActionWorkItemSetFieldPlugin)Mockito.verify((Object)plugin)).setOriginalColumnConfig52((DTColumnConfig52)originalColumn);
        ((PluginHandler)Mockito.verify((Object)this.pluginHandler)).openWizard((DecisionTableColumnPlugin)plugin);
        ((NewGuidedDecisionTableColumnWizard)Mockito.verify((Object)this.wizard)).start((DecisionTableColumnPlugin)plugin);
    }

    @Test
    public void testEditWhenColumnIsAnActionInsertFactCol52() {
        ActionInsertFactCol52 originalColumn = (ActionInsertFactCol52)Mockito.mock(ActionInsertFactCol52.class);
        ActionSetFactPlugin plugin = (ActionSetFactPlugin)Mockito.spy((Object)new ActionSetFactPlugin(this.patternPage, this.fieldPage, this.valueOptionsPage, this.additionalInfoPage, this.event, this.translationService));
        this.testEditActionColumn((BaseDecisionTableColumnPlugin)plugin, this.actionSetFactPlugin, (ActionCol52)originalColumn);
    }

    @Test
    public void testEditWhenColumnIsAnActionSetFieldCol52() {
        ActionSetFieldCol52 originalColumn = (ActionSetFieldCol52)Mockito.mock(ActionSetFieldCol52.class);
        ActionSetFactPlugin plugin = (ActionSetFactPlugin)Mockito.spy((Object)new ActionSetFactPlugin(this.patternPage, this.fieldPage, this.valueOptionsPage, this.additionalInfoPage, this.event, this.translationService));
        this.testEditActionColumn((BaseDecisionTableColumnPlugin)plugin, this.actionSetFactPlugin, (ActionCol52)originalColumn);
    }

    @Test
    public void testEditWhenColumnIsAnActionRetractFactCol52() {
        ActionRetractFactCol52 originalColumn = (ActionRetractFactCol52)Mockito.mock(ActionRetractFactCol52.class);
        ActionRetractFactPlugin plugin = (ActionRetractFactPlugin)Mockito.spy((Object)new ActionRetractFactPlugin(this.patternToDeletePage, this.additionalInfoPage, this.event, this.translationService));
        this.testEditActionColumn((BaseDecisionTableColumnPlugin)plugin, this.actionRetractFactPlugin, (ActionCol52)originalColumn);
    }

    @Test
    public void testEditWhenColumnIsAnActionWorkItemCol52() {
        ActionWorkItemCol52 originalColumn = (ActionWorkItemCol52)Mockito.mock(ActionWorkItemCol52.class);
        ActionWorkItemPlugin plugin = (ActionWorkItemPlugin)Mockito.spy((Object)new ActionWorkItemPlugin(this.additionalInfoPage, this.workItemPage, this.event, this.translationService));
        this.testEditActionColumn((BaseDecisionTableColumnPlugin)plugin, this.actionWorkItemPlugin, (ActionCol52)originalColumn);
    }

    @Test
    public void testEditWhenColumnIsALimitedEntryBRLActionColumn() {
        LimitedEntryBRLActionColumn originalColumn = (LimitedEntryBRLActionColumn)Mockito.mock(LimitedEntryBRLActionColumn.class);
        BRLActionColumnPlugin plugin = (BRLActionColumnPlugin)Mockito.spy((Object)new BRLActionColumnPlugin(this.ruleModellerPage, this.defaultValuesPage, new MockInstanceImpl(new ArrayList()), this.additionalInfoPage, this.event, this.translationService));
        this.testEditActionColumn((BaseDecisionTableColumnPlugin)plugin, this.brlActionColumnPlugin, (ActionCol52)originalColumn);
    }

    @Test
    public void testEditWhenColumnIsABRLActionColumn() {
        BRLActionColumn originalColumn = (BRLActionColumn)Mockito.mock(BRLActionColumn.class);
        BRLActionColumnPlugin plugin = (BRLActionColumnPlugin)Mockito.spy((Object)new BRLActionColumnPlugin(this.ruleModellerPage, this.defaultValuesPage, new MockInstanceImpl(new ArrayList()), this.additionalInfoPage, this.event, this.translationService));
        this.testEditActionColumn((BaseDecisionTableColumnPlugin)plugin, this.brlActionColumnPlugin, (ActionCol52)originalColumn);
    }

    private void testEditActionColumn(BaseDecisionTableColumnPlugin plugin, ManagedInstance pluginManagedInstance, ActionCol52 originalColumn) {
        ((ManagedInstance)Mockito.doReturn((Object)this.wizard).when(this.wizardManagedInstance)).get();
        ((ManagedInstance)Mockito.doReturn((Object)plugin).when((Object)pluginManagedInstance)).get();
        this.pluginHandler.edit(originalColumn);
        ((BaseDecisionTableColumnPlugin)Mockito.verify((Object)plugin)).setOriginalColumnConfig52((DTColumnConfig52)originalColumn);
        ((PluginHandler)Mockito.verify((Object)this.pluginHandler)).openWizard((DecisionTableColumnPlugin)plugin);
        ((NewGuidedDecisionTableColumnWizard)Mockito.verify((Object)this.wizard)).start((DecisionTableColumnPlugin)plugin);
    }

    @Test
    public void testEditWhenColumnIsInvalid() {
        ActionCol52 column = (ActionCol52)Mockito.mock(ActionCol52.class);
        DecisionTableColumnPlugin plugin = (DecisionTableColumnPlugin)Mockito.mock(DecisionTableColumnPlugin.class);
        ((ManagedInstance)Mockito.doReturn((Object)plugin).when(this.actionWorkItemSetFieldPlugin)).get();
        this.pluginHandler.edit(column);
        ((DecisionTableColumnPlugin)Mockito.verify((Object)plugin, (VerificationMode)Mockito.never())).setOriginalColumnConfig52((DTColumnConfig52)column);
        ((PluginHandler)Mockito.verify((Object)this.pluginHandler, (VerificationMode)Mockito.never())).openWizard(plugin);
    }

    @Test
    public void testEditWhenColumnIsABRLConditionColumn() {
        BRLConditionColumn originalColumn = (BRLConditionColumn)Mockito.mock(BRLConditionColumn.class);
        this.testEditBrlConditionColumn(originalColumn);
    }

    @Test
    public void testEditWhenColumnIsALimitedEntryBRLConditionColumn() {
        LimitedEntryBRLConditionColumn originalColumn = (LimitedEntryBRLConditionColumn)Mockito.mock(LimitedEntryBRLConditionColumn.class);
        this.testEditBrlConditionColumn((BRLConditionColumn)originalColumn);
    }

    private void testEditBrlConditionColumn(BRLConditionColumn originalColumn) {
        BRLConditionColumnPlugin plugin = (BRLConditionColumnPlugin)Mockito.spy((Object)new BRLConditionColumnPlugin(this.ruleModellerPage, this.defaultValuesPage, this.additionalInfoPage, this.event, this.translationService));
        ((ManagedInstance)Mockito.doReturn((Object)this.wizard).when(this.wizardManagedInstance)).get();
        ((ManagedInstance)Mockito.doReturn((Object)plugin).when(this.brlConditionColumnPlugin)).get();
        this.pluginHandler.edit(originalColumn);
        ((BRLConditionColumnPlugin)Mockito.verify((Object)plugin)).setOriginalColumnConfig52((DTColumnConfig52)originalColumn);
        ((PluginHandler)Mockito.verify((Object)this.pluginHandler)).openWizard((DecisionTableColumnPlugin)plugin);
        ((NewGuidedDecisionTableColumnWizard)Mockito.verify((Object)this.wizard)).start((DecisionTableColumnPlugin)plugin);
    }

    @Test
    public void testEditWhenColumnIsAConditionCol52() {
        Pattern52 originalPattern = (Pattern52)Mockito.mock(Pattern52.class);
        ConditionCol52 originalColumn = (ConditionCol52)Mockito.mock(ConditionCol52.class);
        ConditionColumnPlugin plugin = (ConditionColumnPlugin)Mockito.spy((Object)new ConditionColumnPlugin(this.patternPage, this.calculationTypePage, this.fieldPage, this.operatorPage, this.valueOptionsPage, this.additionalInfoPage, this.event, this.translationService));
        ((ManagedInstance)Mockito.doReturn((Object)this.wizard).when(this.wizardManagedInstance)).get();
        ((ManagedInstance)Mockito.doReturn((Object)plugin).when(this.conditionColumnPlugin)).get();
        ((ConditionColumnPlugin)Mockito.doReturn((Object)new Pattern52()).when((Object)plugin)).getEditingPattern();
        this.pluginHandler.edit(originalPattern, originalColumn);
        ((ConditionColumnPlugin)Mockito.verify((Object)plugin)).setOriginalPattern52(originalPattern);
        ((ConditionColumnPlugin)Mockito.verify((Object)plugin)).setOriginalColumnConfig52((DTColumnConfig52)originalColumn);
        ((PluginHandler)Mockito.verify((Object)this.pluginHandler)).openWizard((DecisionTableColumnPlugin)plugin);
        ((NewGuidedDecisionTableColumnWizard)Mockito.verify((Object)this.wizard)).start((DecisionTableColumnPlugin)plugin);
    }

    @Test
    public void testOpenWizardWhenTableIsReadOnly() throws Exception {
        DecisionTableColumnPlugin plugin = (DecisionTableColumnPlugin)Mockito.mock(DecisionTableColumnPlugin.class);
        NewGuidedDecisionTableColumnWizard wizard = (NewGuidedDecisionTableColumnWizard)Mockito.mock(NewGuidedDecisionTableColumnWizard.class);
        ((GuidedDecisionTableView.Presenter)Mockito.doReturn((Object)true).when((Object)this.presenter)).isReadOnly();
        ((ManagedInstance)Mockito.doReturn((Object)wizard).when(this.wizardManagedInstance)).get();
        this.pluginHandler.openWizard(plugin);
        ((NewGuidedDecisionTableColumnWizard)Mockito.verify((Object)wizard, (VerificationMode)Mockito.never())).init(this.presenter);
        ((NewGuidedDecisionTableColumnWizard)Mockito.verify((Object)wizard, (VerificationMode)Mockito.never())).start(plugin);
    }

    @Test
    public void testOpenWizardWhenTableIsNotReadOnly() throws Exception {
        DecisionTableColumnPlugin plugin = (DecisionTableColumnPlugin)Mockito.mock(DecisionTableColumnPlugin.class);
        NewGuidedDecisionTableColumnWizard wizard = (NewGuidedDecisionTableColumnWizard)Mockito.mock(NewGuidedDecisionTableColumnWizard.class);
        ((GuidedDecisionTableView.Presenter)Mockito.doReturn((Object)false).when((Object)this.presenter)).isReadOnly();
        ((ManagedInstance)Mockito.doReturn((Object)wizard).when(this.wizardManagedInstance)).get();
        this.pluginHandler.openWizard(plugin);
        ((NewGuidedDecisionTableColumnWizard)Mockito.verify((Object)wizard)).init(this.presenter);
        ((NewGuidedDecisionTableColumnWizard)Mockito.verify((Object)wizard)).start(plugin);
    }
}

