/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.table.columns;

import com.ait.lienzo.client.core.shape.Node;
import com.ait.lienzo.client.core.shape.Text;
import com.ait.lienzo.test.LienzoMockitoTestRunner;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTablePresenter;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableView;
import org.drools.workbench.screens.guided.dtable.client.widget.table.columns.EnumSingleSelectStringUiColumn;
import org.drools.workbench.screens.guided.dtable.client.widget.table.columns.dom.listbox.ListBoxStringSingletonDOMElementFactory;
import org.drools.workbench.screens.guided.dtable.client.widget.table.columns.dom.listbox.MultiValueSingletonDOMElementFactory;
import org.drools.workbench.screens.guided.dtable.client.widget.table.columns.dom.textbox.SingleValueSingletonDOMElementFactory;
import org.drools.workbench.screens.guided.dtable.client.widget.table.columns.dom.textbox.TextBoxStringSingletonDOMElementFactory;
import org.drools.workbench.screens.guided.dtable.client.widget.table.model.GuidedDecisionTableUiCell;
import org.drools.workbench.screens.guided.dtable.client.widget.table.utilities.DependentEnumsUtilities;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.client.callbacks.Callback;
import org.uberfire.ext.wires.core.grids.client.model.GridCell;
import org.uberfire.ext.wires.core.grids.client.model.GridCellValue;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridCell;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridCellValue;
import org.uberfire.ext.wires.core.grids.client.widget.context.GridBodyCellRenderContext;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.grids.GridRenderer;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.themes.GridRendererTheme;

@RunWith(value=LienzoMockitoTestRunner.class)
public class BaseEnumSingleSelectUiColumnTest {
    @Mock
    private GridColumn.HeaderMetaData headerMetaData;
    @Mock
    private GuidedDecisionTablePresenter.Access access;
    @Mock
    private ListBoxStringSingletonDOMElementFactory multiValueFactory;
    @Mock
    private TextBoxStringSingletonDOMElementFactory singleValueFactory;
    @Mock
    private GuidedDecisionTableView.Presenter presenter;
    @Mock
    private GuidedDecisionTableView view;
    @Mock
    private GridData uiModel;
    @Mock
    private GridBodyCellRenderContext context;
    @Mock
    private GridRenderer renderer;
    @Mock
    private GridRendererTheme theme;
    @Mock
    private Text bodyText;
    @Mock
    private Node bodyTextNode;
    @Mock
    private Callback<GridCellValue<String>> callback;
    @Captor
    private ArgumentCaptor<BaseGridCellValue<Boolean>> callbackArgumentCaptor;
    private EnumSingleSelectStringUiColumn column;

    @Before
    public void setup() {
        ArrayList<GridColumn.HeaderMetaData> metaDataList = new ArrayList<GridColumn.HeaderMetaData>(){
            {
                this.add(BaseEnumSingleSelectUiColumnTest.this.headerMetaData);
            }
        };
        this.column = new EnumSingleSelectStringUiColumn((List)metaDataList, 100.0, true, true, this.access, (MultiValueSingletonDOMElementFactory)this.multiValueFactory, (SingleValueSingletonDOMElementFactory)this.singleValueFactory, this.presenter, "FactType", "FactField");
        Mockito.when((Object)this.presenter.getView()).thenReturn((Object)this.view);
        Mockito.when((Object)this.view.getModel()).thenReturn((Object)this.uiModel);
        Mockito.when((Object)this.context.getRenderer()).thenReturn((Object)this.renderer);
        Mockito.when((Object)this.context.getCellWidth()).thenReturn((Object)100.0);
        Mockito.when((Object)this.context.getCellHeight()).thenReturn((Object)32.0);
        Mockito.when((Object)this.renderer.getTheme()).thenReturn((Object)this.theme);
        Mockito.when((Object)this.theme.getBodyText()).thenReturn((Object)this.bodyText);
        Mockito.when((Object)this.bodyText.setListening(Mockito.anyBoolean())).thenReturn((Object)this.bodyText);
        Mockito.when((Object)this.bodyText.setX(Mockito.anyDouble())).thenReturn((Object)this.bodyText);
        Mockito.when((Object)this.bodyText.setY(Mockito.anyDouble())).thenReturn((Object)this.bodyText);
        Mockito.when((Object)this.bodyText.asNode()).thenReturn((Object)this.bodyTextNode);
    }

    @Test
    public void renderCellWhenCellValueIsInEnumData() {
        this.setupEnums("A", "A");
        Mockito.when((Object)this.access.isEditable()).thenReturn((Object)true);
        BaseGridCell cell = new BaseGridCell((GridCellValue)new GuidedDecisionTableUiCell((Object)"A"));
        this.column.getColumnRenderer().renderCell((GridCell)cell, this.context);
        ((Text)Mockito.verify((Object)this.bodyText, (VerificationMode)Mockito.times((int)1))).setText((String)Mockito.eq((Object)"A"));
        ((GridData)Mockito.verify((Object)this.uiModel, (VerificationMode)Mockito.never())).deleteCell(Mockito.anyInt(), Mockito.anyInt());
    }

    @Test
    public void clearModelWhenCellValueIsNotInEnumData() {
        this.setupEnums("B", "A");
        Mockito.when((Object)this.access.isEditable()).thenReturn((Object)true);
        BaseGridCell cell = new BaseGridCell((GridCellValue)new GuidedDecisionTableUiCell((Object)"B"));
        this.column.getColumnRenderer().renderCell((GridCell)cell, this.context);
        ((Text)Mockito.verify((Object)this.bodyText, (VerificationMode)Mockito.times((int)1))).setText((String)Mockito.eq((Object)""));
        ((GridData)Mockito.verify((Object)this.uiModel, (VerificationMode)Mockito.times((int)1))).deleteCell(Mockito.anyInt(), Mockito.anyInt());
    }

    private void setupEnums(String cellValue, String ... values) {
        HashMap<String, String> enums = new HashMap<String, String>();
        for (String value : values) {
            enums.put(value, value);
        }
        ((GuidedDecisionTableView.Presenter)Mockito.doAnswer(invocation -> {
            Callback callback = (Callback)invocation.getArguments()[3];
            callback.callback((Object)enums);
            return null;
        }).when((Object)this.presenter)).getEnumLookups(Mockito.anyString(), Mockito.anyString(), (DependentEnumsUtilities.Context)Mockito.any(DependentEnumsUtilities.Context.class), (Callback)Mockito.any(Callback.class));
        Mockito.when((Object)this.multiValueFactory.convert((String)Mockito.eq((Object)cellValue))).thenReturn((Object)cellValue);
    }
}

