/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.table.columns.control;

import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwtmockito.GwtMockitoTestRunner;
import com.google.gwtmockito.WithClassesToStub;
import java.util.HashMap;
import org.drools.workbench.models.datamodel.rule.Attribute;
import org.drools.workbench.models.guided.dtable.shared.model.AttributeCol52;
import org.drools.workbench.models.guided.dtable.shared.model.DTCellValue52;
import org.drools.workbench.screens.guided.dtable.client.widget.table.columns.control.AttributeColumnConfigRowView;
import org.drools.workbench.screens.guided.dtable.client.widget.table.columns.control.ColumnLabelWidget;
import org.drools.workbench.screens.guided.dtable.client.widget.table.columns.control.DeleteColumnManagementAnchorWidget;
import org.gwtbootstrap3.client.ui.CheckBox;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.services.shared.preferences.ApplicationPreferences;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;

@WithClassesToStub(value={ColumnLabelWidget.class})
@RunWith(value=GwtMockitoTestRunner.class)
public class AttributeColumnConfigRowViewTest {
    AttributeColumnConfigRowView view;
    @Mock
    AttributeCol52 attributeColumn;
    @Mock
    DTCellValue52 defaultValue;
    @Mock
    DeleteColumnManagementAnchorWidget deleteWidget;
    @Captor
    ArgumentCaptor<Widget> widgetCaptor;

    @Before
    public void setUp() throws Exception {
        this.view = (AttributeColumnConfigRowView)Mockito.spy((Object)new AttributeColumnConfigRowView(this.deleteWidget));
        Mockito.when((Object)this.attributeColumn.getAttribute()).thenReturn((Object)Attribute.SALIENCE.getAttributeName());
        Mockito.when((Object)this.attributeColumn.getDefaultValue()).thenReturn((Object)this.defaultValue);
        HashMap<String, String> preferences = new HashMap<String, String>();
        preferences.put("drools.dateformat", "dd/mm/yy");
        ApplicationPreferences.setUp(preferences);
    }

    @Test
    public void testAddRemoveAttributeButton() throws Exception {
        this.view.addRemoveAttributeButton(null, false);
        ((AttributeColumnConfigRowView)Mockito.verify((Object)this.view)).add((Widget)this.widgetCaptor.capture());
        Assert.assertTrue((boolean)(this.widgetCaptor.getValue() instanceof Anchor));
    }

    @Test
    public void testAddColumnLabel() throws Exception {
        this.view.addColumnLabel(this.attributeColumn);
        ((AttributeColumnConfigRowView)Mockito.verify((Object)this.view)).add((Widget)this.widgetCaptor.capture());
        Assert.assertTrue((boolean)(this.widgetCaptor.getValue() instanceof ColumnLabelWidget));
    }

    @Test
    public void testAddDefaultValue() throws Exception {
        this.view.addDefaultValue(this.attributeColumn, true, null);
        ((AttributeColumnConfigRowView)Mockito.verify((Object)this.view)).add((Widget)Matchers.any(Widget.class));
    }

    @Test
    public void testAddUseRowNumberCheckBox() throws Exception {
        this.view.addUseRowNumberCheckBox(this.attributeColumn, true, null);
        ((AttributeColumnConfigRowView)Mockito.verify((Object)this.view)).add((Widget)this.widgetCaptor.capture());
        Assert.assertTrue((boolean)(this.widgetCaptor.getValue() instanceof CheckBox));
    }

    @Test
    public void testAddReverseOrderCheckBox() throws Exception {
        this.view.addReverseOrderCheckBox(this.attributeColumn, true, null);
        ((AttributeColumnConfigRowView)Mockito.verify((Object)this.view)).add((Widget)this.widgetCaptor.capture());
        Assert.assertTrue((boolean)(this.widgetCaptor.getValue() instanceof CheckBox));
    }

    @Test
    public void testAddHideColumnCheckBox() throws Exception {
        this.view.addHideColumnCheckBox(this.attributeColumn, null);
        ((AttributeColumnConfigRowView)Mockito.verify((Object)this.view)).add((Widget)this.widgetCaptor.capture());
        Assert.assertTrue((boolean)(this.widgetCaptor.getValue() instanceof CheckBox));
    }
}

