/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.table.columns.dom.listbox;

import com.ait.lienzo.client.core.types.Transform;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.BlurEvent;
import com.google.gwt.event.dom.client.BlurHandler;
import com.google.gwt.event.dom.client.DomEvent;
import com.google.gwt.event.dom.client.KeyDownEvent;
import com.google.gwt.event.dom.client.KeyDownHandler;
import com.google.gwt.event.dom.client.MouseDownEvent;
import com.google.gwt.event.dom.client.MouseDownHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.ui.AbsolutePanel;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Collections;
import java.util.function.Consumer;
import org.assertj.core.api.Assertions;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableView;
import org.drools.workbench.screens.guided.dtable.client.widget.table.columns.dom.listbox.ListBoxSingletonDOMElementFactory;
import org.gwtbootstrap3.client.ui.ListBox;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridData;
import org.uberfire.ext.wires.core.grids.client.widget.context.GridBodyCellRenderContext;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;
import org.uberfire.ext.wires.core.grids.client.widget.grid.keyboard.KeyDownHandlerCommon;
import org.uberfire.ext.wires.core.grids.client.widget.layer.GridLayer;
import org.uberfire.ext.wires.core.grids.client.widget.layer.impl.GridLayerRedrawManager;
import org.uberfire.ext.wires.core.grids.client.widget.layer.impl.GridLienzoPanel;

@RunWith(value=GwtMockitoTestRunner.class)
public class ListBoxSingletonDOMElementFactoryTest {
    @Mock
    private ListBox listBox;
    @Mock
    private Element listBoxElement;
    @Mock
    private AbsolutePanel domElementContainer;
    @Mock
    private GridLienzoPanel gridLienzoPanel;
    @Mock
    private GridLayer gridLayer;
    @Mock
    private GuidedDecisionTableView gridWidget;
    private ListBoxSingletonDOMElementFactory<String, ListBox> factory;

    @Before
    public void setup() {
        Mockito.when((Object)this.listBox.getElement()).thenReturn((Object)this.listBoxElement);
        Mockito.when((Object)this.listBoxElement.getStyle()).thenReturn(Mockito.mock(Style.class));
        Mockito.when((Object)this.domElementContainer.iterator()).thenReturn(Collections.emptyList().iterator());
        Mockito.when((Object)this.gridLayer.getDomElementContainer()).thenReturn((Object)this.domElementContainer);
        Mockito.when((Object)this.gridWidget.getModel()).thenReturn((Object)new BaseGridData());
        ((GridLayer)Mockito.doAnswer(i -> {
            GridLayerRedrawManager.PrioritizedCommand command = (GridLayerRedrawManager.PrioritizedCommand)i.getArguments()[0];
            command.execute();
            return null;
        }).when((Object)this.gridLayer)).batch((GridLayerRedrawManager.PrioritizedCommand)Matchers.any(GridLayerRedrawManager.PrioritizedCommand.class));
        this.factory = (ListBoxSingletonDOMElementFactory)Mockito.spy((Object)((Object)new ListBoxSingletonDOMElementFactoryMock(this.gridLienzoPanel, this.gridLayer, this.gridWidget)));
    }

    @Test
    public void checkDOMElementCreation() {
        this.factory.createDomElement(this.gridLayer, (GridWidget)this.gridWidget);
        ((ListBoxSingletonDOMElementFactory)Mockito.verify(this.factory)).createDomElementInternal(this.listBox, this.gridLayer, (GridWidget)this.gridWidget);
    }

    @Test
    public void checkDOMElementInternalCreation() {
        this.factory.createDomElementInternal(this.listBox, this.gridLayer, (GridWidget)this.gridWidget);
        ((ListBox)Mockito.verify((Object)this.listBox)).isMultipleSelect();
    }

    @Test
    public void checkDOMElementCreationBlurHandler() {
        GridBodyCellRenderContext context = (GridBodyCellRenderContext)Mockito.mock(GridBodyCellRenderContext.class);
        Consumer onCreation = (Consumer)Mockito.mock(Consumer.class);
        Consumer onDisplay = (Consumer)Mockito.mock(Consumer.class);
        Mockito.when((Object)context.getTransform()).thenReturn(Mockito.mock(Transform.class));
        this.factory.attachDomElement(context, onCreation, onDisplay);
        ArgumentCaptor handlerCaptor = ArgumentCaptor.forClass(EventHandler.class);
        ((ListBox)Mockito.verify((Object)this.listBox, (VerificationMode)Mockito.times((int)4))).addDomHandler((EventHandler)handlerCaptor.capture(), (DomEvent.Type)Matchers.any(DomEvent.Type.class));
        Assertions.assertThat(handlerCaptor.getAllValues().get(0)).isInstanceOf(KeyDownHandlerCommon.class);
        KeyDownEvent keyDownEventMock = (KeyDownEvent)Mockito.mock(KeyDownEvent.class);
        Assertions.assertThat(handlerCaptor.getAllValues().get(1)).isInstanceOf(KeyDownHandler.class);
        ((KeyDownHandler)handlerCaptor.getAllValues().get(1)).onKeyDown(keyDownEventMock);
        ((KeyDownEvent)Mockito.verify((Object)keyDownEventMock)).stopPropagation();
        MouseDownEvent mouseDownEventMock = (MouseDownEvent)Mockito.mock(MouseDownEvent.class);
        Assertions.assertThat(handlerCaptor.getAllValues().get(2)).isInstanceOf(MouseDownHandler.class);
        ((MouseDownHandler)handlerCaptor.getAllValues().get(2)).onMouseDown(mouseDownEventMock);
        ((MouseDownEvent)Mockito.verify((Object)mouseDownEventMock)).stopPropagation();
        BlurEvent blurEventMock = (BlurEvent)Mockito.mock(BlurEvent.class);
        Assertions.assertThat(handlerCaptor.getAllValues().get(3)).isInstanceOf(BlurHandler.class);
        ((BlurHandler)handlerCaptor.getAllValues().get(3)).onBlur(blurEventMock);
        ((ListBoxSingletonDOMElementFactory)Mockito.verify(this.factory)).flush();
        ((GridLayer)Mockito.verify((Object)this.gridLayer)).batch();
        ((GridLienzoPanel)Mockito.verify((Object)this.gridLienzoPanel)).setFocus(true);
    }

    private class ListBoxSingletonDOMElementFactoryMock
    extends ListBoxSingletonDOMElementFactory<String, ListBox> {
        public ListBoxSingletonDOMElementFactoryMock(GridLienzoPanel gridPanel, GridLayer gridLayer, GuidedDecisionTableView gridWidget) {
            super(gridPanel, gridLayer, gridWidget);
        }

        public String convert(String value) {
            return "";
        }

        public ListBox createWidget() {
            return ListBoxSingletonDOMElementFactoryTest.this.listBox;
        }
    }
}

