/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.table.keyboard;

import com.ait.lienzo.test.LienzoMockitoTestRunner;
import com.google.gwt.event.dom.client.KeyDownEvent;
import com.google.gwt.event.dom.client.KeyDownHandler;
import java.util.Optional;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableView;
import org.drools.workbench.screens.guided.dtable.client.widget.table.keyboard.BaseKeyboardTest;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.wires.core.grids.client.widget.context.GridBodyCellRenderContext;
import org.uberfire.ext.wires.core.grids.client.widget.dom.single.HasSingletonDOMElementResource;
import org.uberfire.ext.wires.core.grids.client.widget.grid.selections.SelectionExtension;
import org.uberfire.ext.wires.core.grids.client.widget.layer.impl.GridLienzoPanel;

@RunWith(value=LienzoMockitoTestRunner.class)
public abstract class BaseKeyDownHandlerTest
extends BaseKeyboardTest {
    @Mock
    protected GridLienzoPanel gridPanel;
    @Mock
    protected HasSingletonDOMElementResource gridCell;
    @Mock
    protected GridBodyCellRenderContext context;
    protected KeyDownHandler handler;

    @Override
    @Before
    public void setup() {
        super.setup();
        this.handler = this.getHandler();
    }

    protected abstract KeyDownHandler getHandler();

    @Test
    public void keyPressStopsPropagation() {
        KeyDownEvent e = this.mockKeyDownEvent(Optional.empty(), Optional.empty(), Optional.empty());
        this.handler.onKeyDown(e);
        ((KeyDownEvent)Mockito.verify((Object)e)).stopPropagation();
    }

    @Test
    public void tabKeyWithShiftMovesLeft() {
        Mockito.when((Object)this.context.getRowIndex()).thenReturn((Object)0);
        Mockito.when((Object)this.context.getColumnIndex()).thenReturn((Object)1);
        KeyDownEvent e = this.mockKeyDownEvent(Optional.of(9), Optional.of(true), Optional.of(false));
        this.handler.onKeyDown(e);
        ((GuidedDecisionTableView)Mockito.verify((Object)this.gridWidget)).adjustSelection((SelectionExtension)Mockito.eq((Object)SelectionExtension.LEFT), Mockito.eq((boolean)false));
    }

    @Test
    public void tabKeyWithoutShiftMovesRight() {
        Mockito.when((Object)this.context.getRowIndex()).thenReturn((Object)0);
        Mockito.when((Object)this.context.getColumnIndex()).thenReturn((Object)1);
        KeyDownEvent e = this.mockKeyDownEvent(Optional.of(9), Optional.of(false), Optional.of(false));
        this.handler.onKeyDown(e);
        ((GuidedDecisionTableView)Mockito.verify((Object)this.gridWidget)).adjustSelection((SelectionExtension)Mockito.eq((Object)SelectionExtension.RIGHT), Mockito.eq((boolean)false));
    }

    @Test
    public void enterKeyWithShiftMovesUp() {
        Mockito.when((Object)this.context.getRowIndex()).thenReturn((Object)1);
        Mockito.when((Object)this.context.getColumnIndex()).thenReturn((Object)0);
        KeyDownEvent e = this.mockKeyDownEvent(Optional.of(13), Optional.of(true), Optional.of(false));
        this.handler.onKeyDown(e);
        ((GuidedDecisionTableView)Mockito.verify((Object)this.gridWidget)).adjustSelection((SelectionExtension)Mockito.eq((Object)SelectionExtension.UP), Mockito.eq((boolean)false));
    }

    @Test
    public void enterKeyWithoutShiftMovesDown() {
        Mockito.when((Object)this.context.getRowIndex()).thenReturn((Object)1);
        Mockito.when((Object)this.context.getColumnIndex()).thenReturn((Object)0);
        KeyDownEvent e = this.mockKeyDownEvent(Optional.of(13), Optional.of(false), Optional.of(false));
        this.handler.onKeyDown(e);
        ((GuidedDecisionTableView)Mockito.verify((Object)this.gridWidget)).adjustSelection((SelectionExtension)Mockito.eq((Object)SelectionExtension.DOWN), Mockito.eq((boolean)false));
    }

    @Test
    public void escapeKeyDoesNotMoveAnywhere() {
        KeyDownEvent e = this.mockKeyDownEvent(Optional.of(27), Optional.of(false), Optional.of(false));
        this.handler.onKeyDown(e);
        ((GuidedDecisionTableView)Mockito.verify((Object)this.gridWidget, (VerificationMode)Mockito.never())).selectCell(Mockito.anyInt(), Mockito.anyInt(), Mockito.anyBoolean(), Mockito.anyBoolean());
    }

    protected KeyDownEvent mockKeyDownEvent(Optional<Integer> keyCode, Optional<Boolean> isShiftKeyDown, Optional<Boolean> isControlKeyDown) {
        KeyDownEvent e = (KeyDownEvent)Mockito.mock(KeyDownEvent.class);
        keyCode.ifPresent(c -> Mockito.when((Object)e.getNativeKeyCode()).thenReturn(c));
        isShiftKeyDown.ifPresent(c -> Mockito.when((Object)e.isShiftKeyDown()).thenReturn(c));
        isControlKeyDown.ifPresent(c -> Mockito.when((Object)e.isControlKeyDown()).thenReturn(c));
        return e;
    }
}

