/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.table.model.converters.column.impl;

import com.ait.lienzo.test.LienzoMockitoTestRunner;
import java.util.ArrayList;
import org.drools.workbench.models.datamodel.rule.Attribute;
import org.drools.workbench.models.guided.dtable.shared.model.ActionInsertFactCol52;
import org.drools.workbench.models.guided.dtable.shared.model.ActionSetFieldCol52;
import org.drools.workbench.models.guided.dtable.shared.model.AttributeCol52;
import org.drools.workbench.models.guided.dtable.shared.model.BRLConditionVariableColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BaseColumn;
import org.drools.workbench.models.guided.dtable.shared.model.CompositeColumn;
import org.drools.workbench.models.guided.dtable.shared.model.ConditionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.DescriptionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.models.guided.dtable.shared.model.MetadataCol52;
import org.drools.workbench.models.guided.dtable.shared.model.Pattern52;
import org.drools.workbench.models.guided.dtable.shared.model.RowNumberCol52;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableModellerView;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTablePresenter;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableView;
import org.drools.workbench.screens.guided.dtable.client.widget.table.columns.BaseUiColumn;
import org.drools.workbench.screens.guided.dtable.client.widget.table.columns.IntegerUiColumn;
import org.drools.workbench.screens.guided.dtable.client.widget.table.columns.StringUiColumn;
import org.drools.workbench.screens.guided.dtable.client.widget.table.model.converters.column.GridWidgetColumnFactory;
import org.drools.workbench.screens.guided.dtable.client.widget.table.model.converters.column.impl.BaseConverterTest;
import org.drools.workbench.screens.guided.dtable.client.widget.table.model.converters.column.impl.GridWidgetColumnFactoryImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracle;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.widget.layer.GridLayer;

@RunWith(value=LienzoMockitoTestRunner.class)
public class GridWidgetColumnFactoryImplTest
extends BaseConverterTest {
    @Mock
    private GuidedDecisionTable52 model;
    @Mock
    private AsyncPackageDataModelOracle oracle;
    @Mock
    private GuidedDecisionTableView.Presenter dtPresenter;
    @Mock
    private GuidedDecisionTableModellerView dtModellerView;
    @Mock
    private GuidedDecisionTableModellerView.Presenter dtModellerPresenter;
    @Mock
    private GridLayer gridLayer;
    private GridWidgetColumnFactory factory;
    private GuidedDecisionTablePresenter.Access access;

    @Override
    @Before
    public void setup() {
        super.setup();
        this.factory = new GridWidgetColumnFactoryImpl();
        this.factory.setConverters(this.getConverters());
        Mockito.when((Object)this.model.getHitPolicy()).thenReturn((Object)GuidedDecisionTable52.HitPolicy.NONE);
        this.access = new GuidedDecisionTablePresenter.Access();
    }

    @Override
    protected GuidedDecisionTable52 getModel() {
        return this.model;
    }

    @Override
    protected AsyncPackageDataModelOracle getOracle() {
        return this.oracle;
    }

    @Override
    protected GuidedDecisionTableView.Presenter getPresenter() {
        Mockito.when((Object)this.dtPresenter.getModellerPresenter()).thenReturn((Object)this.dtModellerPresenter);
        Mockito.when((Object)this.dtModellerPresenter.getView()).thenReturn((Object)this.dtModellerView);
        Mockito.when((Object)this.dtModellerView.getGridLayerView()).thenReturn((Object)this.gridLayer);
        return this.dtPresenter;
    }

    @Test
    public void columnResizingListenerSetup_RowNumberColumn() {
        RowNumberCol52 column = new RowNumberCol52();
        GridColumn uiColumn = this.factory.convertColumn((BaseColumn)column, this.access, this.gridWidget);
        Assert.assertFalse((boolean)(uiColumn instanceof BaseUiColumn));
        Assert.assertEquals((long)((int)uiColumn.getWidth()), (long)column.getWidth());
        Assert.assertEquals((double)50.0, (double)column.getWidth(), (double)0.0);
    }

    @Test
    public void columnResizingListenerSetup_DescriptionColumn() {
        DescriptionCol52 column = new DescriptionCol52();
        GridColumn uiColumn = this.factory.convertColumn((BaseColumn)column, this.access, this.gridWidget);
        Assert.assertTrue((boolean)(uiColumn instanceof BaseUiColumn));
        Assert.assertEquals((long)((int)uiColumn.getWidth()), (long)column.getWidth());
        Assert.assertEquals((double)150.0, (double)column.getWidth(), (double)0.0);
        uiColumn.setWidth(200.0);
        Assert.assertEquals((long)200L, (long)column.getWidth());
    }

    @Test
    public void columnResizingListenerSetup_MetadataColumn() {
        MetadataCol52 column = new MetadataCol52();
        column.setMetadata("metadata");
        GridColumn uiColumn = this.factory.convertColumn((BaseColumn)column, this.access, this.gridWidget);
        Assert.assertTrue((boolean)(uiColumn instanceof BaseUiColumn));
        Assert.assertEquals((long)((int)uiColumn.getWidth()), (long)column.getWidth());
        uiColumn.setWidth(200.0);
        Assert.assertEquals((long)200L, (long)column.getWidth());
    }

    @Test
    public void columnResizingListenerSetup_AttributeColumn() {
        AttributeCol52 column = new AttributeCol52();
        column.setAttribute(Attribute.SALIENCE.getAttributeName());
        GridColumn uiColumn = this.factory.convertColumn((BaseColumn)column, this.access, this.gridWidget);
        Assert.assertTrue((boolean)(uiColumn instanceof BaseUiColumn));
        Assert.assertEquals((long)((int)uiColumn.getWidth()), (long)column.getWidth());
        uiColumn.setWidth(200.0);
        Assert.assertEquals((long)200L, (long)column.getWidth());
    }

    @Test
    public void columnResizingListenerSetup_ConditionColumn() {
        Pattern52 pattern = (Pattern52)Mockito.mock(Pattern52.class);
        ConditionCol52 column = new ConditionCol52();
        column.setFactField("MyField");
        column.setHeader("MyColumn");
        Mockito.when((Object)this.model.getPattern((ConditionCol52)Mockito.eq((Object)column))).thenReturn((Object)pattern);
        Mockito.when((Object)pattern.getFactType()).thenReturn((Object)"MyFact");
        Mockito.when((Object)this.oracle.getFieldType("MyFact", "MyField")).thenReturn((Object)"String");
        GridColumn uiColumn = this.factory.convertColumn((BaseColumn)column, this.access, this.gridWidget);
        Assert.assertTrue((boolean)(uiColumn instanceof BaseUiColumn));
        Assert.assertEquals((long)((int)uiColumn.getWidth()), (long)column.getWidth());
        uiColumn.setWidth(200.0);
        Assert.assertEquals((long)200L, (long)column.getWidth());
    }

    @Test
    public void columnResizingListenerSetup_ActionSetFieldColumn() {
        final Pattern52 pattern = (Pattern52)Mockito.mock(Pattern52.class);
        ActionSetFieldCol52 column = new ActionSetFieldCol52();
        column.setFactField("MyField");
        column.setHeader("MyColumn");
        column.setBoundName("$f");
        Mockito.when((Object)this.model.getConditions()).thenReturn((Object)new ArrayList<CompositeColumn<? extends BaseColumn>>(){
            {
                this.add(pattern);
            }
        });
        Mockito.when((Object)pattern.getFactType()).thenReturn((Object)"MyFact");
        Mockito.when((Object)pattern.getBoundName()).thenReturn((Object)"$f");
        Mockito.when((Object)pattern.isBound()).thenReturn((Object)true);
        Mockito.when((Object)this.oracle.getFieldType("MyFact", "MyField")).thenReturn((Object)"String");
        GridColumn uiColumn = this.factory.convertColumn((BaseColumn)column, this.access, this.gridWidget);
        Assert.assertTrue((boolean)(uiColumn instanceof BaseUiColumn));
        Assert.assertEquals((long)((int)uiColumn.getWidth()), (long)column.getWidth());
        uiColumn.setWidth(200.0);
        Assert.assertEquals((long)200L, (long)column.getWidth());
    }

    @Test
    public void columnResizingListenerSetup_ActionInsertFactColumn() {
        ActionInsertFactCol52 column = new ActionInsertFactCol52();
        column.setFactType("MyFact");
        column.setFactField("MyField");
        column.setHeader("MyColumn");
        Mockito.when((Object)this.oracle.getFieldType("MyFact", "MyField")).thenReturn((Object)"String");
        GridColumn uiColumn = this.factory.convertColumn((BaseColumn)column, this.access, this.gridWidget);
        Assert.assertTrue((boolean)(uiColumn instanceof BaseUiColumn));
        Assert.assertEquals((long)((int)uiColumn.getWidth()), (long)column.getWidth());
        uiColumn.setWidth(200.0);
        Assert.assertEquals((long)200L, (long)column.getWidth());
    }

    @Test
    public void testHiddenColumn_ConditionColumn() {
        Pattern52 pattern = (Pattern52)Mockito.mock(Pattern52.class);
        ConditionCol52 column = new ConditionCol52();
        column.setFactField("MyField");
        column.setHeader("MyColumn");
        column.setHideColumn(true);
        Mockito.when((Object)this.model.getPattern((ConditionCol52)Mockito.eq((Object)column))).thenReturn((Object)pattern);
        Mockito.when((Object)pattern.getFactType()).thenReturn((Object)"MyFact");
        Mockito.when((Object)this.oracle.getFieldType("MyFact", "MyField")).thenReturn((Object)"String");
        GridColumn uiColumn = this.factory.convertColumn((BaseColumn)column, this.access, this.gridWidget);
        Assert.assertEquals((Object)false, (Object)uiColumn.isVisible());
    }

    @Test
    public void testNumericColumn_IsContainedInOperator() {
        BRLConditionVariableColumn column = new BRLConditionVariableColumn("$a", "Integer", "Applicant", "age", "in");
        column.setHeader("age is");
        GridColumn gridColumn = this.factory.convertColumn((BaseColumn)column, this.access, this.gridWidget);
        Assert.assertTrue((boolean)(gridColumn instanceof StringUiColumn));
    }

    @Test
    public void testNumericColumn_EqualOperator() {
        BRLConditionVariableColumn column = new BRLConditionVariableColumn("$a", "Integer", "Applicant", "age", "==");
        column.setHeader("age equal to");
        Mockito.when((Object)this.oracle.getFieldType("Applicant", "age")).thenReturn((Object)"Integer");
        GridColumn gridColumn = this.factory.convertColumn((BaseColumn)column, this.access, this.gridWidget);
        Assert.assertTrue((boolean)(gridColumn instanceof IntegerUiColumn));
    }
}

