/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.table.model.synchronizers.impl;

import java.util.Collections;
import java.util.List;
import org.drools.workbench.models.datamodel.workitems.PortableWorkDefinition;
import org.drools.workbench.models.guided.dtable.shared.model.ActionWorkItemCol52;
import org.drools.workbench.models.guided.dtable.shared.model.ActionWorkItemSetFieldCol52;
import org.drools.workbench.models.guided.dtable.shared.model.BaseColumn;
import org.drools.workbench.models.guided.dtable.shared.model.ConditionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.DTCellValue52;
import org.drools.workbench.models.guided.dtable.shared.model.Pattern52;
import org.drools.workbench.screens.guided.dtable.client.widget.table.columns.BaseMultipleDOMElementUiColumn;
import org.drools.workbench.screens.guided.dtable.client.widget.table.columns.BooleanUiColumn;
import org.drools.workbench.screens.guided.dtable.client.widget.table.model.synchronizers.ModelSynchronizer;
import org.drools.workbench.screens.guided.dtable.client.widget.table.model.synchronizers.impl.BaseSynchronizerTest;
import org.drools.workbench.screens.guided.rule.client.util.ModelFieldUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.soup.project.datamodel.oracle.ModelField;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracle;
import org.mockito.Mockito;
import org.uberfire.ext.wires.core.grids.client.model.GridCell;
import org.uberfire.ext.wires.core.grids.client.model.GridCellValue;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridCellValue;

public class ActionWorkItemSetFieldColumnSynchronizerTest
extends BaseSynchronizerTest {
    private static final String WORK_ITEM_NAME = "WorkItemDefinition";

    @Before
    public void setupWorkItemExecution() throws ModelSynchronizer.VetoException {
        ActionWorkItemCol52 column = new ActionWorkItemCol52();
        PortableWorkDefinition pwd = new PortableWorkDefinition();
        pwd.setName(WORK_ITEM_NAME);
        column.setWorkItemDefinition(pwd);
        column.setHeader("wid");
        this.modelSynchronizer.appendColumn((BaseColumn)column);
    }

    @Override
    protected AsyncPackageDataModelOracle getOracle() {
        AsyncPackageDataModelOracle oracle = super.getOracle();
        oracle.addModelFields(Collections.singletonMap("Applicant", new ModelField[]{ModelFieldUtil.modelField((String)"this", (String)"Applicant"), ModelFieldUtil.modelField((String)"age", (String)"Integer"), ModelFieldUtil.modelField((String)"name", (String)"String")}));
        return oracle;
    }

    @Test
    public void testAppend() throws ModelSynchronizer.VetoException {
        ActionWorkItemSetFieldCol52 column = new ActionWorkItemSetFieldCol52();
        column.setWorkItemName(WORK_ITEM_NAME);
        column.setHeader("col1");
        this.modelSynchronizer.appendColumn((BaseColumn)column);
        Assert.assertEquals((long)2L, (long)this.model.getActionCols().size());
        Assert.assertEquals((long)5L, (long)this.uiModel.getColumns().size());
        Assert.assertTrue((boolean)(this.uiModel.getColumns().get(4) instanceof BooleanUiColumn));
        Assert.assertEquals((Object)true, (Object)((BaseMultipleDOMElementUiColumn)this.uiModel.getColumns().get(4)).isEditable());
    }

    @Test
    public void testAppendMultipleColumns() throws ModelSynchronizer.VetoException {
        ActionWorkItemSetFieldCol52 column1 = new ActionWorkItemSetFieldCol52();
        column1.setWorkItemName(WORK_ITEM_NAME);
        column1.setHeader("col1");
        ActionWorkItemSetFieldCol52 column2 = new ActionWorkItemSetFieldCol52();
        column2.setWorkItemName(WORK_ITEM_NAME);
        column2.setHeader("col2");
        this.modelSynchronizer.appendColumn((BaseColumn)column1);
        this.modelSynchronizer.appendColumn((BaseColumn)column2);
        Assert.assertEquals((long)3L, (long)this.model.getActionCols().size());
        Assert.assertEquals((long)6L, (long)this.uiModel.getColumns().size());
        Assert.assertTrue((boolean)(this.uiModel.getColumns().get(4) instanceof BooleanUiColumn));
        Assert.assertTrue((boolean)(this.uiModel.getColumns().get(5) instanceof BooleanUiColumn));
        Assert.assertEquals((Object)true, (Object)((BaseMultipleDOMElementUiColumn)this.uiModel.getColumns().get(4)).isEditable());
        Assert.assertEquals((Object)true, (Object)((BaseMultipleDOMElementUiColumn)this.uiModel.getColumns().get(5)).isEditable());
        Assert.assertEquals((Object)column1.getHeader(), (Object)((GridColumn.HeaderMetaData)((GridColumn)this.uiModel.getColumns().get(4)).getHeaderMetaData().get(1)).getTitle());
        Assert.assertEquals((Object)column2.getHeader(), (Object)((GridColumn.HeaderMetaData)((GridColumn)this.uiModel.getColumns().get(5)).getHeaderMetaData().get(1)).getTitle());
    }

    @Test
    public void testUpdate() throws ModelSynchronizer.VetoException {
        ActionWorkItemSetFieldCol52 column = (ActionWorkItemSetFieldCol52)Mockito.spy((Object)new ActionWorkItemSetFieldCol52());
        column.setWorkItemName(WORK_ITEM_NAME);
        column.setHeader("col1");
        this.modelSynchronizer.appendColumn((BaseColumn)column);
        ActionWorkItemSetFieldCol52 edited = new ActionWorkItemSetFieldCol52();
        edited.setWorkItemName(WORK_ITEM_NAME);
        edited.setWidth(column.getWidth());
        edited.setHideColumn(true);
        edited.setHeader("updated");
        List diffs = this.modelSynchronizer.updateColumn((BaseColumn)column, (BaseColumn)edited);
        Assert.assertEquals((long)2L, (long)diffs.size());
        ((ActionWorkItemSetFieldCol52)Mockito.verify((Object)column)).diff((BaseColumn)edited);
        Assert.assertEquals((long)2L, (long)this.model.getActionCols().size());
        Assert.assertEquals((long)5L, (long)this.uiModel.getColumns().size());
        Assert.assertTrue((boolean)(this.uiModel.getColumns().get(4) instanceof BooleanUiColumn));
        Assert.assertEquals((Object)"updated", (Object)((GridColumn.HeaderMetaData)((GridColumn)this.uiModel.getColumns().get(4)).getHeaderMetaData().get(1)).getTitle());
        Assert.assertEquals((Object)false, (Object)((GridColumn)this.uiModel.getColumns().get(4)).isVisible());
    }

    @Test
    public void testDelete() throws ModelSynchronizer.VetoException {
        ActionWorkItemSetFieldCol52 column = new ActionWorkItemSetFieldCol52();
        column.setWorkItemName(WORK_ITEM_NAME);
        column.setHeader("col1");
        this.modelSynchronizer.appendColumn((BaseColumn)column);
        Assert.assertEquals((long)2L, (long)this.model.getActionCols().size());
        Assert.assertEquals((long)5L, (long)this.uiModel.getColumns().size());
        this.modelSynchronizer.deleteColumn((BaseColumn)column);
        Assert.assertEquals((long)1L, (long)this.model.getActionCols().size());
        Assert.assertEquals((long)4L, (long)this.uiModel.getColumns().size());
    }

    @Test
    public void testMoveColumnTo_MoveLeft() throws ModelSynchronizer.VetoException {
        Pattern52 pattern = new Pattern52();
        pattern.setBoundName("$a");
        pattern.setFactType("Applicant");
        ConditionCol52 condition = new ConditionCol52();
        condition.setConstraintValueType(1);
        condition.setHeader("col1");
        condition.setFactField("age");
        condition.setOperator("==");
        this.modelSynchronizer.appendColumn(pattern, condition);
        ActionWorkItemSetFieldCol52 column1 = new ActionWorkItemSetFieldCol52();
        column1.setWorkItemName(WORK_ITEM_NAME);
        column1.setBoundName("$a");
        column1.setFactField("age");
        column1.setHeader("wid1");
        ActionWorkItemSetFieldCol52 column2 = new ActionWorkItemSetFieldCol52();
        column2.setWorkItemName(WORK_ITEM_NAME);
        column2.setBoundName("$a");
        column2.setFactField("name");
        column2.setHeader("wid2");
        this.modelSynchronizer.appendColumn((BaseColumn)column1);
        this.modelSynchronizer.appendColumn((BaseColumn)column2);
        this.modelSynchronizer.appendRow();
        this.uiModel.setCellValue(0, 5, (GridCellValue)new BaseGridCellValue((Object)true));
        this.uiModel.setCellValue(0, 6, (GridCellValue)new BaseGridCellValue((Object)false));
        Assert.assertEquals((long)3L, (long)this.model.getActionCols().size());
        Assert.assertEquals((Object)column1, this.model.getActionCols().get(1));
        Assert.assertEquals((Object)column2, this.model.getActionCols().get(2));
        Assert.assertEquals((Object)true, (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(5)).getBooleanValue());
        Assert.assertEquals((Object)false, (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(6)).getBooleanValue());
        Assert.assertEquals((long)7L, (long)this.uiModel.getColumns().size());
        GridColumn uiModelColumn1_1 = (GridColumn)this.uiModel.getColumns().get(5);
        GridColumn uiModelColumn2_1 = (GridColumn)this.uiModel.getColumns().get(6);
        Assert.assertEquals((Object)"wid1", (Object)((GridColumn.HeaderMetaData)uiModelColumn1_1.getHeaderMetaData().get(1)).getTitle());
        Assert.assertEquals((Object)"wid2", (Object)((GridColumn.HeaderMetaData)uiModelColumn2_1.getHeaderMetaData().get(1)).getTitle());
        Assert.assertTrue((boolean)(uiModelColumn1_1 instanceof BooleanUiColumn));
        Assert.assertTrue((boolean)(uiModelColumn2_1 instanceof BooleanUiColumn));
        Assert.assertEquals((long)5L, (long)uiModelColumn1_1.getIndex());
        Assert.assertEquals((long)6L, (long)uiModelColumn2_1.getIndex());
        Assert.assertEquals((Object)true, (Object)((GridCell)this.uiModel.getRow(0).getCells().get(uiModelColumn1_1.getIndex())).getValue().getValue());
        Assert.assertEquals((Object)false, (Object)((GridCell)this.uiModel.getRow(0).getCells().get(uiModelColumn2_1.getIndex())).getValue().getValue());
        this.uiModel.moveColumnTo(5, uiModelColumn2_1);
        Assert.assertEquals((long)3L, (long)this.model.getActionCols().size());
        Assert.assertEquals((Object)column2, this.model.getActionCols().get(1));
        Assert.assertEquals((Object)column1, this.model.getActionCols().get(2));
        Assert.assertEquals((Object)false, (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(5)).getBooleanValue());
        Assert.assertEquals((Object)true, (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(6)).getBooleanValue());
        Assert.assertEquals((long)7L, (long)this.uiModel.getColumns().size());
        GridColumn uiModelColumn1_2 = (GridColumn)this.uiModel.getColumns().get(5);
        GridColumn uiModelColumn2_2 = (GridColumn)this.uiModel.getColumns().get(6);
        Assert.assertEquals((Object)"wid2", (Object)((GridColumn.HeaderMetaData)uiModelColumn1_2.getHeaderMetaData().get(1)).getTitle());
        Assert.assertEquals((Object)"wid1", (Object)((GridColumn.HeaderMetaData)uiModelColumn2_2.getHeaderMetaData().get(1)).getTitle());
        Assert.assertTrue((boolean)(uiModelColumn1_2 instanceof BooleanUiColumn));
        Assert.assertTrue((boolean)(uiModelColumn2_2 instanceof BooleanUiColumn));
        Assert.assertEquals((long)6L, (long)uiModelColumn1_2.getIndex());
        Assert.assertEquals((long)5L, (long)uiModelColumn2_2.getIndex());
        Assert.assertEquals((Object)false, (Object)((GridCell)this.uiModel.getRow(0).getCells().get(uiModelColumn1_2.getIndex())).getValue().getValue());
        Assert.assertEquals((Object)true, (Object)((GridCell)this.uiModel.getRow(0).getCells().get(uiModelColumn2_2.getIndex())).getValue().getValue());
    }

    @Test
    public void testMoveColumnTo_MoveRight() throws ModelSynchronizer.VetoException {
        Pattern52 pattern = new Pattern52();
        pattern.setBoundName("$a");
        pattern.setFactType("Applicant");
        ConditionCol52 condition = new ConditionCol52();
        condition.setConstraintValueType(1);
        condition.setHeader("col1");
        condition.setFactField("age");
        condition.setOperator("==");
        this.modelSynchronizer.appendColumn(pattern, condition);
        ActionWorkItemSetFieldCol52 column1 = new ActionWorkItemSetFieldCol52();
        column1.setWorkItemName(WORK_ITEM_NAME);
        column1.setBoundName("$a");
        column1.setFactField("age");
        column1.setHeader("wid1");
        ActionWorkItemSetFieldCol52 column2 = new ActionWorkItemSetFieldCol52();
        column2.setWorkItemName(WORK_ITEM_NAME);
        column2.setBoundName("$a");
        column2.setFactField("name");
        column2.setHeader("wid2");
        this.modelSynchronizer.appendColumn((BaseColumn)column1);
        this.modelSynchronizer.appendColumn((BaseColumn)column2);
        this.modelSynchronizer.appendRow();
        this.uiModel.setCellValue(0, 5, (GridCellValue)new BaseGridCellValue((Object)true));
        this.uiModel.setCellValue(0, 6, (GridCellValue)new BaseGridCellValue((Object)false));
        Assert.assertEquals((long)3L, (long)this.model.getActionCols().size());
        Assert.assertEquals((Object)column1, this.model.getActionCols().get(1));
        Assert.assertEquals((Object)column2, this.model.getActionCols().get(2));
        Assert.assertEquals((Object)true, (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(5)).getBooleanValue());
        Assert.assertEquals((Object)false, (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(6)).getBooleanValue());
        Assert.assertEquals((long)7L, (long)this.uiModel.getColumns().size());
        GridColumn uiModelColumn1_1 = (GridColumn)this.uiModel.getColumns().get(5);
        GridColumn uiModelColumn2_1 = (GridColumn)this.uiModel.getColumns().get(6);
        Assert.assertEquals((Object)"wid1", (Object)((GridColumn.HeaderMetaData)uiModelColumn1_1.getHeaderMetaData().get(1)).getTitle());
        Assert.assertEquals((Object)"wid2", (Object)((GridColumn.HeaderMetaData)uiModelColumn2_1.getHeaderMetaData().get(1)).getTitle());
        Assert.assertTrue((boolean)(uiModelColumn1_1 instanceof BooleanUiColumn));
        Assert.assertTrue((boolean)(uiModelColumn2_1 instanceof BooleanUiColumn));
        Assert.assertEquals((long)5L, (long)uiModelColumn1_1.getIndex());
        Assert.assertEquals((long)6L, (long)uiModelColumn2_1.getIndex());
        Assert.assertEquals((Object)true, (Object)((GridCell)this.uiModel.getRow(0).getCells().get(uiModelColumn1_1.getIndex())).getValue().getValue());
        Assert.assertEquals((Object)false, (Object)((GridCell)this.uiModel.getRow(0).getCells().get(uiModelColumn2_1.getIndex())).getValue().getValue());
        this.uiModel.moveColumnTo(6, uiModelColumn1_1);
        Assert.assertEquals((long)3L, (long)this.model.getActionCols().size());
        Assert.assertEquals((Object)column2, this.model.getActionCols().get(1));
        Assert.assertEquals((Object)column1, this.model.getActionCols().get(2));
        Assert.assertEquals((Object)false, (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(5)).getBooleanValue());
        Assert.assertEquals((Object)true, (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(6)).getBooleanValue());
        Assert.assertEquals((long)7L, (long)this.uiModel.getColumns().size());
        GridColumn uiModelColumn1_2 = (GridColumn)this.uiModel.getColumns().get(5);
        GridColumn uiModelColumn2_2 = (GridColumn)this.uiModel.getColumns().get(6);
        Assert.assertEquals((Object)"wid2", (Object)((GridColumn.HeaderMetaData)uiModelColumn1_2.getHeaderMetaData().get(1)).getTitle());
        Assert.assertEquals((Object)"wid1", (Object)((GridColumn.HeaderMetaData)uiModelColumn2_2.getHeaderMetaData().get(1)).getTitle());
        Assert.assertTrue((boolean)(uiModelColumn1_2 instanceof BooleanUiColumn));
        Assert.assertTrue((boolean)(uiModelColumn2_2 instanceof BooleanUiColumn));
        Assert.assertEquals((long)6L, (long)uiModelColumn1_2.getIndex());
        Assert.assertEquals((long)5L, (long)uiModelColumn2_2.getIndex());
        Assert.assertEquals((Object)false, (Object)((GridCell)this.uiModel.getRow(0).getCells().get(uiModelColumn1_2.getIndex())).getValue().getValue());
        Assert.assertEquals((Object)true, (Object)((GridCell)this.uiModel.getRow(0).getCells().get(uiModelColumn2_2.getIndex())).getValue().getValue());
    }

    @Test
    public void testMoveColumnTo_OutOfBounds() throws ModelSynchronizer.VetoException {
        Pattern52 pattern = new Pattern52();
        pattern.setBoundName("$a");
        pattern.setFactType("Applicant");
        ConditionCol52 condition = new ConditionCol52();
        condition.setConstraintValueType(1);
        condition.setHeader("col1");
        condition.setFactField("age");
        condition.setOperator("==");
        this.modelSynchronizer.appendColumn(pattern, condition);
        ActionWorkItemSetFieldCol52 column1 = new ActionWorkItemSetFieldCol52();
        column1.setWorkItemName(WORK_ITEM_NAME);
        column1.setBoundName("$a");
        column1.setFactField("age");
        column1.setHeader("wid1");
        ActionWorkItemSetFieldCol52 column2 = new ActionWorkItemSetFieldCol52();
        column2.setWorkItemName(WORK_ITEM_NAME);
        column2.setBoundName("$a");
        column2.setFactField("name");
        column2.setHeader("wid2");
        this.modelSynchronizer.appendColumn((BaseColumn)column1);
        this.modelSynchronizer.appendColumn((BaseColumn)column2);
        this.modelSynchronizer.appendRow();
        this.uiModel.setCellValue(0, 5, (GridCellValue)new BaseGridCellValue((Object)true));
        this.uiModel.setCellValue(0, 6, (GridCellValue)new BaseGridCellValue((Object)false));
        Assert.assertEquals((long)3L, (long)this.model.getActionCols().size());
        Assert.assertEquals((Object)column1, this.model.getActionCols().get(1));
        Assert.assertEquals((Object)column2, this.model.getActionCols().get(2));
        Assert.assertEquals((Object)true, (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(5)).getBooleanValue());
        Assert.assertEquals((Object)false, (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(6)).getBooleanValue());
        Assert.assertEquals((long)7L, (long)this.uiModel.getColumns().size());
        GridColumn uiModelColumn1_1 = (GridColumn)this.uiModel.getColumns().get(5);
        GridColumn uiModelColumn2_1 = (GridColumn)this.uiModel.getColumns().get(6);
        Assert.assertEquals((Object)"wid1", (Object)((GridColumn.HeaderMetaData)uiModelColumn1_1.getHeaderMetaData().get(1)).getTitle());
        Assert.assertEquals((Object)"wid2", (Object)((GridColumn.HeaderMetaData)uiModelColumn2_1.getHeaderMetaData().get(1)).getTitle());
        Assert.assertTrue((boolean)(uiModelColumn1_1 instanceof BooleanUiColumn));
        Assert.assertTrue((boolean)(uiModelColumn2_1 instanceof BooleanUiColumn));
        Assert.assertEquals((long)5L, (long)uiModelColumn1_1.getIndex());
        Assert.assertEquals((long)6L, (long)uiModelColumn2_1.getIndex());
        Assert.assertEquals((Object)true, (Object)((GridCell)this.uiModel.getRow(0).getCells().get(uiModelColumn1_1.getIndex())).getValue().getValue());
        Assert.assertEquals((Object)false, (Object)((GridCell)this.uiModel.getRow(0).getCells().get(uiModelColumn2_1.getIndex())).getValue().getValue());
        this.uiModel.moveColumnTo(2, uiModelColumn1_1);
        Assert.assertEquals((long)3L, (long)this.model.getActionCols().size());
        Assert.assertEquals((Object)column1, this.model.getActionCols().get(1));
        Assert.assertEquals((Object)column2, this.model.getActionCols().get(2));
        Assert.assertEquals((Object)true, (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(5)).getBooleanValue());
        Assert.assertEquals((Object)false, (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(6)).getBooleanValue());
        Assert.assertEquals((long)7L, (long)this.uiModel.getColumns().size());
        GridColumn uiModelColumn1_2 = (GridColumn)this.uiModel.getColumns().get(5);
        GridColumn uiModelColumn2_2 = (GridColumn)this.uiModel.getColumns().get(6);
        Assert.assertEquals((Object)"wid1", (Object)((GridColumn.HeaderMetaData)uiModelColumn1_2.getHeaderMetaData().get(1)).getTitle());
        Assert.assertEquals((Object)"wid2", (Object)((GridColumn.HeaderMetaData)uiModelColumn2_2.getHeaderMetaData().get(1)).getTitle());
        Assert.assertTrue((boolean)(uiModelColumn1_2 instanceof BooleanUiColumn));
        Assert.assertTrue((boolean)(uiModelColumn2_2 instanceof BooleanUiColumn));
        Assert.assertEquals((long)5L, (long)uiModelColumn1_2.getIndex());
        Assert.assertEquals((long)6L, (long)uiModelColumn2_2.getIndex());
        Assert.assertEquals((Object)true, (Object)((GridCell)this.uiModel.getRow(0).getCells().get(uiModelColumn1_2.getIndex())).getValue().getValue());
        Assert.assertEquals((Object)false, (Object)((GridCell)this.uiModel.getRow(0).getCells().get(uiModelColumn2_2.getIndex())).getValue().getValue());
    }
}

