/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.table.model.synchronizers.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.workbench.models.datamodel.rule.ActionCallMethod;
import org.drools.workbench.models.guided.dtable.shared.model.ActionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.ActionSetFieldCol52;
import org.drools.workbench.models.guided.dtable.shared.model.BRLActionColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BRLActionVariableColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BaseColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BaseColumnFieldDiff;
import org.drools.workbench.models.guided.dtable.shared.model.CompositeColumn;
import org.drools.workbench.models.guided.dtable.shared.model.ConditionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.DTCellValue52;
import org.drools.workbench.models.guided.dtable.shared.model.DescriptionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.Pattern52;
import org.drools.workbench.models.guided.dtable.shared.model.RowNumberCol52;
import org.drools.workbench.models.guided.dtable.shared.model.RuleNameColumn;
import org.drools.workbench.screens.guided.dtable.client.widget.table.columns.BooleanUiColumn;
import org.drools.workbench.screens.guided.dtable.client.widget.table.columns.IntegerUiColumn;
import org.drools.workbench.screens.guided.dtable.client.widget.table.columns.StringUiColumn;
import org.drools.workbench.screens.guided.dtable.client.widget.table.model.GuidedDecisionTableUiCell;
import org.drools.workbench.screens.guided.dtable.client.widget.table.model.synchronizers.ModelSynchronizer;
import org.drools.workbench.screens.guided.dtable.client.widget.table.model.synchronizers.impl.BaseSynchronizerTest;
import org.drools.workbench.screens.guided.rule.client.util.ModelFieldUtil;
import org.junit.Assert;
import org.junit.Test;
import org.kie.soup.project.datamodel.oracle.ModelField;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracle;
import org.mockito.Mockito;
import org.uberfire.ext.wires.core.grids.client.model.GridCell;
import org.uberfire.ext.wires.core.grids.client.model.GridCellValue;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridCellValue;

public class ConditionColumnSynchronizerTest
extends BaseSynchronizerTest {
    @Override
    protected AsyncPackageDataModelOracle getOracle() {
        AsyncPackageDataModelOracle oracle = super.getOracle();
        oracle.addModelFields((Map)new HashMap<String, ModelField[]>(){
            {
                this.put("Applicant", new ModelField[]{ModelFieldUtil.modelField((String)"this", (String)"Applicant"), ModelFieldUtil.modelField((String)"age", (String)"Integer"), ModelFieldUtil.modelField((String)"name", (String)"String"), ModelFieldUtil.modelField((String)"approved", (String)"Boolean")});
                this.put("Address", new ModelField[]{ModelFieldUtil.modelField((String)"this", (String)"Address"), ModelFieldUtil.modelField((String)"state", (String)"String"), ModelFieldUtil.modelField((String)"country", (String)"String")});
            }
        });
        return oracle;
    }

    private ConditionCol52 ageEqualsCondition() {
        ConditionCol52 condition = new ConditionCol52();
        condition.setConstraintValueType(1);
        condition.setHeader("col1");
        condition.setFactField("age");
        condition.setOperator("==");
        return condition;
    }

    private ConditionCol52 nameEqualsCondition() {
        ConditionCol52 condition = new ConditionCol52();
        condition.setConstraintValueType(1);
        condition.setHeader("col2");
        condition.setFactField("name");
        condition.setOperator("==");
        return condition;
    }

    private Pattern52 boundApplicantPattern(String boundName) {
        Pattern52 pattern = new Pattern52();
        pattern.setBoundName(boundName);
        pattern.setFactType("Applicant");
        return pattern;
    }

    private Pattern52 boundAddressPattern(String boundName) {
        Pattern52 pattern = new Pattern52();
        pattern.setBoundName(boundName);
        pattern.setFactType("Address");
        return pattern;
    }

    private ActionCol52 actionUpdatePattern(String boundName) {
        ActionSetFieldCol52 action = new ActionSetFieldCol52();
        action.setBoundName(boundName);
        action.setFactField("age");
        action.setHeader("action1");
        return action;
    }

    private BRLActionColumn actionCallMethod(String boundName) {
        ActionCallMethod action = new ActionCallMethod();
        action.setVariable(boundName);
        action.setMethodName("toString()");
        BRLActionColumn brl = new BRLActionColumn();
        brl.setHeader("brl-action");
        brl.setDefinition(Collections.singletonList(action));
        brl.getChildColumns().add(new BRLActionVariableColumn(){
            {
                this.setHeader("brl-action-v0");
            }
        });
        return brl;
    }

    @Test
    public void testOtherwise() throws ModelSynchronizer.VetoException {
        Pattern52 pattern = this.boundApplicantPattern("$a");
        ConditionCol52 condition = this.nameEqualsCondition();
        this.modelSynchronizer.appendColumn(pattern, condition);
        this.modelSynchronizer.appendRow();
        this.uiModel.setCellValue(0, 3, (GridCellValue)new GuidedDecisionTableUiCell((Object)"John"));
        this.modelSynchronizer.appendRow();
        this.uiModel.setCellValue(1, 3, (GridCellValue)new GuidedDecisionTableUiCell((Object)"George"));
        this.modelSynchronizer.setCellOtherwiseState(1, 3);
        Assert.assertFalse((boolean)((GuidedDecisionTableUiCell)this.uiModel.getCell(0, 3).getValue()).isOtherwise());
        Assert.assertTrue((boolean)((GuidedDecisionTableUiCell)this.uiModel.getCell(1, 3).getValue()).isOtherwise());
    }

    @Test
    public void testAppend1() throws ModelSynchronizer.VetoException {
        Pattern52 pattern = this.boundApplicantPattern("$a");
        ConditionCol52 condition = this.ageEqualsCondition();
        this.modelSynchronizer.appendColumn(pattern, condition);
        Assert.assertEquals((long)4L, (long)this.model.getExpandedColumns().size());
        Assert.assertEquals((long)1L, (long)this.model.getConditions().size());
        Assert.assertEquals((long)1L, (long)this.model.getConditionPattern("$a").getChildColumns().size());
        Assert.assertEquals((long)4L, (long)this.uiModel.getColumns().size());
        Assert.assertTrue((boolean)(this.uiModel.getColumns().get(3) instanceof IntegerUiColumn));
    }

    @Test
    public void testAppend2() throws ModelSynchronizer.VetoException {
        Pattern52 pattern = this.boundApplicantPattern("$a");
        ConditionCol52 condition1 = this.ageEqualsCondition();
        this.modelSynchronizer.appendColumn(pattern, condition1);
        Assert.assertEquals((long)4L, (long)this.model.getExpandedColumns().size());
        Assert.assertEquals((long)1L, (long)this.model.getConditions().size());
        Assert.assertEquals((long)4L, (long)this.uiModel.getColumns().size());
        Assert.assertTrue((boolean)(this.uiModel.getColumns().get(3) instanceof IntegerUiColumn));
        ConditionCol52 condition2 = this.nameEqualsCondition();
        this.modelSynchronizer.appendColumn(pattern, condition2);
        Assert.assertEquals((long)5L, (long)this.model.getExpandedColumns().size());
        Assert.assertEquals((long)1L, (long)this.model.getConditions().size());
        Assert.assertEquals((long)2L, (long)this.model.getConditionPattern("$a").getChildColumns().size());
        Assert.assertEquals((long)5L, (long)this.uiModel.getColumns().size());
        Assert.assertTrue((boolean)(this.uiModel.getColumns().get(3) instanceof IntegerUiColumn));
        Assert.assertTrue((boolean)(this.uiModel.getColumns().get(4) instanceof StringUiColumn));
    }

    @Test
    public void testAppend3() throws ModelSynchronizer.VetoException {
        Pattern52 pattern1 = this.boundApplicantPattern("$a");
        ConditionCol52 condition1 = this.ageEqualsCondition();
        this.modelSynchronizer.appendColumn(pattern1, condition1);
        Assert.assertEquals((long)4L, (long)this.model.getExpandedColumns().size());
        Assert.assertEquals((long)1L, (long)this.model.getConditions().size());
        Assert.assertEquals((long)4L, (long)this.uiModel.getColumns().size());
        Assert.assertTrue((boolean)(this.uiModel.getColumns().get(3) instanceof IntegerUiColumn));
        Pattern52 pattern2 = this.boundAddressPattern("$d");
        ConditionCol52 condition2 = new ConditionCol52();
        condition2.setConstraintValueType(1);
        condition2.setHeader("col2");
        condition2.setFactField("country");
        condition2.setOperator("==");
        this.modelSynchronizer.appendColumn(pattern2, condition2);
        Assert.assertEquals((long)5L, (long)this.model.getExpandedColumns().size());
        Assert.assertEquals((long)2L, (long)this.model.getConditions().size());
        Assert.assertEquals((long)1L, (long)this.model.getConditionPattern("$a").getChildColumns().size());
        Assert.assertEquals((long)1L, (long)this.model.getConditionPattern("$d").getChildColumns().size());
        Assert.assertEquals((long)5L, (long)this.uiModel.getColumns().size());
        Assert.assertTrue((boolean)(this.uiModel.getColumns().get(3) instanceof IntegerUiColumn));
        Assert.assertTrue((boolean)(this.uiModel.getColumns().get(4) instanceof StringUiColumn));
    }

    @Test
    public void testAppendNegated() throws ModelSynchronizer.VetoException {
        Pattern52 pattern = new Pattern52();
        pattern.setNegated(true);
        pattern.setFactType("Applicant");
        ConditionCol52 condition1 = this.ageEqualsCondition();
        this.modelSynchronizer.appendColumn(pattern, condition1);
        Assert.assertEquals((long)4L, (long)this.model.getExpandedColumns().size());
        Assert.assertEquals((long)1L, (long)this.model.getConditions().size());
        Assert.assertEquals((long)4L, (long)this.uiModel.getColumns().size());
        Assert.assertTrue((boolean)(this.uiModel.getColumns().get(3) instanceof IntegerUiColumn));
        ConditionCol52 condition2 = this.nameEqualsCondition();
        this.modelSynchronizer.appendColumn(pattern, condition2);
        Assert.assertEquals((long)5L, (long)this.model.getExpandedColumns().size());
        Assert.assertEquals((long)1L, (long)this.model.getConditions().size());
        Assert.assertEquals((long)2L, (long)((CompositeColumn)this.model.getConditions().get(0)).getChildColumns().size());
        Assert.assertEquals((long)5L, (long)this.uiModel.getColumns().size());
        Assert.assertTrue((boolean)(this.uiModel.getColumns().get(3) instanceof IntegerUiColumn));
        Assert.assertTrue((boolean)(this.uiModel.getColumns().get(4) instanceof StringUiColumn));
        Assert.assertEquals((Object)"not Applicant", (Object)((GridColumn.HeaderMetaData)((GridColumn)this.uiModel.getColumns().get(3)).getHeaderMetaData().get(0)).getTitle());
        Assert.assertEquals((Object)"not Applicant", (Object)((GridColumn.HeaderMetaData)((GridColumn)this.uiModel.getColumns().get(4)).getHeaderMetaData().get(0)).getTitle());
    }

    @Test
    public void testAppendBoolean() throws ModelSynchronizer.VetoException {
        Pattern52 pattern = this.boundApplicantPattern("$a");
        ConditionCol52 condition = new ConditionCol52();
        condition.setConstraintValueType(1);
        condition.setHeader("col1");
        condition.setFactField("approved");
        condition.setOperator("==");
        this.modelSynchronizer.appendColumn(pattern, condition);
        this.modelSynchronizer.appendRow();
        Assert.assertEquals((long)4L, (long)this.model.getExpandedColumns().size());
        Assert.assertEquals((long)1L, (long)this.model.getConditions().size());
        Assert.assertEquals((long)1L, (long)this.model.getConditionPattern("$a").getChildColumns().size());
        Assert.assertEquals((long)4L, (long)this.uiModel.getColumns().size());
        Assert.assertTrue((boolean)(this.uiModel.getColumns().get(3) instanceof BooleanUiColumn));
        this.modelSynchronizer.appendRow();
        Assert.assertFalse((boolean)((DTCellValue52)((List)this.model.getData().get(0)).get(3)).getBooleanValue());
        Assert.assertFalse((boolean)((Boolean)((GridCell)this.uiModel.getRow(0).getCells().get(3)).getValue().getValue()));
    }

    @Test
    public void testUpdate1() throws ModelSynchronizer.VetoException {
        Pattern52 pattern = (Pattern52)Mockito.spy((Object)this.boundApplicantPattern("$a"));
        ConditionCol52 condition = (ConditionCol52)Mockito.spy((Object)this.ageEqualsCondition());
        this.modelSynchronizer.appendColumn(pattern, condition);
        Pattern52 editedPattern = this.boundApplicantPattern("$a");
        ConditionCol52 editedCondition = this.nameEqualsCondition();
        editedCondition.setWidth(condition.getWidth());
        List diffs = this.modelSynchronizer.updateColumn(pattern, condition, editedPattern, editedCondition);
        Assert.assertEquals((long)2L, (long)diffs.size());
        ((Pattern52)Mockito.verify((Object)pattern)).diff((BaseColumn)editedPattern);
        ((ConditionCol52)Mockito.verify((Object)condition)).diff((BaseColumn)editedCondition);
        Assert.assertEquals((Object)"header", (Object)((BaseColumnFieldDiff)diffs.get(0)).getFieldName());
        Assert.assertEquals((Object)"factField", (Object)((BaseColumnFieldDiff)diffs.get(1)).getFieldName());
        Assert.assertEquals((long)4L, (long)this.model.getExpandedColumns().size());
        Assert.assertEquals((long)1L, (long)this.model.getConditions().size());
        Assert.assertEquals((long)1L, (long)this.model.getConditionPattern("$a").getChildColumns().size());
        Assert.assertEquals((long)4L, (long)this.uiModel.getColumns().size());
        Assert.assertTrue((boolean)(this.uiModel.getColumns().get(3) instanceof StringUiColumn));
        Assert.assertEquals((Object)(editedPattern.getBoundName() + " : " + editedPattern.getFactType()), (Object)((GridColumn.HeaderMetaData)((GridColumn)this.uiModel.getColumns().get(3)).getHeaderMetaData().get(0)).getTitle());
        Assert.assertEquals((Object)editedCondition.getHeader(), (Object)((GridColumn.HeaderMetaData)((GridColumn)this.uiModel.getColumns().get(3)).getHeaderMetaData().get(1)).getTitle());
    }

    @Test
    public void testUpdate2() throws ModelSynchronizer.VetoException {
        Pattern52 pattern = (Pattern52)Mockito.spy((Object)this.boundApplicantPattern("$a"));
        ConditionCol52 condition1 = (ConditionCol52)Mockito.spy((Object)this.ageEqualsCondition());
        condition1.setHeader("$a age is");
        this.modelSynchronizer.appendColumn(pattern, condition1);
        ConditionCol52 condition2 = this.nameEqualsCondition();
        this.modelSynchronizer.appendColumn(pattern, condition2);
        Pattern52 editedPattern = this.boundApplicantPattern("$a2");
        ConditionCol52 editedCondition = this.ageEqualsCondition();
        editedCondition.setWidth(condition2.getWidth());
        editedCondition.setHeader("$a2 age is");
        List diffs = this.modelSynchronizer.updateColumn(pattern, condition1, editedPattern, editedCondition);
        Assert.assertEquals((long)2L, (long)diffs.size());
        ((Pattern52)Mockito.verify((Object)pattern)).diff((BaseColumn)editedPattern);
        ((ConditionCol52)Mockito.verify((Object)condition1)).diff((BaseColumn)editedCondition);
        Assert.assertEquals((long)5L, (long)this.model.getExpandedColumns().size());
        Assert.assertEquals((long)2L, (long)this.model.getConditions().size());
        Assert.assertEquals((long)1L, (long)this.model.getConditionPattern("$a").getChildColumns().size());
        Assert.assertEquals((long)1L, (long)this.model.getConditionPattern("$a2").getChildColumns().size());
        Assert.assertEquals((long)5L, (long)this.uiModel.getColumns().size());
        Assert.assertTrue((boolean)(this.uiModel.getColumns().get(3) instanceof StringUiColumn));
        Assert.assertTrue((boolean)(this.uiModel.getColumns().get(4) instanceof IntegerUiColumn));
        Assert.assertEquals((Object)(editedPattern.getBoundName() + " : " + editedPattern.getFactType()), (Object)((GridColumn.HeaderMetaData)((GridColumn)this.uiModel.getColumns().get(4)).getHeaderMetaData().get(0)).getTitle());
        Assert.assertEquals((Object)editedCondition.getHeader(), (Object)((GridColumn.HeaderMetaData)((GridColumn)this.uiModel.getColumns().get(4)).getHeaderMetaData().get(1)).getTitle());
    }

    @Test
    public void testUpdate3() throws ModelSynchronizer.VetoException {
        Pattern52 pattern1 = (Pattern52)Mockito.spy((Object)this.boundApplicantPattern("$a"));
        ConditionCol52 condition1 = (ConditionCol52)Mockito.spy((Object)this.ageEqualsCondition());
        this.modelSynchronizer.appendColumn(pattern1, condition1);
        ConditionCol52 condition2 = this.nameEqualsCondition();
        this.modelSynchronizer.appendColumn(pattern1, condition2);
        Pattern52 editedPattern = this.boundAddressPattern("$d");
        ConditionCol52 editedCondition = new ConditionCol52();
        editedCondition.setWidth(condition1.getWidth());
        editedCondition.setConstraintValueType(1);
        editedCondition.setHeader("col1");
        editedCondition.setFactField("country");
        editedCondition.setOperator("==");
        List diffs = this.modelSynchronizer.updateColumn(pattern1, condition1, editedPattern, editedCondition);
        Assert.assertEquals((long)3L, (long)diffs.size());
        ((Pattern52)Mockito.verify((Object)pattern1)).diff((BaseColumn)editedPattern);
        ((ConditionCol52)Mockito.verify((Object)condition1)).diff((BaseColumn)editedCondition);
        Assert.assertEquals((long)5L, (long)this.model.getExpandedColumns().size());
        Assert.assertEquals((long)2L, (long)this.model.getConditions().size());
        Assert.assertEquals((long)1L, (long)this.model.getConditionPattern("$a").getChildColumns().size());
        Assert.assertEquals((long)1L, (long)this.model.getConditionPattern("$d").getChildColumns().size());
        Assert.assertEquals((long)5L, (long)this.uiModel.getColumns().size());
        Assert.assertTrue((boolean)(this.uiModel.getColumns().get(3) instanceof StringUiColumn));
        Assert.assertTrue((boolean)(this.uiModel.getColumns().get(4) instanceof StringUiColumn));
        Assert.assertEquals((Object)(editedPattern.getBoundName() + " : " + editedPattern.getFactType()), (Object)((GridColumn.HeaderMetaData)((GridColumn)this.uiModel.getColumns().get(4)).getHeaderMetaData().get(0)).getTitle());
        Assert.assertEquals((Object)editedCondition.getHeader(), (Object)((GridColumn.HeaderMetaData)((GridColumn)this.uiModel.getColumns().get(4)).getHeaderMetaData().get(1)).getTitle());
    }

    @Test
    public void testUpdate4() throws ModelSynchronizer.VetoException {
        Pattern52 pattern1 = (Pattern52)Mockito.spy((Object)this.boundApplicantPattern("$a"));
        ConditionCol52 condition1 = (ConditionCol52)Mockito.spy((Object)this.ageEqualsCondition());
        this.modelSynchronizer.appendColumn(pattern1, condition1);
        Pattern52 editedPattern = this.boundAddressPattern("$d");
        ConditionCol52 editedCondition = new ConditionCol52();
        editedCondition.setWidth(condition1.getWidth());
        editedCondition.setConstraintValueType(1);
        editedCondition.setHeader("col1");
        editedCondition.setFactField("country");
        editedCondition.setOperator("==");
        List diffs = this.modelSynchronizer.updateColumn(pattern1, condition1, editedPattern, editedCondition);
        Assert.assertEquals((long)3L, (long)diffs.size());
        ((Pattern52)Mockito.verify((Object)pattern1)).diff((BaseColumn)editedPattern);
        ((ConditionCol52)Mockito.verify((Object)condition1)).diff((BaseColumn)editedCondition);
        Assert.assertEquals((long)4L, (long)this.model.getExpandedColumns().size());
        Assert.assertEquals((long)1L, (long)this.model.getConditions().size());
        Assert.assertNull((Object)this.model.getConditionPattern("$a"));
        Assert.assertEquals((long)1L, (long)this.model.getConditionPattern("$d").getChildColumns().size());
        Assert.assertEquals((long)4L, (long)this.uiModel.getColumns().size());
        Assert.assertTrue((boolean)(this.uiModel.getColumns().get(3) instanceof StringUiColumn));
        Assert.assertEquals((Object)(editedPattern.getBoundName() + " : " + editedPattern.getFactType()), (Object)((GridColumn.HeaderMetaData)((GridColumn)this.uiModel.getColumns().get(3)).getHeaderMetaData().get(0)).getTitle());
        Assert.assertEquals((Object)editedCondition.getHeader(), (Object)((GridColumn.HeaderMetaData)((GridColumn)this.uiModel.getColumns().get(3)).getHeaderMetaData().get(1)).getTitle());
    }

    @Test
    public void testUpdate5() throws ModelSynchronizer.VetoException {
        Pattern52 pattern1 = (Pattern52)Mockito.spy((Object)this.boundApplicantPattern("$a"));
        ConditionCol52 condition1 = (ConditionCol52)Mockito.spy((Object)this.ageEqualsCondition());
        this.modelSynchronizer.appendColumn(pattern1, condition1);
        Pattern52 editedPattern = this.boundApplicantPattern("$a");
        ConditionCol52 editedCondition = this.ageEqualsCondition();
        editedCondition.setWidth(condition1.getWidth());
        editedCondition.setHideColumn(true);
        editedCondition.setHeader("updated");
        List diffs = this.modelSynchronizer.updateColumn(pattern1, condition1, editedPattern, editedCondition);
        Assert.assertEquals((long)2L, (long)diffs.size());
        ((Pattern52)Mockito.verify((Object)pattern1)).diff((BaseColumn)editedPattern);
        ((ConditionCol52)Mockito.verify((Object)condition1)).diff((BaseColumn)editedCondition);
        Assert.assertEquals((long)4L, (long)this.model.getExpandedColumns().size());
        Assert.assertEquals((long)1L, (long)this.model.getConditions().size());
        Assert.assertEquals((long)1L, (long)this.model.getConditionPattern("$a").getChildColumns().size());
        Assert.assertEquals((long)4L, (long)this.uiModel.getColumns().size());
        Assert.assertTrue((boolean)(this.uiModel.getColumns().get(3) instanceof IntegerUiColumn));
        Assert.assertEquals((Object)false, (Object)((GridColumn)this.uiModel.getColumns().get(3)).isVisible());
        Assert.assertEquals((Object)(editedPattern.getBoundName() + " : " + editedPattern.getFactType()), (Object)((GridColumn.HeaderMetaData)((GridColumn)this.uiModel.getColumns().get(3)).getHeaderMetaData().get(0)).getTitle());
        Assert.assertEquals((Object)editedCondition.getHeader(), (Object)((GridColumn.HeaderMetaData)((GridColumn)this.uiModel.getColumns().get(3)).getHeaderMetaData().get(1)).getTitle());
    }

    @Test
    public void testUpdate6() throws ModelSynchronizer.VetoException {
        Pattern52 pattern = (Pattern52)Mockito.spy((Object)this.boundApplicantPattern("$a"));
        ConditionCol52 condition = (ConditionCol52)Mockito.spy((Object)this.ageEqualsCondition());
        this.modelSynchronizer.appendColumn(pattern, condition);
        Pattern52 editedPattern = this.boundApplicantPattern("$a");
        ConditionCol52 editedCondition = this.ageEqualsCondition();
        editedCondition.setWidth(condition.getWidth());
        editedCondition.setOperator("!=");
        List diffs = this.modelSynchronizer.updateColumn(pattern, condition, editedPattern, editedCondition);
        Assert.assertEquals((long)1L, (long)diffs.size());
        ((Pattern52)Mockito.verify((Object)pattern)).diff((BaseColumn)editedPattern);
        ((ConditionCol52)Mockito.verify((Object)condition)).diff((BaseColumn)editedCondition);
        Assert.assertEquals((long)4L, (long)this.model.getExpandedColumns().size());
        Assert.assertEquals((long)1L, (long)this.model.getConditions().size());
        Assert.assertEquals((long)1L, (long)this.model.getConditionPattern("$a").getChildColumns().size());
        Assert.assertEquals((long)4L, (long)this.uiModel.getColumns().size());
        Assert.assertTrue((boolean)(this.uiModel.getColumns().get(3) instanceof IntegerUiColumn));
        Assert.assertEquals((Object)(editedPattern.getBoundName() + " : " + editedPattern.getFactType()), (Object)((GridColumn.HeaderMetaData)((GridColumn)this.uiModel.getColumns().get(3)).getHeaderMetaData().get(0)).getTitle());
        Assert.assertEquals((Object)editedCondition.getHeader(), (Object)((GridColumn.HeaderMetaData)((GridColumn)this.uiModel.getColumns().get(3)).getHeaderMetaData().get(1)).getTitle());
    }

    @Test
    public void testUpdate7() throws ModelSynchronizer.VetoException {
        String boundName = "$a";
        Pattern52 pattern = (Pattern52)Mockito.spy((Object)this.boundApplicantPattern("$a"));
        Pattern52 editedPattern = this.boundApplicantPattern("$a");
        ConditionCol52 condition = (ConditionCol52)Mockito.spy((Object)this.ageEqualsCondition());
        ConditionCol52 editedCondition = this.nameEqualsCondition();
        String entryPoint = "entryPoint";
        this.modelSynchronizer.appendColumn(pattern, condition);
        editedPattern.setEntryPointName("entryPoint");
        editedCondition.setWidth(condition.getWidth());
        List diffs = this.modelSynchronizer.updateColumn(pattern, condition, editedPattern, editedCondition);
        Assert.assertEquals((long)3L, (long)diffs.size());
        ((Pattern52)Mockito.verify((Object)pattern)).diff((BaseColumn)editedPattern);
        ((ConditionCol52)Mockito.verify((Object)condition)).diff((BaseColumn)editedCondition);
        ((Pattern52)Mockito.verify((Object)pattern)).setEntryPointName("entryPoint");
        Assert.assertEquals((Object)"entryPointName", (Object)((BaseColumnFieldDiff)diffs.get(0)).getFieldName());
        Assert.assertEquals((Object)"header", (Object)((BaseColumnFieldDiff)diffs.get(1)).getFieldName());
        Assert.assertEquals((Object)"factField", (Object)((BaseColumnFieldDiff)diffs.get(2)).getFieldName());
        Assert.assertEquals((long)4L, (long)this.model.getExpandedColumns().size());
        Assert.assertEquals((long)1L, (long)this.model.getConditions().size());
        Assert.assertEquals((long)1L, (long)this.model.getConditionPattern("$a").getChildColumns().size());
        Assert.assertEquals((long)4L, (long)this.uiModel.getColumns().size());
        Assert.assertTrue((boolean)(this.uiModel.getColumns().get(3) instanceof StringUiColumn));
        String expectedTitle = editedPattern.getBoundName() + " : " + editedPattern.getFactType();
        String actualTitle = ((GridColumn.HeaderMetaData)((GridColumn)this.uiModel.getColumns().get(3)).getHeaderMetaData().get(0)).getTitle();
        Assert.assertEquals((Object)expectedTitle, (Object)actualTitle);
        String expectedHeader = editedCondition.getHeader();
        String actualHeader = ((GridColumn.HeaderMetaData)((GridColumn)this.uiModel.getColumns().get(3)).getHeaderMetaData().get(1)).getTitle();
        Assert.assertEquals((Object)expectedHeader, (Object)actualHeader);
    }

    @Test
    public void testUpdateToNegated() throws ModelSynchronizer.VetoException {
        Pattern52 pattern = (Pattern52)Mockito.spy((Object)this.boundApplicantPattern("$a"));
        ConditionCol52 condition = (ConditionCol52)Mockito.spy((Object)this.ageEqualsCondition());
        this.modelSynchronizer.appendColumn(pattern, condition);
        Assert.assertEquals((Object)"$a : Applicant", (Object)((GridColumn.HeaderMetaData)((GridColumn)this.uiModel.getColumns().get(3)).getHeaderMetaData().get(0)).getTitle());
        Pattern52 editedPattern = new Pattern52();
        editedPattern.setNegated(true);
        editedPattern.setFactType("Applicant");
        ConditionCol52 editedCondition = (ConditionCol52)Mockito.spy((Object)this.ageEqualsCondition());
        this.modelSynchronizer.updateColumn(pattern, condition, editedPattern, editedCondition);
        Assert.assertEquals((Object)"not Applicant", (Object)((GridColumn.HeaderMetaData)((GridColumn)this.uiModel.getColumns().get(3)).getHeaderMetaData().get(0)).getTitle());
        Assert.assertEquals((Object)editedCondition.getHeader(), (Object)((GridColumn.HeaderMetaData)((GridColumn)this.uiModel.getColumns().get(3)).getHeaderMetaData().get(1)).getTitle());
    }

    @Test
    public void checkConditionCannotBeUpdatedWhenBindingIsUsedInAction() throws ModelSynchronizer.VetoException {
        Pattern52 pattern = this.boundApplicantPattern("$a");
        ConditionCol52 condition = this.ageEqualsCondition();
        ActionCol52 action = this.actionUpdatePattern("$a");
        this.modelSynchronizer.appendColumn(pattern, condition);
        this.modelSynchronizer.appendColumn((BaseColumn)action);
        try {
            Pattern52 editedPattern = this.boundApplicantPattern("$a2");
            ConditionCol52 editedCondition = this.nameEqualsCondition();
            this.modelSynchronizer.updateColumn(pattern, condition, editedPattern, editedCondition);
            Assert.fail((String)"Update of the column should have been vetoed.");
        }
        catch (ModelSynchronizer.VetoUpdatePatternInUseException editedPattern) {
        }
        catch (ModelSynchronizer.VetoException veto) {
            Assert.fail((String)"VetoUpdatePatternInUseException was expected.");
        }
        Assert.assertEquals((long)5L, (long)this.model.getExpandedColumns().size());
        Assert.assertTrue((boolean)(this.model.getExpandedColumns().get(0) instanceof RowNumberCol52));
        Assert.assertTrue((boolean)(this.model.getExpandedColumns().get(1) instanceof RuleNameColumn));
        Assert.assertTrue((boolean)(this.model.getExpandedColumns().get(2) instanceof DescriptionCol52));
        Assert.assertEquals((Object)condition, this.model.getExpandedColumns().get(3));
        Assert.assertEquals((Object)action, this.model.getExpandedColumns().get(4));
    }

    @Test
    public void checkConditionCannotBeUpdatedWhenFieldBindingIsUsedInAction() throws ModelSynchronizer.VetoException {
        Pattern52 pattern = this.boundApplicantPattern("$a");
        ConditionCol52 condition = this.ageEqualsCondition();
        condition.setBinding("$age");
        BRLActionColumn action = this.actionCallMethod("$age");
        this.modelSynchronizer.appendColumn(pattern, condition);
        this.modelSynchronizer.appendColumn((BaseColumn)action);
        try {
            Pattern52 editedPattern = this.boundApplicantPattern("$a");
            ConditionCol52 editedCondition = this.ageEqualsCondition();
            editedCondition.setBinding("$age2");
            this.modelSynchronizer.updateColumn(pattern, condition, editedPattern, editedCondition);
            Assert.fail((String)"Update of the column should have been vetoed.");
        }
        catch (ModelSynchronizer.VetoUpdatePatternInUseException editedPattern) {
        }
        catch (ModelSynchronizer.VetoException veto) {
            Assert.fail((String)"VetoUpdatePatternInUseException was expected.");
        }
        Assert.assertEquals((long)5L, (long)this.model.getExpandedColumns().size());
        Assert.assertTrue((boolean)(this.model.getExpandedColumns().get(0) instanceof RowNumberCol52));
        Assert.assertTrue((boolean)(this.model.getExpandedColumns().get(1) instanceof RuleNameColumn));
        Assert.assertTrue((boolean)(this.model.getExpandedColumns().get(2) instanceof DescriptionCol52));
        Assert.assertEquals((Object)condition, this.model.getExpandedColumns().get(3));
        Assert.assertEquals(action.getChildColumns().get(0), this.model.getExpandedColumns().get(4));
    }

    @Test
    public void checkAddToValueListPreservesData() throws ModelSynchronizer.VetoException {
        Pattern52 pattern = (Pattern52)Mockito.spy((Object)this.boundApplicantPattern("$a"));
        ConditionCol52 condition = (ConditionCol52)Mockito.spy((Object)this.nameEqualsCondition());
        condition.setValueList("A,B,C");
        this.modelSynchronizer.appendColumn(pattern, condition);
        this.modelSynchronizer.appendRow();
        this.modelSynchronizer.appendRow();
        this.modelSynchronizer.appendRow();
        this.uiModel.setCellValue(0, 3, (GridCellValue)new BaseGridCellValue((Object)"A"));
        this.uiModel.setCellValue(1, 3, (GridCellValue)new BaseGridCellValue((Object)"B"));
        this.uiModel.setCellValue(2, 3, (GridCellValue)new BaseGridCellValue((Object)"C"));
        Pattern52 editedPattern = this.boundApplicantPattern("$a");
        ConditionCol52 editedCondition = this.nameEqualsCondition();
        editedCondition.setWidth(condition.getWidth());
        editedCondition.setValueList("A,B,C,D");
        List diffs = this.modelSynchronizer.updateColumn(pattern, condition, editedPattern, editedCondition);
        Assert.assertEquals((long)1L, (long)diffs.size());
        ((Pattern52)Mockito.verify((Object)pattern)).diff((BaseColumn)editedPattern);
        ((ConditionCol52)Mockito.verify((Object)condition)).diff((BaseColumn)editedCondition);
        Assert.assertEquals((Object)"valueList", (Object)((BaseColumnFieldDiff)diffs.get(0)).getFieldName());
        Assert.assertEquals((Object)"A", (Object)this.uiModel.getCell(0, 3).getValue().getValue().toString());
        Assert.assertEquals((Object)"B", (Object)this.uiModel.getCell(1, 3).getValue().getValue().toString());
        Assert.assertEquals((Object)"C", (Object)this.uiModel.getCell(2, 3).getValue().getValue().toString());
        Assert.assertEquals((Object)"A", (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(3)).getStringValue());
        Assert.assertEquals((Object)"B", (Object)((DTCellValue52)((List)this.model.getData().get(1)).get(3)).getStringValue());
        Assert.assertEquals((Object)"C", (Object)((DTCellValue52)((List)this.model.getData().get(2)).get(3)).getStringValue());
    }

    @Test
    public void checkRemoveFromValueListClearsData() throws ModelSynchronizer.VetoException {
        Pattern52 pattern = (Pattern52)Mockito.spy((Object)this.boundApplicantPattern("$a"));
        ConditionCol52 condition = (ConditionCol52)Mockito.spy((Object)this.nameEqualsCondition());
        condition.setValueList("A,B,C");
        this.modelSynchronizer.appendColumn(pattern, condition);
        this.modelSynchronizer.appendRow();
        this.modelSynchronizer.appendRow();
        this.modelSynchronizer.appendRow();
        this.uiModel.setCellValue(0, 3, (GridCellValue)new BaseGridCellValue((Object)"A"));
        this.uiModel.setCellValue(1, 3, (GridCellValue)new BaseGridCellValue((Object)"B"));
        this.uiModel.setCellValue(2, 3, (GridCellValue)new BaseGridCellValue((Object)"C"));
        Pattern52 editedPattern = this.boundApplicantPattern("$a");
        ConditionCol52 editedCondition = this.nameEqualsCondition();
        editedCondition.setWidth(condition.getWidth());
        editedCondition.setValueList("A");
        List diffs = this.modelSynchronizer.updateColumn(pattern, condition, editedPattern, editedCondition);
        Assert.assertEquals((long)1L, (long)diffs.size());
        ((Pattern52)Mockito.verify((Object)pattern)).diff((BaseColumn)editedPattern);
        ((ConditionCol52)Mockito.verify((Object)condition)).diff((BaseColumn)editedCondition);
        Assert.assertEquals((Object)"valueList", (Object)((BaseColumnFieldDiff)diffs.get(0)).getFieldName());
        Assert.assertEquals((Object)"A", (Object)this.uiModel.getCell(0, 3).getValue().getValue().toString());
        Assert.assertNull((Object)this.uiModel.getCell(1, 3));
        Assert.assertNull((Object)this.uiModel.getCell(2, 3));
        Assert.assertEquals((Object)"A", (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(3)).getStringValue());
        Assert.assertFalse((boolean)((DTCellValue52)((List)this.model.getData().get(1)).get(3)).hasValue());
        Assert.assertFalse((boolean)((DTCellValue52)((List)this.model.getData().get(2)).get(3)).hasValue());
    }

    @Test
    public void testDelete1() throws ModelSynchronizer.VetoException {
        Pattern52 pattern = this.boundApplicantPattern("$a");
        ConditionCol52 condition = this.ageEqualsCondition();
        this.modelSynchronizer.appendColumn(pattern, condition);
        Assert.assertEquals((long)4L, (long)this.model.getExpandedColumns().size());
        Assert.assertEquals((long)1L, (long)this.model.getConditions().size());
        Assert.assertEquals((long)4L, (long)this.uiModel.getColumns().size());
        this.modelSynchronizer.deleteColumn((BaseColumn)condition);
        Assert.assertEquals((long)3L, (long)this.model.getExpandedColumns().size());
        Assert.assertEquals((long)0L, (long)this.model.getConditions().size());
        Assert.assertNull((Object)this.model.getConditionPattern("$a"));
        Assert.assertEquals((long)3L, (long)this.uiModel.getColumns().size());
    }

    @Test
    public void testDelete2() throws ModelSynchronizer.VetoException {
        Pattern52 pattern = this.boundApplicantPattern("$a");
        ConditionCol52 condition1 = this.ageEqualsCondition();
        this.modelSynchronizer.appendColumn(pattern, condition1);
        ConditionCol52 condition2 = this.nameEqualsCondition();
        this.modelSynchronizer.appendColumn(pattern, condition2);
        Assert.assertEquals((long)5L, (long)this.model.getExpandedColumns().size());
        Assert.assertEquals((long)1L, (long)this.model.getConditions().size());
        Assert.assertEquals((long)5L, (long)this.uiModel.getColumns().size());
        this.modelSynchronizer.deleteColumn((BaseColumn)condition1);
        Assert.assertEquals((long)4L, (long)this.model.getExpandedColumns().size());
        Assert.assertEquals((long)1L, (long)this.model.getConditions().size());
        Assert.assertEquals((long)1L, (long)this.model.getConditionPattern("$a").getChildColumns().size());
        Assert.assertEquals((long)4L, (long)this.uiModel.getColumns().size());
    }

    @Test
    public void testDelete3() throws ModelSynchronizer.VetoException {
        Pattern52 pattern1 = this.boundApplicantPattern("$a");
        ConditionCol52 condition1 = this.ageEqualsCondition();
        this.modelSynchronizer.appendColumn(pattern1, condition1);
        Pattern52 pattern2 = this.boundAddressPattern("$d");
        ConditionCol52 condition2 = new ConditionCol52();
        condition2.setConstraintValueType(1);
        condition2.setHeader("col2");
        condition2.setFactField("country");
        condition2.setOperator("==");
        this.modelSynchronizer.appendColumn(pattern2, condition2);
        Assert.assertEquals((long)5L, (long)this.model.getExpandedColumns().size());
        Assert.assertEquals((long)2L, (long)this.model.getConditions().size());
        Assert.assertEquals((long)1L, (long)this.model.getConditionPattern("$a").getChildColumns().size());
        Assert.assertEquals((long)1L, (long)this.model.getConditionPattern("$d").getChildColumns().size());
        Assert.assertEquals((long)5L, (long)this.uiModel.getColumns().size());
        this.modelSynchronizer.deleteColumn((BaseColumn)condition1);
        Assert.assertEquals((long)4L, (long)this.model.getExpandedColumns().size());
        Assert.assertEquals((long)1L, (long)this.model.getConditions().size());
        Assert.assertNull((Object)this.model.getConditionPattern("$a"));
        Assert.assertEquals((long)1L, (long)this.model.getConditionPattern("$d").getChildColumns().size());
        Assert.assertEquals((long)4L, (long)this.uiModel.getColumns().size());
    }

    @Test
    public void checkConditionCannotBeDeletedWithSingleChildColumnWithAction() throws ModelSynchronizer.VetoException {
        Pattern52 pattern = this.boundApplicantPattern("$a");
        ConditionCol52 condition = this.ageEqualsCondition();
        ActionCol52 action = this.actionUpdatePattern("$a");
        this.modelSynchronizer.appendColumn(pattern, condition);
        this.modelSynchronizer.appendColumn((BaseColumn)action);
        try {
            this.modelSynchronizer.deleteColumn((BaseColumn)condition);
            Assert.fail((String)"Deletion of the column should have been vetoed.");
        }
        catch (ModelSynchronizer.VetoDeletePatternInUseException vetoDeletePatternInUseException) {
        }
        catch (ModelSynchronizer.VetoException veto) {
            Assert.fail((String)"VetoDeletePatternInUseException was expected.");
        }
        Assert.assertEquals((long)5L, (long)this.model.getExpandedColumns().size());
        Assert.assertTrue((boolean)(this.model.getExpandedColumns().get(0) instanceof RowNumberCol52));
        Assert.assertTrue((boolean)(this.model.getExpandedColumns().get(1) instanceof RuleNameColumn));
        Assert.assertTrue((boolean)(this.model.getExpandedColumns().get(2) instanceof DescriptionCol52));
        Assert.assertEquals((Object)condition, this.model.getExpandedColumns().get(3));
        Assert.assertEquals((Object)action, this.model.getExpandedColumns().get(4));
    }

    @Test
    public void checkConditionCannotBeDeletedWhenFieldBindingIsUsedInAction() throws ModelSynchronizer.VetoException {
        Pattern52 pattern = this.boundApplicantPattern("$a");
        ConditionCol52 condition = this.ageEqualsCondition();
        condition.setBinding("$age");
        BRLActionColumn action = this.actionCallMethod("$age");
        this.modelSynchronizer.appendColumn(pattern, condition);
        this.modelSynchronizer.appendColumn((BaseColumn)action);
        try {
            this.modelSynchronizer.deleteColumn((BaseColumn)condition);
            Assert.fail((String)"Deletion of the column should have been vetoed.");
        }
        catch (ModelSynchronizer.VetoDeletePatternInUseException vetoDeletePatternInUseException) {
        }
        catch (ModelSynchronizer.VetoException veto) {
            Assert.fail((String)"VetoDeletePatternInUseException was expected.");
        }
        Assert.assertEquals((long)5L, (long)this.model.getExpandedColumns().size());
        Assert.assertTrue((boolean)(this.model.getExpandedColumns().get(0) instanceof RowNumberCol52));
        Assert.assertTrue((boolean)(this.model.getExpandedColumns().get(1) instanceof RuleNameColumn));
        Assert.assertTrue((boolean)(this.model.getExpandedColumns().get(2) instanceof DescriptionCol52));
        Assert.assertEquals((Object)condition, this.model.getExpandedColumns().get(3));
        Assert.assertEquals(action.getChildColumns().get(0), this.model.getExpandedColumns().get(4));
    }

    @Test
    public void checkConditionCanBeDeletedWithSingleChildColumnWithNoAction() throws ModelSynchronizer.VetoException {
        Pattern52 pattern = this.boundApplicantPattern("$a");
        ConditionCol52 condition = this.ageEqualsCondition();
        this.modelSynchronizer.appendColumn(pattern, condition);
        try {
            this.modelSynchronizer.deleteColumn((BaseColumn)condition);
        }
        catch (ModelSynchronizer.VetoException veto) {
            Assert.fail((String)"Deletion should have been permitted.");
        }
        Assert.assertEquals((long)3L, (long)this.model.getExpandedColumns().size());
        Assert.assertTrue((boolean)(this.model.getExpandedColumns().get(0) instanceof RowNumberCol52));
        Assert.assertTrue((boolean)(this.model.getExpandedColumns().get(1) instanceof RuleNameColumn));
        Assert.assertTrue((boolean)(this.model.getExpandedColumns().get(2) instanceof DescriptionCol52));
    }

    @Test
    public void checkConditionCanBeDeletedWithMultipleChildColumns() throws ModelSynchronizer.VetoException {
        Pattern52 pattern = this.boundApplicantPattern("$a");
        ConditionCol52 condition1 = this.ageEqualsCondition();
        ConditionCol52 condition2 = this.nameEqualsCondition();
        this.modelSynchronizer.appendColumn(pattern, condition1);
        this.modelSynchronizer.appendColumn(pattern, condition2);
        try {
            this.modelSynchronizer.deleteColumn((BaseColumn)condition2);
        }
        catch (ModelSynchronizer.VetoException veto) {
            Assert.fail((String)"Deletion should have been permitted.");
        }
        Assert.assertEquals((long)4L, (long)this.model.getExpandedColumns().size());
        Assert.assertTrue((boolean)(this.model.getExpandedColumns().get(0) instanceof RowNumberCol52));
        Assert.assertTrue((boolean)(this.model.getExpandedColumns().get(1) instanceof RuleNameColumn));
        Assert.assertTrue((boolean)(this.model.getExpandedColumns().get(2) instanceof DescriptionCol52));
        Assert.assertEquals((Object)condition1, this.model.getExpandedColumns().get(3));
    }

    @Test
    public void testMoveLeftNegatedPattern() throws ModelSynchronizer.VetoException {
        Pattern52 pattern = new Pattern52();
        pattern.setNegated(true);
        pattern.setFactType("Applicant");
        ConditionCol52 column1 = this.ageEqualsCondition();
        ConditionCol52 column2 = this.nameEqualsCondition();
        this.modelSynchronizer.appendColumn(pattern, column1);
        this.modelSynchronizer.appendColumn(pattern, column2);
        this.modelSynchronizer.appendRow();
        this.uiModel.setCellValue(0, 3, (GridCellValue)new BaseGridCellValue((Object)45));
        this.uiModel.setCellValue(0, 4, (GridCellValue)new BaseGridCellValue((Object)"Smurf"));
        Assert.assertEquals((long)1L, (long)this.model.getPatterns().size());
        List conditionColumns1_1 = ((Pattern52)this.model.getPatterns().get(0)).getChildColumns();
        Assert.assertEquals((Object)column1, conditionColumns1_1.get(0));
        Assert.assertEquals((Object)column2, conditionColumns1_1.get(1));
        Assert.assertEquals((Object)45, (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(3)).getNumericValue());
        Assert.assertEquals((Object)"Smurf", (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(4)).getStringValue());
        Assert.assertEquals((long)5L, (long)this.uiModel.getColumns().size());
        GridColumn uiModelColumn1_1 = (GridColumn)this.uiModel.getColumns().get(3);
        GridColumn uiModelColumn2_1 = (GridColumn)this.uiModel.getColumns().get(4);
        Assert.assertEquals((Object)"not Applicant", (Object)((GridColumn.HeaderMetaData)uiModelColumn1_1.getHeaderMetaData().get(0)).getTitle());
        Assert.assertEquals((Object)"not Applicant", (Object)((GridColumn.HeaderMetaData)uiModelColumn2_1.getHeaderMetaData().get(0)).getTitle());
        Assert.assertTrue((boolean)(uiModelColumn1_1 instanceof IntegerUiColumn));
        Assert.assertTrue((boolean)(uiModelColumn2_1 instanceof StringUiColumn));
        Assert.assertEquals((long)3L, (long)uiModelColumn1_1.getIndex());
        Assert.assertEquals((long)4L, (long)uiModelColumn2_1.getIndex());
        Assert.assertEquals((Object)45, (Object)((GridCell)this.uiModel.getRow(0).getCells().get(uiModelColumn1_1.getIndex())).getValue().getValue());
        Assert.assertEquals((Object)"Smurf", (Object)((GridCell)this.uiModel.getRow(0).getCells().get(uiModelColumn2_1.getIndex())).getValue().getValue());
        this.uiModel.moveColumnTo(3, uiModelColumn2_1);
        Assert.assertEquals((long)1L, (long)this.model.getPatterns().size());
        List conditionColumns1_2 = ((Pattern52)this.model.getPatterns().get(0)).getChildColumns();
        Assert.assertEquals((Object)column2, conditionColumns1_2.get(0));
        Assert.assertEquals((Object)column1, conditionColumns1_2.get(1));
        Assert.assertEquals((Object)"Smurf", (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(3)).getStringValue());
        Assert.assertEquals((Object)45, (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(4)).getNumericValue());
        Assert.assertEquals((long)5L, (long)this.uiModel.getColumns().size());
        GridColumn uiModelColumn1_2 = (GridColumn)this.uiModel.getColumns().get(3);
        GridColumn uiModelColumn2_2 = (GridColumn)this.uiModel.getColumns().get(4);
        Assert.assertEquals((Object)"not Applicant", (Object)((GridColumn.HeaderMetaData)uiModelColumn1_2.getHeaderMetaData().get(0)).getTitle());
        Assert.assertEquals((Object)"not Applicant", (Object)((GridColumn.HeaderMetaData)uiModelColumn2_2.getHeaderMetaData().get(0)).getTitle());
        Assert.assertTrue((boolean)(uiModelColumn1_2 instanceof StringUiColumn));
        Assert.assertTrue((boolean)(uiModelColumn2_2 instanceof IntegerUiColumn));
        Assert.assertEquals((long)4L, (long)uiModelColumn1_2.getIndex());
        Assert.assertEquals((long)3L, (long)uiModelColumn2_2.getIndex());
        Assert.assertEquals((Object)"Smurf", (Object)((GridCell)this.uiModel.getRow(0).getCells().get(uiModelColumn1_2.getIndex())).getValue().getValue());
        Assert.assertEquals((Object)45, (Object)((GridCell)this.uiModel.getRow(0).getCells().get(uiModelColumn2_2.getIndex())).getValue().getValue());
    }

    @Test
    public void testMoveColumnTo_MoveLeft() throws ModelSynchronizer.VetoException {
        Pattern52 pattern = this.boundApplicantPattern("$a");
        ConditionCol52 column1 = this.ageEqualsCondition();
        ConditionCol52 column2 = this.nameEqualsCondition();
        this.modelSynchronizer.appendColumn(pattern, column1);
        this.modelSynchronizer.appendColumn(pattern, column2);
        this.modelSynchronizer.appendRow();
        this.uiModel.setCellValue(0, 3, (GridCellValue)new BaseGridCellValue((Object)45));
        this.uiModel.setCellValue(0, 4, (GridCellValue)new BaseGridCellValue((Object)"Smurf"));
        Assert.assertEquals((long)1L, (long)this.model.getPatterns().size());
        List conditionColumns1_1 = ((Pattern52)this.model.getPatterns().get(0)).getChildColumns();
        Assert.assertEquals((Object)column1, conditionColumns1_1.get(0));
        Assert.assertEquals((Object)column2, conditionColumns1_1.get(1));
        Assert.assertEquals((Object)45, (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(3)).getNumericValue());
        Assert.assertEquals((Object)"Smurf", (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(4)).getStringValue());
        Assert.assertEquals((long)5L, (long)this.uiModel.getColumns().size());
        GridColumn uiModelColumn1_1 = (GridColumn)this.uiModel.getColumns().get(3);
        GridColumn uiModelColumn2_1 = (GridColumn)this.uiModel.getColumns().get(4);
        Assert.assertEquals((Object)"$a : Applicant", (Object)((GridColumn.HeaderMetaData)uiModelColumn1_1.getHeaderMetaData().get(0)).getTitle());
        Assert.assertEquals((Object)"$a : Applicant", (Object)((GridColumn.HeaderMetaData)uiModelColumn2_1.getHeaderMetaData().get(0)).getTitle());
        Assert.assertTrue((boolean)(uiModelColumn1_1 instanceof IntegerUiColumn));
        Assert.assertTrue((boolean)(uiModelColumn2_1 instanceof StringUiColumn));
        Assert.assertEquals((long)3L, (long)uiModelColumn1_1.getIndex());
        Assert.assertEquals((long)4L, (long)uiModelColumn2_1.getIndex());
        Assert.assertEquals((Object)45, (Object)((GridCell)this.uiModel.getRow(0).getCells().get(uiModelColumn1_1.getIndex())).getValue().getValue());
        Assert.assertEquals((Object)"Smurf", (Object)((GridCell)this.uiModel.getRow(0).getCells().get(uiModelColumn2_1.getIndex())).getValue().getValue());
        this.uiModel.moveColumnTo(3, uiModelColumn2_1);
        Assert.assertEquals((long)1L, (long)this.model.getPatterns().size());
        List conditionColumns1_2 = ((Pattern52)this.model.getPatterns().get(0)).getChildColumns();
        Assert.assertEquals((Object)column2, conditionColumns1_2.get(0));
        Assert.assertEquals((Object)column1, conditionColumns1_2.get(1));
        Assert.assertEquals((Object)"Smurf", (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(3)).getStringValue());
        Assert.assertEquals((Object)45, (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(4)).getNumericValue());
        Assert.assertEquals((long)5L, (long)this.uiModel.getColumns().size());
        GridColumn uiModelColumn1_2 = (GridColumn)this.uiModel.getColumns().get(3);
        GridColumn uiModelColumn2_2 = (GridColumn)this.uiModel.getColumns().get(4);
        Assert.assertEquals((Object)"$a : Applicant", (Object)((GridColumn.HeaderMetaData)uiModelColumn1_2.getHeaderMetaData().get(0)).getTitle());
        Assert.assertEquals((Object)"$a : Applicant", (Object)((GridColumn.HeaderMetaData)uiModelColumn2_2.getHeaderMetaData().get(0)).getTitle());
        Assert.assertTrue((boolean)(uiModelColumn1_2 instanceof StringUiColumn));
        Assert.assertTrue((boolean)(uiModelColumn2_2 instanceof IntegerUiColumn));
        Assert.assertEquals((long)4L, (long)uiModelColumn1_2.getIndex());
        Assert.assertEquals((long)3L, (long)uiModelColumn2_2.getIndex());
        Assert.assertEquals((Object)"Smurf", (Object)((GridCell)this.uiModel.getRow(0).getCells().get(uiModelColumn1_2.getIndex())).getValue().getValue());
        Assert.assertEquals((Object)45, (Object)((GridCell)this.uiModel.getRow(0).getCells().get(uiModelColumn2_2.getIndex())).getValue().getValue());
    }

    @Test
    public void testMoveColumnTo_MoveRight() throws ModelSynchronizer.VetoException {
        Pattern52 pattern = this.boundApplicantPattern("$a");
        ConditionCol52 column1 = this.ageEqualsCondition();
        ConditionCol52 column2 = this.nameEqualsCondition();
        this.modelSynchronizer.appendColumn(pattern, column1);
        this.modelSynchronizer.appendColumn(pattern, column2);
        this.modelSynchronizer.appendRow();
        this.uiModel.setCellValue(0, 3, (GridCellValue)new BaseGridCellValue((Object)45));
        this.uiModel.setCellValue(0, 4, (GridCellValue)new BaseGridCellValue((Object)"Smurf"));
        Assert.assertEquals((long)1L, (long)this.model.getPatterns().size());
        List conditionColumns1_1 = ((Pattern52)this.model.getPatterns().get(0)).getChildColumns();
        Assert.assertEquals((Object)column1, conditionColumns1_1.get(0));
        Assert.assertEquals((Object)column2, conditionColumns1_1.get(1));
        Assert.assertEquals((Object)45, (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(3)).getNumericValue());
        Assert.assertEquals((Object)"Smurf", (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(4)).getStringValue());
        Assert.assertEquals((long)5L, (long)this.uiModel.getColumns().size());
        GridColumn uiModelColumn1_1 = (GridColumn)this.uiModel.getColumns().get(3);
        GridColumn uiModelColumn2_1 = (GridColumn)this.uiModel.getColumns().get(4);
        Assert.assertEquals((Object)"$a : Applicant", (Object)((GridColumn.HeaderMetaData)uiModelColumn1_1.getHeaderMetaData().get(0)).getTitle());
        Assert.assertEquals((Object)"$a : Applicant", (Object)((GridColumn.HeaderMetaData)uiModelColumn2_1.getHeaderMetaData().get(0)).getTitle());
        Assert.assertTrue((boolean)(uiModelColumn1_1 instanceof IntegerUiColumn));
        Assert.assertTrue((boolean)(uiModelColumn2_1 instanceof StringUiColumn));
        Assert.assertEquals((long)3L, (long)uiModelColumn1_1.getIndex());
        Assert.assertEquals((long)4L, (long)uiModelColumn2_1.getIndex());
        Assert.assertEquals((Object)45, (Object)((GridCell)this.uiModel.getRow(0).getCells().get(uiModelColumn1_1.getIndex())).getValue().getValue());
        Assert.assertEquals((Object)"Smurf", (Object)((GridCell)this.uiModel.getRow(0).getCells().get(uiModelColumn2_1.getIndex())).getValue().getValue());
        this.uiModel.moveColumnTo(4, uiModelColumn1_1);
        Assert.assertEquals((long)1L, (long)this.model.getPatterns().size());
        List conditionColumns1_2 = ((Pattern52)this.model.getPatterns().get(0)).getChildColumns();
        Assert.assertEquals((Object)column2, conditionColumns1_2.get(0));
        Assert.assertEquals((Object)column1, conditionColumns1_2.get(1));
        Assert.assertEquals((Object)"Smurf", (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(3)).getStringValue());
        Assert.assertEquals((Object)45, (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(4)).getNumericValue());
        Assert.assertEquals((long)5L, (long)this.uiModel.getColumns().size());
        GridColumn uiModelColumn1_2 = (GridColumn)this.uiModel.getColumns().get(3);
        GridColumn uiModelColumn2_2 = (GridColumn)this.uiModel.getColumns().get(4);
        Assert.assertEquals((Object)"$a : Applicant", (Object)((GridColumn.HeaderMetaData)uiModelColumn1_2.getHeaderMetaData().get(0)).getTitle());
        Assert.assertEquals((Object)"$a : Applicant", (Object)((GridColumn.HeaderMetaData)uiModelColumn2_2.getHeaderMetaData().get(0)).getTitle());
        Assert.assertTrue((boolean)(uiModelColumn1_2 instanceof StringUiColumn));
        Assert.assertTrue((boolean)(uiModelColumn2_2 instanceof IntegerUiColumn));
        Assert.assertEquals((long)4L, (long)uiModelColumn1_2.getIndex());
        Assert.assertEquals((long)3L, (long)uiModelColumn2_2.getIndex());
        Assert.assertEquals((Object)"Smurf", (Object)((GridCell)this.uiModel.getRow(0).getCells().get(uiModelColumn1_2.getIndex())).getValue().getValue());
        Assert.assertEquals((Object)45, (Object)((GridCell)this.uiModel.getRow(0).getCells().get(uiModelColumn2_2.getIndex())).getValue().getValue());
    }

    @Test
    public void testMoveColumnTo_OutOfBounds_OutOfConditions() throws ModelSynchronizer.VetoException {
        Pattern52 pattern = this.boundApplicantPattern("$a");
        ConditionCol52 column1 = this.ageEqualsCondition();
        ConditionCol52 column2 = this.nameEqualsCondition();
        this.modelSynchronizer.appendColumn(pattern, column1);
        this.modelSynchronizer.appendColumn(pattern, column2);
        this.modelSynchronizer.appendRow();
        this.uiModel.setCellValue(0, 3, (GridCellValue)new BaseGridCellValue((Object)45));
        this.uiModel.setCellValue(0, 4, (GridCellValue)new BaseGridCellValue((Object)"Smurf"));
        Assert.assertEquals((long)1L, (long)this.model.getPatterns().size());
        List conditionColumns1_1 = ((Pattern52)this.model.getPatterns().get(0)).getChildColumns();
        Assert.assertEquals((Object)column1, conditionColumns1_1.get(0));
        Assert.assertEquals((Object)column2, conditionColumns1_1.get(1));
        Assert.assertEquals((Object)45, (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(3)).getNumericValue());
        Assert.assertEquals((Object)"Smurf", (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(4)).getStringValue());
        Assert.assertEquals((long)5L, (long)this.uiModel.getColumns().size());
        GridColumn uiModelColumn1_1 = (GridColumn)this.uiModel.getColumns().get(3);
        GridColumn uiModelColumn2_1 = (GridColumn)this.uiModel.getColumns().get(4);
        Assert.assertEquals((Object)"$a : Applicant", (Object)((GridColumn.HeaderMetaData)uiModelColumn1_1.getHeaderMetaData().get(0)).getTitle());
        Assert.assertEquals((Object)"$a : Applicant", (Object)((GridColumn.HeaderMetaData)uiModelColumn2_1.getHeaderMetaData().get(0)).getTitle());
        Assert.assertTrue((boolean)(uiModelColumn1_1 instanceof IntegerUiColumn));
        Assert.assertTrue((boolean)(uiModelColumn2_1 instanceof StringUiColumn));
        Assert.assertEquals((long)3L, (long)uiModelColumn1_1.getIndex());
        Assert.assertEquals((long)4L, (long)uiModelColumn2_1.getIndex());
        Assert.assertEquals((Object)45, (Object)((GridCell)this.uiModel.getRow(0).getCells().get(uiModelColumn1_1.getIndex())).getValue().getValue());
        Assert.assertEquals((Object)"Smurf", (Object)((GridCell)this.uiModel.getRow(0).getCells().get(uiModelColumn2_1.getIndex())).getValue().getValue());
        this.uiModel.moveColumnTo(1, uiModelColumn1_1);
        Assert.assertEquals((long)1L, (long)this.model.getPatterns().size());
        List conditionColumns1_2 = ((Pattern52)this.model.getPatterns().get(0)).getChildColumns();
        Assert.assertEquals((Object)column1, conditionColumns1_2.get(0));
        Assert.assertEquals((Object)column2, conditionColumns1_2.get(1));
        Assert.assertEquals((Object)45, (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(3)).getNumericValue());
        Assert.assertEquals((Object)"Smurf", (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(4)).getStringValue());
        Assert.assertEquals((long)5L, (long)this.uiModel.getColumns().size());
        GridColumn uiModelColumn1_2 = (GridColumn)this.uiModel.getColumns().get(3);
        GridColumn uiModelColumn2_2 = (GridColumn)this.uiModel.getColumns().get(4);
        Assert.assertEquals((Object)"$a : Applicant", (Object)((GridColumn.HeaderMetaData)uiModelColumn1_2.getHeaderMetaData().get(0)).getTitle());
        Assert.assertEquals((Object)"$a : Applicant", (Object)((GridColumn.HeaderMetaData)uiModelColumn2_2.getHeaderMetaData().get(0)).getTitle());
        Assert.assertTrue((boolean)(uiModelColumn1_2 instanceof IntegerUiColumn));
        Assert.assertTrue((boolean)(uiModelColumn2_2 instanceof StringUiColumn));
        Assert.assertEquals((long)3L, (long)uiModelColumn1_2.getIndex());
        Assert.assertEquals((long)4L, (long)uiModelColumn2_2.getIndex());
        Assert.assertEquals((Object)45, (Object)((GridCell)this.uiModel.getRow(0).getCells().get(uiModelColumn1_2.getIndex())).getValue().getValue());
        Assert.assertEquals((Object)"Smurf", (Object)((GridCell)this.uiModel.getRow(0).getCells().get(uiModelColumn2_2.getIndex())).getValue().getValue());
    }

    @Test
    public void testMoveColumnTo_OutOfBounds_OutOfPattern() throws ModelSynchronizer.VetoException {
        Pattern52 pattern1 = this.boundApplicantPattern("$a");
        ConditionCol52 column1p1 = this.ageEqualsCondition();
        this.modelSynchronizer.appendColumn(pattern1, column1p1);
        ConditionCol52 column2p1 = this.nameEqualsCondition();
        this.modelSynchronizer.appendColumn(pattern1, column2p1);
        Pattern52 pattern2 = this.boundApplicantPattern("$a2");
        ConditionCol52 column1p2 = this.nameEqualsCondition();
        this.modelSynchronizer.appendColumn(pattern2, column1p2);
        this.modelSynchronizer.appendRow();
        this.uiModel.setCellValue(0, 3, (GridCellValue)new BaseGridCellValue((Object)45));
        this.uiModel.setCellValue(0, 4, (GridCellValue)new BaseGridCellValue((Object)"Fred"));
        this.uiModel.setCellValue(0, 5, (GridCellValue)new BaseGridCellValue((Object)"Smurf"));
        Assert.assertEquals((long)2L, (long)this.model.getPatterns().size());
        List conditionColumns1_1 = ((Pattern52)this.model.getPatterns().get(0)).getChildColumns();
        Assert.assertEquals((Object)column1p1, conditionColumns1_1.get(0));
        Assert.assertEquals((Object)column2p1, conditionColumns1_1.get(1));
        List conditionColumns2_1 = ((Pattern52)this.model.getPatterns().get(1)).getChildColumns();
        Assert.assertEquals((Object)column1p2, conditionColumns2_1.get(0));
        Assert.assertEquals((Object)45, (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(3)).getNumericValue());
        Assert.assertEquals((Object)"Fred", (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(4)).getStringValue());
        Assert.assertEquals((Object)"Smurf", (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(5)).getStringValue());
        Assert.assertEquals((long)6L, (long)this.uiModel.getColumns().size());
        GridColumn uiModelColumn1_1 = (GridColumn)this.uiModel.getColumns().get(3);
        GridColumn uiModelColumn2_1 = (GridColumn)this.uiModel.getColumns().get(4);
        GridColumn uiModelColumn3_1 = (GridColumn)this.uiModel.getColumns().get(5);
        Assert.assertEquals((Object)"$a : Applicant", (Object)((GridColumn.HeaderMetaData)uiModelColumn1_1.getHeaderMetaData().get(0)).getTitle());
        Assert.assertEquals((Object)"$a : Applicant", (Object)((GridColumn.HeaderMetaData)uiModelColumn2_1.getHeaderMetaData().get(0)).getTitle());
        Assert.assertEquals((Object)"$a2 : Applicant", (Object)((GridColumn.HeaderMetaData)uiModelColumn3_1.getHeaderMetaData().get(0)).getTitle());
        Assert.assertTrue((boolean)(uiModelColumn1_1 instanceof IntegerUiColumn));
        Assert.assertTrue((boolean)(uiModelColumn2_1 instanceof StringUiColumn));
        Assert.assertTrue((boolean)(uiModelColumn3_1 instanceof StringUiColumn));
        Assert.assertEquals((long)3L, (long)uiModelColumn1_1.getIndex());
        Assert.assertEquals((long)4L, (long)uiModelColumn2_1.getIndex());
        Assert.assertEquals((long)5L, (long)uiModelColumn3_1.getIndex());
        Assert.assertEquals((Object)45, (Object)((GridCell)this.uiModel.getRow(0).getCells().get(uiModelColumn1_1.getIndex())).getValue().getValue());
        Assert.assertEquals((Object)"Fred", (Object)((GridCell)this.uiModel.getRow(0).getCells().get(uiModelColumn2_1.getIndex())).getValue().getValue());
        Assert.assertEquals((Object)"Smurf", (Object)((GridCell)this.uiModel.getRow(0).getCells().get(uiModelColumn3_1.getIndex())).getValue().getValue());
        this.uiModel.moveColumnTo(5, uiModelColumn1_1);
        Assert.assertEquals((long)2L, (long)this.model.getPatterns().size());
        List conditionColumns1_2 = ((Pattern52)this.model.getPatterns().get(0)).getChildColumns();
        Assert.assertEquals((Object)column1p1, conditionColumns1_2.get(0));
        Assert.assertEquals((Object)column2p1, conditionColumns1_2.get(1));
        List conditionColumns2_2 = ((Pattern52)this.model.getPatterns().get(1)).getChildColumns();
        Assert.assertEquals((Object)column1p2, conditionColumns2_2.get(0));
        Assert.assertEquals((Object)45, (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(3)).getNumericValue());
        Assert.assertEquals((Object)"Fred", (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(4)).getStringValue());
        Assert.assertEquals((Object)"Smurf", (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(5)).getStringValue());
        Assert.assertEquals((long)6L, (long)this.uiModel.getColumns().size());
        GridColumn uiModelColumn1_2 = (GridColumn)this.uiModel.getColumns().get(3);
        GridColumn uiModelColumn2_2 = (GridColumn)this.uiModel.getColumns().get(4);
        GridColumn uiModelColumn3_2 = (GridColumn)this.uiModel.getColumns().get(5);
        Assert.assertEquals((Object)"$a : Applicant", (Object)((GridColumn.HeaderMetaData)uiModelColumn1_2.getHeaderMetaData().get(0)).getTitle());
        Assert.assertEquals((Object)"$a : Applicant", (Object)((GridColumn.HeaderMetaData)uiModelColumn2_2.getHeaderMetaData().get(0)).getTitle());
        Assert.assertEquals((Object)"$a2 : Applicant", (Object)((GridColumn.HeaderMetaData)uiModelColumn3_2.getHeaderMetaData().get(0)).getTitle());
        Assert.assertTrue((boolean)(uiModelColumn1_2 instanceof IntegerUiColumn));
        Assert.assertTrue((boolean)(uiModelColumn2_2 instanceof StringUiColumn));
        Assert.assertTrue((boolean)(uiModelColumn3_2 instanceof StringUiColumn));
        Assert.assertEquals((long)3L, (long)uiModelColumn1_2.getIndex());
        Assert.assertEquals((long)4L, (long)uiModelColumn2_2.getIndex());
        Assert.assertEquals((long)5L, (long)uiModelColumn3_2.getIndex());
        Assert.assertEquals((Object)45, (Object)((GridCell)this.uiModel.getRow(0).getCells().get(uiModelColumn1_2.getIndex())).getValue().getValue());
        Assert.assertEquals((Object)"Fred", (Object)((GridCell)this.uiModel.getRow(0).getCells().get(uiModelColumn2_2.getIndex())).getValue().getValue());
        Assert.assertEquals((Object)"Smurf", (Object)((GridCell)this.uiModel.getRow(0).getCells().get(uiModelColumn3_2.getIndex())).getValue().getValue());
    }

    @Test
    public void testMoveColumnTo_SingleColumnPattern() throws ModelSynchronizer.VetoException {
        Pattern52 pattern1 = this.boundApplicantPattern("$a");
        ConditionCol52 column1p1 = this.ageEqualsCondition();
        this.modelSynchronizer.appendColumn(pattern1, column1p1);
        Pattern52 pattern2 = this.boundApplicantPattern("$a2");
        ConditionCol52 column1p2 = this.nameEqualsCondition();
        this.modelSynchronizer.appendColumn(pattern2, column1p2);
        this.modelSynchronizer.appendRow();
        this.uiModel.setCellValue(0, 3, (GridCellValue)new BaseGridCellValue((Object)45));
        this.uiModel.setCellValue(0, 4, (GridCellValue)new BaseGridCellValue((Object)"Smurf"));
        Assert.assertEquals((long)2L, (long)this.model.getPatterns().size());
        List conditionColumns1_1 = ((Pattern52)this.model.getPatterns().get(0)).getChildColumns();
        Assert.assertEquals((Object)column1p1, conditionColumns1_1.get(0));
        List conditionColumns2_1 = ((Pattern52)this.model.getPatterns().get(1)).getChildColumns();
        Assert.assertEquals((Object)column1p2, conditionColumns2_1.get(0));
        Assert.assertEquals((Object)45, (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(3)).getNumericValue());
        Assert.assertEquals((Object)"Smurf", (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(4)).getStringValue());
        Assert.assertEquals((long)5L, (long)this.uiModel.getColumns().size());
        GridColumn uiModelColumn1_1 = (GridColumn)this.uiModel.getColumns().get(3);
        GridColumn uiModelColumn2_1 = (GridColumn)this.uiModel.getColumns().get(4);
        Assert.assertEquals((Object)"$a : Applicant", (Object)((GridColumn.HeaderMetaData)uiModelColumn1_1.getHeaderMetaData().get(0)).getTitle());
        Assert.assertEquals((Object)"$a2 : Applicant", (Object)((GridColumn.HeaderMetaData)uiModelColumn2_1.getHeaderMetaData().get(0)).getTitle());
        Assert.assertTrue((boolean)(uiModelColumn1_1 instanceof IntegerUiColumn));
        Assert.assertTrue((boolean)(uiModelColumn2_1 instanceof StringUiColumn));
        Assert.assertEquals((long)3L, (long)uiModelColumn1_1.getIndex());
        Assert.assertEquals((long)4L, (long)uiModelColumn2_1.getIndex());
        Assert.assertEquals((Object)45, (Object)((GridCell)this.uiModel.getRow(0).getCells().get(uiModelColumn1_1.getIndex())).getValue().getValue());
        Assert.assertEquals((Object)"Smurf", (Object)((GridCell)this.uiModel.getRow(0).getCells().get(uiModelColumn2_1.getIndex())).getValue().getValue());
        this.uiModel.moveColumnTo(4, uiModelColumn1_1);
        Assert.assertEquals((long)2L, (long)this.model.getPatterns().size());
        List conditionColumns1_2 = ((Pattern52)this.model.getPatterns().get(0)).getChildColumns();
        Assert.assertEquals((Object)column1p2, conditionColumns1_2.get(0));
        List conditionColumns2_2 = ((Pattern52)this.model.getPatterns().get(1)).getChildColumns();
        Assert.assertEquals((Object)column1p1, conditionColumns2_2.get(0));
        Assert.assertEquals((Object)"Smurf", (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(3)).getStringValue());
        Assert.assertEquals((Object)45, (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(4)).getNumericValue());
        Assert.assertEquals((long)5L, (long)this.uiModel.getColumns().size());
        GridColumn uiModelColumn1_2 = (GridColumn)this.uiModel.getColumns().get(3);
        GridColumn uiModelColumn2_2 = (GridColumn)this.uiModel.getColumns().get(4);
        Assert.assertEquals((Object)"$a2 : Applicant", (Object)((GridColumn.HeaderMetaData)uiModelColumn1_2.getHeaderMetaData().get(0)).getTitle());
        Assert.assertEquals((Object)"$a : Applicant", (Object)((GridColumn.HeaderMetaData)uiModelColumn2_2.getHeaderMetaData().get(0)).getTitle());
        Assert.assertTrue((boolean)(uiModelColumn1_2 instanceof StringUiColumn));
        Assert.assertTrue((boolean)(uiModelColumn2_2 instanceof IntegerUiColumn));
        Assert.assertEquals((long)4L, (long)uiModelColumn1_2.getIndex());
        Assert.assertEquals((long)3L, (long)uiModelColumn2_2.getIndex());
        Assert.assertEquals((Object)"Smurf", (Object)((GridCell)this.uiModel.getRow(0).getCells().get(uiModelColumn1_2.getIndex())).getValue().getValue());
        Assert.assertEquals((Object)45, (Object)((GridCell)this.uiModel.getRow(0).getCells().get(uiModelColumn2_2.getIndex())).getValue().getValue());
    }

    @Test
    public void testMoveColumnsTo_MoveLeft() throws ModelSynchronizer.VetoException {
        Pattern52 pattern1 = this.boundApplicantPattern("$a");
        ConditionCol52 column1p1 = this.ageEqualsCondition();
        ConditionCol52 column2p1 = this.nameEqualsCondition();
        this.modelSynchronizer.appendColumn(pattern1, column1p1);
        this.modelSynchronizer.appendColumn(pattern1, column2p1);
        Pattern52 pattern2 = this.boundAddressPattern("$d");
        ConditionCol52 column1p2 = new ConditionCol52();
        column1p2.setConstraintValueType(1);
        column1p2.setFactField("state");
        column1p2.setOperator("==");
        column1p2.setHeader("state");
        ConditionCol52 column2p2 = new ConditionCol52();
        column2p2.setConstraintValueType(1);
        column2p2.setFactField("country");
        column2p2.setOperator("==");
        column2p2.setHeader("country");
        this.modelSynchronizer.appendColumn(pattern2, column1p2);
        this.modelSynchronizer.appendColumn(pattern2, column2p2);
        this.modelSynchronizer.appendRow();
        this.uiModel.setCellValue(0, 3, (GridCellValue)new BaseGridCellValue((Object)45));
        this.uiModel.setCellValue(0, 4, (GridCellValue)new BaseGridCellValue((Object)"Smurf"));
        this.uiModel.setCellValue(0, 5, (GridCellValue)new BaseGridCellValue((Object)"NY"));
        this.uiModel.setCellValue(0, 6, (GridCellValue)new BaseGridCellValue((Object)"America"));
        Assert.assertEquals((long)2L, (long)this.model.getPatterns().size());
        List conditionColumns1_1p1 = ((Pattern52)this.model.getPatterns().get(0)).getChildColumns();
        Assert.assertEquals((Object)column1p1, conditionColumns1_1p1.get(0));
        Assert.assertEquals((Object)column2p1, conditionColumns1_1p1.get(1));
        Assert.assertEquals((Object)45, (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(3)).getNumericValue());
        Assert.assertEquals((Object)"Smurf", (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(4)).getStringValue());
        List conditionColumns1_1p2 = ((Pattern52)this.model.getPatterns().get(1)).getChildColumns();
        Assert.assertEquals((Object)column1p2, conditionColumns1_1p2.get(0));
        Assert.assertEquals((Object)column2p2, conditionColumns1_1p2.get(1));
        Assert.assertEquals((Object)"NY", (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(5)).getStringValue());
        Assert.assertEquals((Object)"America", (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(6)).getStringValue());
        Assert.assertEquals((long)7L, (long)this.uiModel.getColumns().size());
        GridColumn uiModelColumn1_1 = (GridColumn)this.uiModel.getColumns().get(3);
        GridColumn uiModelColumn2_1 = (GridColumn)this.uiModel.getColumns().get(4);
        final GridColumn uiModelColumn3_1 = (GridColumn)this.uiModel.getColumns().get(5);
        final GridColumn uiModelColumn4_1 = (GridColumn)this.uiModel.getColumns().get(6);
        Assert.assertEquals((Object)"$a : Applicant", (Object)((GridColumn.HeaderMetaData)uiModelColumn1_1.getHeaderMetaData().get(0)).getTitle());
        Assert.assertEquals((Object)"$a : Applicant", (Object)((GridColumn.HeaderMetaData)uiModelColumn2_1.getHeaderMetaData().get(0)).getTitle());
        Assert.assertEquals((Object)"$d : Address", (Object)((GridColumn.HeaderMetaData)uiModelColumn3_1.getHeaderMetaData().get(0)).getTitle());
        Assert.assertEquals((Object)"$d : Address", (Object)((GridColumn.HeaderMetaData)uiModelColumn4_1.getHeaderMetaData().get(0)).getTitle());
        Assert.assertTrue((boolean)(uiModelColumn1_1 instanceof IntegerUiColumn));
        Assert.assertTrue((boolean)(uiModelColumn2_1 instanceof StringUiColumn));
        Assert.assertTrue((boolean)(uiModelColumn3_1 instanceof StringUiColumn));
        Assert.assertTrue((boolean)(uiModelColumn4_1 instanceof StringUiColumn));
        Assert.assertEquals((long)3L, (long)uiModelColumn1_1.getIndex());
        Assert.assertEquals((long)4L, (long)uiModelColumn2_1.getIndex());
        Assert.assertEquals((long)5L, (long)uiModelColumn3_1.getIndex());
        Assert.assertEquals((long)6L, (long)uiModelColumn4_1.getIndex());
        Assert.assertEquals((Object)45, (Object)((GridCell)this.uiModel.getRow(0).getCells().get(uiModelColumn1_1.getIndex())).getValue().getValue());
        Assert.assertEquals((Object)"Smurf", (Object)((GridCell)this.uiModel.getRow(0).getCells().get(uiModelColumn2_1.getIndex())).getValue().getValue());
        Assert.assertEquals((Object)"NY", (Object)((GridCell)this.uiModel.getRow(0).getCells().get(uiModelColumn3_1.getIndex())).getValue().getValue());
        Assert.assertEquals((Object)"America", (Object)((GridCell)this.uiModel.getRow(0).getCells().get(uiModelColumn4_1.getIndex())).getValue().getValue());
        this.uiModel.moveColumnsTo(3, (List)new ArrayList<GridColumn<?>>(){
            {
                this.add(uiModelColumn3_1);
                this.add(uiModelColumn4_1);
            }
        });
        Assert.assertEquals((long)2L, (long)this.model.getPatterns().size());
        List conditionColumns1_2p2 = ((Pattern52)this.model.getPatterns().get(0)).getChildColumns();
        Assert.assertEquals((Object)column1p2, conditionColumns1_2p2.get(0));
        Assert.assertEquals((Object)column2p2, conditionColumns1_2p2.get(1));
        Assert.assertEquals((Object)"NY", (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(3)).getStringValue());
        Assert.assertEquals((Object)"America", (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(4)).getStringValue());
        List conditionColumns1_2p1 = ((Pattern52)this.model.getPatterns().get(1)).getChildColumns();
        Assert.assertEquals((Object)column1p1, conditionColumns1_2p1.get(0));
        Assert.assertEquals((Object)column2p1, conditionColumns1_2p1.get(1));
        Assert.assertEquals((Object)45, (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(5)).getNumericValue());
        Assert.assertEquals((Object)"Smurf", (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(6)).getStringValue());
        Assert.assertEquals((long)7L, (long)this.uiModel.getColumns().size());
        GridColumn uiModelColumn1_2 = (GridColumn)this.uiModel.getColumns().get(3);
        GridColumn uiModelColumn2_2 = (GridColumn)this.uiModel.getColumns().get(4);
        GridColumn uiModelColumn3_2 = (GridColumn)this.uiModel.getColumns().get(5);
        GridColumn uiModelColumn4_2 = (GridColumn)this.uiModel.getColumns().get(6);
        Assert.assertEquals((Object)"$d : Address", (Object)((GridColumn.HeaderMetaData)uiModelColumn1_2.getHeaderMetaData().get(0)).getTitle());
        Assert.assertEquals((Object)"$d : Address", (Object)((GridColumn.HeaderMetaData)uiModelColumn2_2.getHeaderMetaData().get(0)).getTitle());
        Assert.assertEquals((Object)"$a : Applicant", (Object)((GridColumn.HeaderMetaData)uiModelColumn3_2.getHeaderMetaData().get(0)).getTitle());
        Assert.assertEquals((Object)"$a : Applicant", (Object)((GridColumn.HeaderMetaData)uiModelColumn4_2.getHeaderMetaData().get(0)).getTitle());
        Assert.assertTrue((boolean)(uiModelColumn1_2 instanceof StringUiColumn));
        Assert.assertTrue((boolean)(uiModelColumn2_2 instanceof StringUiColumn));
        Assert.assertTrue((boolean)(uiModelColumn3_2 instanceof IntegerUiColumn));
        Assert.assertTrue((boolean)(uiModelColumn4_2 instanceof StringUiColumn));
        Assert.assertEquals((long)5L, (long)uiModelColumn1_2.getIndex());
        Assert.assertEquals((long)6L, (long)uiModelColumn2_2.getIndex());
        Assert.assertEquals((long)3L, (long)uiModelColumn3_2.getIndex());
        Assert.assertEquals((long)4L, (long)uiModelColumn4_2.getIndex());
        Assert.assertEquals((Object)"NY", (Object)((GridCell)this.uiModel.getRow(0).getCells().get(uiModelColumn1_2.getIndex())).getValue().getValue());
        Assert.assertEquals((Object)"America", (Object)((GridCell)this.uiModel.getRow(0).getCells().get(uiModelColumn2_2.getIndex())).getValue().getValue());
        Assert.assertEquals((Object)45, (Object)((GridCell)this.uiModel.getRow(0).getCells().get(uiModelColumn3_2.getIndex())).getValue().getValue());
        Assert.assertEquals((Object)"Smurf", (Object)((GridCell)this.uiModel.getRow(0).getCells().get(uiModelColumn4_2.getIndex())).getValue().getValue());
    }

    @Test
    public void testMoveColumnsTo_MoveLeft_MidPoint() throws ModelSynchronizer.VetoException {
        Pattern52 pattern1 = this.boundApplicantPattern("$a");
        ConditionCol52 column1p1 = this.ageEqualsCondition();
        ConditionCol52 column2p1 = this.nameEqualsCondition();
        this.modelSynchronizer.appendColumn(pattern1, column1p1);
        this.modelSynchronizer.appendColumn(pattern1, column2p1);
        Pattern52 pattern2 = this.boundAddressPattern("$d");
        ConditionCol52 column1p2 = new ConditionCol52();
        column1p2.setConstraintValueType(1);
        column1p2.setFactField("state");
        column1p2.setOperator("==");
        column1p2.setHeader("state $d");
        ConditionCol52 column2p2 = new ConditionCol52();
        column2p2.setConstraintValueType(1);
        column2p2.setFactField("country");
        column2p2.setOperator("==");
        column2p2.setHeader("country $d");
        this.modelSynchronizer.appendColumn(pattern2, column1p2);
        this.modelSynchronizer.appendColumn(pattern2, column2p2);
        Pattern52 pattern3 = this.boundAddressPattern("$d2");
        ConditionCol52 column1p3 = new ConditionCol52();
        column1p3.setConstraintValueType(1);
        column1p3.setFactField("state");
        column1p3.setOperator("==");
        column1p3.setHeader("state $d2");
        ConditionCol52 column2p3 = new ConditionCol52();
        column2p3.setConstraintValueType(1);
        column2p3.setFactField("country");
        column2p3.setOperator("==");
        column2p3.setHeader("country $d2");
        this.modelSynchronizer.appendColumn(pattern3, column1p3);
        this.modelSynchronizer.appendColumn(pattern3, column2p3);
        this.modelSynchronizer.appendRow();
        this.uiModel.setCellValue(0, 3, (GridCellValue)new BaseGridCellValue((Object)45));
        this.uiModel.setCellValue(0, 4, (GridCellValue)new BaseGridCellValue((Object)"Smurf"));
        this.uiModel.setCellValue(0, 5, (GridCellValue)new BaseGridCellValue((Object)"NY"));
        this.uiModel.setCellValue(0, 6, (GridCellValue)new BaseGridCellValue((Object)"America"));
        this.uiModel.setCellValue(0, 7, (GridCellValue)new BaseGridCellValue((Object)"Essex"));
        this.uiModel.setCellValue(0, 8, (GridCellValue)new BaseGridCellValue((Object)"England"));
        Assert.assertEquals((long)3L, (long)this.model.getPatterns().size());
        List conditionColumns1_1p1 = ((Pattern52)this.model.getPatterns().get(0)).getChildColumns();
        Assert.assertEquals((Object)column1p1, conditionColumns1_1p1.get(0));
        Assert.assertEquals((Object)column2p1, conditionColumns1_1p1.get(1));
        Assert.assertEquals((Object)45, (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(3)).getNumericValue());
        Assert.assertEquals((Object)"Smurf", (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(4)).getStringValue());
        List conditionColumns1_1p2 = ((Pattern52)this.model.getPatterns().get(1)).getChildColumns();
        Assert.assertEquals((Object)column1p2, conditionColumns1_1p2.get(0));
        Assert.assertEquals((Object)column2p2, conditionColumns1_1p2.get(1));
        Assert.assertEquals((Object)"NY", (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(5)).getStringValue());
        Assert.assertEquals((Object)"America", (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(6)).getStringValue());
        List conditionColumns1_1p3 = ((Pattern52)this.model.getPatterns().get(2)).getChildColumns();
        Assert.assertEquals((Object)column1p3, conditionColumns1_1p3.get(0));
        Assert.assertEquals((Object)column2p3, conditionColumns1_1p3.get(1));
        Assert.assertEquals((Object)"Essex", (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(7)).getStringValue());
        Assert.assertEquals((Object)"England", (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(8)).getStringValue());
        Assert.assertEquals((long)9L, (long)this.uiModel.getColumns().size());
        GridColumn uiModelColumn1_1 = (GridColumn)this.uiModel.getColumns().get(3);
        GridColumn uiModelColumn2_1 = (GridColumn)this.uiModel.getColumns().get(4);
        GridColumn uiModelColumn3_1 = (GridColumn)this.uiModel.getColumns().get(5);
        GridColumn uiModelColumn4_1 = (GridColumn)this.uiModel.getColumns().get(6);
        final GridColumn uiModelColumn5_1 = (GridColumn)this.uiModel.getColumns().get(7);
        final GridColumn uiModelColumn6_1 = (GridColumn)this.uiModel.getColumns().get(8);
        Assert.assertEquals((Object)"$a : Applicant", (Object)((GridColumn.HeaderMetaData)uiModelColumn1_1.getHeaderMetaData().get(0)).getTitle());
        Assert.assertEquals((Object)"$a : Applicant", (Object)((GridColumn.HeaderMetaData)uiModelColumn2_1.getHeaderMetaData().get(0)).getTitle());
        Assert.assertEquals((Object)"$d : Address", (Object)((GridColumn.HeaderMetaData)uiModelColumn3_1.getHeaderMetaData().get(0)).getTitle());
        Assert.assertEquals((Object)"$d : Address", (Object)((GridColumn.HeaderMetaData)uiModelColumn4_1.getHeaderMetaData().get(0)).getTitle());
        Assert.assertEquals((Object)"$d2 : Address", (Object)((GridColumn.HeaderMetaData)uiModelColumn5_1.getHeaderMetaData().get(0)).getTitle());
        Assert.assertEquals((Object)"$d2 : Address", (Object)((GridColumn.HeaderMetaData)uiModelColumn6_1.getHeaderMetaData().get(0)).getTitle());
        Assert.assertTrue((boolean)(uiModelColumn1_1 instanceof IntegerUiColumn));
        Assert.assertTrue((boolean)(uiModelColumn2_1 instanceof StringUiColumn));
        Assert.assertTrue((boolean)(uiModelColumn3_1 instanceof StringUiColumn));
        Assert.assertTrue((boolean)(uiModelColumn4_1 instanceof StringUiColumn));
        Assert.assertTrue((boolean)(uiModelColumn5_1 instanceof StringUiColumn));
        Assert.assertTrue((boolean)(uiModelColumn6_1 instanceof StringUiColumn));
        Assert.assertEquals((long)3L, (long)uiModelColumn1_1.getIndex());
        Assert.assertEquals((long)4L, (long)uiModelColumn2_1.getIndex());
        Assert.assertEquals((long)5L, (long)uiModelColumn3_1.getIndex());
        Assert.assertEquals((long)6L, (long)uiModelColumn4_1.getIndex());
        Assert.assertEquals((long)7L, (long)uiModelColumn5_1.getIndex());
        Assert.assertEquals((long)8L, (long)uiModelColumn6_1.getIndex());
        Assert.assertEquals((Object)45, (Object)((GridCell)this.uiModel.getRow(0).getCells().get(uiModelColumn1_1.getIndex())).getValue().getValue());
        Assert.assertEquals((Object)"Smurf", (Object)((GridCell)this.uiModel.getRow(0).getCells().get(uiModelColumn2_1.getIndex())).getValue().getValue());
        Assert.assertEquals((Object)"NY", (Object)((GridCell)this.uiModel.getRow(0).getCells().get(uiModelColumn3_1.getIndex())).getValue().getValue());
        Assert.assertEquals((Object)"America", (Object)((GridCell)this.uiModel.getRow(0).getCells().get(uiModelColumn4_1.getIndex())).getValue().getValue());
        Assert.assertEquals((Object)"Essex", (Object)((GridCell)this.uiModel.getRow(0).getCells().get(uiModelColumn5_1.getIndex())).getValue().getValue());
        Assert.assertEquals((Object)"England", (Object)((GridCell)this.uiModel.getRow(0).getCells().get(uiModelColumn6_1.getIndex())).getValue().getValue());
        this.uiModel.moveColumnsTo(5, (List)new ArrayList<GridColumn<?>>(){
            {
                this.add(uiModelColumn5_1);
                this.add(uiModelColumn6_1);
            }
        });
        Assert.assertEquals((long)3L, (long)this.model.getPatterns().size());
        List conditionColumns1_2p1 = ((Pattern52)this.model.getPatterns().get(0)).getChildColumns();
        Assert.assertEquals((Object)column1p1, conditionColumns1_2p1.get(0));
        Assert.assertEquals((Object)column2p1, conditionColumns1_2p1.get(1));
        Assert.assertEquals((Object)45, (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(3)).getNumericValue());
        Assert.assertEquals((Object)"Smurf", (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(4)).getStringValue());
        List conditionColumns1_2p3 = ((Pattern52)this.model.getPatterns().get(1)).getChildColumns();
        Assert.assertEquals((Object)column1p3, conditionColumns1_2p3.get(0));
        Assert.assertEquals((Object)column2p3, conditionColumns1_2p3.get(1));
        Assert.assertEquals((Object)"Essex", (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(5)).getStringValue());
        Assert.assertEquals((Object)"England", (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(6)).getStringValue());
        List conditionColumns1_2p2 = ((Pattern52)this.model.getPatterns().get(2)).getChildColumns();
        Assert.assertEquals((Object)column1p2, conditionColumns1_2p2.get(0));
        Assert.assertEquals((Object)column2p2, conditionColumns1_2p2.get(1));
        Assert.assertEquals((Object)"NY", (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(7)).getStringValue());
        Assert.assertEquals((Object)"America", (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(8)).getStringValue());
        Assert.assertEquals((long)9L, (long)this.uiModel.getColumns().size());
        GridColumn uiModelColumn1_2 = (GridColumn)this.uiModel.getColumns().get(3);
        GridColumn uiModelColumn2_2 = (GridColumn)this.uiModel.getColumns().get(4);
        GridColumn uiModelColumn3_2 = (GridColumn)this.uiModel.getColumns().get(5);
        GridColumn uiModelColumn4_2 = (GridColumn)this.uiModel.getColumns().get(6);
        GridColumn uiModelColumn5_2 = (GridColumn)this.uiModel.getColumns().get(7);
        GridColumn uiModelColumn6_2 = (GridColumn)this.uiModel.getColumns().get(8);
        Assert.assertEquals((Object)"$a : Applicant", (Object)((GridColumn.HeaderMetaData)uiModelColumn1_2.getHeaderMetaData().get(0)).getTitle());
        Assert.assertEquals((Object)"$a : Applicant", (Object)((GridColumn.HeaderMetaData)uiModelColumn2_2.getHeaderMetaData().get(0)).getTitle());
        Assert.assertEquals((Object)"$d2 : Address", (Object)((GridColumn.HeaderMetaData)uiModelColumn3_2.getHeaderMetaData().get(0)).getTitle());
        Assert.assertEquals((Object)"$d2 : Address", (Object)((GridColumn.HeaderMetaData)uiModelColumn4_2.getHeaderMetaData().get(0)).getTitle());
        Assert.assertEquals((Object)"$d : Address", (Object)((GridColumn.HeaderMetaData)uiModelColumn5_2.getHeaderMetaData().get(0)).getTitle());
        Assert.assertEquals((Object)"$d : Address", (Object)((GridColumn.HeaderMetaData)uiModelColumn6_2.getHeaderMetaData().get(0)).getTitle());
        Assert.assertTrue((boolean)(uiModelColumn1_2 instanceof IntegerUiColumn));
        Assert.assertTrue((boolean)(uiModelColumn2_2 instanceof StringUiColumn));
        Assert.assertTrue((boolean)(uiModelColumn3_2 instanceof StringUiColumn));
        Assert.assertTrue((boolean)(uiModelColumn4_2 instanceof StringUiColumn));
        Assert.assertTrue((boolean)(uiModelColumn5_2 instanceof StringUiColumn));
        Assert.assertTrue((boolean)(uiModelColumn6_2 instanceof StringUiColumn));
        Assert.assertEquals((long)3L, (long)uiModelColumn1_2.getIndex());
        Assert.assertEquals((long)4L, (long)uiModelColumn2_2.getIndex());
        Assert.assertEquals((long)7L, (long)uiModelColumn3_2.getIndex());
        Assert.assertEquals((long)8L, (long)uiModelColumn4_2.getIndex());
        Assert.assertEquals((long)5L, (long)uiModelColumn5_2.getIndex());
        Assert.assertEquals((long)6L, (long)uiModelColumn6_2.getIndex());
        Assert.assertEquals((Object)45, (Object)((GridCell)this.uiModel.getRow(0).getCells().get(uiModelColumn1_2.getIndex())).getValue().getValue());
        Assert.assertEquals((Object)"Smurf", (Object)((GridCell)this.uiModel.getRow(0).getCells().get(uiModelColumn2_2.getIndex())).getValue().getValue());
        Assert.assertEquals((Object)"Essex", (Object)((GridCell)this.uiModel.getRow(0).getCells().get(uiModelColumn3_2.getIndex())).getValue().getValue());
        Assert.assertEquals((Object)"England", (Object)((GridCell)this.uiModel.getRow(0).getCells().get(uiModelColumn4_2.getIndex())).getValue().getValue());
        Assert.assertEquals((Object)"NY", (Object)((GridCell)this.uiModel.getRow(0).getCells().get(uiModelColumn5_2.getIndex())).getValue().getValue());
        Assert.assertEquals((Object)"America", (Object)((GridCell)this.uiModel.getRow(0).getCells().get(uiModelColumn6_2.getIndex())).getValue().getValue());
    }

    @Test
    public void testMoveColumnsTo_MoveRight() throws ModelSynchronizer.VetoException {
        Pattern52 pattern1 = this.boundApplicantPattern("$a");
        ConditionCol52 column1p1 = this.ageEqualsCondition();
        ConditionCol52 column2p1 = this.nameEqualsCondition();
        this.modelSynchronizer.appendColumn(pattern1, column1p1);
        this.modelSynchronizer.appendColumn(pattern1, column2p1);
        Pattern52 pattern2 = this.boundAddressPattern("$d");
        ConditionCol52 column1p2 = new ConditionCol52();
        column1p2.setConstraintValueType(1);
        column1p2.setFactField("state");
        column1p2.setOperator("==");
        column1p2.setHeader("state");
        ConditionCol52 column2p2 = new ConditionCol52();
        column2p2.setConstraintValueType(1);
        column2p2.setFactField("country");
        column2p2.setOperator("==");
        column2p2.setHeader("country");
        this.modelSynchronizer.appendColumn(pattern2, column1p2);
        this.modelSynchronizer.appendColumn(pattern2, column2p2);
        this.modelSynchronizer.appendRow();
        this.uiModel.setCellValue(0, 3, (GridCellValue)new BaseGridCellValue((Object)45));
        this.uiModel.setCellValue(0, 4, (GridCellValue)new BaseGridCellValue((Object)"Smurf"));
        this.uiModel.setCellValue(0, 5, (GridCellValue)new BaseGridCellValue((Object)"NY"));
        this.uiModel.setCellValue(0, 6, (GridCellValue)new BaseGridCellValue((Object)"America"));
        Assert.assertEquals((long)2L, (long)this.model.getPatterns().size());
        List conditionColumns1_1p1 = ((Pattern52)this.model.getPatterns().get(0)).getChildColumns();
        Assert.assertEquals((Object)column1p1, conditionColumns1_1p1.get(0));
        Assert.assertEquals((Object)column2p1, conditionColumns1_1p1.get(1));
        Assert.assertEquals((Object)45, (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(3)).getNumericValue());
        Assert.assertEquals((Object)"Smurf", (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(4)).getStringValue());
        List conditionColumns1_1p2 = ((Pattern52)this.model.getPatterns().get(1)).getChildColumns();
        Assert.assertEquals((Object)column1p2, conditionColumns1_1p2.get(0));
        Assert.assertEquals((Object)column2p2, conditionColumns1_1p2.get(1));
        Assert.assertEquals((Object)"NY", (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(5)).getStringValue());
        Assert.assertEquals((Object)"America", (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(6)).getStringValue());
        Assert.assertEquals((long)7L, (long)this.uiModel.getColumns().size());
        final GridColumn uiModelColumn1_1 = (GridColumn)this.uiModel.getColumns().get(3);
        final GridColumn uiModelColumn2_1 = (GridColumn)this.uiModel.getColumns().get(4);
        GridColumn uiModelColumn3_1 = (GridColumn)this.uiModel.getColumns().get(5);
        GridColumn uiModelColumn4_1 = (GridColumn)this.uiModel.getColumns().get(6);
        Assert.assertEquals((Object)"$a : Applicant", (Object)((GridColumn.HeaderMetaData)uiModelColumn1_1.getHeaderMetaData().get(0)).getTitle());
        Assert.assertEquals((Object)"$a : Applicant", (Object)((GridColumn.HeaderMetaData)uiModelColumn2_1.getHeaderMetaData().get(0)).getTitle());
        Assert.assertEquals((Object)"$d : Address", (Object)((GridColumn.HeaderMetaData)uiModelColumn3_1.getHeaderMetaData().get(0)).getTitle());
        Assert.assertEquals((Object)"$d : Address", (Object)((GridColumn.HeaderMetaData)uiModelColumn4_1.getHeaderMetaData().get(0)).getTitle());
        Assert.assertTrue((boolean)(uiModelColumn1_1 instanceof IntegerUiColumn));
        Assert.assertTrue((boolean)(uiModelColumn2_1 instanceof StringUiColumn));
        Assert.assertTrue((boolean)(uiModelColumn3_1 instanceof StringUiColumn));
        Assert.assertTrue((boolean)(uiModelColumn4_1 instanceof StringUiColumn));
        Assert.assertEquals((long)3L, (long)uiModelColumn1_1.getIndex());
        Assert.assertEquals((long)4L, (long)uiModelColumn2_1.getIndex());
        Assert.assertEquals((long)5L, (long)uiModelColumn3_1.getIndex());
        Assert.assertEquals((long)6L, (long)uiModelColumn4_1.getIndex());
        Assert.assertEquals((Object)45, (Object)((GridCell)this.uiModel.getRow(0).getCells().get(uiModelColumn1_1.getIndex())).getValue().getValue());
        Assert.assertEquals((Object)"Smurf", (Object)((GridCell)this.uiModel.getRow(0).getCells().get(uiModelColumn2_1.getIndex())).getValue().getValue());
        Assert.assertEquals((Object)"NY", (Object)((GridCell)this.uiModel.getRow(0).getCells().get(uiModelColumn3_1.getIndex())).getValue().getValue());
        Assert.assertEquals((Object)"America", (Object)((GridCell)this.uiModel.getRow(0).getCells().get(uiModelColumn4_1.getIndex())).getValue().getValue());
        this.uiModel.moveColumnsTo(6, (List)new ArrayList<GridColumn<?>>(){
            {
                this.add(uiModelColumn1_1);
                this.add(uiModelColumn2_1);
            }
        });
        Assert.assertEquals((long)2L, (long)this.model.getPatterns().size());
        List conditionColumns1_2p2 = ((Pattern52)this.model.getPatterns().get(0)).getChildColumns();
        Assert.assertEquals((Object)column1p2, conditionColumns1_2p2.get(0));
        Assert.assertEquals((Object)column2p2, conditionColumns1_2p2.get(1));
        Assert.assertEquals((Object)"NY", (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(3)).getStringValue());
        Assert.assertEquals((Object)"America", (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(4)).getStringValue());
        List conditionColumns1_2p1 = ((Pattern52)this.model.getPatterns().get(1)).getChildColumns();
        Assert.assertEquals((Object)column1p1, conditionColumns1_2p1.get(0));
        Assert.assertEquals((Object)column2p1, conditionColumns1_2p1.get(1));
        Assert.assertEquals((Object)45, (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(5)).getNumericValue());
        Assert.assertEquals((Object)"Smurf", (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(6)).getStringValue());
        Assert.assertEquals((long)7L, (long)this.uiModel.getColumns().size());
        GridColumn uiModelColumn1_2 = (GridColumn)this.uiModel.getColumns().get(3);
        GridColumn uiModelColumn2_2 = (GridColumn)this.uiModel.getColumns().get(4);
        GridColumn uiModelColumn3_2 = (GridColumn)this.uiModel.getColumns().get(5);
        GridColumn uiModelColumn4_2 = (GridColumn)this.uiModel.getColumns().get(6);
        Assert.assertEquals((Object)"$d : Address", (Object)((GridColumn.HeaderMetaData)uiModelColumn1_2.getHeaderMetaData().get(0)).getTitle());
        Assert.assertEquals((Object)"$d : Address", (Object)((GridColumn.HeaderMetaData)uiModelColumn2_2.getHeaderMetaData().get(0)).getTitle());
        Assert.assertEquals((Object)"$a : Applicant", (Object)((GridColumn.HeaderMetaData)uiModelColumn3_2.getHeaderMetaData().get(0)).getTitle());
        Assert.assertEquals((Object)"$a : Applicant", (Object)((GridColumn.HeaderMetaData)uiModelColumn4_2.getHeaderMetaData().get(0)).getTitle());
        Assert.assertTrue((boolean)(uiModelColumn1_2 instanceof StringUiColumn));
        Assert.assertTrue((boolean)(uiModelColumn2_2 instanceof StringUiColumn));
        Assert.assertTrue((boolean)(uiModelColumn3_2 instanceof IntegerUiColumn));
        Assert.assertTrue((boolean)(uiModelColumn4_2 instanceof StringUiColumn));
        Assert.assertEquals((long)5L, (long)uiModelColumn1_2.getIndex());
        Assert.assertEquals((long)6L, (long)uiModelColumn2_2.getIndex());
        Assert.assertEquals((long)3L, (long)uiModelColumn3_2.getIndex());
        Assert.assertEquals((long)4L, (long)uiModelColumn4_2.getIndex());
        Assert.assertEquals((Object)"NY", (Object)((GridCell)this.uiModel.getRow(0).getCells().get(uiModelColumn1_2.getIndex())).getValue().getValue());
        Assert.assertEquals((Object)"America", (Object)((GridCell)this.uiModel.getRow(0).getCells().get(uiModelColumn2_2.getIndex())).getValue().getValue());
        Assert.assertEquals((Object)45, (Object)((GridCell)this.uiModel.getRow(0).getCells().get(uiModelColumn3_2.getIndex())).getValue().getValue());
        Assert.assertEquals((Object)"Smurf", (Object)((GridCell)this.uiModel.getRow(0).getCells().get(uiModelColumn4_2.getIndex())).getValue().getValue());
    }

    @Test
    public void testMoveColumnsTo_MoveRight_MidPoint() throws ModelSynchronizer.VetoException {
        Pattern52 pattern1 = this.boundApplicantPattern("$a");
        ConditionCol52 column1p1 = this.ageEqualsCondition();
        ConditionCol52 column2p1 = this.nameEqualsCondition();
        this.modelSynchronizer.appendColumn(pattern1, column1p1);
        this.modelSynchronizer.appendColumn(pattern1, column2p1);
        Pattern52 pattern2 = this.boundAddressPattern("$d");
        ConditionCol52 column1p2 = new ConditionCol52();
        column1p2.setConstraintValueType(1);
        column1p2.setFactField("state");
        column1p2.setOperator("==");
        column1p2.setHeader("state");
        ConditionCol52 column2p2 = new ConditionCol52();
        column2p2.setConstraintValueType(1);
        column2p2.setFactField("country");
        column2p2.setOperator("==");
        column2p2.setHeader("country");
        this.modelSynchronizer.appendColumn(pattern2, column1p2);
        this.modelSynchronizer.appendColumn(pattern2, column2p2);
        Pattern52 pattern3 = this.boundAddressPattern("$d2");
        ConditionCol52 column1p3 = new ConditionCol52();
        column1p3.setConstraintValueType(1);
        column1p3.setFactField("state");
        column1p3.setOperator("==");
        column1p3.setHeader("state");
        ConditionCol52 column2p3 = new ConditionCol52();
        column2p3.setConstraintValueType(1);
        column2p3.setFactField("country");
        column2p3.setOperator("==");
        column2p3.setHeader("country");
        this.modelSynchronizer.appendColumn(pattern3, column1p3);
        this.modelSynchronizer.appendColumn(pattern3, column2p3);
        this.modelSynchronizer.appendRow();
        this.uiModel.setCellValue(0, 3, (GridCellValue)new BaseGridCellValue((Object)45));
        this.uiModel.setCellValue(0, 4, (GridCellValue)new BaseGridCellValue((Object)"Smurf"));
        this.uiModel.setCellValue(0, 5, (GridCellValue)new BaseGridCellValue((Object)"NY"));
        this.uiModel.setCellValue(0, 6, (GridCellValue)new BaseGridCellValue((Object)"America"));
        this.uiModel.setCellValue(0, 7, (GridCellValue)new BaseGridCellValue((Object)"Essex"));
        this.uiModel.setCellValue(0, 8, (GridCellValue)new BaseGridCellValue((Object)"England"));
        Assert.assertEquals((long)3L, (long)this.model.getPatterns().size());
        List conditionColumns1_1p1 = ((Pattern52)this.model.getPatterns().get(0)).getChildColumns();
        Assert.assertEquals((Object)column1p1, conditionColumns1_1p1.get(0));
        Assert.assertEquals((Object)column2p1, conditionColumns1_1p1.get(1));
        Assert.assertEquals((Object)45, (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(3)).getNumericValue());
        Assert.assertEquals((Object)"Smurf", (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(4)).getStringValue());
        List conditionColumns1_1p2 = ((Pattern52)this.model.getPatterns().get(1)).getChildColumns();
        Assert.assertEquals((Object)column1p2, conditionColumns1_1p2.get(0));
        Assert.assertEquals((Object)column2p2, conditionColumns1_1p2.get(1));
        Assert.assertEquals((Object)"NY", (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(5)).getStringValue());
        Assert.assertEquals((Object)"America", (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(6)).getStringValue());
        List conditionColumns1_1p3 = ((Pattern52)this.model.getPatterns().get(2)).getChildColumns();
        Assert.assertEquals((Object)column1p3, conditionColumns1_1p3.get(0));
        Assert.assertEquals((Object)column2p3, conditionColumns1_1p3.get(1));
        Assert.assertEquals((Object)"Essex", (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(7)).getStringValue());
        Assert.assertEquals((Object)"England", (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(8)).getStringValue());
        Assert.assertEquals((long)9L, (long)this.uiModel.getColumns().size());
        final GridColumn uiModelColumn1_1 = (GridColumn)this.uiModel.getColumns().get(3);
        final GridColumn uiModelColumn2_1 = (GridColumn)this.uiModel.getColumns().get(4);
        GridColumn uiModelColumn3_1 = (GridColumn)this.uiModel.getColumns().get(5);
        GridColumn uiModelColumn4_1 = (GridColumn)this.uiModel.getColumns().get(6);
        GridColumn uiModelColumn5_1 = (GridColumn)this.uiModel.getColumns().get(7);
        GridColumn uiModelColumn6_1 = (GridColumn)this.uiModel.getColumns().get(8);
        Assert.assertEquals((Object)"$a : Applicant", (Object)((GridColumn.HeaderMetaData)uiModelColumn1_1.getHeaderMetaData().get(0)).getTitle());
        Assert.assertEquals((Object)"$a : Applicant", (Object)((GridColumn.HeaderMetaData)uiModelColumn2_1.getHeaderMetaData().get(0)).getTitle());
        Assert.assertEquals((Object)"$d : Address", (Object)((GridColumn.HeaderMetaData)uiModelColumn3_1.getHeaderMetaData().get(0)).getTitle());
        Assert.assertEquals((Object)"$d : Address", (Object)((GridColumn.HeaderMetaData)uiModelColumn4_1.getHeaderMetaData().get(0)).getTitle());
        Assert.assertEquals((Object)"$d2 : Address", (Object)((GridColumn.HeaderMetaData)uiModelColumn5_1.getHeaderMetaData().get(0)).getTitle());
        Assert.assertEquals((Object)"$d2 : Address", (Object)((GridColumn.HeaderMetaData)uiModelColumn6_1.getHeaderMetaData().get(0)).getTitle());
        Assert.assertTrue((boolean)(uiModelColumn1_1 instanceof IntegerUiColumn));
        Assert.assertTrue((boolean)(uiModelColumn2_1 instanceof StringUiColumn));
        Assert.assertTrue((boolean)(uiModelColumn3_1 instanceof StringUiColumn));
        Assert.assertTrue((boolean)(uiModelColumn4_1 instanceof StringUiColumn));
        Assert.assertTrue((boolean)(uiModelColumn5_1 instanceof StringUiColumn));
        Assert.assertTrue((boolean)(uiModelColumn6_1 instanceof StringUiColumn));
        Assert.assertEquals((long)3L, (long)uiModelColumn1_1.getIndex());
        Assert.assertEquals((long)4L, (long)uiModelColumn2_1.getIndex());
        Assert.assertEquals((long)5L, (long)uiModelColumn3_1.getIndex());
        Assert.assertEquals((long)6L, (long)uiModelColumn4_1.getIndex());
        Assert.assertEquals((long)7L, (long)uiModelColumn5_1.getIndex());
        Assert.assertEquals((long)8L, (long)uiModelColumn6_1.getIndex());
        Assert.assertEquals((Object)45, (Object)((GridCell)this.uiModel.getRow(0).getCells().get(uiModelColumn1_1.getIndex())).getValue().getValue());
        Assert.assertEquals((Object)"Smurf", (Object)((GridCell)this.uiModel.getRow(0).getCells().get(uiModelColumn2_1.getIndex())).getValue().getValue());
        Assert.assertEquals((Object)"NY", (Object)((GridCell)this.uiModel.getRow(0).getCells().get(uiModelColumn3_1.getIndex())).getValue().getValue());
        Assert.assertEquals((Object)"America", (Object)((GridCell)this.uiModel.getRow(0).getCells().get(uiModelColumn4_1.getIndex())).getValue().getValue());
        Assert.assertEquals((Object)"Essex", (Object)((GridCell)this.uiModel.getRow(0).getCells().get(uiModelColumn5_1.getIndex())).getValue().getValue());
        Assert.assertEquals((Object)"England", (Object)((GridCell)this.uiModel.getRow(0).getCells().get(uiModelColumn6_1.getIndex())).getValue().getValue());
        this.uiModel.moveColumnsTo(6, (List)new ArrayList<GridColumn<?>>(){
            {
                this.add(uiModelColumn1_1);
                this.add(uiModelColumn2_1);
            }
        });
        Assert.assertEquals((long)3L, (long)this.model.getPatterns().size());
        List conditionColumns1_2p2 = ((Pattern52)this.model.getPatterns().get(0)).getChildColumns();
        Assert.assertEquals((Object)column1p2, conditionColumns1_2p2.get(0));
        Assert.assertEquals((Object)column2p2, conditionColumns1_2p2.get(1));
        Assert.assertEquals((Object)"NY", (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(3)).getStringValue());
        Assert.assertEquals((Object)"America", (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(4)).getStringValue());
        List conditionColumns1_2p1 = ((Pattern52)this.model.getPatterns().get(1)).getChildColumns();
        Assert.assertEquals((Object)column1p1, conditionColumns1_2p1.get(0));
        Assert.assertEquals((Object)column2p1, conditionColumns1_2p1.get(1));
        Assert.assertEquals((Object)45, (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(5)).getNumericValue());
        Assert.assertEquals((Object)"Smurf", (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(6)).getStringValue());
        List conditionColumns1_2p3 = ((Pattern52)this.model.getPatterns().get(2)).getChildColumns();
        Assert.assertEquals((Object)column1p3, conditionColumns1_2p3.get(0));
        Assert.assertEquals((Object)column2p3, conditionColumns1_2p3.get(1));
        Assert.assertEquals((Object)"Essex", (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(7)).getStringValue());
        Assert.assertEquals((Object)"England", (Object)((DTCellValue52)((List)this.model.getData().get(0)).get(8)).getStringValue());
        Assert.assertEquals((long)9L, (long)this.uiModel.getColumns().size());
        GridColumn uiModelColumn1_2 = (GridColumn)this.uiModel.getColumns().get(3);
        GridColumn uiModelColumn2_2 = (GridColumn)this.uiModel.getColumns().get(4);
        GridColumn uiModelColumn3_2 = (GridColumn)this.uiModel.getColumns().get(5);
        GridColumn uiModelColumn4_2 = (GridColumn)this.uiModel.getColumns().get(6);
        GridColumn uiModelColumn5_2 = (GridColumn)this.uiModel.getColumns().get(7);
        GridColumn uiModelColumn6_2 = (GridColumn)this.uiModel.getColumns().get(8);
        Assert.assertEquals((Object)"$d : Address", (Object)((GridColumn.HeaderMetaData)uiModelColumn1_2.getHeaderMetaData().get(0)).getTitle());
        Assert.assertEquals((Object)"$d : Address", (Object)((GridColumn.HeaderMetaData)uiModelColumn2_2.getHeaderMetaData().get(0)).getTitle());
        Assert.assertEquals((Object)"$a : Applicant", (Object)((GridColumn.HeaderMetaData)uiModelColumn3_2.getHeaderMetaData().get(0)).getTitle());
        Assert.assertEquals((Object)"$a : Applicant", (Object)((GridColumn.HeaderMetaData)uiModelColumn4_2.getHeaderMetaData().get(0)).getTitle());
        Assert.assertEquals((Object)"$d2 : Address", (Object)((GridColumn.HeaderMetaData)uiModelColumn5_2.getHeaderMetaData().get(0)).getTitle());
        Assert.assertEquals((Object)"$d2 : Address", (Object)((GridColumn.HeaderMetaData)uiModelColumn6_2.getHeaderMetaData().get(0)).getTitle());
        Assert.assertTrue((boolean)(uiModelColumn1_2 instanceof StringUiColumn));
        Assert.assertTrue((boolean)(uiModelColumn2_2 instanceof StringUiColumn));
        Assert.assertTrue((boolean)(uiModelColumn3_2 instanceof IntegerUiColumn));
        Assert.assertTrue((boolean)(uiModelColumn4_2 instanceof StringUiColumn));
        Assert.assertTrue((boolean)(uiModelColumn5_2 instanceof StringUiColumn));
        Assert.assertTrue((boolean)(uiModelColumn6_2 instanceof StringUiColumn));
        Assert.assertEquals((long)5L, (long)uiModelColumn1_2.getIndex());
        Assert.assertEquals((long)6L, (long)uiModelColumn2_2.getIndex());
        Assert.assertEquals((long)3L, (long)uiModelColumn3_2.getIndex());
        Assert.assertEquals((long)4L, (long)uiModelColumn4_2.getIndex());
        Assert.assertEquals((long)7L, (long)uiModelColumn5_2.getIndex());
        Assert.assertEquals((long)8L, (long)uiModelColumn6_2.getIndex());
        Assert.assertEquals((Object)"NY", (Object)((GridCell)this.uiModel.getRow(0).getCells().get(uiModelColumn1_2.getIndex())).getValue().getValue());
        Assert.assertEquals((Object)"America", (Object)((GridCell)this.uiModel.getRow(0).getCells().get(uiModelColumn2_2.getIndex())).getValue().getValue());
        Assert.assertEquals((Object)45, (Object)((GridCell)this.uiModel.getRow(0).getCells().get(uiModelColumn3_2.getIndex())).getValue().getValue());
        Assert.assertEquals((Object)"Smurf", (Object)((GridCell)this.uiModel.getRow(0).getCells().get(uiModelColumn4_2.getIndex())).getValue().getValue());
        Assert.assertEquals((Object)"Essex", (Object)((GridCell)this.uiModel.getRow(0).getCells().get(uiModelColumn5_2.getIndex())).getValue().getValue());
        Assert.assertEquals((Object)"England", (Object)((GridCell)this.uiModel.getRow(0).getCells().get(uiModelColumn6_2.getIndex())).getValue().getValue());
    }
}

