/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.table.themes;

import com.ait.lienzo.client.core.shape.Group;
import com.ait.lienzo.client.core.shape.IPrimitive;
import com.ait.lienzo.test.LienzoMockitoTestRunner;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.drools.verifier.api.reporting.Severity;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.screens.guided.dtable.client.widget.table.model.GuidedDecisionTableUiModel;
import org.drools.workbench.screens.guided.dtable.client.widget.table.model.synchronizers.ModelSynchronizer;
import org.drools.workbench.screens.guided.dtable.client.widget.table.themes.GuidedDecisionTableRenderer;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.model.GridRow;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridRow;
import org.uberfire.ext.wires.core.grids.client.widget.context.GridBodyRenderContext;
import org.uberfire.ext.wires.core.grids.client.widget.grid.columns.RowNumberColumn;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.grids.GridRenderer;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.grids.impl.BaseGridRendererHelper;

@RunWith(value=LienzoMockitoTestRunner.class)
public class GuidedDecisionTableRendererTest {
    @Mock
    private ModelSynchronizer synchronizer;
    @Mock
    private GridBodyRenderContext context;
    @Mock
    private BaseGridRendererHelper rendererHelper;
    @Mock
    private BaseGridRendererHelper.RenderingInformation renderingInformation;
    @Mock
    private BaseGridRendererHelper.RenderingBlockInformation bodyBlockInformation;
    @Mock
    private BaseGridRendererHelper.RenderingBlockInformation floatingBlockInformation;
    @Mock
    private Group parent;
    private GuidedDecisionTableUiModel uiModel;
    private GridColumn<?> uiColumn;
    private GuidedDecisionTableRenderer renderer;

    @Before
    public void setup() {
        this.uiModel = new GuidedDecisionTableUiModel(this.synchronizer);
        this.uiColumn = new RowNumberColumn();
        this.uiModel.appendColumn(this.uiColumn);
        this.uiModel.appendRow((GridRow)new BaseGridRow());
        this.renderer = (GuidedDecisionTableRenderer)Mockito.spy((Object)new GuidedDecisionTableRenderer(this.uiModel, new GuidedDecisionTable52()));
        Mockito.when((Object)this.renderingInformation.getVisibleRowOffsets()).thenReturn(Collections.singletonList(20.0));
        Mockito.when((Object)this.renderingInformation.getAllRowHeights()).thenReturn(Collections.singletonList(20.0));
        Mockito.when((Object)this.context.getBlockColumns()).thenReturn(Collections.singletonList(this.uiColumn));
        Mockito.when((Object)this.renderingInformation.getBodyBlockInformation()).thenReturn((Object)this.bodyBlockInformation);
        Mockito.when((Object)this.bodyBlockInformation.getColumns()).thenReturn(Collections.singletonList(this.uiColumn));
        Mockito.when((Object)this.renderingInformation.getFloatingBlockInformation()).thenReturn((Object)this.floatingBlockInformation);
        Mockito.when((Object)this.floatingBlockInformation.getColumns()).thenReturn(Collections.emptyList());
        Mockito.when((Object)this.context.getRenderer()).thenReturn((Object)this.renderer);
    }

    @Test
    public void testRenderBodyWithRowHighlights() {
        this.renderer.highlightRows(Severity.ERROR, Collections.singleton(1));
        List commands = this.renderer.renderBody((GridData)this.uiModel, this.context, this.rendererHelper, this.renderingInformation);
        this.assertRenderingCommands(commands, GridRenderer.RenderBodyGridBackgroundCommand.class, GridRenderer.RenderBodyGridLinesCommand.class, GridRenderer.RenderBodyGridContentCommand.class, GridRenderer.RenderSelectedCellsCommand.class);
    }

    @Test
    public void testRenderBodyWithNoRowHighlights() {
        this.renderer.clearHighlights();
        List commands = this.renderer.renderBody((GridData)this.uiModel, this.context, this.rendererHelper, this.renderingInformation);
        this.assertRenderingCommands(commands, GridRenderer.RenderBodyGridBackgroundCommand.class, GridRenderer.RenderBodyGridLinesCommand.class, GridRenderer.RenderBodyGridContentCommand.class);
    }

    @Test
    public void testRenderSelector() {
        GridRenderer.RendererCommand command = this.renderer.renderSelector(10.0, 20.0, this.renderingInformation);
        this.assertRenderingCommands(Collections.singletonList(command), GridRenderer.RenderSelectorCommand.class);
    }

    @Test
    public void testRenderSelectorIsSelectionLayer() {
        GridRenderer.RendererCommand command = this.renderer.renderSelector(10.0, 20.0, this.renderingInformation);
        command.execute(this.makeGridRendererContext(true));
        ((Group)Mockito.verify((Object)this.parent, (VerificationMode)Mockito.never())).add((IPrimitive)Matchers.any(Group.class));
    }

    @Test
    public void testRenderSelectorIsNotSelectionLayer() {
        GridRenderer.RendererCommand command = this.renderer.renderSelector(10.0, 20.0, this.renderingInformation);
        command.execute(this.makeGridRendererContext(false));
        ((Group)Mockito.verify((Object)this.parent)).add((IPrimitive)Matchers.any(Group.class));
    }

    private GridRenderer.GridRendererContext makeGridRendererContext(final boolean isSelectionLayer) {
        return new GridRenderer.GridRendererContext(){

            public Group getGroup() {
                return GuidedDecisionTableRendererTest.this.parent;
            }

            public boolean isSelectionLayer() {
                return isSelectionLayer;
            }
        };
    }

    @Test
    public void testRenderHeaderBodyDivider() {
        GridRenderer.RendererCommand command = this.renderer.renderHeaderBodyDivider(10.0);
        this.assertRenderingCommands(Collections.singletonList(command), GridRenderer.RenderHeaderGridLinesCommand.class);
    }

    @SafeVarargs
    private final void assertRenderingCommands(List<GridRenderer.RendererCommand> actualCommands, Class<? extends GridRenderer.RendererCommand> ... expectedTypes) {
        Assertions.assertThat(actualCommands).hasOnlyElementsOfTypes((Class[])expectedTypes);
        Arrays.asList(expectedTypes).forEach(type -> {
            ListAssert cfr_ignored_0 = (ListAssert)((ListAssert)Assertions.assertThat((List)actualCommands).filteredOn(type::isInstance)).hasSize(1);
        });
    }
}

