/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.table.utilities;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import org.drools.workbench.models.guided.dtable.shared.model.DTCellValue52;
import org.drools.workbench.screens.guided.dtable.client.widget.table.utilities.CellUtilities;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.soup.project.datamodel.oracle.DataType;

@RunWith(value=Parameterized.class)
public class CellUtilitiesConvertToShortTest {
    private Object expected;
    private Object value;
    private boolean isOtherwise;
    private CellUtilities cellUtilities;

    public CellUtilitiesConvertToShortTest(Object expected, Object value, boolean isOtherwise) {
        this.expected = expected;
        this.value = value;
        this.isOtherwise = isOtherwise;
    }

    @Before
    public void setup() {
        this.cellUtilities = new CellUtilities();
    }

    @Parameterized.Parameters
    public static Collection testParameters() {
        return Arrays.asList({new Short("1"), new BigDecimal("1"), false}, {new Short("2"), new BigInteger("2"), false}, {new Short("3"), new Byte("3"), false}, {null, new Double("4.0"), false}, {null, new Float("5.0"), false}, {new Short("6"), new Integer("6"), false}, {new Short("7"), new Long("7"), false}, {new Short("8"), new Short("8"), false}, {new Short("9"), "9", false}, {null, true, false}, {null, new Date(), false}, {null, "banana", false}, {null, null, true});
    }

    @Test
    public void conversion() {
        DTCellValue52 dcv = new DTCellValue52(this.value);
        dcv.setOtherwise(this.isOtherwise);
        Assert.assertEquals((Object)this.expected, (Object)this.cellUtilities.convertToShort(dcv));
    }

    @Test
    public void conversionToDataType() {
        DTCellValue52 dcv = new DTCellValue52(this.value);
        dcv.setOtherwise(this.isOtherwise);
        this.cellUtilities.convertDTCellValueType(DataType.DataTypes.NUMERIC_SHORT, dcv);
        Assert.assertEquals((Object)this.expected, (Object)dcv.getNumericValue());
    }
}

