/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.wizard;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.lang.annotation.Annotation;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.screens.guided.dtable.client.type.GuidedDTableResourceType;
import org.drools.workbench.screens.guided.dtable.client.wizard.NewGuidedDecisionTableWizardHelper;
import org.drools.workbench.screens.guided.dtable.client.wizard.table.NewGuidedDecisionTableWizard;
import org.drools.workbench.screens.guided.dtable.service.GuidedDecisionTableEditorService;
import org.guvnor.common.services.project.categories.Decision;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jboss.errai.ioc.client.container.SyncBeanDef;
import org.jboss.errai.ioc.client.container.SyncBeanManager;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.kie.workbench.common.services.datamodel.model.PackageDataModelOracleBaselinePayload;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracle;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracleFactory;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.backend.vfs.Path;
import org.uberfire.backend.vfs.PathFactory;
import org.uberfire.ext.widgets.common.client.common.HasBusyIndicator;
import org.uberfire.mocks.CallerMock;

@RunWith(value=GwtMockitoTestRunner.class)
public class NewGuidedDecisionTableWizardHelperTest {
    @Rule
    public ExpectedException rule = ExpectedException.none();
    @Mock
    private GuidedDecisionTableEditorService dtService;
    private Caller<GuidedDecisionTableEditorService> dtServiceCaller;
    @Mock
    private AsyncPackageDataModelOracleFactory oracleFactory;
    @Mock
    private PackageDataModelOracleBaselinePayload oracleBasePayload;
    @Mock
    private AsyncPackageDataModelOracle oracle;
    @Mock
    private SyncBeanManager beanManager;
    @Mock
    private SyncBeanDef<NewGuidedDecisionTableWizard> wizardBeanDef;
    @Mock
    private NewGuidedDecisionTableWizard wizardBean;
    @Mock
    private Path contextPath;
    private String baseFileName = "baseFileName";
    private GuidedDecisionTable52.TableFormat tableFormat = GuidedDecisionTable52.TableFormat.EXTENDED_ENTRY;
    private GuidedDecisionTable52.HitPolicy hitPolicy = GuidedDecisionTable52.HitPolicy.NONE;
    @Mock
    private HasBusyIndicator view;
    @Mock
    private RemoteCallback<Path> onSaveSuccessCallback;
    @Captor
    private ArgumentCaptor<NewGuidedDecisionTableWizard.GuidedDecisionTableWizardHandler> wizardHandlerCaptor;
    @Captor
    private ArgumentCaptor<String> fileNameCaptor;
    private GuidedDecisionTable52 model;
    private NewGuidedDecisionTableWizardHelper helper;
    private GuidedDTableResourceType dtResourceType = new GuidedDTableResourceType(new Decision());

    @Before
    public void setup() {
        this.dtServiceCaller = new CallerMock((Object)this.dtService);
        this.model = new GuidedDecisionTable52();
        this.model.setTableFormat(this.tableFormat);
        this.model.setHitPolicy(this.hitPolicy);
        this.helper = new NewGuidedDecisionTableWizardHelper(this.dtServiceCaller, this.oracleFactory, this.beanManager);
        Mockito.when((Object)this.beanManager.lookupBean((Class)Matchers.eq(NewGuidedDecisionTableWizard.class), new Annotation[0])).thenReturn(this.wizardBeanDef);
        Mockito.when((Object)this.wizardBeanDef.getInstance()).thenReturn((Object)this.wizardBean);
        Mockito.when((Object)this.dtService.loadDataModel((Path)Matchers.eq((Object)this.contextPath))).thenReturn((Object)this.oracleBasePayload);
        Mockito.when((Object)this.dtService.create((Path)Matchers.any(Path.class), (String)Matchers.any(String.class), Matchers.any(GuidedDecisionTable52.class), (String)Matchers.any(String.class))).thenAnswer(invocation -> {
            Path path = (Path)invocation.getArguments()[0];
            String fileName = (String)invocation.getArguments()[1];
            Path newPath = PathFactory.newPath((String)fileName, (String)(path.toURI() + "/" + fileName));
            return newPath;
        });
        Mockito.when((Object)this.oracleFactory.makeAsyncPackageDataModelOracle(this.contextPath, this.oracleBasePayload)).thenReturn((Object)this.oracle);
    }

    @Test
    public void checkNullContextPath() {
        this.rule.expect(IllegalArgumentException.class);
        this.helper.createNewGuidedDecisionTable(null, this.baseFileName, this.tableFormat, this.hitPolicy, this.view, this.onSaveSuccessCallback);
    }

    @Test
    public void checkNullBaseFilename() {
        this.rule.expect(IllegalArgumentException.class);
        this.helper.createNewGuidedDecisionTable(this.contextPath, null, this.tableFormat, this.hitPolicy, this.view, this.onSaveSuccessCallback);
    }

    @Test
    public void checkNullTableFormat() {
        this.rule.expect(IllegalArgumentException.class);
        this.helper.createNewGuidedDecisionTable(this.contextPath, this.baseFileName, null, this.hitPolicy, this.view, this.onSaveSuccessCallback);
    }

    @Test
    public void checkNullHitPolicy() {
        this.rule.expect(IllegalArgumentException.class);
        this.helper.createNewGuidedDecisionTable(this.contextPath, this.baseFileName, this.tableFormat, null, this.view, this.onSaveSuccessCallback);
    }

    @Test
    public void checkNullHasBusyIndicator() {
        this.rule.expect(IllegalArgumentException.class);
        this.helper.createNewGuidedDecisionTable(this.contextPath, this.baseFileName, this.tableFormat, this.hitPolicy, null, this.onSaveSuccessCallback);
    }

    @Test
    public void checkNullSaveSuccessCallback() {
        this.rule.expect(IllegalArgumentException.class);
        this.helper.createNewGuidedDecisionTable(this.contextPath, this.baseFileName, this.tableFormat, this.hitPolicy, this.view, null);
    }

    @Test
    public void checkWizardContentIsSet() {
        this.helper.createNewGuidedDecisionTable(this.contextPath, this.baseFileName, this.tableFormat, this.hitPolicy, this.view, this.onSaveSuccessCallback);
        ((NewGuidedDecisionTableWizard)Mockito.verify((Object)this.wizardBean, (VerificationMode)Mockito.times((int)1))).setContent((Path)Matchers.eq((Object)this.contextPath), (String)Matchers.eq((Object)this.baseFileName), (GuidedDecisionTable52.TableFormat)Matchers.eq((Object)this.tableFormat), (GuidedDecisionTable52.HitPolicy)Matchers.eq((Object)this.hitPolicy), (AsyncPackageDataModelOracle)Matchers.eq((Object)this.oracle), (NewGuidedDecisionTableWizard.GuidedDecisionTableWizardHandler)Matchers.any(NewGuidedDecisionTableWizard.GuidedDecisionTableWizardHandler.class));
    }

    @Test
    public void checkWizardHandlerSave() {
        this.helper.createNewGuidedDecisionTable(this.contextPath, this.baseFileName, this.tableFormat, this.hitPolicy, this.view, this.onSaveSuccessCallback);
        ((NewGuidedDecisionTableWizard)Mockito.verify((Object)this.wizardBean, (VerificationMode)Mockito.times((int)1))).setContent((Path)Matchers.eq((Object)this.contextPath), (String)Matchers.eq((Object)this.baseFileName), (GuidedDecisionTable52.TableFormat)Matchers.eq((Object)this.tableFormat), (GuidedDecisionTable52.HitPolicy)Matchers.eq((Object)this.hitPolicy), (AsyncPackageDataModelOracle)Matchers.eq((Object)this.oracle), (NewGuidedDecisionTableWizard.GuidedDecisionTableWizardHandler)this.wizardHandlerCaptor.capture());
        NewGuidedDecisionTableWizard.GuidedDecisionTableWizardHandler wizardHandler = (NewGuidedDecisionTableWizard.GuidedDecisionTableWizardHandler)this.wizardHandlerCaptor.getValue();
        Assert.assertNotNull((Object)wizardHandler);
        wizardHandler.save(this.contextPath, this.baseFileName, this.model);
        ((SyncBeanManager)Mockito.verify((Object)this.beanManager, (VerificationMode)Mockito.times((int)1))).destroyBean((Object)this.wizardBean);
        ((AsyncPackageDataModelOracleFactory)Mockito.verify((Object)this.oracleFactory, (VerificationMode)Mockito.times((int)1))).destroy(this.oracle);
        ((HasBusyIndicator)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).showBusyIndicator((String)Matchers.any(String.class));
        ((GuidedDecisionTableEditorService)Mockito.verify((Object)this.dtService, (VerificationMode)Mockito.times((int)1))).create((Path)Matchers.eq((Object)this.contextPath), (String)this.fileNameCaptor.capture(), Matchers.eq((Object)this.model), (String)Matchers.eq((Object)""));
        ((RemoteCallback)Mockito.verify(this.onSaveSuccessCallback, (VerificationMode)Mockito.times((int)1))).callback(Matchers.any(Path.class));
        ((HasBusyIndicator)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).hideBusyIndicator();
        String fileName = (String)this.fileNameCaptor.getValue();
        Assert.assertNotNull((Object)fileName);
        Assert.assertEquals((Object)(this.baseFileName + "." + this.dtResourceType.getSuffix()), (Object)fileName);
    }

    @Test
    public void checkWizardHandlerDestroyWizard() {
        this.helper.createNewGuidedDecisionTable(this.contextPath, this.baseFileName, this.tableFormat, this.hitPolicy, this.view, this.onSaveSuccessCallback);
        ((NewGuidedDecisionTableWizard)Mockito.verify((Object)this.wizardBean, (VerificationMode)Mockito.times((int)1))).setContent((Path)Matchers.eq((Object)this.contextPath), (String)Matchers.eq((Object)this.baseFileName), (GuidedDecisionTable52.TableFormat)Matchers.eq((Object)this.tableFormat), (GuidedDecisionTable52.HitPolicy)Matchers.eq((Object)this.hitPolicy), (AsyncPackageDataModelOracle)Matchers.eq((Object)this.oracle), (NewGuidedDecisionTableWizard.GuidedDecisionTableWizardHandler)this.wizardHandlerCaptor.capture());
        NewGuidedDecisionTableWizard.GuidedDecisionTableWizardHandler wizardHandler = (NewGuidedDecisionTableWizard.GuidedDecisionTableWizardHandler)this.wizardHandlerCaptor.getValue();
        Assert.assertNotNull((Object)wizardHandler);
        wizardHandler.destroyWizard();
        ((SyncBeanManager)Mockito.verify((Object)this.beanManager, (VerificationMode)Mockito.times((int)1))).destroyBean((Object)this.wizardBean);
    }
}

