/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.wizard.column.pages;

import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.junit.GWTMockUtilities;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwtmockito.GwtMockito;
import com.google.gwtmockito.GwtMockitoTestRunner;
import com.google.gwtmockito.fakes.FakeProvider;
import java.util.Arrays;
import java.util.List;
import org.drools.workbench.models.datamodel.rule.HasParameterizedOperator;
import org.drools.workbench.models.guided.dtable.shared.model.ConditionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.Pattern52;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableView;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.OperatorPage;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.plugins.ConditionColumnPlugin;
import org.drools.workbench.screens.guided.rule.client.editor.CEPOperatorsDropdown;
import org.drools.workbench.screens.guided.rule.client.resources.GuidedRuleEditorResources;
import org.drools.workbench.screens.guided.rule.client.resources.css.GuidedRuleEditorCss;
import org.drools.workbench.screens.guided.rule.client.resources.images.GuidedRuleEditorImages;
import org.gwtbootstrap3.client.ui.ListBox;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.soup.project.datamodel.oracle.OperatorsOracle;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracle;
import org.kie.workbench.common.widgets.client.resources.ItemImages;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.uberfire.client.callbacks.Callback;
import org.uberfire.ext.widgets.core.client.wizards.WizardPageStatusChangeEvent;
import org.uberfire.mocks.EventSourceMock;

@RunWith(value=GwtMockitoTestRunner.class)
public class OperatorPageTest {
    @Captor
    ArgumentCaptor<Callback<String[]>> callbackArgumentCaptor;
    @Captor
    ArgumentCaptor<String[]> stringArrayArgumentCaptor;
    @Mock
    private ConditionColumnPlugin plugin;
    @Mock
    private TranslationService translationService;
    @Mock
    private GuidedDecisionTableView.Presenter presenter;
    @Mock
    private AsyncPackageDataModelOracle oracle;
    @Mock
    private Pattern52 pattern52;
    @Mock
    private ConditionCol52 editingCol;
    @Mock
    private OperatorPage.View view;
    @Mock
    private SimplePanel content;
    @Mock
    private ListBox listBox;
    @Mock
    private EventSourceMock<WizardPageStatusChangeEvent> eventSourceMock;
    @InjectMocks
    private OperatorPage page;

    public OperatorPageTest() {
        this.page = (OperatorPage)Mockito.spy((Object)new OperatorPage(this.view, this.eventSourceMock, this.translationService));
    }

    @BeforeClass
    public static void setupPreferences() {
        GWTMockUtilities.disarm();
    }

    @Before
    public void setup() {
        Mockito.when((Object)this.plugin.editingCol()).thenReturn((Object)this.editingCol);
        Mockito.when((Object)this.page.plugin()).thenReturn((Object)this.plugin);
    }

    @Test
    public void testIsConstraintValuePredicateWhenConstraintValueIsPredicate() {
        Mockito.when((Object)this.plugin.constraintValue()).thenReturn((Object)5);
        Assert.assertTrue((boolean)this.page.isConstraintValuePredicate());
    }

    @Test
    public void testIsConstraintValuePredicateWhenConstraintValueIsNotPredicate() {
        Mockito.when((Object)this.plugin.constraintValue()).thenReturn((Object)1);
        Assert.assertFalse((boolean)this.page.isConstraintValuePredicate());
    }

    @Test
    public void testCanSetOperatorWhenEditingColIsBlank() {
        Mockito.when((Object)this.plugin.getFactField()).thenReturn((Object)"");
        Assert.assertFalse((boolean)this.page.hasFactField());
    }

    @Test
    public void testCanSetOperatorWhenEditingColIsNull() {
        Mockito.when((Object)this.plugin.getFactField()).thenReturn(null);
        Assert.assertFalse((boolean)this.page.hasFactField());
    }

    @Test
    public void testCanSetOperatorWhenEditingColIsNotNull() {
        Mockito.when((Object)this.plugin.getFactField()).thenReturn((Object)"factField");
        Assert.assertTrue((boolean)this.page.hasFactField());
    }

    @Test
    public void testGetOperator() {
        String expectedOperator = "operator";
        Mockito.when((Object)this.plugin.getFactField()).thenReturn((Object)"factField");
        Mockito.when((Object)this.plugin.editingCol()).thenReturn((Object)this.editingCol);
        Mockito.when((Object)this.editingCol.getOperator()).thenReturn((Object)"operator");
        String operator = this.page.getOperator();
        ((ConditionColumnPlugin)Mockito.verify((Object)this.plugin)).editingCol();
        ((ConditionCol52)Mockito.verify((Object)this.editingCol)).getOperator();
        Assert.assertEquals((Object)"operator", (Object)operator);
    }

    @Test
    public void testOperatorPlaceholderSelectedWhenNothingSelectedPreviously() {
        this.registerFakeProvider();
        Mockito.when((Object)this.plugin.getFactField()).thenReturn((Object)"factField");
        Mockito.when((Object)this.plugin.operatorPlaceholder()).thenReturn((Object)"please choose");
        this.mockGetOperatorCompletionsToReturn(OperatorsOracle.STANDARD_OPERATORS);
        this.spyOperatorsDropdown();
        this.mockListBox("please choose", "equal to");
        this.page.operatorDropdown(widget -> {
            Assert.assertTrue((boolean)(widget instanceof CEPOperatorsDropdown));
            CEPOperatorsDropdown operatorsDropdown = (CEPOperatorsDropdown)widget;
            ((ListBox)Mockito.verify((Object)operatorsDropdown.getBox())).setSelectedIndex(0);
        });
    }

    @Test
    public void testOperatorDropdownSelectedNotFirstItem() {
        this.registerFakeProvider();
        Mockito.when((Object)this.plugin.getFactField()).thenReturn((Object)"factField");
        Mockito.when((Object)this.plugin.operatorPlaceholder()).thenReturn((Object)"please choose");
        Mockito.when((Object)this.editingCol.getOperator()).thenReturn((Object)"not equal to");
        this.mockGetOperatorCompletionsToReturn(OperatorsOracle.STANDARD_OPERATORS);
        this.spyOperatorsDropdown();
        this.mockListBox("please choose", "equal to", "not equal to");
        this.page.operatorDropdown(widget -> {
            Assert.assertTrue((boolean)(widget instanceof CEPOperatorsDropdown));
            CEPOperatorsDropdown operatorsDropdown = (CEPOperatorsDropdown)widget;
            ((ListBox)Mockito.verify((Object)operatorsDropdown.getBox())).setSelectedIndex(2);
        });
    }

    @Test
    public void testOperatorDropdownWhenOperatorCanBeSet() {
        String operatorPlaceholder = "--- please choose ---";
        this.registerFakeProvider();
        Mockito.when((Object)this.translationService.format("OperatorPage.NoOperator", new Object[0])).thenReturn((Object)"(no operator)");
        Mockito.when((Object)this.presenter.getDataModelOracle()).thenReturn((Object)this.oracle);
        Mockito.when((Object)this.plugin.getFactField()).thenReturn((Object)"factField");
        Mockito.when((Object)this.plugin.operatorPlaceholder()).thenReturn((Object)"--- please choose ---");
        Mockito.when((Object)this.editingCol.getOperator()).thenReturn((Object)"");
        this.mockGetOperatorCompletionsToReturn(OperatorsOracle.STANDARD_OPERATORS);
        this.spyOperatorsDropdown();
        this.mockListBox("--- please choose ---", "", "equal to");
        this.page.operatorDropdown(widget -> {
            Assert.assertTrue((boolean)(widget instanceof CEPOperatorsDropdown));
            CEPOperatorsDropdown dropdown = (CEPOperatorsDropdown)widget;
            ((ListBox)Mockito.verify((Object)this.listBox)).setSelectedIndex(1);
            ((ListBox)Mockito.verify((Object)this.listBox)).addChangeHandler((ChangeHandler)Mockito.any());
            ((CEPOperatorsDropdown)Mockito.verify((Object)dropdown)).addPlaceholder("--- please choose ---", "--- please choose ---");
            ((CEPOperatorsDropdown)Mockito.verify((Object)dropdown)).insertItem("(no operator)", "", 1);
            ((ListBox)Mockito.verify((Object)dropdown.getBox())).setSelectedIndex(1);
        });
    }

    private void mockListBox(String ... items) {
        Mockito.when((Object)this.listBox.getItemCount()).thenReturn((Object)items.length);
        for (int i = 0; i < items.length; ++i) {
            Mockito.when((Object)this.listBox.getValue(i)).thenReturn((Object)items[i]);
        }
    }

    @Test
    public void testOperatorDropdownWhenOperatorCanNotBeSet() {
        String operatorPlaceholder = "--- please choose ---";
        Element elementMock = (Element)Mockito.mock(Element.class);
        ListBox listBoxMock = (ListBox)Mockito.mock(ListBox.class);
        Mockito.when((Object)listBoxMock.getElement()).thenReturn((Object)elementMock);
        Mockito.when((Object)this.plugin.getFactField()).thenReturn((Object)"");
        Mockito.when((Object)this.plugin.operatorPlaceholder()).thenReturn((Object)"--- please choose ---");
        ((OperatorPage)Mockito.doReturn((Object)listBoxMock).when((Object)this.page)).newListBox();
        this.page.operatorDropdown(widget -> {
            Assert.assertTrue((boolean)(widget instanceof ListBox));
            ((ListBox)Mockito.verify((Object)listBoxMock)).addItem("--- please choose ---");
            ((Element)Mockito.verify((Object)elementMock)).setAttribute("disabled", "disabled");
        });
    }

    @Test
    public void testFilterOptionsForConstraintTypeLiteralWhenConstraintValueIsLiteral() {
        Mockito.when((Object)this.plugin.constraintValue()).thenReturn((Object)1);
        String[] result = this.page.filterOptionsForConstraintTypeLiteral(OperatorsOracle.EXPLICIT_LIST_OPERATORS);
        List<String> operators = Arrays.asList(result);
        Assert.assertTrue((boolean)operators.contains("in"));
        Assert.assertTrue((boolean)operators.contains("not in"));
        Assert.assertEquals((long)2L, (long)operators.size());
    }

    @Test
    public void testFilterOptionsForConstraintTypeLiteralWhenConstraintValueIsPredicate() {
        Mockito.when((Object)this.plugin.constraintValue()).thenReturn((Object)5);
        String[] result = this.page.filterOptionsForConstraintTypeLiteral(OperatorsOracle.EXPLICIT_LIST_OPERATORS);
        List<String> operators = Arrays.asList(result);
        Assert.assertEquals((long)0L, (long)operators.size());
    }

    @Test
    public void testFilterOptionsForConstraintTypeLiteralWhenConstraintValueIsFormula() {
        Mockito.when((Object)this.plugin.constraintValue()).thenReturn((Object)3);
        String[] result = this.page.filterOptionsForConstraintTypeLiteral(OperatorsOracle.EXPLICIT_LIST_OPERATORS);
        List<String> operators = Arrays.asList(result);
        Assert.assertEquals((long)0L, (long)operators.size());
    }

    @Test
    public void testGetOperatorCompletions() {
        Mockito.when((Object)this.plugin.getFactType()).thenReturn((Object)"factType");
        Mockito.when((Object)this.plugin.getFactField()).thenReturn((Object)"factField");
        Mockito.when((Object)this.presenter.getDataModelOracle()).thenReturn((Object)this.oracle);
        this.page.getOperatorCompletions(s -> {});
        ((AsyncPackageDataModelOracle)Mockito.verify((Object)this.oracle)).getOperatorCompletions((String)Mockito.eq((Object)"factType"), (String)Mockito.eq((Object)"factField"), (Callback)Mockito.any());
    }

    @Test
    public void testGetTitle() throws Exception {
        String errorKey = "OperatorPage.Operator";
        String errorMessage = "Title";
        Mockito.when((Object)this.translationService.format("OperatorPage.Operator", new Object[0])).thenReturn((Object)"Title");
        String title = this.page.getTitle();
        Assert.assertEquals((Object)"Title", (Object)title);
    }

    @Test
    public void testPrepareView() throws Exception {
        this.page.prepareView();
        ((OperatorPage.View)Mockito.verify((Object)this.view)).init((Object)this.page);
        ((OperatorPage)Mockito.verify((Object)this.page)).setupWarningMessages();
        ((OperatorPage)Mockito.verify((Object)this.page)).setupOperator();
        ((OperatorPage)Mockito.verify((Object)this.page)).setupCurrentField();
    }

    @Test
    public void testSetupCurrentFieldWhenFactFieldIsNotNull() throws Exception {
        String factField = "factField";
        ((ConditionColumnPlugin)Mockito.doReturn((Object)"factField").when((Object)this.plugin)).getFactField();
        this.page.setupCurrentField();
        ((OperatorPage.View)Mockito.verify((Object)this.view)).setCurrentField("factField");
        ((OperatorPage.View)Mockito.verify((Object)this.view)).currentFieldToggle(true);
    }

    @Test
    public void testSetupCurrentFieldWhenFactFieldIsNull() throws Exception {
        Object factField = null;
        ((ConditionColumnPlugin)Mockito.doReturn(factField).when((Object)this.plugin)).getFactField();
        this.page.setupCurrentField();
        ((OperatorPage.View)Mockito.verify((Object)this.view)).setCurrentField("");
        ((OperatorPage.View)Mockito.verify((Object)this.view)).currentFieldToggle(false);
    }

    @Test
    public void testCurrentFieldWhenFactFieldIsNull() throws Exception {
        Object factField = null;
        ((ConditionColumnPlugin)Mockito.doReturn(factField).when((Object)this.plugin)).getFactField();
        String currentField = this.page.currentField();
        Assert.assertEquals((Object)"", (Object)currentField);
    }

    @Test
    public void testCurrentFieldWhenFactFieldIsNotNull() throws Exception {
        String factField = "factField";
        ((ConditionColumnPlugin)Mockito.doReturn((Object)"factField").when((Object)this.plugin)).getFactField();
        String currentField = this.page.currentField();
        Assert.assertEquals((Object)"factField", (Object)currentField);
    }

    @Test
    public void testCurrentFieldWhenBindingIsNotNull() throws Exception {
        String factField = "factField";
        String binding = "binding";
        ((ConditionColumnPlugin)Mockito.doReturn((Object)"factField").when((Object)this.plugin)).getFactField();
        ((ConditionColumnPlugin)Mockito.doReturn((Object)"binding").when((Object)this.plugin)).getBinding();
        String currentField = this.page.currentField();
        Assert.assertEquals((Object)"binding : factField", (Object)currentField);
    }

    @Test
    public void testAsWidget() {
        Widget contentWidget = this.page.asWidget();
        Assert.assertEquals((Object)contentWidget, (Object)this.content);
    }

    @Test
    public void testIsCompleteWhenFactFieldIsNull() {
        Mockito.when((Object)this.editingCol.getOperator()).thenReturn((Object)"operator");
        Mockito.when((Object)this.plugin.getFactField()).thenReturn(null);
        this.page.isComplete(Assert::assertFalse);
        ((OperatorPage.View)Mockito.verify((Object)this.view)).showOperatorWarning();
        ((OperatorPage.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).hideOperatorWarning();
    }

    @Test
    public void testIsCompleteWhenOperatorIsNotSelected() {
        String operatorPlaceholder = "--- please choose ---";
        Mockito.when((Object)this.plugin.operatorPlaceholder()).thenReturn((Object)"--- please choose ---");
        Mockito.when((Object)this.editingCol.getOperator()).thenReturn((Object)"--- please choose ---");
        Mockito.when((Object)this.plugin.getFactField()).thenReturn((Object)"factType");
        this.page.isComplete(Assert::assertFalse);
        ((OperatorPage.View)Mockito.verify((Object)this.view)).showOperatorWarning();
        ((OperatorPage.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).hideOperatorWarning();
    }

    @Test
    public void testIsCompleteWhenFactFieldAndOperatorAreNotNull() {
        String operatorPlaceholder = "--- please choose ---";
        Mockito.when((Object)this.plugin.operatorPlaceholder()).thenReturn((Object)"--- please choose ---");
        Mockito.when((Object)this.editingCol.getOperator()).thenReturn((Object)"operator");
        Mockito.when((Object)this.plugin.getFactField()).thenReturn((Object)"factType");
        this.page.isComplete(Assert::assertTrue);
        ((OperatorPage.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).showOperatorWarning();
        ((OperatorPage.View)Mockito.verify((Object)this.view)).hideOperatorWarning();
    }

    @Test
    public void testSetOperator() {
        String operator = "operator";
        this.page.setOperator("operator");
        ((ConditionColumnPlugin)Mockito.verify((Object)this.plugin)).setOperator("operator");
    }

    @Test
    public void testNewListBox() {
        ListBox listBox = this.page.newListBox();
        Assert.assertNotNull((Object)listBox);
    }

    @Test
    public void testCanOperatorBeSetWhenFactTypeIsNil() {
        String factField = "";
        ((ConditionColumnPlugin)Mockito.doReturn((Object)"").when((Object)this.plugin)).getFactField();
        Assert.assertFalse((boolean)this.page.canOperatorBeSet());
    }

    @Test
    public void testCanOperatorBeSetWhenFactTypeIsNotNilAndConstraintValueIsPredicate() {
        String factField = "factField";
        int constraintValue = 5;
        ((ConditionColumnPlugin)Mockito.doReturn((Object)"factField").when((Object)this.plugin)).getFactField();
        ((ConditionColumnPlugin)Mockito.doReturn((Object)5).when((Object)this.plugin)).constraintValue();
        Assert.assertFalse((boolean)this.page.canOperatorBeSet());
    }

    @Test
    public void testCanOperatorBeSetWhenFactTypeIsNotNilAndConstraintValueIsNotPredicate() {
        String factField = "factField";
        boolean constraintValue = true;
        ((ConditionColumnPlugin)Mockito.doReturn((Object)"factField").when((Object)this.plugin)).getFactField();
        ((ConditionColumnPlugin)Mockito.doReturn((Object)1).when((Object)this.plugin)).constraintValue();
        Assert.assertTrue((boolean)this.page.canOperatorBeSet());
    }

    private void spyOperatorsDropdown() {
        ((ListBox)Mockito.doNothing().when((Object)this.listBox)).setSelectedIndex(Mockito.anyInt());
        ((OperatorPage)Mockito.doAnswer(answer -> {
            Object firstArgument = answer.getArguments()[0];
            String[] operators = (String[])firstArgument;
            CEPOperatorsDropdown dropdown = (CEPOperatorsDropdown)Mockito.spy((Object)new CEPOperatorsDropdown(operators, (HasParameterizedOperator)this.editingCol));
            Mockito.when((Object)dropdown.getBox()).thenReturn((Object)this.listBox);
            return dropdown;
        }).when((Object)this.page)).newCepOperatorsDropdown((String[])Mockito.any(), (ConditionCol52)Mockito.any());
    }

    private void mockGetOperatorCompletionsToReturn(final String[] standardOperators) {
        ((OperatorPage)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) throws Throwable {
                Callback callback = (Callback)OperatorPageTest.this.callbackArgumentCaptor.getValue();
                callback.callback((Object)standardOperators);
                return null;
            }
        }).when((Object)this.page)).getOperatorCompletions((Callback)this.callbackArgumentCaptor.capture());
    }

    private void registerFakeProvider() {
        GwtMockito.useProviderForType(GuidedRuleEditorResources.class, this.fakeProvider());
    }

    private FakeProvider<GuidedRuleEditorResources> fakeProvider() {
        return provider -> new GuidedRuleEditorResources(){

            public ItemImages itemImages() {
                return (ItemImages)Mockito.mock(ItemImages.class);
            }

            public GuidedRuleEditorCss css() {
                return (GuidedRuleEditorCss)Mockito.mock(GuidedRuleEditorCss.class);
            }

            public GuidedRuleEditorImages images() {
                return (GuidedRuleEditorImages)Mockito.mock(GuidedRuleEditorImages.class);
            }
        };
    }
}

