/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.common;

import com.google.gwt.user.client.ui.ListBox;
import com.google.gwtmockito.GwtMockitoTestRunner;
import org.drools.workbench.models.guided.dtable.shared.model.ActionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.ActionInsertFactCol52;
import org.drools.workbench.models.guided.dtable.shared.model.ActionRetractFactCol52;
import org.drools.workbench.models.guided.dtable.shared.model.ActionSetFieldCol52;
import org.drools.workbench.models.guided.dtable.shared.model.ActionWorkItemCol52;
import org.drools.workbench.models.guided.dtable.shared.model.ActionWorkItemInsertFactCol52;
import org.drools.workbench.models.guided.dtable.shared.model.ActionWorkItemSetFieldCol52;
import org.drools.workbench.models.guided.dtable.shared.model.BRLActionColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BRLConditionColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BaseColumn;
import org.drools.workbench.models.guided.dtable.shared.model.Pattern52;
import org.drools.workbench.screens.guided.dtable.client.resources.i18n.GuidedDecisionTableConstants;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.common.DecisionTableColumnViewUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;

@RunWith(value=GwtMockitoTestRunner.class)
public class DecisionTableColumnViewUtilsTest {
    private static final String SECOND_OPTION = "second option";
    private static final String FIRST_OPTION = "first option";
    private static final String PLEASE_CHOOSE = "please choose";
    private static final String FACT_TYPE_APPLICANT = "Applicant";
    private static final String APPLICANT_BOUND_NAME = "$a";
    private static final String COLUMN_HEADER = "column header";
    @Mock
    org.gwtbootstrap3.client.ui.ListBox listBox;

    @Before
    public void setUp() throws Exception {
        Mockito.when((Object)this.listBox.getItemCount()).thenReturn((Object)3);
        Mockito.when((Object)this.listBox.getValue(0)).thenReturn((Object)PLEASE_CHOOSE);
        Mockito.when((Object)this.listBox.getValue(1)).thenReturn((Object)FIRST_OPTION);
        Mockito.when((Object)this.listBox.getValue(2)).thenReturn((Object)SECOND_OPTION);
    }

    @Test
    public void testGetIndexWithoutDefaultSelectNull() throws Exception {
        Assert.assertEquals((long)-1L, (long)DecisionTableColumnViewUtils.getCurrentIndexFromListWithoutDefaultSelect(null, (ListBox)this.listBox));
    }

    @Test
    public void testGetIndexWithoutDefaultSelectEmpty() throws Exception {
        Assert.assertEquals((long)-1L, (long)DecisionTableColumnViewUtils.getCurrentIndexFromListWithoutDefaultSelect((String)"", (ListBox)this.listBox));
    }

    @Test
    public void testGetIndexWithoutDefaultSelectPlaceholder() throws Exception {
        Assert.assertEquals((long)0L, (long)DecisionTableColumnViewUtils.getCurrentIndexFromListWithoutDefaultSelect((String)PLEASE_CHOOSE, (ListBox)this.listBox));
    }

    @Test
    public void testGetIndexWithoutDefaultSelectFirstOption() throws Exception {
        Assert.assertEquals((long)1L, (long)DecisionTableColumnViewUtils.getCurrentIndexFromListWithoutDefaultSelect((String)FIRST_OPTION, (ListBox)this.listBox));
    }

    @Test
    public void testGetIndexWithoutDefaultSelectSecondOption() throws Exception {
        Assert.assertEquals((long)2L, (long)DecisionTableColumnViewUtils.getCurrentIndexFromListWithoutDefaultSelect((String)SECOND_OPTION, (ListBox)this.listBox));
    }

    @Test
    public void testGetIndexWithDefaultSelectNull() throws Exception {
        Assert.assertEquals((long)0L, (long)DecisionTableColumnViewUtils.getCurrentIndexFromList(null, (ListBox)this.listBox));
    }

    @Test
    public void testGetIndexWithDefaultSelectEmpty() throws Exception {
        Assert.assertEquals((long)0L, (long)DecisionTableColumnViewUtils.getCurrentIndexFromList((String)"", (ListBox)this.listBox));
    }

    @Test
    public void testGetIndexWithDefaultSelectPlaceholder() throws Exception {
        Assert.assertEquals((long)0L, (long)DecisionTableColumnViewUtils.getCurrentIndexFromList((String)PLEASE_CHOOSE, (ListBox)this.listBox));
    }

    @Test
    public void testGetIndexWithDefaultSelectFirstOption() throws Exception {
        Assert.assertEquals((long)1L, (long)DecisionTableColumnViewUtils.getCurrentIndexFromList((String)FIRST_OPTION, (ListBox)this.listBox));
    }

    @Test
    public void testGetIndexWithDefaultSelectSecondOption() throws Exception {
        Assert.assertEquals((long)2L, (long)DecisionTableColumnViewUtils.getCurrentIndexFromList((String)SECOND_OPTION, (ListBox)this.listBox));
    }

    @Test
    public void testColumnManagementGroupTitleInsertFact() throws Exception {
        ActionInsertFactCol52 column = (ActionInsertFactCol52)Mockito.mock(ActionInsertFactCol52.class);
        ((ActionInsertFactCol52)Mockito.doReturn((Object)FACT_TYPE_APPLICANT).when((Object)column)).getFactType();
        ((ActionInsertFactCol52)Mockito.doReturn((Object)APPLICANT_BOUND_NAME).when((Object)column)).getBoundName();
        Assert.assertEquals((Object)"Applicant [$a]", (Object)DecisionTableColumnViewUtils.getColumnManagementGroupTitle((BaseColumn)column));
    }

    @Test
    public void testColumnManagementGroupTitleInsertFactEmpty() throws Exception {
        ActionInsertFactCol52 column = (ActionInsertFactCol52)Mockito.mock(ActionInsertFactCol52.class);
        ((ActionInsertFactCol52)Mockito.doReturn((Object)COLUMN_HEADER).when((Object)column)).getHeader();
        Assert.assertEquals((Object)COLUMN_HEADER, (Object)DecisionTableColumnViewUtils.getColumnManagementGroupTitle((BaseColumn)column));
    }

    @Test
    public void testColumnManagementGroupTitleSetField() throws Exception {
        ActionSetFieldCol52 column = (ActionSetFieldCol52)Mockito.mock(ActionSetFieldCol52.class);
        ((ActionSetFieldCol52)Mockito.doReturn((Object)APPLICANT_BOUND_NAME).when((Object)column)).getBoundName();
        Assert.assertEquals((Object)"[$a]", (Object)DecisionTableColumnViewUtils.getColumnManagementGroupTitle((BaseColumn)column));
    }

    @Test
    public void testColumnManagementGroupTitleSetFieldEmpty() throws Exception {
        ActionSetFieldCol52 column = (ActionSetFieldCol52)Mockito.mock(ActionSetFieldCol52.class);
        ((ActionSetFieldCol52)Mockito.doReturn((Object)COLUMN_HEADER).when((Object)column)).getHeader();
        Assert.assertEquals((Object)COLUMN_HEADER, (Object)DecisionTableColumnViewUtils.getColumnManagementGroupTitle((BaseColumn)column));
    }

    @Test
    public void testColumnManagementGroupTitleWorkItemInsertFact() throws Exception {
        ActionWorkItemInsertFactCol52 column = (ActionWorkItemInsertFactCol52)Mockito.mock(ActionWorkItemInsertFactCol52.class);
        ((ActionWorkItemInsertFactCol52)Mockito.doReturn((Object)FACT_TYPE_APPLICANT).when((Object)column)).getFactType();
        ((ActionWorkItemInsertFactCol52)Mockito.doReturn((Object)APPLICANT_BOUND_NAME).when((Object)column)).getBoundName();
        Assert.assertEquals((Object)"Applicant [$a]", (Object)DecisionTableColumnViewUtils.getColumnManagementGroupTitle((BaseColumn)column));
    }

    @Test
    public void testColumnManagementGroupTitleWorkItemInsertFactEmpty() throws Exception {
        ActionWorkItemInsertFactCol52 column = (ActionWorkItemInsertFactCol52)Mockito.mock(ActionWorkItemInsertFactCol52.class);
        ((ActionWorkItemInsertFactCol52)Mockito.doReturn((Object)COLUMN_HEADER).when((Object)column)).getHeader();
        Assert.assertEquals((Object)COLUMN_HEADER, (Object)DecisionTableColumnViewUtils.getColumnManagementGroupTitle((BaseColumn)column));
    }

    @Test
    public void testColumnManagementGroupTitleWorkItemSetField() throws Exception {
        ActionWorkItemSetFieldCol52 column = (ActionWorkItemSetFieldCol52)Mockito.mock(ActionWorkItemSetFieldCol52.class);
        ((ActionWorkItemSetFieldCol52)Mockito.doReturn((Object)APPLICANT_BOUND_NAME).when((Object)column)).getBoundName();
        Assert.assertEquals((Object)"[$a]", (Object)DecisionTableColumnViewUtils.getColumnManagementGroupTitle((BaseColumn)column));
    }

    @Test
    public void testColumnManagementGroupTitleWorkItemSetFieldEmpty() throws Exception {
        ActionWorkItemSetFieldCol52 column = (ActionWorkItemSetFieldCol52)Mockito.mock(ActionWorkItemSetFieldCol52.class);
        ((ActionWorkItemSetFieldCol52)Mockito.doReturn((Object)COLUMN_HEADER).when((Object)column)).getHeader();
        Assert.assertEquals((Object)COLUMN_HEADER, (Object)DecisionTableColumnViewUtils.getColumnManagementGroupTitle((BaseColumn)column));
    }

    @Test
    public void testColumnManagementGroupTitlePattern() throws Exception {
        Pattern52 column = (Pattern52)Mockito.mock(Pattern52.class);
        ((Pattern52)Mockito.doReturn((Object)FACT_TYPE_APPLICANT).when((Object)column)).getFactType();
        ((Pattern52)Mockito.doReturn((Object)APPLICANT_BOUND_NAME).when((Object)column)).getBoundName();
        Assert.assertEquals((Object)"Applicant [$a]", (Object)DecisionTableColumnViewUtils.getColumnManagementGroupTitle((BaseColumn)column));
    }

    @Test
    public void testColumnManagementGroupTitlePatternNegated() throws Exception {
        Pattern52 column = (Pattern52)Mockito.mock(Pattern52.class);
        ((Pattern52)Mockito.doReturn((Object)FACT_TYPE_APPLICANT).when((Object)column)).getFactType();
        ((Pattern52)Mockito.doReturn((Object)true).when((Object)column)).isNegated();
        Assert.assertEquals((Object)(GuidedDecisionTableConstants.INSTANCE.negatedPattern() + " " + FACT_TYPE_APPLICANT), (Object)DecisionTableColumnViewUtils.getColumnManagementGroupTitle((BaseColumn)column));
    }

    @Test
    public void testColumnManagementGroupTitlePatternEmpty() throws Exception {
        Pattern52 column = (Pattern52)Mockito.mock(Pattern52.class);
        ((Pattern52)Mockito.doReturn((Object)COLUMN_HEADER).when((Object)column)).getHeader();
        Assert.assertEquals((Object)COLUMN_HEADER, (Object)DecisionTableColumnViewUtils.getColumnManagementGroupTitle((BaseColumn)column));
    }

    @Test
    public void testColumnManagementGroupTitleRetractAction() throws Exception {
        ActionRetractFactCol52 column = (ActionRetractFactCol52)Mockito.mock(ActionRetractFactCol52.class);
        Assert.assertEquals((Object)GuidedDecisionTableConstants.INSTANCE.RetractActions(), (Object)DecisionTableColumnViewUtils.getColumnManagementGroupTitle((BaseColumn)column));
    }

    @Test
    public void testColumnManagementGroupTitleWorkItemAction() throws Exception {
        ActionWorkItemCol52 column = (ActionWorkItemCol52)Mockito.mock(ActionWorkItemCol52.class);
        Assert.assertEquals((Object)GuidedDecisionTableConstants.INSTANCE.ExecuteWorkItemActions(), (Object)DecisionTableColumnViewUtils.getColumnManagementGroupTitle((BaseColumn)column));
    }

    @Test
    public void testColumnManagementGroupTitleBrlAction() throws Exception {
        BRLActionColumn column = (BRLActionColumn)Mockito.mock(BRLActionColumn.class);
        Assert.assertEquals((Object)GuidedDecisionTableConstants.INSTANCE.BrlActions(), (Object)DecisionTableColumnViewUtils.getColumnManagementGroupTitle((BaseColumn)column));
    }

    @Test
    public void testColumnManagementGroupTitleBrlCondition() throws Exception {
        BRLConditionColumn column = (BRLConditionColumn)Mockito.mock(BRLConditionColumn.class);
        Assert.assertEquals((Object)GuidedDecisionTableConstants.INSTANCE.BrlConditions(), (Object)DecisionTableColumnViewUtils.getColumnManagementGroupTitle((BaseColumn)column));
    }

    @Test
    public void testColumnManagementGroupTitle() throws Exception {
        ActionCol52 column = (ActionCol52)Mockito.mock(ActionCol52.class);
        ((ActionCol52)Mockito.doReturn((Object)COLUMN_HEADER).when((Object)column)).getHeader();
        Assert.assertEquals((Object)COLUMN_HEADER, (Object)DecisionTableColumnViewUtils.getColumnManagementGroupTitle((BaseColumn)column));
    }
}

