/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.wizard.column.plugins;

import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwtmockito.GwtMockitoTestRunner;
import com.google.gwtmockito.WithClassesToStub;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.drools.workbench.models.datamodel.rule.RuleModel;
import org.drools.workbench.models.guided.dtable.shared.model.ActionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.BRLActionColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BRLRuleModel;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableView;
import org.drools.workbench.screens.guided.dtable.client.widget.table.model.synchronizers.ModelSynchronizer;
import org.drools.workbench.screens.guided.dtable.client.widget.table.popovers.MockInstanceImpl;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.NewGuidedDecisionTableColumnWizard;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.AdditionalInfoPage;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.DefaultValuesPage;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.RuleModellerPage;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.plugins.BRLActionColumnPlugin;
import org.drools.workbench.screens.guided.rule.client.editor.plugin.RuleModellerActionPlugin;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.widgets.core.client.wizards.WizardPage;
import org.uberfire.ext.widgets.core.client.wizards.WizardPageStatusChangeEvent;
import org.uberfire.mocks.EventSourceMock;

@RunWith(value=GwtMockitoTestRunner.class)
@WithClassesToStub(value={BRLRuleModel.class})
public class BRLActionColumnPluginTest {
    @Mock
    private RuleModellerPage ruleModellerPage;
    @Mock
    private AdditionalInfoPage<BRLActionColumnPlugin> additionalInfoPage;
    @Mock
    private EventSourceMock<WizardPageStatusChangeEvent> changeEvent;
    @Mock
    private GuidedDecisionTableView.Presenter presenter;
    @Mock
    private GuidedDecisionTable52 model;
    @Mock
    private TranslationService translationService;
    @Mock
    private HandlerRegistration registration;
    @Mock
    private NewGuidedDecisionTableColumnWizard wizard;
    @Mock
    private BRLActionColumn editingCol;
    @InjectMocks
    private BRLActionColumnPlugin plugin;

    public BRLActionColumnPluginTest() {
        this.plugin = (BRLActionColumnPlugin)Mockito.spy((Object)new BRLActionColumnPlugin(this.ruleModellerPage, (DefaultValuesPage)Mockito.mock(DefaultValuesPage.class), new MockInstanceImpl<Object>(Collections.singletonList(Mockito.mock(RuleModellerActionPlugin.class))), this.additionalInfoPage, this.changeEvent, this.translationService));
    }

    @Test
    public void testGetTitle() throws Exception {
        String errorKey = "BRLActionColumnPlugin.AddActionBRL";
        String errorMessage = "Title";
        Mockito.when((Object)this.translationService.format("BRLActionColumnPlugin.AddActionBRL", new Object[0])).thenReturn((Object)"Title");
        String title = this.plugin.getTitle();
        Assert.assertEquals((Object)"Title", (Object)title);
    }

    @Test
    public void testInit() throws Exception {
        ((BRLActionColumnPlugin)Mockito.doReturn((Object)GuidedDecisionTable52.TableFormat.EXTENDED_ENTRY).when((Object)this.plugin)).tableFormat();
        ((GuidedDecisionTableView.Presenter)Mockito.doReturn((Object)Mockito.mock(EventBus.class)).when((Object)this.presenter)).getEventBus();
        ((NewGuidedDecisionTableColumnWizard)Mockito.doReturn((Object)this.presenter).when((Object)this.wizard)).getPresenter();
        this.plugin.init(this.wizard);
        ((BRLActionColumnPlugin)Mockito.verify((Object)this.plugin)).setupEditingCol();
        ((BRLActionColumnPlugin)Mockito.verify((Object)this.plugin)).setupRuleModellerEvents();
    }

    @Test
    public void testSetupEditingColWhenColumnIsNew() throws Exception {
        BRLActionColumn column = (BRLActionColumn)Mockito.mock(BRLActionColumn.class);
        ((BRLActionColumnPlugin)Mockito.doReturn((Object)true).when((Object)this.plugin)).isNewColumn();
        ((BRLActionColumnPlugin)Mockito.doReturn((Object)column).when((Object)this.plugin)).newBRLActionColumn();
        this.plugin.setupEditingCol();
        ((BRLActionColumn)Mockito.verify((Object)column, (VerificationMode)Mockito.never())).setHeader((String)Mockito.any());
        ((BRLActionColumn)Mockito.verify((Object)column, (VerificationMode)Mockito.never())).setDefinition((List)Mockito.any());
        ((BRLActionColumn)Mockito.verify((Object)column, (VerificationMode)Mockito.never())).setChildColumns((List)Mockito.any());
        ((BRLActionColumn)Mockito.verify((Object)column, (VerificationMode)Mockito.never())).setHideColumn(Mockito.anyBoolean());
        Assert.assertEquals((Object)column, (Object)this.plugin.editingCol());
    }

    @Test
    public void testSetupEditingColWhenColumnIsNotNew() throws Exception {
        BRLActionColumn originalColumn = (BRLActionColumn)Mockito.mock(BRLActionColumn.class);
        BRLActionColumn editingColumn = (BRLActionColumn)Mockito.mock(BRLActionColumn.class);
        String header = "header";
        ArrayList definition = new ArrayList();
        ArrayList childColumns = new ArrayList();
        boolean isHideColumn = false;
        ((BRLActionColumnPlugin)Mockito.doReturn((Object)false).when((Object)this.plugin)).isNewColumn();
        ((BRLActionColumnPlugin)Mockito.doReturn((Object)editingColumn).when((Object)this.plugin)).newBRLActionColumn();
        ((BRLActionColumnPlugin)Mockito.doReturn((Object)originalColumn).when((Object)this.plugin)).getOriginalColumnConfig52();
        ((BRLActionColumn)Mockito.doReturn((Object)"header").when((Object)originalColumn)).getHeader();
        ((BRLActionColumn)Mockito.doReturn(definition).when((Object)originalColumn)).getDefinition();
        ((BRLActionColumn)Mockito.doReturn(childColumns).when((Object)originalColumn)).getChildColumns();
        ((BRLActionColumn)Mockito.doReturn((Object)false).when((Object)originalColumn)).isHideColumn();
        this.plugin.setupEditingCol();
        ((BRLActionColumn)Mockito.verify((Object)editingColumn)).setHeader("header");
        ((BRLActionColumn)Mockito.verify((Object)editingColumn)).setDefinition(definition);
        ((BRLActionColumn)Mockito.verify((Object)editingColumn)).setChildColumns(childColumns);
        ((BRLActionColumn)Mockito.verify((Object)editingColumn)).setHideColumn(false);
        Assert.assertEquals((Object)editingColumn, (Object)this.plugin.editingCol());
    }

    @Test
    public void testGetPages() throws Exception {
        List pages = this.plugin.getPages();
        Assert.assertEquals((long)3L, (long)pages.size());
    }

    @Test
    public void testOnClose() throws Exception {
        this.plugin.onClose();
        ((BRLActionColumnPlugin)Mockito.verify((Object)this.plugin)).teardownRuleModellerEvents();
    }

    @Test
    public void testGenerateColumnWhenColumnIsNew() throws Exception {
        GuidedDecisionTable52 model = (GuidedDecisionTable52)Mockito.mock(GuidedDecisionTable52.class);
        ArrayList actionCol52s = new ArrayList();
        Mockito.when((Object)model.getActionCols()).thenReturn(actionCol52s);
        Mockito.when((Object)this.presenter.getModel()).thenReturn((Object)model);
        Mockito.when((Object)this.editingCol.getHeader()).thenReturn((Object)"header");
        Mockito.when((Object)this.plugin.isNewColumn()).thenReturn((Object)true);
        Boolean success = this.plugin.generateColumn();
        Assert.assertTrue((boolean)success);
        ((BRLActionColumnPlugin)Mockito.verify((Object)this.plugin)).setupDefinedVariables((RuleModel)Mockito.any());
        ((BRLActionColumn)Mockito.verify((Object)this.editingCol)).setDefinition((List)Mockito.any());
        ((GuidedDecisionTableView.Presenter)Mockito.verify((Object)this.presenter)).appendColumn((ActionCol52)this.editingCol);
        ((TranslationService)Mockito.verify((Object)this.translationService, (VerificationMode)Mockito.never())).format((String)Mockito.any(), new Object[0]);
    }

    @Test
    public void testGenerateColumnWhenColumnIsNotNew() throws Exception {
        BRLActionColumn originalCol = (BRLActionColumn)Mockito.mock(BRLActionColumn.class);
        GuidedDecisionTable52 model = (GuidedDecisionTable52)Mockito.mock(GuidedDecisionTable52.class);
        Mockito.when((Object)model.getActionCols()).thenReturn(new ArrayList());
        Mockito.when((Object)this.presenter.getModel()).thenReturn((Object)model);
        Mockito.when((Object)this.editingCol.getHeader()).thenReturn((Object)"header");
        Mockito.when((Object)this.plugin.originalCol()).thenReturn((Object)originalCol);
        Mockito.when((Object)this.plugin.isNewColumn()).thenReturn((Object)false);
        Boolean success = this.plugin.generateColumn();
        Assert.assertTrue((boolean)success);
        ((BRLActionColumnPlugin)Mockito.verify((Object)this.plugin)).setupDefinedVariables((RuleModel)Mockito.any());
        ((BRLActionColumn)Mockito.verify((Object)this.editingCol)).setDefinition((List)Mockito.any());
        ((GuidedDecisionTableView.Presenter)Mockito.verify((Object)this.presenter)).updateColumn((ActionCol52)originalCol, (ActionCol52)this.editingCol);
        ((TranslationService)Mockito.verify((Object)this.translationService, (VerificationMode)Mockito.never())).format((String)Mockito.any(), new Object[0]);
    }

    @Test
    public void testGenerateColumnVeto() throws Exception {
        ((BRLActionColumnPlugin)Mockito.doReturn((Object)false).when((Object)this.plugin)).isNewColumn();
        ((GuidedDecisionTableView.Presenter)Mockito.doThrow((Throwable)new ModelSynchronizer.VetoException()).when((Object)this.presenter)).updateColumn((ActionCol52)Mockito.any(BRLActionColumn.class), (ActionCol52)Mockito.any(BRLActionColumn.class));
        Boolean success = this.plugin.generateColumn();
        Assert.assertFalse((boolean)success);
        ((NewGuidedDecisionTableColumnWizard)Mockito.verify((Object)this.wizard)).showGenericVetoError();
    }

    @Test
    public void testGetHeader() throws Exception {
        this.plugin.getHeader();
        ((BRLActionColumn)Mockito.verify((Object)this.editingCol)).getHeader();
    }

    @Test
    public void testSetHeader() throws Exception {
        String header = "header";
        this.plugin.setHeader("header");
        ((BRLActionColumn)Mockito.verify((Object)this.editingCol)).setHeader("header");
        ((BRLActionColumnPlugin)Mockito.verify((Object)this.plugin)).fireChangeEvent(this.additionalInfoPage);
    }

    @Test
    public void testGetRuleModel() throws Exception {
        Assert.assertNotNull((Object)this.plugin.getRuleModel());
    }

    @Test
    public void testSetRuleModellerPageAsCompletedWhenItIsCompleted() throws Exception {
        ((BRLActionColumnPlugin)Mockito.doReturn((Object)true).when((Object)this.plugin)).isRuleModellerPageCompleted();
        this.plugin.setRuleModellerPageAsCompleted();
        ((BRLActionColumnPlugin)Mockito.verify((Object)this.plugin, (VerificationMode)Mockito.never())).setRuleModellerPageCompleted();
        ((BRLActionColumnPlugin)Mockito.verify((Object)this.plugin, (VerificationMode)Mockito.never())).fireChangeEvent((WizardPage)this.ruleModellerPage);
    }

    @Test
    public void testSetRuleModellerPageAsCompletedWhenItIsNotCompleted() throws Exception {
        ((BRLActionColumnPlugin)Mockito.doReturn((Object)false).when((Object)this.plugin)).isRuleModellerPageCompleted();
        this.plugin.setRuleModellerPageAsCompleted();
        ((BRLActionColumnPlugin)Mockito.verify((Object)this.plugin)).setRuleModellerPageCompleted();
        ((BRLActionColumnPlugin)Mockito.verify((Object)this.plugin)).fireChangeEvent((WizardPage)this.ruleModellerPage);
    }

    @Test
    public void testTableFormat() throws Exception {
        GuidedDecisionTable52.TableFormat expectedTableFormat = GuidedDecisionTable52.TableFormat.EXTENDED_ENTRY;
        ((GuidedDecisionTable52)Mockito.doReturn((Object)expectedTableFormat).when((Object)this.model)).getTableFormat();
        ((GuidedDecisionTableView.Presenter)Mockito.doReturn((Object)this.model).when((Object)this.presenter)).getModel();
        GuidedDecisionTable52.TableFormat actualTableFormat = this.plugin.tableFormat();
        Assert.assertEquals((Object)expectedTableFormat, (Object)actualTableFormat);
    }

    @Test
    public void testGetAlreadyUsedColumnNames() throws Exception {
        GuidedDecisionTable52 model = new GuidedDecisionTable52();
        model.getActionCols().add(new ActionCol52(){
            {
                this.setHeader("a");
            }
        });
        model.getActionCols().add(new ActionCol52(){
            {
                this.setHeader("b");
            }
        });
        Mockito.when((Object)this.presenter.getModel()).thenReturn((Object)model);
        Assert.assertEquals((long)2L, (long)this.plugin.getAlreadyUsedColumnHeaders().size());
        Assert.assertTrue((boolean)this.plugin.getAlreadyUsedColumnHeaders().contains("a"));
        Assert.assertTrue((boolean)this.plugin.getAlreadyUsedColumnHeaders().contains("b"));
    }

    @Test
    public void testGetRuleModellerDescription() throws Exception {
        this.plugin.getRuleModellerDescription();
        ((TranslationService)Mockito.verify((Object)this.translationService)).format("RuleModellerPage.InsertAnActionBRLFragment", new Object[0]);
        ((TranslationService)Mockito.verify((Object)this.translationService, (VerificationMode)Mockito.never())).format("RuleModellerPage.InsertAConditionBRLFragment", new Object[0]);
    }

    @Test
    public void testIsHideColumn() {
        this.plugin.isHideColumn();
        ((BRLActionColumn)Mockito.verify((Object)this.editingCol)).isHideColumn();
    }

    @Test
    public void testSetHideColumn() throws Exception {
        boolean hideColumn = false;
        this.plugin.setHideColumn(false);
        ((BRLActionColumn)Mockito.verify((Object)this.editingCol)).setHideColumn(false);
    }

    @Test
    public void testRuleModellerActionPlugins() throws Exception {
        Assertions.assertThat((Iterable)this.plugin.getRuleModellerActionPlugins()).hasSize(1);
        Assertions.assertThat((Iterable)this.plugin.getRuleModellerActionPlugins()).hasAtLeastOneElementOfType(RuleModellerActionPlugin.class);
    }
}

