/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.editor.menu;

import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.drools.workbench.screens.guided.dtable.client.editor.clipboard.Clipboard;
import org.drools.workbench.screens.guided.dtable.client.editor.menu.BaseMenu;
import org.drools.workbench.screens.guided.dtable.client.editor.menu.CellContextMenuView;
import org.drools.workbench.screens.guided.dtable.client.widget.table.events.cdi.DecisionTableSelectedEvent;
import org.drools.workbench.screens.guided.dtable.client.widget.table.events.cdi.DecisionTableSelectionsChangedEvent;
import org.drools.workbench.screens.guided.dtable.client.widget.table.events.cdi.RefreshMenusEvent;
import org.uberfire.ext.wires.core.grids.client.model.GridData;

@Dependent
public class CellContextMenu
extends BaseMenu
implements IsWidget,
CellContextMenuView.Presenter {
    private CellContextMenuView view;
    private Clipboard clipboard;

    @Inject
    public CellContextMenu(CellContextMenuView view, Clipboard clipboard) {
        this.view = view;
        this.clipboard = clipboard;
    }

    @PostConstruct
    void setup() {
        this.view.init(this);
    }

    @Override
    public void onDecisionTableSelectedEvent(@Observes DecisionTableSelectedEvent event) {
        super.onDecisionTableSelectedEvent(event);
    }

    @Override
    public void onDecisionTableSelectionsChangedEvent(@Observes DecisionTableSelectionsChangedEvent event) {
        super.onDecisionTableSelectionsChangedEvent(event);
    }

    @Override
    public void onRefreshMenusEvent(@Observes RefreshMenusEvent event) {
        super.onRefreshMenusEvent(event);
    }

    public Widget asWidget() {
        return this.view.asWidget();
    }

    @Override
    public void show(int mx, int my) {
        this.view.show(mx, my);
    }

    @Override
    public void hide() {
        this.view.hide();
    }

    @Override
    public void initialise() {
        if (this.activeDecisionTable == null || !this.activeDecisionTable.getAccess().isEditable()) {
            this.disableMenuItems();
            return;
        }
        List selections = this.activeDecisionTable.getView().getModel().getSelectedCells();
        if (selections == null || selections.isEmpty()) {
            this.disableMenuItems();
            return;
        }
        this.enableMenuItems(selections);
    }

    @Override
    public void onCut() {
        if (this.activeDecisionTable != null) {
            this.activeDecisionTable.onCut();
        }
        this.hide();
    }

    @Override
    public void onCopy() {
        if (this.activeDecisionTable != null) {
            this.activeDecisionTable.onCopy();
        }
        this.hide();
    }

    @Override
    public void onPaste() {
        if (this.activeDecisionTable != null) {
            this.activeDecisionTable.onPaste();
        }
        this.hide();
    }

    @Override
    public void onDeleteSelectedCells() {
        if (this.activeDecisionTable != null) {
            this.activeDecisionTable.onDeleteSelectedCells();
        }
        this.hide();
    }

    private void disableMenuItems() {
        this.view.enableCutMenuItem(false);
        this.view.enableCopyMenuItem(false);
        this.view.enablePasteMenuItem(false);
        this.view.enableDeleteCellMenuItem(false);
    }

    private void enableMenuItems(List<GridData.SelectedCell> selections) {
        boolean enabled = selections.size() > 0;
        this.view.enableCutMenuItem(enabled);
        this.view.enableCopyMenuItem(enabled);
        this.view.enablePasteMenuItem(this.clipboard.hasData());
        this.view.enableDeleteCellMenuItem(enabled);
    }
}

