/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.editor.menu;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.drools.workbench.models.guided.dtable.shared.model.BaseColumn;
import org.drools.workbench.models.guided.dtable.shared.model.DTCellValue52;
import org.drools.workbench.models.guided.dtable.shared.model.DescriptionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.RowNumberCol52;
import org.drools.workbench.models.guided.dtable.shared.model.RuleNameColumn;
import org.drools.workbench.screens.guided.dtable.client.editor.clipboard.Clipboard;
import org.drools.workbench.screens.guided.dtable.client.editor.menu.BaseMenu;
import org.drools.workbench.screens.guided.dtable.client.widget.table.events.cdi.DecisionTableSelectedEvent;
import org.drools.workbench.screens.guided.dtable.client.widget.table.events.cdi.DecisionTableSelectionsChangedEvent;
import org.drools.workbench.screens.guided.dtable.client.widget.table.events.cdi.RefreshMenusEvent;
import org.drools.workbench.screens.guided.dtable.client.widget.table.utilities.ColumnUtilities;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.common.DecisionTablePopoverUtils;
import org.gwtbootstrap3.client.ui.constants.IconType;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.uberfire.ext.widgets.common.client.menu.MenuItemFactory;
import org.uberfire.ext.widgets.common.client.menu.MenuItemWithIconView;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.workbench.model.menu.MenuFactory;
import org.uberfire.workbench.model.menu.MenuItem;

@Dependent
public class EditMenuBuilder
extends BaseMenu
implements MenuFactory.CustomMenuBuilder {
    private Clipboard clipboard;
    private TranslationService ts;
    private MenuItemFactory menuItemFactory;
    private DecisionTablePopoverUtils popoverUtils;
    MenuItemFactory.MenuItemViewHolder<MenuItemWithIconView> miCut;
    MenuItemFactory.MenuItemViewHolder<MenuItemWithIconView> miCopy;
    MenuItemFactory.MenuItemViewHolder<MenuItemWithIconView> miPaste;
    MenuItemFactory.MenuItemViewHolder<MenuItemWithIconView> miDeleteSelectedCells;
    MenuItemFactory.MenuItemViewHolder<MenuItemWithIconView> miDeleteSelectedColumns;
    MenuItemFactory.MenuItemViewHolder<MenuItemWithIconView> miDeleteSelectedRows;
    MenuItemFactory.MenuItemViewHolder<MenuItemWithIconView> miOtherwiseCell;

    @Inject
    public EditMenuBuilder(Clipboard clipboard, TranslationService ts, MenuItemFactory menuItemFactory, DecisionTablePopoverUtils popoverUtils) {
        this.clipboard = clipboard;
        this.ts = ts;
        this.menuItemFactory = menuItemFactory;
        this.popoverUtils = popoverUtils;
    }

    @PostConstruct
    public void setup() {
        this.miCut = this.menuItemFactory.makeMenuItemWithIcon(this.ts.getTranslation("EditMenu.cut"), this::onCut);
        this.miCopy = this.menuItemFactory.makeMenuItemWithIcon(this.ts.getTranslation("EditMenu.copy"), this::onCopy);
        this.miPaste = this.menuItemFactory.makeMenuItemWithIcon(this.ts.getTranslation("EditMenu.paste"), this::onPaste);
        this.miDeleteSelectedCells = this.menuItemFactory.makeMenuItemWithIcon(this.ts.getTranslation("EditMenu.deleteCells"), this::onDeleteSelectedCells);
        this.miDeleteSelectedColumns = this.menuItemFactory.makeMenuItemWithIcon(this.ts.getTranslation("EditMenu.deleteColumns"), this::onDeleteSelectedColumns);
        this.miDeleteSelectedRows = this.menuItemFactory.makeMenuItemWithIcon(this.ts.getTranslation("EditMenu.deleteRows"), this::onDeleteSelectedRows);
        this.miOtherwiseCell = this.menuItemFactory.makeMenuItemWithIcon(this.ts.getTranslation("EditMenu.otherwise"), this::onOtherwiseCell);
        this.setupOtherwisePopover();
    }

    private void setupOtherwisePopover() {
        ((MenuItemWithIconView)this.miOtherwiseCell.getMenuItemView()).getElement().setAttribute("data-toggle", "popover");
        this.popoverUtils.setupPopover(((MenuItemWithIconView)this.miOtherwiseCell.getMenuItemView()).getElement(), this.ts.getTranslation("EditMenu.otherwiseDescription"));
    }

    public void push(MenuFactory.CustomMenuBuilder element) {
    }

    public MenuItem build() {
        return (MenuItem)((MenuFactory.TopLevelMenusBuilder)MenuFactory.newTopLevelMenu((String)this.ts.getTranslation("EditMenu.title")).withItems(this.getEditMenuItems()).endMenu()).build().getItems().get(0);
    }

    List<MenuItem> getEditMenuItems() {
        ArrayList<MenuItem> menuItems = new ArrayList<MenuItem>();
        menuItems.add(this.miCut.getMenuItem());
        menuItems.add(this.miCopy.getMenuItem());
        menuItems.add(this.miPaste.getMenuItem());
        menuItems.add(this.miDeleteSelectedCells.getMenuItem());
        menuItems.add(this.miDeleteSelectedColumns.getMenuItem());
        menuItems.add(this.miDeleteSelectedRows.getMenuItem());
        menuItems.add(this.miOtherwiseCell.getMenuItem());
        return menuItems;
    }

    @Override
    public void onDecisionTableSelectedEvent(@Observes DecisionTableSelectedEvent event) {
        super.onDecisionTableSelectedEvent(event);
    }

    @Override
    public void onDecisionTableSelectionsChangedEvent(@Observes DecisionTableSelectionsChangedEvent event) {
        super.onDecisionTableSelectionsChangedEvent(event);
    }

    @Override
    public void onRefreshMenusEvent(@Observes RefreshMenusEvent event) {
        super.onRefreshMenusEvent(event);
    }

    @Override
    public void initialise() {
        if (this.activeDecisionTable == null || !this.activeDecisionTable.getAccess().isEditable()) {
            this.disableMenuItems();
            return;
        }
        List selections = this.activeDecisionTable.getView().getModel().getSelectedCells();
        if (selections == null || selections.isEmpty()) {
            this.disableMenuItems();
            return;
        }
        this.enableMenuItems(selections);
        this.setupOtherwiseCellEntry(selections);
    }

    void onCut() {
        if (this.activeDecisionTable != null) {
            this.activeDecisionTable.onCut();
        }
    }

    void onCopy() {
        if (this.activeDecisionTable != null) {
            this.activeDecisionTable.onCopy();
        }
    }

    void onPaste() {
        if (this.activeDecisionTable != null) {
            this.activeDecisionTable.onPaste();
        }
    }

    void onDeleteSelectedCells() {
        if (this.activeDecisionTable != null) {
            this.activeDecisionTable.onDeleteSelectedCells();
        }
    }

    void onDeleteSelectedColumns() {
        if (this.activeDecisionTable != null) {
            this.activeDecisionTable.onDeleteSelectedColumns();
        }
    }

    void onDeleteSelectedRows() {
        if (this.activeDecisionTable != null) {
            this.activeDecisionTable.onDeleteSelectedRows();
        }
    }

    void onOtherwiseCell() {
        if (this.activeDecisionTable != null) {
            ((MenuItemWithIconView)this.miOtherwiseCell.getMenuItemView()).setIconType(IconType.CHECK);
            this.activeDecisionTable.onOtherwiseCell();
        }
    }

    private void disableMenuItems() {
        this.miCut.getMenuItem().setEnabled(false);
        this.miCopy.getMenuItem().setEnabled(false);
        this.miPaste.getMenuItem().setEnabled(false);
        this.miDeleteSelectedCells.getMenuItem().setEnabled(false);
        this.miDeleteSelectedColumns.getMenuItem().setEnabled(false);
        this.miDeleteSelectedRows.getMenuItem().setEnabled(false);
        this.miOtherwiseCell.getMenuItem().setEnabled(false);
        this.popoverUtils.enableOtherwisePopover(((MenuItemWithIconView)this.miOtherwiseCell.getMenuItemView()).getElement(), false);
    }

    private void enableMenuItems(List<GridData.SelectedCell> selections) {
        boolean enabled = selections.size() > 0;
        boolean isOtherwiseEnabled = this.isOtherwiseEnabled(selections);
        boolean isColumnDeletable = this.isColumnDeletable(selections);
        this.miCut.getMenuItem().setEnabled(enabled);
        this.miCopy.getMenuItem().setEnabled(enabled);
        this.miPaste.getMenuItem().setEnabled(this.clipboard.hasData());
        this.miDeleteSelectedCells.getMenuItem().setEnabled(enabled);
        this.miDeleteSelectedColumns.getMenuItem().setEnabled(isColumnDeletable);
        this.miDeleteSelectedRows.getMenuItem().setEnabled(enabled);
        this.miOtherwiseCell.getMenuItem().setEnabled(isOtherwiseEnabled);
        this.popoverUtils.enableOtherwisePopover(((MenuItemWithIconView)this.miOtherwiseCell.getMenuItemView()).getElement(), isOtherwiseEnabled);
    }

    private boolean isColumnDeletable(List<GridData.SelectedCell> selections) {
        boolean enabled = selections.size() > 0;
        boolean isNotOnlyMandatoryColumnSelected = !this.isOnlyMandatoryColumnSelected(selections);
        boolean guidedDecisionTableHasEditableColumns = this.activeDecisionTable.hasEditableColumns();
        return enabled && isNotOnlyMandatoryColumnSelected && guidedDecisionTableHasEditableColumns;
    }

    private void setupOtherwiseCellEntry(List<GridData.SelectedCell> selections) {
        if (selections.size() != 1) {
            ((MenuItemWithIconView)this.miOtherwiseCell.getMenuItemView()).setIconType(null);
            return;
        }
        GridData.SelectedCell selection = selections.get(0);
        int rowIndex = selection.getRowIndex();
        int columnIndex = this.findUiColumnIndex(selection.getColumnIndex());
        boolean isOtherwiseCell = ((DTCellValue52)((List)this.activeDecisionTable.getModel().getData().get(rowIndex)).get(columnIndex)).isOtherwise();
        ((MenuItemWithIconView)this.miOtherwiseCell.getMenuItemView()).setIconType((IconType)(isOtherwiseCell ? IconType.CHECK : null));
    }

    private boolean isOtherwiseEnabled(List<GridData.SelectedCell> selections) {
        if (selections.size() != 1) {
            return false;
        }
        boolean isOtherwiseEnabled = true;
        GridData.SelectedCell selection = selections.get(0);
        int columnIndex = this.findUiColumnIndex(selection.getColumnIndex());
        BaseColumn column = (BaseColumn)this.activeDecisionTable.getModel().getExpandedColumns().get(columnIndex);
        isOtherwiseEnabled = isOtherwiseEnabled && ColumnUtilities.canAcceptOtherwiseValues(column);
        return isOtherwiseEnabled;
    }

    private boolean isOnlyMandatoryColumnSelected(List<GridData.SelectedCell> selections) {
        boolean isOnlyMandatoryColumnSelected = true;
        for (GridData.SelectedCell sc : selections) {
            int columnIndex = this.findUiColumnIndex(sc.getColumnIndex());
            BaseColumn column = (BaseColumn)this.activeDecisionTable.getModel().getExpandedColumns().get(columnIndex);
            if ((column instanceof RowNumberCol52 || column instanceof DescriptionCol52) && !(column instanceof RuleNameColumn)) continue;
            isOnlyMandatoryColumnSelected = false;
        }
        return isOnlyMandatoryColumnSelected;
    }

    private int findUiColumnIndex(int modelColumnIndex) {
        List columns = this.activeDecisionTable.getView().getModel().getColumns();
        for (int uiColumnIndex = 0; uiColumnIndex < columns.size(); ++uiColumnIndex) {
            GridColumn c = (GridColumn)columns.get(uiColumnIndex);
            if (c.getIndex() != modelColumnIndex) continue;
            return uiColumnIndex;
        }
        throw new IllegalStateException("Column was not found!");
    }

    public static interface SupportsEditMenu {
        public void onCut();

        public void onCopy();

        public void onPaste();

        public void onDeleteSelectedCells();

        public void onDeleteSelectedColumns();

        public void onDeleteSelectedRows();

        public void onOtherwiseCell();
    }
}

