/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.editor.page.accordion;

import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.drools.workbench.screens.guided.dtable.client.editor.page.accordion.GuidedDecisionTableAccordionItem;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.uberfire.client.mvp.UberElement;
import org.uberfire.commons.uuid.UUID;

@Dependent
public class GuidedDecisionTableAccordion {
    private final View view;
    private final ManagedInstance<GuidedDecisionTableAccordionItem> itemManagedInstance;
    private final List<GuidedDecisionTableAccordionItem> items = new ArrayList<GuidedDecisionTableAccordionItem>();
    private String parentId;

    @Inject
    public GuidedDecisionTableAccordion(View view, ManagedInstance<GuidedDecisionTableAccordionItem> itemManagedInstance) {
        this.view = view;
        this.itemManagedInstance = itemManagedInstance;
    }

    @PostConstruct
    public void setup() {
        this.view.init(this);
        this.setupParentId();
    }

    private void setupParentId() {
        this.parentId = UUID.uuid();
        this.view.setParentId(this.parentId);
    }

    public View getView() {
        return this.view;
    }

    public void addItem(GuidedDecisionTableAccordionItem.Type type, Widget widget) {
        this.addItem(this.makeItem(type, widget));
    }

    private GuidedDecisionTableAccordionItem makeItem(GuidedDecisionTableAccordionItem.Type type, Widget widget) {
        GuidedDecisionTableAccordionItem accordionItem = this.blankAccordionItem();
        accordionItem.init(this.getParentId(), type, widget);
        return accordionItem;
    }

    GuidedDecisionTableAccordionItem blankAccordionItem() {
        return (GuidedDecisionTableAccordionItem)this.itemManagedInstance.get();
    }

    List<GuidedDecisionTableAccordionItem> getItems() {
        return this.items;
    }

    private void addItem(GuidedDecisionTableAccordionItem item) {
        this.getItems().add(item);
        this.getView().addItem(item);
    }

    public void clear() {
        this.getItems().clear();
        this.getView().clear();
    }

    public GuidedDecisionTableAccordionItem getItem(GuidedDecisionTableAccordionItem.Type type) {
        return this.getItems().stream().filter(item -> item.getType() == type).findFirst().orElse(this.blankAccordionItem());
    }

    String getParentId() {
        return this.parentId;
    }

    public static interface View
    extends UberElement<GuidedDecisionTableAccordion> {
        public void addItem(GuidedDecisionTableAccordionItem var1);

        public void clear();

        public void setParentId(String var1);
    }
}

