/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.editor.search;

import javax.inject.Inject;
import org.drools.workbench.models.guided.dtable.shared.model.DTCellValue52;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.screens.guided.dtable.client.editor.search.GuidedDecisionTableGridHighlightHelper;
import org.drools.workbench.screens.guided.dtable.client.editor.search.GuidedDecisionTableSearchableElement;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableModellerView;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableView;
import org.drools.workbench.screens.guided.dtable.client.widget.table.utilities.CellUtilities;
import org.drools.workbench.screens.guided.rule.client.util.GWTDateConverter;
import org.kie.soup.project.datamodel.oracle.DateConverter;

public class SearchableElementFactory {
    private final GuidedDecisionTableGridHighlightHelper highlightHelper;
    private final CellUtilities cellUtilities;

    @Inject
    public SearchableElementFactory(GuidedDecisionTableGridHighlightHelper highlightHelper) {
        this.highlightHelper = highlightHelper;
        this.cellUtilities = new CellUtilities();
        CellUtilities.injectDateConvertor(this.getDateConverter());
    }

    private DateConverter getDateConverter() {
        return GWTDateConverter.getInstance();
    }

    public GuidedDecisionTableSearchableElement makeSearchableElement(int row, int column, DTCellValue52 cellValue52, GuidedDecisionTableView widget, GuidedDecisionTable52 model, GuidedDecisionTableModellerView.Presenter modeller) {
        GuidedDecisionTableSearchableElement searchableElement = new GuidedDecisionTableSearchableElement();
        searchableElement.setHighlightHelper(this.highlightHelper);
        searchableElement.setModeller(modeller);
        searchableElement.setValue(this.cellUtilities.asString(cellValue52));
        searchableElement.setRow(row);
        searchableElement.setColumn(column);
        searchableElement.setWidget(widget);
        searchableElement.setModel(model);
        return searchableElement;
    }
}

