/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget;

import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.ui.Widget;
import java.util.Date;
import java.util.Objects;
import org.drools.workbench.models.datamodel.rule.Attribute;
import org.drools.workbench.models.guided.dtable.shared.model.AttributeCol52;
import org.drools.workbench.models.guided.dtable.shared.model.DTCellValue52;
import org.drools.workbench.screens.guided.rule.client.widget.attribute.RuleAttributeWidget;
import org.gwtbootstrap3.client.ui.CheckBox;
import org.gwtbootstrap3.client.ui.ListBox;
import org.gwtbootstrap3.client.ui.TextBox;
import org.kie.workbench.common.services.shared.preferences.ApplicationPreferences;
import org.kie.workbench.common.widgets.client.widget.TextBoxFactory;
import org.uberfire.ext.widgets.common.client.common.DatePicker;

public class DefaultValueWidgetFactory {
    private static final String DATE_FORMAT = ApplicationPreferences.getDroolsDateFormat();
    private static final DateTimeFormat format = DateTimeFormat.getFormat((String)DATE_FORMAT);

    public static Widget getDefaultValueWidget(AttributeCol52 ac, boolean isReadOnly, DefaultValueChangedEventHandler defaultValueChangedEventHandler) {
        TextBox editor = null;
        String attribute = ac.getAttribute();
        if (Objects.equals(attribute, Attribute.DIALECT.getAttributeName())) {
            ListBox lb = new ListBox();
            lb.addItem((String)RuleAttributeWidget.DIALECTS.get(0));
            lb.addItem((String)RuleAttributeWidget.DIALECTS.get(1));
            if (ac.getDefaultValue() == null) {
                ac.setDefaultValue(new DTCellValue52((String)RuleAttributeWidget.DIALECTS.get(1)));
            }
            DTCellValue52 defaultValue = ac.getDefaultValue();
            String stringValue = defaultValue.getStringValue();
            lb.setEnabled(!isReadOnly);
            if (!isReadOnly) {
                lb.addChangeHandler(event -> {
                    int selectedIndex = lb.getSelectedIndex();
                    if (selectedIndex < 0) {
                        return;
                    }
                    DTCellValue52 editedDefaultValue = defaultValue.cloneDefaultValueCell();
                    editedDefaultValue.setStringValue(lb.getValue(selectedIndex));
                    defaultValueChangedEventHandler.onDefaultValueChanged(new DefaultValueChangedEvent(defaultValue, editedDefaultValue));
                });
            }
            if (stringValue == null || stringValue.isEmpty()) {
                lb.setSelectedIndex(1);
                defaultValue.setStringValue((String)RuleAttributeWidget.DIALECTS.get(1));
            } else if (stringValue.equals(RuleAttributeWidget.DIALECTS.get(0))) {
                lb.setSelectedIndex(0);
            } else if (stringValue.equals(RuleAttributeWidget.DIALECTS.get(1))) {
                lb.setSelectedIndex(1);
            } else {
                lb.setSelectedIndex(1);
                defaultValue.setStringValue((String)RuleAttributeWidget.DIALECTS.get(1));
            }
            editor = lb;
        } else if (Objects.equals(attribute, Attribute.SALIENCE.getAttributeName())) {
            TextBox tb = TextBoxFactory.getTextBox((String)"Integer");
            if (ac.getDefaultValue() == null) {
                ac.setDefaultValue(new DTCellValue52(Integer.valueOf(0)));
            } else {
                DefaultValueWidgetFactory.assertIntegerDefaultValue(ac.getDefaultValue());
            }
            DTCellValue52 defaultValue = ac.getDefaultValue();
            Integer numericValue = (Integer)defaultValue.getNumericValue();
            tb.setValue((Object)(numericValue == null ? "" : numericValue.toString()));
            tb.setEnabled(!isReadOnly);
            if (!isReadOnly) {
                tb.addValueChangeHandler(event -> {
                    DTCellValue52 editedDefaultValue = defaultValue.cloneDefaultValueCell();
                    try {
                        editedDefaultValue.setNumericValue(Integer.valueOf((String)event.getValue()));
                    }
                    catch (NumberFormatException nfe) {
                        editedDefaultValue.setNumericValue(Integer.valueOf(0));
                        tb.setValue((Object)"0");
                    }
                    finally {
                        defaultValueChangedEventHandler.onDefaultValueChanged(new DefaultValueChangedEvent(defaultValue, editedDefaultValue));
                    }
                });
            }
            editor = tb;
        } else if (Objects.equals(attribute, Attribute.DURATION.getAttributeName())) {
            TextBox tb = TextBoxFactory.getTextBox((String)"Long");
            if (ac.getDefaultValue() == null) {
                ac.setDefaultValue(new DTCellValue52(Long.valueOf(0L)));
            } else {
                DefaultValueWidgetFactory.assertLongDefaultValue(ac.getDefaultValue());
            }
            DTCellValue52 defaultValue = ac.getDefaultValue();
            Long numericValue = (Long)defaultValue.getNumericValue();
            tb.setValue((Object)(numericValue == null ? "" : numericValue.toString()));
            tb.setEnabled(!isReadOnly);
            if (!isReadOnly) {
                tb.addValueChangeHandler(event -> {
                    DTCellValue52 editedDefaultValue = defaultValue.cloneDefaultValueCell();
                    try {
                        editedDefaultValue.setNumericValue(Long.valueOf((String)event.getValue()));
                    }
                    catch (NumberFormatException nfe) {
                        editedDefaultValue.setNumericValue(Long.valueOf(0L));
                        tb.setValue((Object)"0");
                    }
                    finally {
                        defaultValueChangedEventHandler.onDefaultValueChanged(new DefaultValueChangedEvent(defaultValue, editedDefaultValue));
                    }
                });
            }
            editor = tb;
        } else if (Objects.equals(Attribute.getAttributeDataType((String)attribute), "String")) {
            TextBox tb = TextBoxFactory.getTextBox((String)"String");
            if (ac.getDefaultValue() == null) {
                ac.setDefaultValue(new DTCellValue52(""));
            }
            DTCellValue52 defaultValue = ac.getDefaultValue();
            tb.setValue((Object)defaultValue.getStringValue());
            tb.setEnabled(!isReadOnly);
            if (!isReadOnly) {
                tb.addValueChangeHandler(event -> {
                    DTCellValue52 editedDefaultValue = defaultValue.cloneDefaultValueCell();
                    editedDefaultValue.setStringValue(tb.getValue());
                    defaultValueChangedEventHandler.onDefaultValueChanged(new DefaultValueChangedEvent(defaultValue, editedDefaultValue));
                });
            }
            editor = tb;
        } else if (Objects.equals(Attribute.getAttributeDataType((String)attribute), "Boolean")) {
            CheckBox cb = new CheckBox();
            if (ac.getDefaultValue() == null) {
                ac.setDefaultValue(new DTCellValue52(Boolean.FALSE));
            } else {
                DefaultValueWidgetFactory.assertBooleanDefaultValue(ac.getDefaultValue());
            }
            DTCellValue52 defaultValue = ac.getDefaultValue();
            Boolean booleanValue = defaultValue.getBooleanValue();
            cb.setEnabled(!isReadOnly);
            if (booleanValue == null) {
                cb.setValue(Boolean.valueOf(false));
                defaultValue.setBooleanValue(Boolean.FALSE);
            } else {
                cb.setValue(booleanValue);
            }
            cb.addClickHandler(event -> {
                DTCellValue52 editedDefaultValue = defaultValue.cloneDefaultValueCell();
                editedDefaultValue.setBooleanValue(cb.getValue());
                defaultValueChangedEventHandler.onDefaultValueChanged(new DefaultValueChangedEvent(defaultValue, editedDefaultValue));
            });
            editor = cb;
        } else if (Objects.equals(Attribute.getAttributeDataType((String)attribute), "Date")) {
            if (ac.getDefaultValue() == null) {
                ac.setDefaultValue(new DTCellValue52(new Date()));
            } else {
                DefaultValueWidgetFactory.assertDateDefaultValue(ac.getDefaultValue());
            }
            DTCellValue52 defaultValue = ac.getDefaultValue();
            if (isReadOnly) {
                TextBox tb = TextBoxFactory.getTextBox((String)"String");
                tb.setValue((Object)format.format(defaultValue.getDateValue()));
                tb.setEnabled(false);
            } else {
                DatePicker datePicker = new DatePicker();
                datePicker.addChangeDateHandler(event -> {
                    DTCellValue52 editedDefaultValue = defaultValue.cloneDefaultValueCell();
                    editedDefaultValue.setDateValue(datePicker.getValue());
                    defaultValueChangedEventHandler.onDefaultValueChanged(new DefaultValueChangedEvent(defaultValue, editedDefaultValue));
                });
                Date dateValue = defaultValue.getDateValue();
                datePicker.setFormat(DATE_FORMAT);
                datePicker.setValue(dateValue);
                editor = datePicker;
            }
        }
        return editor;
    }

    private static void assertIntegerDefaultValue(DTCellValue52 dcv) {
        if (dcv.getNumericValue() == null) {
            try {
                dcv.setNumericValue(Integer.valueOf(dcv.getStringValue()));
            }
            catch (NumberFormatException nfe) {
                dcv.setNumericValue(Integer.valueOf(0));
            }
        }
    }

    private static void assertLongDefaultValue(DTCellValue52 dcv) {
        if (dcv.getNumericValue() == null) {
            try {
                dcv.setNumericValue(Long.valueOf(dcv.getStringValue()));
            }
            catch (NumberFormatException nfe) {
                dcv.setNumericValue(Long.valueOf(0L));
            }
        }
    }

    private static void assertBooleanDefaultValue(DTCellValue52 dcv) {
        if (dcv.getBooleanValue() == null) {
            dcv.setBooleanValue(Boolean.valueOf(dcv.getStringValue()));
        }
    }

    private static void assertDateDefaultValue(DTCellValue52 dcv) {
        if (dcv.getDateValue() == null) {
            try {
                dcv.setDateValue(format.parse(dcv.getStringValue()));
            }
            catch (IllegalArgumentException eae) {
                dcv.setDateValue(new Date());
            }
        }
    }

    public static class DefaultValueChangedEvent {
        private final DTCellValue52 originalDefaultValue;
        private final DTCellValue52 editedDefaultValue;

        public DefaultValueChangedEvent(DTCellValue52 originalDefaultValue, DTCellValue52 editedDefaultValue) {
            this.originalDefaultValue = originalDefaultValue;
            this.editedDefaultValue = editedDefaultValue;
        }

        public DTCellValue52 getOriginalDefaultValue() {
            return this.originalDefaultValue;
        }

        public DTCellValue52 getEditedDefaultValue() {
            return this.editedDefaultValue;
        }
    }

    public static interface DefaultValueChangedEventHandler {
        public void onDefaultValueChanged(DefaultValueChangedEvent var1);
    }
}

