/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.table.model.converters.cell.impl;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import org.drools.workbench.models.guided.dtable.shared.model.BaseColumn;
import org.drools.workbench.models.guided.dtable.shared.model.DTCellValue52;
import org.drools.workbench.screens.guided.dtable.client.widget.table.model.GuidedDecisionTableUiCell;
import org.drools.workbench.screens.guided.dtable.client.widget.table.model.converters.cell.GridWidgetCellFactory;
import org.drools.workbench.screens.guided.dtable.client.widget.table.utilities.CellUtilities;
import org.drools.workbench.screens.guided.dtable.client.widget.table.utilities.ColumnUtilities;
import org.kie.soup.project.datamodel.oracle.DataType;

public class GridWidgetCellFactoryImpl
implements GridWidgetCellFactory {
    @Override
    public GuidedDecisionTableUiCell convertCell(DTCellValue52 cell, BaseColumn column, CellUtilities cellUtilities, ColumnUtilities columnUtilities) {
        if (!cell.hasValue()) {
            return null;
        }
        DataType.DataTypes dataType = columnUtilities.getDataType(column);
        cellUtilities.convertDTCellValueType(dataType, cell);
        switch (dataType) {
            case NUMERIC: {
                return new GuidedDecisionTableUiCell<BigDecimal>(cellUtilities.convertToBigDecimal(cell), cell.isOtherwise());
            }
            case NUMERIC_BIGDECIMAL: {
                return new GuidedDecisionTableUiCell<BigDecimal>(cellUtilities.convertToBigDecimal(cell), cell.isOtherwise());
            }
            case NUMERIC_BIGINTEGER: {
                return new GuidedDecisionTableUiCell<BigInteger>(cellUtilities.convertToBigInteger(cell), cell.isOtherwise());
            }
            case NUMERIC_BYTE: {
                return new GuidedDecisionTableUiCell<Byte>(cellUtilities.convertToByte(cell), cell.isOtherwise());
            }
            case NUMERIC_DOUBLE: {
                return new GuidedDecisionTableUiCell<Double>(cellUtilities.convertToDouble(cell), cell.isOtherwise());
            }
            case NUMERIC_FLOAT: {
                return new GuidedDecisionTableUiCell<Float>(cellUtilities.convertToFloat(cell), cell.isOtherwise());
            }
            case NUMERIC_INTEGER: {
                return new GuidedDecisionTableUiCell<Integer>(cellUtilities.convertToInteger(cell), cell.isOtherwise());
            }
            case NUMERIC_LONG: {
                return new GuidedDecisionTableUiCell<Long>(cellUtilities.convertToLong(cell), cell.isOtherwise());
            }
            case NUMERIC_SHORT: {
                return new GuidedDecisionTableUiCell<Short>(cellUtilities.convertToShort(cell), cell.isOtherwise());
            }
            case DATE: {
                return new GuidedDecisionTableUiCell<Date>(cellUtilities.convertToDate(cell), cell.isOtherwise());
            }
            case BOOLEAN: {
                return new GuidedDecisionTableUiCell<Boolean>(cellUtilities.convertToBoolean(cell), cell.isOtherwise());
            }
        }
        return new GuidedDecisionTableUiCell<String>(cellUtilities.convertToString(cell), cell.isOtherwise());
    }
}

