/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.table.model.synchronizers.impl;

import com.google.gwt.event.shared.GwtEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.enterprise.context.Dependent;
import org.drools.workbench.models.datamodel.rule.IPattern;
import org.drools.workbench.models.datamodel.rule.RuleModel;
import org.drools.workbench.models.guided.dtable.shared.model.BRLConditionColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BRLConditionVariableColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BaseColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BaseColumnFieldDiff;
import org.drools.workbench.models.guided.dtable.shared.model.DTCellValue52;
import org.drools.workbench.screens.guided.dtable.client.widget.table.events.gwt.BoundFactsChangedEvent;
import org.drools.workbench.screens.guided.dtable.client.widget.table.model.synchronizers.ModelSynchronizer;
import org.drools.workbench.screens.guided.dtable.client.widget.table.model.synchronizers.Synchronizer;
import org.drools.workbench.screens.guided.dtable.client.widget.table.model.synchronizers.impl.BaseColumnSynchronizer;
import org.drools.workbench.screens.guided.dtable.client.widget.table.model.synchronizers.impl.BaseSynchronizer;

@Dependent
public class BRLConditionColumnSynchronizer
extends BaseColumnSynchronizer<BaseColumnSynchronizer.ColumnMetaData, BaseColumnSynchronizer.ColumnMetaData, BaseColumnSynchronizer.ColumnMetaData> {
    @Override
    public int priority() {
        return 3;
    }

    @Override
    public boolean handlesAppend(Synchronizer.MetaData metaData) throws ModelSynchronizer.VetoException {
        return this.handlesUpdate(metaData);
    }

    @Override
    public void append(BaseColumnSynchronizer.ColumnMetaData metaData) throws ModelSynchronizer.VetoException {
        if (!this.handlesAppend(metaData)) {
            return;
        }
        BRLConditionColumn column = (BRLConditionColumn)metaData.getColumn();
        this.model.getConditions().add(column);
        for (BRLConditionVariableColumn childModelColumn : column.getChildColumns()) {
            this.synchroniseAppendColumn((BaseColumn)childModelColumn);
        }
    }

    @Override
    public boolean handlesUpdate(Synchronizer.MetaData metaData) throws ModelSynchronizer.VetoException {
        if (!(metaData instanceof BaseColumnSynchronizer.ColumnMetaData)) {
            return false;
        }
        return ((BaseColumnSynchronizer.ColumnMetaData)metaData).getColumn() instanceof BRLConditionColumn;
    }

    @Override
    public List<BaseColumnFieldDiff> update(BaseColumnSynchronizer.ColumnMetaData originalMetaData, BaseColumnSynchronizer.ColumnMetaData editedMetaData) throws ModelSynchronizer.VetoException {
        ArrayList<DTCellValue52> originalColumnData;
        if (!this.handlesUpdate(originalMetaData) || !this.handlesUpdate(editedMetaData)) {
            return Collections.emptyList();
        }
        BRLConditionColumn originalColumn = (BRLConditionColumn)originalMetaData.getColumn();
        BRLConditionColumn editedColumn = (BRLConditionColumn)editedMetaData.getColumn();
        Set<String> originalBindings = this.getPatternBindings(originalColumn);
        Set<String> editedBindings = this.getPatternBindings(editedColumn);
        originalBindings.removeAll(editedBindings);
        for (String binding : originalBindings) {
            if (!this.rm.isBoundFactUsed(binding)) continue;
            throw new ModelSynchronizer.VetoUpdatePatternInUseException();
        }
        List diffs = originalColumn.diff((BaseColumn)editedColumn);
        HashMap originalColumnsData = new HashMap();
        for (BRLConditionVariableColumn variable : originalColumn.getChildColumns()) {
            int iColumnIndex = this.model.getExpandedColumns().indexOf(variable);
            originalColumnData = new ArrayList();
            String key = this.makeUpdateBRLConditionColumnKey(variable);
            for (List row : this.model.getData()) {
                originalColumnData.add((DTCellValue52)row.get(iColumnIndex));
            }
            originalColumnsData.put(key, originalColumnData);
        }
        this.model.getConditions().add(this.model.getConditions().indexOf(originalColumn), editedColumn);
        for (BRLConditionVariableColumn childModelColumn : editedColumn.getChildColumns()) {
            String key = this.makeUpdateBRLConditionColumnKey(childModelColumn);
            if (originalColumnsData.containsKey(key)) {
                originalColumnData = (List)originalColumnsData.get(key);
                this.synchroniseAppendColumn((BaseColumn)childModelColumn, originalColumnData);
                continue;
            }
            this.synchroniseAppendColumn((BaseColumn)childModelColumn);
        }
        this.doDelete(originalColumn);
        BoundFactsChangedEvent pce = new BoundFactsChangedEvent(this.rm.getLHSBoundFacts());
        this.eventBus.fireEvent((GwtEvent)pce);
        return diffs;
    }

    @Override
    public boolean handlesDelete(Synchronizer.MetaData metaData) throws ModelSynchronizer.VetoException {
        if (!(metaData instanceof BaseColumnSynchronizer.ColumnMetaData)) {
            return false;
        }
        return ((BaseColumnSynchronizer.ColumnMetaData)metaData).getColumn() instanceof BRLConditionColumn;
    }

    @Override
    public void delete(BaseColumnSynchronizer.ColumnMetaData metaData) throws ModelSynchronizer.VetoException {
        if (!this.handlesDelete(metaData)) {
            return;
        }
        BRLConditionColumn column = (BRLConditionColumn)metaData.getColumn();
        Set<String> bindings = this.getPatternBindings(column);
        for (String binding : bindings) {
            if (!this.rm.isBoundFactUsed(binding)) continue;
            throw new ModelSynchronizer.VetoDeletePatternInUseException();
        }
        this.doDelete(column);
    }

    private void doDelete(BRLConditionColumn column) throws ModelSynchronizer.VetoException {
        if (column.getChildColumns().size() > 0) {
            int iFirstColumnIndex = this.model.getExpandedColumns().indexOf(column.getChildColumns().get(0));
            for (int iColumnIndex = 0; iColumnIndex < column.getChildColumns().size(); ++iColumnIndex) {
                this.synchroniseDeleteColumn(iFirstColumnIndex);
            }
        }
        this.model.getConditions().remove(column);
    }

    @Override
    public boolean handlesMoveColumnsTo(List<? extends Synchronizer.MetaData> metaData) throws ModelSynchronizer.VetoException {
        return this.isBRLFragment(metaData);
    }

    private boolean isBRLFragment(List<? extends Synchronizer.MetaData> metaData) {
        if (!metaData.stream().allMatch(c -> c instanceof BaseSynchronizer.MoveColumnToMetaData)) {
            return false;
        }
        if (!metaData.stream().allMatch(c -> ((BaseSynchronizer.MoveColumnToMetaData)c).getColumn() instanceof BRLConditionVariableColumn)) {
            return false;
        }
        BaseSynchronizer.MoveColumnToMetaData md = (BaseSynchronizer.MoveColumnToMetaData)metaData.get(0);
        BRLConditionVariableColumn srcModelColumn = (BRLConditionVariableColumn)md.getColumn();
        BRLConditionColumn srcModelPattern = this.model.getBRLColumn(srcModelColumn);
        return srcModelPattern.getChildColumns().size() == metaData.size();
    }

    @Override
    public void moveColumnsTo(List<BaseSynchronizer.MoveColumnToMetaData> metaData) throws ModelSynchronizer.VetoException {
        if (!this.handlesMoveColumnsTo(metaData)) {
            return;
        }
        if (!this.isBRLFragment(metaData)) {
            throw new ModelSynchronizer.MoveVetoException();
        }
        this.doMoveBRLFragment(metaData);
    }

    private void doMoveBRLFragment(List<BaseSynchronizer.MoveColumnToMetaData> metaData) throws ModelSynchronizer.VetoException {
        BaseSynchronizer.MoveColumnToMetaData md = metaData.get(0);
        BRLConditionVariableColumn srcModelColumn = (BRLConditionVariableColumn)md.getColumn();
        BRLConditionColumn srcModelBRLFragment = this.model.getBRLColumn(srcModelColumn);
        if (srcModelBRLFragment == null) {
            throw new ModelSynchronizer.MoveVetoException();
        }
        List srcModelBRLFragmentColumns = srcModelBRLFragment.getChildColumns();
        int srcModelPatternConditionColumnCount = srcModelBRLFragmentColumns.size();
        if (srcModelPatternConditionColumnCount == 0) {
            throw new ModelSynchronizer.MoveVetoException();
        }
        if (srcModelPatternConditionColumnCount != metaData.size()) {
            throw new ModelSynchronizer.MoveVetoException();
        }
        int tgtColumnIndex = md.getTargetColumnIndex();
        int tgtPatternIndex = this.findTargetPatternIndex(md);
        List allModelColumns = this.model.getExpandedColumns();
        this.moveModelData(tgtColumnIndex, allModelColumns.indexOf(srcModelBRLFragmentColumns.get(0)), allModelColumns.indexOf(srcModelBRLFragmentColumns.get(0)) + srcModelPatternConditionColumnCount - 1);
        this.model.getConditions().remove(srcModelBRLFragment);
        this.model.getConditions().add(tgtPatternIndex, srcModelBRLFragment);
    }

    private String makeUpdateBRLConditionColumnKey(BRLConditionVariableColumn variable) {
        StringBuilder key = new StringBuilder(variable.getVarName()).append(":").append(variable.getFieldType()).append(":").append(variable.getFactField()).append(":").append(variable.getFactType());
        return key.toString();
    }

    private Set<String> getPatternBindings(BRLConditionColumn column) {
        HashSet<String> bindings = new HashSet<String>();
        List definition = column.getDefinition();
        RuleModel rm = new RuleModel();
        rm.lhs = definition.toArray(new IPattern[definition.size()]);
        bindings.addAll(rm.getLHSVariables(true, true));
        return bindings;
    }
}

