/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.table.model.synchronizers.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.drools.workbench.models.guided.dtable.shared.model.ActionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.BRLActionColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BaseColumn;
import org.drools.workbench.models.guided.dtable.shared.model.CompositeColumn;
import org.drools.workbench.models.guided.dtable.shared.model.DTCellValue52;
import org.drools.workbench.screens.guided.dtable.client.widget.table.model.synchronizers.ModelSynchronizer;
import org.drools.workbench.screens.guided.dtable.client.widget.table.model.synchronizers.Synchronizer;
import org.drools.workbench.screens.guided.dtable.client.widget.table.model.synchronizers.impl.BaseSynchronizer;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.uberfire.ext.wires.core.grids.client.model.GridCellValue;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;

public abstract class BaseColumnSynchronizer<A extends ColumnMetaData, U extends ColumnMetaData, D extends ColumnMetaData>
extends BaseSynchronizer<A, U, D> {
    @Override
    public boolean handlesInsert(Synchronizer.MetaData metaData) throws ModelSynchronizer.VetoException {
        return false;
    }

    @Override
    public void insert(A metaData) throws ModelSynchronizer.VetoException {
    }

    protected void synchroniseAppendColumn(BaseColumn modelColumn) {
        int columnIndex = this.model.getExpandedColumns().indexOf(modelColumn);
        GridColumn<?> uiModelColumn = this.gridWidgetColumnFactory.convertColumn(modelColumn, this.access, this.view);
        this.uiModel.insertColumn(columnIndex, uiModelColumn);
        for (int rowIndex = 0; rowIndex < this.model.getData().size(); ++rowIndex) {
            DTCellValue52 modelCell = this.makeModelCellValue(modelColumn);
            List modelRow = (List)this.model.getData().get(rowIndex);
            modelRow.add(columnIndex, modelCell);
            if (!modelCell.hasValue()) continue;
            this.uiModel.setCellValueInternal(rowIndex, columnIndex, (GridCellValue<?>)this.gridWidgetCellFactory.convertCell(modelCell, modelColumn, this.cellUtilities, this.columnUtilities));
        }
        this.uiModel.indexColumn(columnIndex);
    }

    protected void synchroniseAppendColumn(BaseColumn modelColumn, List<DTCellValue52> originalColumnData) {
        int columnIndex = this.model.getExpandedColumns().indexOf(modelColumn);
        GridColumn<?> uiModelColumn = this.gridWidgetColumnFactory.convertColumn(modelColumn, this.access, this.view);
        this.uiModel.insertColumn(columnIndex, uiModelColumn);
        for (int rowIndex = 0; rowIndex < this.model.getData().size(); ++rowIndex) {
            DTCellValue52 modelCell = originalColumnData.get(rowIndex);
            List modelRow = (List)this.model.getData().get(rowIndex);
            modelRow.add(columnIndex, modelCell);
            if (!modelCell.hasValue()) continue;
            this.uiModel.setCellValueInternal(rowIndex, columnIndex, (GridCellValue<?>)this.gridWidgetCellFactory.convertCell(modelCell, modelColumn, this.cellUtilities, this.columnUtilities));
        }
        this.uiModel.indexColumn(columnIndex);
    }

    protected void synchroniseUpdateColumn(BaseColumn modelColumn) {
        int columnIndex = this.model.getExpandedColumns().indexOf(modelColumn);
        GridColumn<?> uiModelColumn = this.gridWidgetColumnFactory.convertColumn(modelColumn, this.access, this.view);
        this.uiModel.updateColumn(columnIndex, uiModelColumn);
        for (int rowIndex = 0; rowIndex < this.model.getData().size(); ++rowIndex) {
            List modelRow = (List)this.model.getData().get(rowIndex);
            DTCellValue52 modelCell = (DTCellValue52)modelRow.get(columnIndex);
            if (!modelCell.hasValue()) continue;
            this.uiModel.setCellValueInternal(rowIndex, columnIndex, (GridCellValue<?>)this.gridWidgetCellFactory.convertCell(modelCell, modelColumn, this.cellUtilities, this.columnUtilities));
        }
        this.uiModel.indexColumn(columnIndex);
    }

    protected void synchroniseDeleteColumn(int columnIndex) {
        for (int rowIndex = 0; rowIndex < this.model.getData().size(); ++rowIndex) {
            List modelRow = (List)this.model.getData().get(rowIndex);
            modelRow.remove(columnIndex);
        }
        GridColumn uiModelColumn = (GridColumn)this.uiModel.getColumns().get(columnIndex);
        this.uiModel.deleteColumn(uiModelColumn);
    }

    protected void setColumnVisibility(BaseColumn modelColumn, boolean isHidden) {
        modelColumn.setHideColumn(isHidden);
        int iModelColumn = this.model.getExpandedColumns().indexOf(modelColumn);
        ((GridColumn)this.uiModel.getColumns().get(iModelColumn)).setVisible(!isHidden);
    }

    protected void setColumnHeader(BaseColumn modelColumn, String header) {
        modelColumn.setHeader(header);
        int iModelColumn = this.model.getExpandedColumns().indexOf(modelColumn);
        ((GridColumn.HeaderMetaData)((GridColumn)this.uiModel.getColumns().get(iModelColumn)).getHeaderMetaData().get(0)).setTitle(header);
    }

    protected void clearColumnData(BaseColumn column) {
        int columnIndex = this.model.getExpandedColumns().indexOf(column);
        for (List row : this.model.getData()) {
            DTCellValue52 dcv = (DTCellValue52)row.get(columnIndex);
            dcv.clearValues();
        }
    }

    protected void updateCellsForOptionValueList(BaseColumn originalColumn, BaseColumn editedColumn) {
        List<String> values = Arrays.asList(this.columnUtilities.getValueList(editedColumn));
        boolean clearExistingValues = values.size() > 0;
        int columnIndex = this.model.getExpandedColumns().indexOf(originalColumn);
        for (List row : this.model.getData()) {
            DTCellValue52 dcv = (DTCellValue52)row.get(columnIndex);
            if (!clearExistingValues || values.contains(dcv.getStringValue())) continue;
            dcv.clearValues();
        }
    }

    protected int findTargetPatternIndex(BaseSynchronizer.MoveColumnToMetaData md) throws ModelSynchronizer.MoveVetoException {
        int tgtPatternIndex = -1;
        int tgtColumnIndex = md.getTargetColumnIndex();
        List allModelColumns = this.model.getExpandedColumns();
        List allModelConditions = this.model.getConditions();
        for (int patternIndex = 0; patternIndex < allModelConditions.size(); ++patternIndex) {
            CompositeColumn cc = (CompositeColumn)allModelConditions.get(patternIndex);
            List children = cc.getChildColumns();
            if (children == null || children.isEmpty()) continue;
            BaseColumn firstChild = (BaseColumn)children.get(0);
            BaseColumn lastChild = (BaseColumn)children.get(children.size() - 1);
            int firstChildIndex = allModelColumns.indexOf(firstChild);
            int lastChildIndex = allModelColumns.indexOf(lastChild);
            if (tgtColumnIndex < firstChildIndex || tgtColumnIndex > lastChildIndex) continue;
            tgtPatternIndex = patternIndex;
            break;
        }
        if (tgtPatternIndex < 0) {
            throw new ModelSynchronizer.MoveVetoException();
        }
        return tgtPatternIndex;
    }

    protected int findTargetActionIndex(BaseSynchronizer.MoveColumnToMetaData md) throws ModelSynchronizer.MoveVetoException {
        int tgtActionIndex = -1;
        int tgtColumnIndex = md.getTargetColumnIndex();
        List allModelColumns = this.model.getExpandedColumns();
        List allModelActions = this.model.getActionCols();
        for (int actionIndex = 0; actionIndex < allModelActions.size(); ++actionIndex) {
            ActionCol52 ac = (ActionCol52)allModelActions.get(actionIndex);
            List<ActionCol52> children = this.getChildren(ac);
            if (children == null || children.isEmpty()) continue;
            BaseColumn firstChild = (BaseColumn)children.get(0);
            BaseColumn lastChild = (BaseColumn)children.get(children.size() - 1);
            int firstChildIndex = allModelColumns.indexOf(firstChild);
            int lastChildIndex = allModelColumns.indexOf(lastChild);
            if (tgtColumnIndex < firstChildIndex || tgtColumnIndex > lastChildIndex) continue;
            tgtActionIndex = actionIndex;
            break;
        }
        if (tgtActionIndex < 0) {
            throw new ModelSynchronizer.MoveVetoException();
        }
        return tgtActionIndex;
    }

    protected List<ActionCol52> getChildren(ActionCol52 ac) {
        ArrayList<ActionCol52> children = new ArrayList<ActionCol52>();
        if (ac instanceof BRLActionColumn) {
            children.addAll(((BRLActionColumn)ac).getChildColumns());
        } else {
            children.add(ac);
        }
        return children;
    }

    public static class ColumnMetaDataImpl
    implements ColumnMetaData<BaseColumn> {
        private final BaseColumn column;

        public ColumnMetaDataImpl(BaseColumn column) {
            this.column = (BaseColumn)PortablePreconditions.checkNotNull((String)"column", (Object)column);
        }

        @Override
        public BaseColumn getColumn() {
            return this.column;
        }
    }

    public static interface ColumnMetaData<C extends BaseColumn>
    extends Synchronizer.MetaData {
        public C getColumn();
    }
}

