/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.table.utilities;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.drools.workbench.models.datamodel.rule.IAction;
import org.drools.workbench.models.datamodel.rule.IPattern;
import org.drools.workbench.models.datamodel.rule.RuleModel;
import org.drools.workbench.models.guided.dtable.shared.model.ActionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.ActionInsertFactCol52;
import org.drools.workbench.models.guided.dtable.shared.model.ActionSetFieldCol52;
import org.drools.workbench.models.guided.dtable.shared.model.BRLActionColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BRLActionVariableColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BRLConditionColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BRLConditionVariableColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BaseColumn;
import org.drools.workbench.models.guided.dtable.shared.model.ConditionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.DTCellValue52;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.models.guided.dtable.shared.model.Pattern52;
import org.drools.workbench.screens.guided.dtable.client.widget.table.utilities.CellUtilities;
import org.drools.workbench.screens.guided.template.client.editor.RuleModelPeerVariableVisitor;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracle;
import org.kie.workbench.common.widgets.decoratedgrid.client.widget.DropDownDataValueMapProvider;

public class DependentEnumsUtilities
implements DropDownDataValueMapProvider<Context> {
    private final GuidedDecisionTable52 model;
    private final AsyncPackageDataModelOracle oracle;
    private final CellUtilities cellUtilities;

    public DependentEnumsUtilities(GuidedDecisionTable52 model, AsyncPackageDataModelOracle oracle) {
        this.model = (GuidedDecisionTable52)PortablePreconditions.checkNotNull((String)"model", (Object)model);
        this.oracle = (AsyncPackageDataModelOracle)PortablePreconditions.checkNotNull((String)"oracle", (Object)oracle);
        this.cellUtilities = new CellUtilities();
    }

    public Map<String, String> getCurrentValueMap(Context context) {
        HashMap<String, String> currentValueMap;
        block14: {
            BaseColumn baseColumn;
            List allColumns;
            List rowData;
            block17: {
                block16: {
                    block15: {
                        block13: {
                            currentValueMap = new HashMap<String, String>();
                            int iBaseRowIndex = context.getRowIndex();
                            int iBaseColIndex = context.getColumnIndex();
                            rowData = (List)this.model.getData().get(iBaseRowIndex);
                            allColumns = this.model.getExpandedColumns();
                            baseColumn = (BaseColumn)allColumns.get(iBaseColIndex);
                            if (!(baseColumn instanceof BRLConditionVariableColumn)) break block13;
                            BRLConditionVariableColumn baseBRLConditionColumn = (BRLConditionVariableColumn)baseColumn;
                            BRLConditionColumn brl = this.model.getBRLColumn(baseBRLConditionColumn);
                            RuleModel rm = new RuleModel();
                            IPattern[] lhs = new IPattern[brl.getDefinition().size()];
                            brl.getDefinition().toArray(lhs);
                            rm.lhs = lhs;
                            RuleModelPeerVariableVisitor peerVariableVisitor = new RuleModelPeerVariableVisitor(rm, baseBRLConditionColumn.getVarName());
                            List peerVariables = peerVariableVisitor.getPeerVariables();
                            for (RuleModelPeerVariableVisitor.ValueHolder valueHolder : peerVariables) {
                                switch (valueHolder.getType()) {
                                    case TEMPLATE_KEY: {
                                        BRLConditionVariableColumn vc = this.getConditionVariableColumnIndex(brl.getChildColumns(), valueHolder.getValue());
                                        int iCol = allColumns.indexOf(vc);
                                        DTCellValue52 dcv = (DTCellValue52)rowData.get(iCol);
                                        String field = vc.getFactField();
                                        currentValueMap.put(field, this.cellUtilities.asString(dcv));
                                        break;
                                    }
                                    case VALUE: {
                                        currentValueMap.put(valueHolder.getFieldName(), valueHolder.getValue());
                                    }
                                }
                            }
                            break block14;
                        }
                        if (!(baseColumn instanceof BRLActionVariableColumn)) break block15;
                        BRLActionVariableColumn baseBRLActionColumn = (BRLActionVariableColumn)baseColumn;
                        BRLActionColumn brl = this.model.getBRLColumn(baseBRLActionColumn);
                        RuleModel rm = new RuleModel();
                        IAction[] rhs = new IAction[brl.getDefinition().size()];
                        brl.getDefinition().toArray(rhs);
                        rm.rhs = rhs;
                        RuleModelPeerVariableVisitor peerVariableVisitor = new RuleModelPeerVariableVisitor(rm, baseBRLActionColumn.getVarName());
                        List peerVariables = peerVariableVisitor.getPeerVariables();
                        for (RuleModelPeerVariableVisitor.ValueHolder valueHolder : peerVariables) {
                            switch (valueHolder.getType()) {
                                case TEMPLATE_KEY: {
                                    BRLActionVariableColumn vc = this.getActionVariableColumnIndex(brl.getChildColumns(), valueHolder.getValue());
                                    int iCol = allColumns.indexOf(vc);
                                    DTCellValue52 dcv = (DTCellValue52)rowData.get(iCol);
                                    String field = vc.getFactField();
                                    currentValueMap.put(field, this.cellUtilities.asString(dcv));
                                    break;
                                }
                                case VALUE: {
                                    currentValueMap.put(valueHolder.getFieldName(), valueHolder.getValue());
                                }
                            }
                        }
                        break block14;
                    }
                    if (!(baseColumn instanceof ConditionCol52)) break block16;
                    ConditionCol52 baseConditionColumn = (ConditionCol52)baseColumn;
                    Pattern52 basePattern = this.model.getPattern(baseConditionColumn);
                    for (ConditionCol52 cc : basePattern.getChildColumns()) {
                        int iCol = allColumns.indexOf(cc);
                        DTCellValue52 dcv = (DTCellValue52)rowData.get(iCol);
                        currentValueMap.put(cc.getFactField(), this.cellUtilities.asString(dcv));
                    }
                    break block14;
                }
                if (!(baseColumn instanceof ActionSetFieldCol52)) break block17;
                ActionSetFieldCol52 baseActionColumn = (ActionSetFieldCol52)baseColumn;
                String binding = baseActionColumn.getBoundName();
                for (ActionCol52 ac : this.model.getActionCols()) {
                    ActionSetFieldCol52 asf;
                    if (!(ac instanceof ActionSetFieldCol52) || !(asf = (ActionSetFieldCol52)ac).getBoundName().equals(binding)) continue;
                    int iCol = allColumns.indexOf(asf);
                    DTCellValue52 dcv = (DTCellValue52)rowData.get(iCol);
                    currentValueMap.put(asf.getFactField(), this.cellUtilities.asString(dcv));
                }
                break block14;
            }
            if (!(baseColumn instanceof ActionInsertFactCol52)) break block14;
            ActionInsertFactCol52 baseActionColumn = (ActionInsertFactCol52)baseColumn;
            String binding = baseActionColumn.getBoundName();
            for (ActionCol52 ac : this.model.getActionCols()) {
                ActionInsertFactCol52 aif;
                if (!(ac instanceof ActionInsertFactCol52) || !(aif = (ActionInsertFactCol52)ac).getBoundName().equals(binding)) continue;
                int iCol = allColumns.indexOf(aif);
                DTCellValue52 dcv = (DTCellValue52)rowData.get(iCol);
                currentValueMap.put(aif.getFactField(), this.cellUtilities.asString(dcv));
            }
        }
        return currentValueMap;
    }

    private BRLConditionVariableColumn getConditionVariableColumnIndex(List<BRLConditionVariableColumn> definition, String variableName) {
        for (BRLConditionVariableColumn vc : definition) {
            if (!vc.getVarName().equals(variableName)) continue;
            return vc;
        }
        throw new IllegalArgumentException("Variable '" + variableName + "' not found. This suggests a programming error.");
    }

    private BRLActionVariableColumn getActionVariableColumnIndex(List<BRLActionVariableColumn> definition, String variableName) {
        for (BRLActionVariableColumn ac : definition) {
            if (!ac.getVarName().equals(variableName)) continue;
            return ac;
        }
        throw new IllegalArgumentException("Variable '" + variableName + "' not found. This suggests a programming error.");
    }

    public Set<Integer> getDependentColumnIndexes(Context context) {
        HashSet<Integer> dependentColumnIndexes;
        block12: {
            BaseColumn baseColumn;
            List allColumns;
            block15: {
                block14: {
                    block13: {
                        block11: {
                            int iBaseColIndex = context.getColumnIndex();
                            dependentColumnIndexes = new HashSet<Integer>();
                            allColumns = this.model.getExpandedColumns();
                            baseColumn = (BaseColumn)allColumns.get(iBaseColIndex);
                            if (!(baseColumn instanceof BRLConditionVariableColumn)) break block11;
                            BRLConditionVariableColumn baseBRLConditionColumn = (BRLConditionVariableColumn)baseColumn;
                            BRLConditionColumn brl = this.model.getBRLColumn(baseBRLConditionColumn);
                            RuleModel rm = new RuleModel();
                            IPattern[] lhs = new IPattern[brl.getDefinition().size()];
                            brl.getDefinition().toArray(lhs);
                            rm.lhs = lhs;
                            RuleModelPeerVariableVisitor peerVariableVisitor = new RuleModelPeerVariableVisitor(rm, baseBRLConditionColumn.getVarName());
                            List peerVariables = peerVariableVisitor.getPeerVariables();
                            for (RuleModelPeerVariableVisitor.ValueHolder valueHolder : peerVariables) {
                                switch (valueHolder.getType()) {
                                    case TEMPLATE_KEY: {
                                        if (!this.oracle.isDependentEnum(baseBRLConditionColumn.getFactType(), baseBRLConditionColumn.getFactField(), valueHolder.getFieldName())) break;
                                        BRLConditionVariableColumn vc = this.getConditionVariableColumnIndex(brl.getChildColumns(), valueHolder.getValue());
                                        int iCol = allColumns.indexOf(vc);
                                        dependentColumnIndexes.add(iCol);
                                    }
                                }
                            }
                            break block12;
                        }
                        if (!(baseColumn instanceof BRLActionVariableColumn)) break block13;
                        BRLActionVariableColumn baseBRLActionColumn = (BRLActionVariableColumn)baseColumn;
                        BRLActionColumn brl = this.model.getBRLColumn(baseBRLActionColumn);
                        RuleModel rm = new RuleModel();
                        IAction[] rhs = new IAction[brl.getDefinition().size()];
                        brl.getDefinition().toArray(rhs);
                        rm.rhs = rhs;
                        RuleModelPeerVariableVisitor peerVariableVisitor = new RuleModelPeerVariableVisitor(rm, baseBRLActionColumn.getVarName());
                        List peerVariables = peerVariableVisitor.getPeerVariables();
                        for (RuleModelPeerVariableVisitor.ValueHolder valueHolder : peerVariables) {
                            switch (valueHolder.getType()) {
                                case TEMPLATE_KEY: {
                                    if (!this.oracle.isDependentEnum(baseBRLActionColumn.getFactType(), baseBRLActionColumn.getFactField(), valueHolder.getFieldName())) break;
                                    BRLActionVariableColumn vc = this.getActionVariableColumnIndex(brl.getChildColumns(), valueHolder.getValue());
                                    int iCol = allColumns.indexOf(vc);
                                    dependentColumnIndexes.add(iCol);
                                }
                            }
                        }
                        break block12;
                    }
                    if (!(baseColumn instanceof ConditionCol52)) break block14;
                    ConditionCol52 baseConditionColumn = (ConditionCol52)baseColumn;
                    Pattern52 basePattern = this.model.getPattern(baseConditionColumn);
                    for (ConditionCol52 cc : basePattern.getChildColumns()) {
                        if (!this.oracle.isDependentEnum(basePattern.getFactType(), baseConditionColumn.getFactField(), cc.getFactField())) continue;
                        dependentColumnIndexes.add(allColumns.indexOf(cc));
                    }
                    break block12;
                }
                if (!(baseColumn instanceof ActionSetFieldCol52)) break block15;
                ActionSetFieldCol52 baseActionColumn = (ActionSetFieldCol52)baseColumn;
                Pattern52 basePattern = this.model.getConditionPattern(baseActionColumn.getBoundName());
                String binding = baseActionColumn.getBoundName();
                for (ActionCol52 ac : this.model.getActionCols()) {
                    ActionSetFieldCol52 asf;
                    if (!(ac instanceof ActionSetFieldCol52) || !(asf = (ActionSetFieldCol52)ac).getBoundName().equals(binding) || !this.oracle.isDependentEnum(basePattern.getFactType(), baseActionColumn.getFactField(), asf.getFactField())) continue;
                    dependentColumnIndexes.add(allColumns.indexOf(ac));
                }
                break block12;
            }
            if (!(baseColumn instanceof ActionInsertFactCol52)) break block12;
            ActionInsertFactCol52 baseActionColumn = (ActionInsertFactCol52)baseColumn;
            String binding = baseActionColumn.getBoundName();
            for (ActionCol52 ac : this.model.getActionCols()) {
                ActionInsertFactCol52 aif;
                if (!(ac instanceof ActionInsertFactCol52) || !(aif = (ActionInsertFactCol52)ac).getBoundName().equals(binding) || !this.oracle.isDependentEnum(baseActionColumn.getFactType(), baseActionColumn.getFactField(), aif.getFactField())) continue;
                dependentColumnIndexes.add(allColumns.indexOf(ac));
            }
        }
        return dependentColumnIndexes;
    }

    public static class Context {
        private final int rowIndex;
        private final int columnIndex;

        public Context(int rowIndex, int columnIndex) {
            this.rowIndex = rowIndex;
            this.columnIndex = columnIndex;
        }

        public int getRowIndex() {
            return this.rowIndex;
        }

        public int getColumnIndex() {
            return this.columnIndex;
        }
    }
}

