/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.wizard.column.pages;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.common.BaseDecisionTableColumnPage;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.common.DecisionTableColumnViewUtils;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.plugins.AttributeColumnPlugin;
import org.drools.workbench.screens.guided.rule.client.resources.GuidedRuleEditorResources;
import org.drools.workbench.screens.guided.rule.client.widget.attribute.RuleAttributeWidget;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.uberfire.client.callbacks.Callback;
import org.uberfire.client.mvp.UberElement;

@Dependent
public class AttributeColumnPage
extends BaseDecisionTableColumnPage<AttributeColumnPlugin> {
    private View view;

    @Inject
    public AttributeColumnPage(View view, TranslationService translationService) {
        super(translationService);
        this.view = view;
    }

    public String getTitle() {
        return this.translate("AttributeColumnPage.AddNewAttribute", new Object[0]);
    }

    public void isComplete(Callback<Boolean> callback) {
        boolean hasAttribute = !DecisionTableColumnViewUtils.nil(((AttributeColumnPlugin)this.plugin()).getAttribute());
        callback.callback((Object)hasAttribute);
    }

    @Override
    protected UberElement<?> getView() {
        return this.view;
    }

    public void prepareView() {
        this.view.init(this);
        this.view.setupAttributeList(this.getAttributes());
    }

    List<String> getAttributes() {
        return this.removeAttributesAlreadyAdded(this.rawAttributes());
    }

    private List<String> rawAttributes() {
        return new ArrayList<String>(){
            {
                this.addAll(AttributeColumnPage.this.attributesWithoutChooseAttribute());
            }
        };
    }

    private List<String> attributesWithoutChooseAttribute() {
        List<String> originalAttributes = Arrays.asList(RuleAttributeWidget.getAttributesList());
        ArrayList<String> attributes = new ArrayList<String>(originalAttributes);
        attributes.remove(GuidedRuleEditorResources.CONSTANTS.Choose());
        return attributes;
    }

    private List<String> removeAttributesAlreadyAdded(List<String> attributeList) {
        ArrayList<String> attributes = new ArrayList<String>(attributeList);
        attributes.removeAll(this.presenter.getReservedAttributeNames());
        return attributes;
    }

    void selectItem(String selectedItemText) {
        ((AttributeColumnPlugin)this.plugin()).setAttribute(selectedItemText);
    }

    String selectedAttribute() {
        return ((AttributeColumnPlugin)this.plugin()).getAttribute();
    }

    public static interface View
    extends UberElement<AttributeColumnPage> {
        public void setupAttributeList(List<String> var1);

        public boolean isAttributeDescriptionHidden();

        public void hideAttributeDescription();

        public void showAttributeDescription();
    }
}

