/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.wizard.column.pages;

import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.ListBox;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.drools.workbench.models.datamodel.rule.HasParameterizedOperator;
import org.drools.workbench.models.guided.dtable.shared.model.ConditionCol52;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.common.BaseDecisionTableColumnPage;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.common.DecisionTableColumnViewUtils;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.plugins.ConditionColumnPlugin;
import org.drools.workbench.screens.guided.rule.client.editor.CEPOperatorsDropdown;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracle;
import org.uberfire.client.callbacks.Callback;
import org.uberfire.client.mvp.UberElement;
import org.uberfire.ext.widgets.core.client.wizards.WizardPageStatusChangeEvent;

@Dependent
public class OperatorPage
extends BaseDecisionTableColumnPage<ConditionColumnPlugin> {
    private View view;
    private Event<WizardPageStatusChangeEvent> changeEvent;

    @Inject
    public OperatorPage(View view, Event<WizardPageStatusChangeEvent> changeEvent, TranslationService translationService) {
        super(translationService);
        this.view = view;
        this.changeEvent = changeEvent;
    }

    @Override
    protected UberElement<?> getView() {
        return this.view;
    }

    public String getTitle() {
        return this.translate("OperatorPage.Operator", new Object[0]);
    }

    public void prepareView() {
        this.view.init(this);
        this.setupWarningMessages();
        this.setupOperator();
        this.setupCurrentField();
    }

    void setupCurrentField() {
        this.view.setCurrentField(this.currentField());
        this.view.currentFieldToggle(this.hasFactField());
    }

    String currentField() {
        List<String> parts = Arrays.asList(((ConditionColumnPlugin)this.plugin()).getBinding(), ((ConditionColumnPlugin)this.plugin()).getFactField());
        return parts.stream().filter(part -> !DecisionTableColumnViewUtils.nil(part)).collect(Collectors.joining(" : "));
    }

    void setupOperator() {
        this.operatorDropdown(dropdown -> this.view.setupOperator((IsWidget)dropdown));
    }

    void setupWarningMessages() {
        if (this.isConstraintValuePredicate()) {
            this.view.showPredicateWarning();
        } else {
            this.view.showFactFieldWarningWhenItIsNotDefined(this.hasFactField());
        }
    }

    public void isComplete(Callback<Boolean> callback) {
        boolean isComplete;
        boolean hasOperator = !DecisionTableColumnViewUtils.nil(((ConditionColumnPlugin)this.plugin()).getFactField()) && !((ConditionColumnPlugin)this.plugin()).operatorPlaceholder().equals(this.getOperator());
        boolean bl = isComplete = hasOperator || this.isConstraintValuePredicate();
        if (!isComplete) {
            this.view.showOperatorWarning();
        } else {
            this.view.hideOperatorWarning();
        }
        callback.callback((Object)isComplete);
    }

    public String getOperator() {
        return this.editingCol().getOperator();
    }

    void setOperator(String operator) {
        ((ConditionColumnPlugin)this.plugin()).setOperator(operator);
    }

    void operatorDropdown(Consumer<IsWidget> widgetSupplier) {
        if (this.canOperatorBeSet()) {
            this.cepOperatorsDropdown(widgetSupplier);
        } else {
            this.emptyOperatorsDropdown(widgetSupplier);
        }
    }

    boolean canOperatorBeSet() {
        return this.hasFactField() && !this.isConstraintValuePredicate();
    }

    boolean isConstraintValuePredicate() {
        return ((ConditionColumnPlugin)this.plugin()).constraintValue() == 5;
    }

    boolean hasFactField() {
        return !DecisionTableColumnViewUtils.nil(((ConditionColumnPlugin)this.plugin()).getFactField());
    }

    void getOperatorCompletions(Callback<String[]> callback) {
        AsyncPackageDataModelOracle oracle = this.presenter.getDataModelOracle();
        oracle.getOperatorCompletions(((ConditionColumnPlugin)this.plugin()).getFactType(), ((ConditionColumnPlugin)this.plugin()).getFactField(), callback);
    }

    private void emptyOperatorsDropdown(Consumer<IsWidget> widgetSupplier) {
        org.gwtbootstrap3.client.ui.ListBox listBox = this.newListBox();
        listBox.addItem(((ConditionColumnPlugin)this.plugin()).operatorPlaceholder());
        listBox.getElement().setAttribute("disabled", "disabled");
        widgetSupplier.accept((IsWidget)listBox);
    }

    org.gwtbootstrap3.client.ui.ListBox newListBox() {
        return new org.gwtbootstrap3.client.ui.ListBox();
    }

    private void cepOperatorsDropdown(Consumer<IsWidget> widgetSupplier) {
        this.getOperatorCompletions((Callback<String[]>)((Callback)options -> {
            String[] operatorsArray = this.filterOptionsForConstraintTypeLiteral((String[])options);
            CEPOperatorsDropdown dropdown = this.newCepOperatorsDropdown(operatorsArray);
            org.gwtbootstrap3.client.ui.ListBox box = dropdown.getBox();
            int currentValueIndex = DecisionTableColumnViewUtils.getCurrentIndexFromList(this.getOperator(), (ListBox)box);
            box.addChangeHandler(valueChangeEvent -> this.setOperator(box.getValue(box.getSelectedIndex())));
            if (currentValueIndex != box.getSelectedIndex()) {
                box.setSelectedIndex(currentValueIndex);
            }
            widgetSupplier.accept((IsWidget)dropdown);
        }));
    }

    private CEPOperatorsDropdown newCepOperatorsDropdown(String[] operatorsArray) {
        CEPOperatorsDropdown dropdown = this.newCepOperatorsDropdown(operatorsArray, this.editingCol());
        dropdown.addPlaceholder(((ConditionColumnPlugin)this.plugin()).operatorPlaceholder(), ((ConditionColumnPlugin)this.plugin()).operatorPlaceholder());
        dropdown.insertItem(this.translate("OperatorPage.NoOperator", new Object[0]), "", 1);
        return dropdown;
    }

    CEPOperatorsDropdown newCepOperatorsDropdown(String[] operatorsArray, ConditionCol52 col52) {
        return new CEPOperatorsDropdown(operatorsArray, (HasParameterizedOperator)col52);
    }

    String[] filterOptionsForConstraintTypeLiteral(String[] options) {
        ArrayList operatorOptions = new ArrayList();
        Collections.addAll(operatorOptions, options);
        if (this.getConstraintValueType() != 1) {
            operatorOptions.remove("in");
            operatorOptions.remove("not in");
        }
        return operatorOptions.toArray(new String[operatorOptions.size()]);
    }

    private ConditionCol52 editingCol() {
        return ((ConditionColumnPlugin)this.plugin()).editingCol();
    }

    private int getConstraintValueType() {
        return ((ConditionColumnPlugin)this.plugin()).constraintValue();
    }

    public static interface View
    extends UberElement<OperatorPage> {
        public void showFactFieldWarningWhenItIsNotDefined(boolean var1);

        public void showPredicateWarning();

        public void setupOperator(IsWidget var1);

        public void showOperatorWarning();

        public void hideOperatorWarning();

        public void setCurrentField(String var1);

        public void currentFieldToggle(boolean var1);
    }
}

