/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.wizard.column.plugins;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.drools.workbench.models.datamodel.workitems.PortableWorkDefinition;
import org.drools.workbench.models.guided.dtable.shared.model.ActionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.ActionWorkItemCol52;
import org.drools.workbench.models.guided.dtable.shared.model.DTColumnConfig52;
import org.drools.workbench.screens.guided.dtable.client.widget.table.model.synchronizers.ModelSynchronizer;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.NewGuidedDecisionTableColumnWizard;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.commons.HasAdditionalInfoPage;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.commons.HasWorkItemPage;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.AdditionalInfoPage;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.WorkItemPage;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.common.DecisionTableColumnViewUtils;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.plugins.commons.AdditionalInfoPageInitializer;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.plugins.commons.BaseDecisionTableColumnPlugin;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.plugins.commons.DecisionTableColumnPlugin;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.uberfire.ext.widgets.core.client.wizards.WizardPage;
import org.uberfire.ext.widgets.core.client.wizards.WizardPageStatusChangeEvent;

@Dependent
public class ActionWorkItemPlugin
extends BaseDecisionTableColumnPlugin
implements HasWorkItemPage,
HasAdditionalInfoPage {
    private AdditionalInfoPage<ActionWorkItemPlugin> additionalInfoPage;
    private WorkItemPage workItemPage;
    private ActionWorkItemCol52 editingCol;

    @Inject
    public ActionWorkItemPlugin(AdditionalInfoPage<ActionWorkItemPlugin> additionalInfoPage, WorkItemPage workItemPage, Event<WizardPageStatusChangeEvent> changeEvent, TranslationService translationService) {
        super(changeEvent, translationService);
        this.additionalInfoPage = additionalInfoPage;
        this.workItemPage = workItemPage;
    }

    @Override
    public String getTitle() {
        return this.translate("ActionWorkItemPlugin.ExecuteWorkItem", new Object[0]);
    }

    @Override
    public List<WizardPage> getPages() {
        return new ArrayList<WizardPage>(){
            {
                this.add(ActionWorkItemPlugin.this.workItemPage());
                this.add(ActionWorkItemPlugin.this.additionalInfoPage());
            }
        };
    }

    @Override
    public void init(NewGuidedDecisionTableColumnWizard wizard) {
        super.init(wizard);
        this.setupDefaultValues();
    }

    void setupDefaultValues() {
        if (this.isNewColumn().booleanValue()) {
            this.editingCol = this.newActionWorkItemCol52();
            return;
        }
        this.editingCol = this.clone(this.originalCol());
        this.fireChangeEvent(this.workItemPage);
        this.fireChangeEvent(this.additionalInfoPage);
    }

    ActionWorkItemCol52 newActionWorkItemCol52() {
        return new ActionWorkItemCol52();
    }

    ActionWorkItemCol52 clone(ActionWorkItemCol52 column) {
        ActionWorkItemCol52 clone = new ActionWorkItemCol52();
        clone.setHeader(column.getHeader());
        clone.setWorkItemDefinition(column.getWorkItemDefinition());
        clone.setHideColumn(column.isHideColumn());
        return clone;
    }

    @Override
    public String getWorkItem() {
        boolean hasWorkItemDefinition;
        boolean bl = hasWorkItemDefinition = this.getWorkItemDefinition() != null;
        if (hasWorkItemDefinition) {
            return this.getWorkItemDefinition().getName();
        }
        return "";
    }

    @Override
    public void setWorkItem(String workItem) {
        if (!DecisionTableColumnViewUtils.nil(workItem)) {
            this.editingCol.setWorkItemDefinition(this.findWorkItemDefinition(workItem));
        } else {
            this.editingCol.setWorkItemDefinition(null);
        }
        this.fireChangeEvent(this.workItemPage);
    }

    public ActionWorkItemCol52 editingCol() {
        return this.editingCol;
    }

    @Override
    public String getHeader() {
        return this.editingCol().getHeader();
    }

    @Override
    public void setHeader(String header) {
        this.editingCol().setHeader(header);
        this.fireChangeEvent(this.additionalInfoPage);
    }

    @Override
    public Set<String> getAlreadyUsedColumnHeaders() {
        return this.presenter.getModel().getActionCols().stream().map(DTColumnConfig52::getHeader).collect(Collectors.toSet());
    }

    @Override
    public Boolean isWorkItemSet() {
        return this.editingCol.getWorkItemDefinition() != null;
    }

    @Override
    public PortableWorkDefinition getWorkItemDefinition() {
        return this.editingCol().getWorkItemDefinition();
    }

    @Override
    public void forEachWorkItem(BiConsumer<String, String> biConsumer) {
        this.getPresenter().getWorkItemDefinitions().stream().filter(this::isWorkItemAvailable).forEach(workDefinition -> biConsumer.accept(workDefinition.getDisplayName(), workDefinition.getName()));
    }

    private boolean isWorkItemAvailable(PortableWorkDefinition pwd) {
        boolean isUsedInModel = this.getPresenter().getModel().getActionCols().stream().filter(a -> a instanceof ActionWorkItemCol52).map(a -> ((ActionWorkItemCol52)a).getWorkItemDefinition()).anyMatch(p -> p.getName().equals(pwd.getName()));
        if (this.isNewColumn().booleanValue()) {
            return !isUsedInModel;
        }
        if (!this.isWorkItemSet().booleanValue()) {
            return !isUsedInModel;
        }
        String pwdName = pwd.getName();
        return pwdName.equals(this.getWorkItemDefinition().getName()) || !isUsedInModel;
    }

    @Override
    public void setWorkItemPageAsCompleted() {
    }

    @Override
    public boolean isHideColumn() {
        return this.editingCol().isHideColumn();
    }

    @Override
    public void setHideColumn(boolean hideColumn) {
        this.editingCol().setHideColumn(hideColumn);
    }

    @Override
    public void setInsertLogical(Boolean value) {
    }

    @Override
    public void setUpdate(Boolean value) {
    }

    @Override
    public boolean showUpdateEngineWithChanges() {
        return false;
    }

    @Override
    public boolean showLogicallyInsert() {
        return false;
    }

    @Override
    public boolean isLogicallyInsert() {
        return false;
    }

    @Override
    public boolean isUpdateEngine() {
        return false;
    }

    PortableWorkDefinition findWorkItemDefinition(String workItem) {
        ArrayList<PortableWorkDefinition> workItemDefinitions = new ArrayList<PortableWorkDefinition>(this.presenter.getWorkItemDefinitions());
        return workItemDefinitions.stream().filter(a -> a.getName().equals(workItem)).findFirst().orElseThrow(IllegalStateException::new);
    }

    @Override
    public Boolean generateColumn() {
        if (this.isNewColumn().booleanValue()) {
            this.presenter.appendColumn((ActionCol52)this.editingCol());
        } else {
            try {
                this.presenter.updateColumn((ActionCol52)this.originalCol(), (ActionCol52)this.editingCol());
            }
            catch (ModelSynchronizer.VetoException veto) {
                this.wizard.showGenericVetoError();
                return false;
            }
        }
        return true;
    }

    private ActionWorkItemCol52 originalCol() {
        return (ActionWorkItemCol52)this.getOriginalColumnConfig52();
    }

    WizardPage workItemPage() {
        this.workItemPage.enableParameters();
        return this.workItemPage;
    }

    AdditionalInfoPage additionalInfoPage() {
        return AdditionalInfoPageInitializer.init(this.additionalInfoPage, this);
    }

    @Override
    public DecisionTableColumnPlugin.Type getType() {
        return DecisionTableColumnPlugin.Type.ADVANCED;
    }
}

