/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.wizard.table.pages;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.cellview.client.CellList;
import com.google.gwt.user.cellview.client.HasKeyboardSelectionPolicy;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.MultiSelectionModel;
import com.google.gwt.view.client.SelectionChangeEvent;
import com.google.gwt.view.client.SelectionModel;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.drools.workbench.models.guided.dtable.shared.model.ConditionCol52;
import org.drools.workbench.screens.guided.dtable.client.resources.i18n.GuidedDecisionTableConstants;
import org.drools.workbench.screens.guided.dtable.client.widget.Validator;
import org.drools.workbench.screens.guided.dtable.client.wizard.table.pages.ColumnExpansionPageView;
import org.drools.workbench.screens.guided.dtable.client.wizard.table.pages.MinimumWidthCellList;
import org.drools.workbench.screens.guided.dtable.client.wizard.table.pages.cells.ConditionCell;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.CheckBox;
import org.gwtbootstrap3.client.ui.Label;
import org.uberfire.ext.widgets.core.client.resources.WizardCellListResources;

@Dependent
public class ColumnExpansionPageViewImpl
extends Composite
implements ColumnExpansionPageView {
    private ColumnExpansionPageView.Presenter presenter;
    private List<ConditionCol52> availableColumns;
    private Set<ConditionCol52> availableColumnsSelections;
    private MinimumWidthCellList<ConditionCol52> availableColumnsWidget;
    private List<ConditionCol52> chosenColumns = new ArrayList<ConditionCol52>();
    private Set<ConditionCol52> chosenColumnsSelections;
    private MinimumWidthCellList<ConditionCol52> chosenColumnsWidget;
    private MultiSelectionModel<ConditionCol52> availableSelectionModel = new MultiSelectionModel();
    private MultiSelectionModel<ConditionCol52> chosenSelectionModel = new MultiSelectionModel();
    private boolean isFullyExpanded = true;
    @UiField
    CheckBox chkExpandInFull;
    @UiField
    HorizontalPanel columnSelectorContainer;
    @UiField
    ScrollPanel availableColumnsContainer;
    @UiField
    ScrollPanel chosenColumnsContainer;
    @UiField
    Button btnAdd;
    @UiField
    Button btnRemove;
    @Inject
    private ConditionCell availableConditionsCell;
    @Inject
    private ConditionCell chosenConditionsCell;
    private static ColumnExpansionPageWidgetBinder uiBinder = (ColumnExpansionPageWidgetBinder)GWT.create(ColumnExpansionPageWidgetBinder.class);

    public ColumnExpansionPageViewImpl() {
        this.initWidget((Widget)uiBinder.createAndBindUi(this));
    }

    @PostConstruct
    public void setup() {
        this.availableColumnsWidget = new MinimumWidthCellList(this.availableConditionsCell, (CellList.Resources)WizardCellListResources.INSTANCE);
        this.chosenColumnsWidget = new MinimumWidthCellList(this.chosenConditionsCell, (CellList.Resources)WizardCellListResources.INSTANCE);
        this.initialiseAvailableColumns();
        this.initialiseChosenColumns();
        this.initialiseExpandInFull();
    }

    @Override
    public void setValidator(Validator validator) {
        this.availableConditionsCell.setValidator(validator);
        this.chosenConditionsCell.setValidator(validator);
    }

    private void initialiseAvailableColumns() {
        this.availableColumnsContainer.add(this.availableColumnsWidget);
        this.availableColumnsWidget.setKeyboardSelectionPolicy(HasKeyboardSelectionPolicy.KeyboardSelectionPolicy.ENABLED);
        this.availableColumnsWidget.setMinimumWidth(270);
        Label lstEmpty = new Label(GuidedDecisionTableConstants.INSTANCE.DecisionTableWizardNoAvailableColumns());
        lstEmpty.setStyleName(WizardCellListResources.INSTANCE.cellListStyle().cellListEmptyItem());
        this.availableColumnsWidget.setEmptyListWidget((Widget)lstEmpty);
        this.availableColumnsWidget.setSelectionModel((SelectionModel)this.availableSelectionModel);
        this.availableSelectionModel.addSelectionChangeHandler(new SelectionChangeEvent.Handler(){

            public void onSelectionChange(SelectionChangeEvent event) {
                ColumnExpansionPageViewImpl.this.availableColumnsSelections = ColumnExpansionPageViewImpl.this.availableSelectionModel.getSelectedSet();
                ColumnExpansionPageViewImpl.this.btnAdd.setEnabled(ColumnExpansionPageViewImpl.this.availableColumnsSelections.size() > 0);
            }
        });
    }

    private void initialiseChosenColumns() {
        this.chosenColumnsContainer.add(this.chosenColumnsWidget);
        this.chosenColumnsWidget.setKeyboardSelectionPolicy(HasKeyboardSelectionPolicy.KeyboardSelectionPolicy.ENABLED);
        this.chosenColumnsWidget.setMinimumWidth(270);
        Label lstEmpty = new Label(GuidedDecisionTableConstants.INSTANCE.DecisionTableWizardNoChosenColumns());
        lstEmpty.setStyleName(WizardCellListResources.INSTANCE.cellListStyle().cellListEmptyItem());
        this.chosenColumnsWidget.setEmptyListWidget((Widget)lstEmpty);
        this.chosenColumnsWidget.setSelectionModel((SelectionModel)this.chosenSelectionModel);
        this.chosenSelectionModel.addSelectionChangeHandler(new SelectionChangeEvent.Handler(){

            public void onSelectionChange(SelectionChangeEvent event) {
                ColumnExpansionPageViewImpl.this.chosenColumnsSelections = ColumnExpansionPageViewImpl.this.chosenSelectionModel.getSelectedSet();
                ColumnExpansionPageViewImpl.this.btnRemove.setEnabled(ColumnExpansionPageViewImpl.this.chosenColumnsSelections.size() > 0);
            }
        });
    }

    private void initialiseExpandInFull() {
        this.chkExpandInFull.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                ColumnExpansionPageViewImpl.this.isFullyExpanded = ColumnExpansionPageViewImpl.this.chkExpandInFull.getValue();
                ColumnExpansionPageViewImpl.this.columnSelectorContainer.setVisible(!ColumnExpansionPageViewImpl.this.isFullyExpanded);
                ColumnExpansionPageViewImpl.this.presenter.setColumnsToExpand(ColumnExpansionPageViewImpl.this.getColumnsToExpand());
            }
        });
    }

    @Override
    public void setChosenColumns(List<ConditionCol52> columns) {
        this.chosenColumnsWidget.setRowCount(columns.size(), true);
        this.chosenColumnsWidget.setRowData(columns);
    }

    @Override
    public void setAvailableColumns(List<ConditionCol52> columns) {
        this.availableColumns = columns;
        this.availableColumns.removeAll(this.chosenColumns);
        this.availableColumnsWidget.setRowCount(columns.size(), true);
        this.availableColumnsWidget.setRowData(columns);
    }

    public void init(ColumnExpansionPageView.Presenter presenter) {
        this.presenter = presenter;
    }

    @Override
    public void setAreConditionsDefined(boolean areConditionsDefined) {
        this.availableColumnsWidget.redraw();
        this.chosenColumnsWidget.redraw();
    }

    private List<ConditionCol52> getColumnsToExpand() {
        ArrayList<ConditionCol52> columns = new ArrayList<ConditionCol52>();
        if (this.isFullyExpanded) {
            columns.addAll(this.availableColumns);
        }
        columns.addAll(this.chosenColumns);
        return columns;
    }

    @UiHandler(value={"btnAdd"})
    public void btnAddClick(ClickEvent event) {
        for (ConditionCol52 column : this.availableColumnsSelections) {
            this.chosenColumns.add(column);
            this.availableColumns.remove(column);
        }
        this.availableSelectionModel.clear();
        this.availableColumnsSelections.clear();
        this.setChosenColumns(this.chosenColumns);
        this.setAvailableColumns(this.availableColumns);
        this.presenter.setColumnsToExpand(this.getColumnsToExpand());
        this.btnAdd.setEnabled(false);
    }

    @UiHandler(value={"btnRemove"})
    public void btnRemoveClick(ClickEvent event) {
        for (ConditionCol52 column : this.chosenColumnsSelections) {
            this.chosenColumns.remove(column);
            this.availableColumns.add(column);
        }
        this.chosenSelectionModel.clear();
        this.chosenColumnsSelections.clear();
        this.setChosenColumns(this.chosenColumns);
        this.setAvailableColumns(this.availableColumns);
        this.presenter.setColumnsToExpand(this.getColumnsToExpand());
        this.btnRemove.setEnabled(false);
    }

    static interface ColumnExpansionPageWidgetBinder
    extends UiBinder<Widget, ColumnExpansionPageViewImpl> {
    }
}

