/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.table.model.synchronizers.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.drools.workbench.models.guided.dtable.shared.model.BaseColumn;
import org.drools.workbench.models.guided.dtable.shared.model.DTCellValue52;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.models.guided.dtable.shared.model.MetadataCol52;
import org.drools.workbench.screens.guided.dtable.client.widget.table.model.GuidedDecisionTableUiCell;
import org.drools.workbench.screens.guided.dtable.client.widget.table.model.GuidedDecisionTableUiModel;
import org.drools.workbench.screens.guided.dtable.client.widget.table.model.converters.cell.GridWidgetCellFactory;
import org.drools.workbench.screens.guided.dtable.client.widget.table.utilities.CellUtilities;
import org.drools.workbench.screens.guided.dtable.client.widget.table.utilities.ColumnUtilities;
import org.uberfire.ext.wires.core.grids.client.model.GridCellValue;

public class PrioritySynchronizer {
    private final GuidedDecisionTable52 model;
    private final GuidedDecisionTableUiModel uiModel;
    private final GridWidgetCellFactory gridWidgetCellFactory;
    private final CellUtilities cellUtilities;
    private final ColumnUtilities columnUtilities;

    public PrioritySynchronizer(GuidedDecisionTable52 model, GuidedDecisionTableUiModel uiModel, GridWidgetCellFactory gridWidgetCellFactory, CellUtilities cellUtilities, ColumnUtilities columnUtilities) {
        this.model = model;
        this.uiModel = uiModel;
        this.gridWidgetCellFactory = gridWidgetCellFactory;
        this.cellUtilities = cellUtilities;
        this.columnUtilities = columnUtilities;
    }

    public void update(int rowNumberColumnIndex, RowNumberChanges rowNumberChanges) {
        if (!GuidedDecisionTable52.HitPolicy.RESOLVED_HIT.equals((Object)this.model.getHitPolicy())) {
            return;
        }
        Optional<BaseColumnInfo> optional = this.getPriorityColumnInfo();
        if (optional.isPresent()) {
            BaseColumnInfo baseColumnInfo = optional.get();
            for (List row : this.model.getData()) {
                GuidedDecisionTableUiCell newUiCell;
                DTCellValue52 dtCellValue52 = (DTCellValue52)row.get(baseColumnInfo.getColumnIndex());
                int oldValue = this.getNumber(dtCellValue52);
                int rowNumber = ((DTCellValue52)row.get(rowNumberColumnIndex)).getNumericValue().intValue() - 1;
                if (oldValue == 0) continue;
                if (oldValue > rowNumber || (Integer)rowNumberChanges.get(oldValue) > rowNumber) {
                    newUiCell = new GuidedDecisionTableUiCell("");
                } else {
                    dtCellValue52.setStringValue(Integer.toString((Integer)rowNumberChanges.get(oldValue)));
                    newUiCell = this.gridWidgetCellFactory.convertCell(dtCellValue52, baseColumnInfo.getBaseColumn(), this.cellUtilities, this.columnUtilities);
                }
                this.uiModel.setCellValueInternal(rowNumber, baseColumnInfo.getColumnIndex(), (GridCellValue<?>)newUiCell);
            }
        }
    }

    private int getNumber(DTCellValue52 dtCellValue52) {
        try {
            return Integer.parseInt(dtCellValue52.getStringValue());
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    private Optional<BaseColumnInfo> getPriorityColumnInfo() {
        int attributeColumnIndex = 0;
        for (BaseColumn baseColumn : this.model.getExpandedColumns()) {
            if (baseColumn instanceof MetadataCol52 && "ResolvedHitPriorityOverRow".equals(((MetadataCol52)baseColumn).getMetadata())) {
                return Optional.of(new BaseColumnInfo(attributeColumnIndex, baseColumn));
            }
            ++attributeColumnIndex;
        }
        return Optional.empty();
    }

    public void deleteRow(int deletedRowIndex) {
        if (!GuidedDecisionTable52.HitPolicy.RESOLVED_HIT.equals((Object)this.model.getHitPolicy())) {
            return;
        }
        int deletedRowNumber = deletedRowIndex + 1;
        Optional<BaseColumnInfo> optional = this.getPriorityColumnInfo();
        if (optional.isPresent()) {
            BaseColumnInfo baseColumnInfo = optional.get();
            int rowNumber = 0;
            for (List row : this.model.getData()) {
                DTCellValue52 dtCellValue52 = (DTCellValue52)row.get(baseColumnInfo.getColumnIndex());
                int oldValue = this.getNumber(dtCellValue52);
                if (oldValue >= deletedRowNumber) {
                    dtCellValue52.setStringValue(Integer.toString(oldValue - 1));
                    this.uiModel.setCellValueInternal(rowNumber, baseColumnInfo.getColumnIndex(), (GridCellValue<?>)this.gridWidgetCellFactory.convertCell(dtCellValue52, baseColumnInfo.getBaseColumn(), this.cellUtilities, this.columnUtilities));
                }
                ++rowNumber;
            }
        }
    }

    public void insertRow(int insertedRowIndex) {
        if (!GuidedDecisionTable52.HitPolicy.RESOLVED_HIT.equals((Object)this.model.getHitPolicy())) {
            return;
        }
        Optional<BaseColumnInfo> optional = this.getPriorityColumnInfo();
        if (optional.isPresent()) {
            BaseColumnInfo baseColumnInfo = optional.get();
            int rowNumber = 0;
            for (List row : this.model.getData()) {
                DTCellValue52 dtCellValue52 = (DTCellValue52)row.get(baseColumnInfo.getColumnIndex());
                int oldValue = this.getNumber(dtCellValue52);
                if (oldValue != 0 && oldValue >= insertedRowIndex) {
                    dtCellValue52.setStringValue(Integer.toString(oldValue + 1));
                    this.uiModel.setCellValueInternal(rowNumber, baseColumnInfo.getColumnIndex(), (GridCellValue<?>)this.gridWidgetCellFactory.convertCell(dtCellValue52, baseColumnInfo.getBaseColumn(), this.cellUtilities, this.columnUtilities));
                }
                ++rowNumber;
            }
        }
    }

    private class BaseColumnInfo {
        private int columnIndex;
        private BaseColumn baseColumn;

        public BaseColumnInfo(int columnIndex, BaseColumn baseColumn) {
            this.columnIndex = columnIndex;
            this.baseColumn = baseColumn;
        }

        public int getColumnIndex() {
            return this.columnIndex;
        }

        public BaseColumn getBaseColumn() {
            return this.baseColumn;
        }
    }

    public static class RowNumberChanges
    extends HashMap<Integer, Integer> {
    }
}

