/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.common;

import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.ListBox;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.drools.workbench.models.guided.dtable.shared.model.ActionInsertFactCol52;
import org.drools.workbench.models.guided.dtable.shared.model.ActionRetractFactCol52;
import org.drools.workbench.models.guided.dtable.shared.model.ActionSetFieldCol52;
import org.drools.workbench.models.guided.dtable.shared.model.ActionWorkItemCol52;
import org.drools.workbench.models.guided.dtable.shared.model.BRLActionColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BRLConditionColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BaseColumn;
import org.drools.workbench.models.guided.dtable.shared.model.Pattern52;
import org.drools.workbench.screens.guided.dtable.client.resources.i18n.GuidedDecisionTableConstants;
import org.jboss.errai.common.client.dom.DOMUtil;
import org.jboss.errai.common.client.dom.Div;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.common.client.dom.Node;

public class DecisionTableColumnViewUtils {
    public static int getCurrentIndexFromList(String currentValue, ListBox list) {
        int currentIndexFromList = DecisionTableColumnViewUtils.getCurrentIndexFromListWithoutDefaultSelect(currentValue, list);
        if (currentIndexFromList == -1) {
            return 0;
        }
        return currentIndexFromList;
    }

    public static int getCurrentIndexFromListWithoutDefaultSelect(String currentValue, ListBox list) {
        for (int index = 0; index < list.getItemCount(); ++index) {
            String value = list.getValue(index);
            if (value == null || !value.equals(currentValue)) continue;
            return index;
        }
        return -1;
    }

    public static boolean nil(String s) {
        return s == null || s.equals("");
    }

    public static void addWidgetToContainer(IsWidget widget, Div container) {
        DecisionTableColumnViewUtils.clean(container);
        DecisionTableColumnViewUtils.append(widget, container);
    }

    public static String getColumnManagementGroupTitle(BaseColumn column) {
        String managementSectionHeader = null;
        if (column instanceof ActionInsertFactCol52) {
            managementSectionHeader = DecisionTableColumnViewUtils.concatenateFactTypeAndBoundName(((ActionInsertFactCol52)column).getFactType(), ((ActionInsertFactCol52)column).getBoundName());
        } else if (column instanceof ActionSetFieldCol52) {
            managementSectionHeader = DecisionTableColumnViewUtils.concatenateFactTypeAndBoundName(null, ((ActionSetFieldCol52)column).getBoundName());
        } else if (column instanceof Pattern52) {
            managementSectionHeader = DecisionTableColumnViewUtils.concatenateFactTypeAndBoundName(((Pattern52)column).getFactType(), ((Pattern52)column).getBoundName());
            if (((Pattern52)column).isNegated()) {
                managementSectionHeader = GuidedDecisionTableConstants.INSTANCE.negatedPattern() + " " + managementSectionHeader;
            }
        } else if (column instanceof ActionRetractFactCol52) {
            managementSectionHeader = GuidedDecisionTableConstants.INSTANCE.RetractActions();
        } else if (column instanceof ActionWorkItemCol52) {
            managementSectionHeader = GuidedDecisionTableConstants.INSTANCE.ExecuteWorkItemActions();
        } else if (column instanceof BRLActionColumn) {
            managementSectionHeader = GuidedDecisionTableConstants.INSTANCE.BrlActions();
        } else if (column instanceof BRLConditionColumn) {
            managementSectionHeader = GuidedDecisionTableConstants.INSTANCE.BrlConditions();
        }
        if (managementSectionHeader == null || managementSectionHeader.isEmpty()) {
            return column.getHeader();
        }
        return managementSectionHeader;
    }

    private static String concatenateFactTypeAndBoundName(String factType, String boundName) {
        return Stream.of(factType, boundName != null && !boundName.isEmpty() ? "[" + boundName + "]" : boundName).filter(text -> text != null && !text.isEmpty()).collect(Collectors.joining(" "));
    }

    private static void append(IsWidget widget, Div container) {
        DOMUtil.appendWidgetToElement((HTMLElement)container, (IsWidget)widget);
    }

    private static void clean(Div container) {
        DOMUtil.removeAllChildren((Node)container);
    }
}

