/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.table;

import com.ait.lienzo.client.core.event.NodeMouseMoveEvent;
import com.ait.lienzo.client.core.mediator.IMediator;
import com.ait.lienzo.client.core.shape.IPrimitive;
import com.ait.lienzo.client.core.types.Point2D;
import com.ait.lienzo.client.core.types.Transform;
import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ContextMenuEvent;
import com.google.gwt.event.dom.client.ContextMenuHandler;
import com.google.gwt.event.dom.client.KeyDownHandler;
import com.google.gwt.event.dom.client.MouseDownEvent;
import com.google.gwt.event.dom.client.MouseDownHandler;
import com.google.gwt.event.dom.client.ScrollEvent;
import com.google.gwt.event.dom.client.ScrollHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTMLPanel;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.Collections;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.drools.workbench.models.guided.dtable.shared.model.ActionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.ConditionCol52;
import org.drools.workbench.screens.guided.dtable.client.widget.table.BoundaryTransformMediator;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableModellerBoundsHelper;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableModellerView;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableView;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.uberfire.ext.widgets.common.client.common.popups.errors.ErrorPopup;
import org.uberfire.ext.wires.core.grids.client.model.Bounds;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;
import org.uberfire.ext.wires.core.grids.client.widget.layer.GridLayer;
import org.uberfire.ext.wires.core.grids.client.widget.layer.impl.DefaultGridLayer;
import org.uberfire.ext.wires.core.grids.client.widget.layer.impl.GridLienzoPanel;
import org.uberfire.ext.wires.core.grids.client.widget.layer.pinning.GridPinnedModeManager;
import org.uberfire.ext.wires.core.grids.client.widget.layer.pinning.TransformMediator;
import org.uberfire.ext.wires.core.grids.client.widget.layer.pinning.impl.RestrictedMousePanMediator;

public class GuidedDecisionTableModellerViewImpl
extends Composite
implements GuidedDecisionTableModellerView {
    private static final double VP_SCALE = 1.0;
    private static GuidedDecisionTableModellerViewImplUiBinder uiBinder = (GuidedDecisionTableModellerViewImplUiBinder)GWT.create(GuidedDecisionTableModellerViewImplUiBinder.class);
    private final GuidedDecisionTableModellerBoundsHelper boundsHelper = new GuidedDecisionTableModellerBoundsHelper();
    private TranslationService translationService;
    @UiField
    HTMLPanel pinnedModeIndicator;
    @UiField(provided=true)
    GridLienzoPanel gridPanel = new GridLienzoPanel(){

        public void onResize() {
            Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

                public void execute() {
                    this.updatePanelSize();
                    this.refreshScrollPosition();
                    TransformMediator restriction = GuidedDecisionTableModellerViewImpl.this.mousePanMediator.getTransformMediator();
                    Transform transform = restriction.adjust(GuidedDecisionTableModellerViewImpl.this.gridLayer.getViewport().getTransform(), GuidedDecisionTableModellerViewImpl.this.gridLayer.getVisibleBounds());
                    GuidedDecisionTableModellerViewImpl.this.gridLayer.getViewport().setTransform(transform);
                    GuidedDecisionTableModellerViewImpl.this.gridLayer.draw();
                }
            });
        }
    };
    private TransformMediator defaultTransformMediator;
    private GuidedDecisionTableModellerView.Presenter presenter;
    private final DefaultGridLayer gridLayer = this.defaultGridLayer();
    private final RestrictedMousePanMediator mousePanMediator = this.restrictedMousePanMediator();

    public GuidedDecisionTableModellerViewImpl() {
    }

    @Inject
    public GuidedDecisionTableModellerViewImpl(TranslationService translationService) {
        this.translationService = translationService;
        this.initWidget((Widget)uiBinder.createAndBindUi(this));
    }

    DefaultGridLayer defaultGridLayer() {
        return new DefaultGridLayer(){

            public void enterPinnedMode(GridWidget gridWidget, final Command onStartCommand) {
                super.enterPinnedMode(gridWidget, new Command(){

                    public void execute() {
                        onStartCommand.execute();
                        GuidedDecisionTableModellerViewImpl.this.presenter.onViewPinned(true);
                    }
                });
            }

            public void exitPinnedMode(final Command onCompleteCommand) {
                super.exitPinnedMode(new Command(){

                    public void execute() {
                        onCompleteCommand.execute();
                        GuidedDecisionTableModellerViewImpl.this.presenter.onViewPinned(false);
                    }
                });
            }

            public TransformMediator getDefaultTransformMediator() {
                return GuidedDecisionTableModellerViewImpl.this.defaultTransformMediator;
            }
        };
    }

    RestrictedMousePanMediator restrictedMousePanMediator() {
        return new RestrictedMousePanMediator((GridLayer)this.gridLayer){

            protected void onMouseMove(NodeMouseMoveEvent event) {
                super.onMouseMove(event);
                GuidedDecisionTableModellerViewImpl.this.presenter.updateRadar();
            }
        };
    }

    protected void initWidget(Widget widget) {
        super.initWidget(widget);
    }

    public void init(GuidedDecisionTableModellerView.Presenter presenter) {
        this.presenter = presenter;
    }

    @PostConstruct
    public void setup() {
        this.setupGridPanel();
    }

    void setupGridPanel() {
        Transform transform = this.newTransform().scale(1.0);
        this.gridPanel.getViewport().setTransform(transform);
        this.defaultTransformMediator = new BoundaryTransformMediator(this);
        this.mousePanMediator.setTransformMediator(this.defaultTransformMediator);
        this.gridPanel.getViewport().getMediators().push((IMediator)this.mousePanMediator);
        this.mousePanMediator.setBatchDraw(true);
        this.gridPanel.setBounds(this.getBounds());
        this.gridPanel.getScrollPanel().addDomHandler((EventHandler)((ScrollHandler)scrollEvent -> this.getPresenter().updateRadar()), ScrollEvent.getType());
        this.gridPanel.add(this.gridLayer);
        this.gridPanel.getElement().setId("dtable_container_" + Document.get().createUniqueId());
    }

    public void onResize() {
        this.gridPanel.onResize();
        this.getPresenter().updateRadar();
    }

    public HandlerRegistration addKeyDownHandler(KeyDownHandler handler) {
        return this.gridPanel.addKeyDownHandler(handler);
    }

    public HandlerRegistration addContextMenuHandler(ContextMenuHandler handler) {
        return this.gridPanel.addDomHandler((EventHandler)handler, ContextMenuEvent.getType());
    }

    public HandlerRegistration addMouseDownHandler(MouseDownHandler handler) {
        return this.rootPanel().addDomHandler((EventHandler)handler, MouseDownEvent.getType());
    }

    RootPanel rootPanel() {
        return RootPanel.get();
    }

    @Override
    public void clear() {
        this.gridLayer.removeAll();
    }

    @Override
    public void addDecisionTable(GuidedDecisionTableView gridWidget) {
        if (this.gridLayer.getGridWidgets().isEmpty()) {
            Point2D translation = this.getTranslation(gridWidget);
            Transform t = this.gridLayer.getViewport().getTransform();
            t.translate(translation.getX(), translation.getY());
        }
        this.gridLayer.add((IPrimitive)gridWidget);
        this.gridLayer.batch();
    }

    private Point2D getTranslation(GuidedDecisionTableView gridWidget) {
        double boundsPadding = 20.0;
        Transform t = this.gridLayer.getViewport().getTransform();
        double requiredTranslateX = 20.0 - gridWidget.getX();
        double requiredTranslateY = 20.0 - gridWidget.getY();
        double actualTranslateX = t.getTranslateX();
        double actualTranslateY = t.getTranslateY();
        double dx = requiredTranslateX - actualTranslateX;
        double dy = requiredTranslateY - actualTranslateY;
        return new Point2D(dx, dy);
    }

    @Override
    public void removeDecisionTable(GuidedDecisionTableView gridWidget, Command afterRemovalCommand) {
        if (gridWidget == null) {
            return;
        }
        Command remove = () -> {
            this.gridLayer.remove((IPrimitive)gridWidget);
            afterRemovalCommand.execute();
            this.gridLayer.batch();
        };
        if (this.gridLayer.isGridPinned()) {
            GridPinnedModeManager.PinnedContext context = this.gridLayer.getPinnedContext();
            if (gridWidget.equals(context.getGridWidget())) {
                this.gridLayer.exitPinnedMode(remove);
            }
        } else {
            remove.execute();
        }
    }

    @Override
    public void refreshScrollPosition() {
        this.gridPanel.refreshScrollPosition();
    }

    @Override
    public void setZoom(int zoom) {
        Transform transform = this.newTransform();
        double tx = this.gridPanel.getViewport().getTransform().getTranslateX();
        double ty = this.gridPanel.getViewport().getTransform().getTranslateY();
        transform.translate(tx, ty);
        transform.scale((double)zoom / 100.0);
        this.gridPanel.getViewport().setTransform(transform);
        TransformMediator restriction = this.mousePanMediator.getTransformMediator();
        Transform newTransform = restriction.adjust(transform, this.gridLayer.getVisibleBounds());
        this.gridPanel.getViewport().setTransform(newTransform);
        this.gridPanel.getViewport().batch();
        this.gridPanel.refreshScrollPosition();
    }

    @Override
    public GridLayer getGridLayerView() {
        return this.gridLayer;
    }

    @Override
    public GridLienzoPanel getGridPanel() {
        return this.gridPanel;
    }

    @Override
    public Bounds getBounds() {
        if (this.presenter == null) {
            return this.boundsHelper.getBounds(Collections.emptySet());
        }
        return this.boundsHelper.getBounds(this.presenter.getAvailableDecisionTables());
    }

    public void select(GridWidget selectedGridWidget) {
        this.getGridLayer().select(selectedGridWidget);
    }

    public void selectLinkedColumn(GridColumn<?> link) {
        this.gridLayer.selectLinkedColumn(link);
    }

    public Set<GridWidget> getGridWidgets() {
        return this.gridLayer.getGridWidgets();
    }

    @Override
    public void setPinnedModeIndicatorVisibility(boolean visibility, double headerCaptionWidth) {
        this.style(this.pinnedModeIndicator).setTop(visibility ? 0.5 : -2.0, Style.Unit.EM);
        this.style(this.pinnedModeIndicator).setLeft(headerCaptionWidth, Style.Unit.PX);
    }

    private Style style(HTMLPanel pinnedModeIndicator) {
        return pinnedModeIndicator.getElement().getStyle();
    }

    @Override
    public void showGenericVetoMessage() {
        ErrorPopup.showMessage((String)this.translate("NewGuidedDecisionTableColumnWizard.GenericVetoError", new String[0]));
    }

    @Override
    public void showUnableToDeleteColumnMessage(ConditionCol52 column) {
        ErrorPopup.showMessage((String)this.translate("NewGuidedDecisionTableColumnWizard.DeletePatternInUseVetoError0", column.getHeader()));
    }

    @Override
    public void showUnableToDeleteColumnMessage(ActionCol52 column) {
        ErrorPopup.showMessage((String)this.translate("NewGuidedDecisionTableColumnWizard.DeletePatternInUseVetoError0", column.getHeader()));
    }

    private String translate(String key, String ... args) {
        return this.translationService.format(key, (Object[])args);
    }

    GuidedDecisionTableModellerView.Presenter getPresenter() {
        return this.presenter;
    }

    DefaultGridLayer getGridLayer() {
        return this.gridLayer;
    }

    Transform newTransform() {
        return new Transform();
    }

    static interface GuidedDecisionTableModellerViewImplUiBinder
    extends UiBinder<Widget, GuidedDecisionTableModellerViewImpl> {
    }
}

