/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.table.popovers.definitions;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.drools.workbench.models.guided.dtable.shared.model.BaseColumn;
import org.drools.workbench.models.guided.dtable.shared.model.DTCellValue52;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.screens.guided.dtable.client.widget.table.popovers.definitions.ColumnDefinitionBuilder;
import org.drools.workbench.screens.guided.dtable.client.widget.table.utilities.ColumnUtilities;
import org.drools.workbench.screens.guided.dtable.service.GuidedDecisionTableEditorService;
import org.jboss.errai.common.client.api.Caller;
import org.kie.soup.project.datamodel.oracle.DataType;
import org.uberfire.backend.vfs.Path;
import org.uberfire.client.callbacks.Callback;

public abstract class BaseColumnDefinitionBuilder
implements ColumnDefinitionBuilder {
    private static final String WHEN = "when\n";
    private static final String THEN = "then\n";
    private static final String END = "end\n";
    private Caller<GuidedDecisionTableEditorService> service;

    public BaseColumnDefinitionBuilder(Caller<GuidedDecisionTableEditorService> service) {
        this.service = service;
    }

    protected void generateDefinitionOnServer(GuidedDecisionTable52 partialModel, Path path, Callback<String> afterGenerationCallback) {
        ((GuidedDecisionTableEditorService)this.service.call(source -> afterGenerationCallback.callback(source))).toSource(path, (Object)partialModel);
    }

    protected List<DTCellValue52> makeRowData(ColumnUtilities columnUtilities, BaseColumn column) {
        ArrayList<DTCellValue52> row = new ArrayList<DTCellValue52>();
        row.add(new DTCellValue52(Integer.valueOf(1)));
        row.add(new DTCellValue52(""));
        row.add(new DTCellValue52("desc"));
        DataType.DataTypes dataType = columnUtilities.getDataType(column);
        row.add(this.makeCell(dataType));
        return row;
    }

    protected DTCellValue52 makeCell(DataType.DataTypes dataType) {
        switch (dataType) {
            case NUMERIC: 
            case NUMERIC_BIGDECIMAL: 
            case NUMERIC_BIGINTEGER: 
            case NUMERIC_BYTE: 
            case NUMERIC_DOUBLE: 
            case NUMERIC_FLOAT: 
            case NUMERIC_INTEGER: 
            case NUMERIC_LONG: 
            case NUMERIC_SHORT: {
                return new DTCellValue52(Integer.valueOf(1));
            }
            case DATE: {
                return new DTCellValue52(new Date());
            }
            case BOOLEAN: {
                return new DTCellValue52(Boolean.valueOf(true));
            }
        }
        return new DTCellValue52("x");
    }

    protected String getLHS(String drl) {
        return this.strip(drl, WHEN, THEN);
    }

    protected String getRHS(String drl) {
        return this.strip(drl, THEN, END);
    }

    protected String strip(String drl, String blockStartTag, String blockEndTag) {
        String _drl = drl.toLowerCase();
        int start = _drl.indexOf(blockStartTag);
        int end = _drl.indexOf(blockEndTag);
        if (start < 0 || end < 0 || end < start) {
            return drl;
        }
        return drl.substring(start + blockStartTag.length(), end).trim().replaceAll("\t", "").replaceAll("\n", "<br/>");
    }
}

