/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.wizard.column.pages;

import java.util.function.BiConsumer;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.drools.workbench.models.datamodel.workitems.PortableWorkDefinition;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.commons.HasWorkItemPage;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.common.BaseDecisionTableColumnPage;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.modals.HasList;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.plugins.commons.DecisionTableColumnPlugin;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.kie.workbench.common.widgets.client.workitems.IBindingProvider;
import org.kie.workbench.common.widgets.client.workitems.WorkItemParametersWidget;
import org.uberfire.client.callbacks.Callback;
import org.uberfire.client.mvp.UberElement;

@Dependent
public class WorkItemPage<T extends HasWorkItemPage & DecisionTableColumnPlugin>
extends BaseDecisionTableColumnPage<T> {
    private View view;
    private boolean parametersEnabled = false;

    @Inject
    public WorkItemPage(View view, TranslationService translationService) {
        super(translationService);
        this.view = view;
    }

    public String getTitle() {
        return this.translate("WorkItemPage.WorkItem", new Object[0]);
    }

    public void isComplete(Callback<Boolean> callback) {
        callback.callback((Object)((HasWorkItemPage)this.plugin()).isWorkItemSet());
    }

    @Override
    protected UberElement<?> getView() {
        return this.view;
    }

    public void prepareView() {
        this.view.init(this);
        this.markAsViewed();
        this.setupWorkItemsList();
    }

    void setupWorkItemsList() {
        this.view.setupWorkItemList();
        this.forEachWorkItem((name, key) -> this.view.addItem((String)name, (String)key));
        if (this.hasWorkItems()) {
            this.view.selectWorkItem(this.currentWorkItem());
            this.showParameters();
        } else {
            this.view.setupEmptyWorkItemList();
        }
    }

    public void enableParameters() {
        this.parametersEnabled = true;
    }

    void forEachWorkItem(BiConsumer<String, String> biConsumer) {
        ((HasWorkItemPage)this.plugin()).forEachWorkItem(biConsumer);
    }

    boolean hasWorkItems() {
        return this.view.workItemsCount() > 1;
    }

    void selectWorkItem(String selectedWorkItem) {
        ((HasWorkItemPage)this.plugin()).setWorkItem(selectedWorkItem);
        this.showParameters();
    }

    void showParameters() {
        boolean hasWorkItemDefinition;
        boolean bl = hasWorkItemDefinition = this.workItemDefinition() != null;
        if (this.isParametersEnabled() && hasWorkItemDefinition) {
            this.view.showParameters(this.parametersWidget());
        } else {
            this.view.hideParameters();
        }
    }

    String currentWorkItem() {
        return ((HasWorkItemPage)((Object)this.plugin)).getWorkItem();
    }

    boolean isParametersEnabled() {
        return this.parametersEnabled;
    }

    private WorkItemParametersWidget parametersWidget() {
        WorkItemParametersWidget parametersWidget = new WorkItemParametersWidget((IBindingProvider)this.presenter, false);
        parametersWidget.setParameters(this.workItemDefinition().getParameters());
        return parametersWidget;
    }

    private PortableWorkDefinition workItemDefinition() {
        return ((HasWorkItemPage)this.plugin()).getWorkItemDefinition();
    }

    void markAsViewed() {
        ((HasWorkItemPage)this.plugin()).setWorkItemPageAsCompleted();
    }

    public static interface View
    extends HasList,
    UberElement<WorkItemPage> {
        public String getSelectedWorkItem();

        public void setupWorkItemList();

        public void setupEmptyWorkItemList();

        public void selectWorkItem(String var1);

        public void showParameters(WorkItemParametersWidget var1);

        public void hideParameters();

        public int workItemsCount();
    }
}

