/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.wizard.column.plugins;

import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.drools.workbench.models.datamodel.rule.IPattern;
import org.drools.workbench.models.datamodel.rule.InterpolationVariable;
import org.drools.workbench.models.datamodel.rule.RuleModel;
import org.drools.workbench.models.datamodel.rule.util.InterpolationVariableCollector;
import org.drools.workbench.models.datamodel.rule.visitors.RuleModelVisitor;
import org.drools.workbench.models.guided.dtable.shared.model.BRLConditionColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BRLConditionVariableColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BRLRuleModel;
import org.drools.workbench.models.guided.dtable.shared.model.BaseColumn;
import org.drools.workbench.models.guided.dtable.shared.model.CompositeColumn;
import org.drools.workbench.models.guided.dtable.shared.model.ConditionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.DTColumnConfig52;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.models.guided.dtable.shared.model.LimitedEntryBRLConditionColumn;
import org.drools.workbench.screens.guided.dtable.client.widget.RuleModelCloneVisitor;
import org.drools.workbench.screens.guided.dtable.client.widget.table.model.synchronizers.ModelSynchronizer;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.NewGuidedDecisionTableColumnWizard;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.commons.HasAdditionalInfoPage;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.commons.HasDefaultValuesPage;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.commons.HasRuleModellerPage;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.AdditionalInfoPage;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.DefaultValuesPage;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.RuleModellerPage;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.plugins.commons.AdditionalInfoPageInitializer;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.plugins.commons.BaseDecisionTableColumnPlugin;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.plugins.commons.DecisionTableColumnPlugin;
import org.drools.workbench.screens.guided.rule.client.editor.RuleModellerConfiguration;
import org.drools.workbench.screens.guided.rule.client.editor.events.TemplateVariablesChangedEvent;
import org.drools.workbench.screens.guided.rule.client.editor.plugin.RuleModellerActionPlugin;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.uberfire.ext.widgets.core.client.wizards.WizardPage;
import org.uberfire.ext.widgets.core.client.wizards.WizardPageStatusChangeEvent;

@Dependent
public class BRLConditionColumnPlugin
extends BaseDecisionTableColumnPlugin
implements HasDefaultValuesPage,
HasRuleModellerPage,
HasAdditionalInfoPage,
TemplateVariablesChangedEvent.Handler {
    private static final String EMPTY_COLUMN_NAME = "";
    private RuleModellerPage ruleModellerPage;
    private DefaultValuesPage defaultValuesPage;
    private AdditionalInfoPage additionalInfoPage;
    private BRLConditionColumn editingCol;
    private Boolean ruleModellerPageCompleted = Boolean.FALSE;
    private HandlerRegistration registration;
    private RuleModel ruleModel = null;

    @Inject
    public BRLConditionColumnPlugin(RuleModellerPage ruleModellerPage, DefaultValuesPage defaultValuesPage, AdditionalInfoPage additionalInfoPage, Event<WizardPageStatusChangeEvent> changeEvent, TranslationService translationService) {
        super(changeEvent, translationService);
        this.ruleModellerPage = ruleModellerPage;
        this.defaultValuesPage = defaultValuesPage;
        this.additionalInfoPage = additionalInfoPage;
    }

    @Override
    public void init(NewGuidedDecisionTableColumnWizard wizard) {
        super.init(wizard);
        this.setupEditingCol();
        this.setupRuleModellerEvents();
    }

    @Override
    public void onClose() {
        super.onClose();
        this.teardownRuleModellerEvents();
    }

    @Override
    public String getTitle() {
        return this.translate("BRLConditionColumnPlugin.AddConditionBRL", new Object[0]);
    }

    @Override
    public List<WizardPage> getPages() {
        return new ArrayList<WizardPage>(){
            {
                this.add(BRLConditionColumnPlugin.this.ruleModellerPage);
                this.add(BRLConditionColumnPlugin.this.defaultValuesPage);
                this.add(BRLConditionColumnPlugin.this.additionalInfoPage());
            }
        };
    }

    @Override
    public Boolean generateColumn() {
        this.setupDefinedVariables(this.getRuleModel());
        this.editingCol().setDefinition(Arrays.asList(this.getRuleModel().lhs));
        if (this.isNewColumn().booleanValue()) {
            this.presenter.appendColumn((ConditionCol52)this.editingCol());
        } else {
            try {
                this.presenter.updateColumn(this.getOriginalColumn(), (ConditionCol52)this.editingCol());
            }
            catch (ModelSynchronizer.VetoUpdatePatternInUseException veto) {
                this.wizard.showPatternInUseError();
                return false;
            }
            catch (ModelSynchronizer.VetoException veto) {
                this.wizard.showGenericVetoError();
                return false;
            }
        }
        return true;
    }

    ConditionCol52 getOriginalColumn() {
        return (ConditionCol52)this.getOriginalColumnConfig52();
    }

    @Override
    public DecisionTableColumnPlugin.Type getType() {
        return DecisionTableColumnPlugin.Type.ADVANCED;
    }

    @Override
    public boolean setupDefinedVariables(RuleModel ruleModel) {
        HashMap ivs = new HashMap();
        RuleModelVisitor rmv = new RuleModelVisitor(ivs);
        rmv.visit((Object)ruleModel);
        Map result = new InterpolationVariableCollector(ivs, "String").getMap();
        this.editingCol.setChildColumns(this.convertInterpolationVariables(result));
        return ivs.size() > 0;
    }

    private List<BRLConditionVariableColumn> convertInterpolationVariables(Map<InterpolationVariable, Integer> ivs) {
        if (ivs.isEmpty()) {
            BRLConditionVariableColumn variable = new BRLConditionVariableColumn(EMPTY_COLUMN_NAME, "Boolean");
            variable.setHeader(this.editingCol.getHeader());
            variable.setHideColumn(this.editingCol.isHideColumn());
            Optional<BRLConditionVariableColumn> oldCol = this.getChildEditingCol(EMPTY_COLUMN_NAME);
            if (oldCol.isPresent()) {
                variable.setDefaultValue(oldCol.get().getDefaultValue());
            }
            ArrayList<BRLConditionVariableColumn> variables = new ArrayList<BRLConditionVariableColumn>();
            variables.add(variable);
            return variables;
        }
        BRLConditionVariableColumn[] variables = new BRLConditionVariableColumn[ivs.size()];
        for (Map.Entry<InterpolationVariable, Integer> me : ivs.entrySet()) {
            InterpolationVariable iv = me.getKey();
            int index = me.getValue();
            BRLConditionVariableColumn variable = new BRLConditionVariableColumn(iv.getVarName(), iv.getDataType(), iv.getFactType(), iv.getFactField(), iv.getOperator());
            Optional<BRLConditionVariableColumn> oldCol = this.getChildEditingCol(iv.getVarName());
            if (oldCol.isPresent()) {
                variable.setDefaultValue(oldCol.get().getDefaultValue());
            }
            variable.setHeader(this.editingCol.getHeader());
            variable.setHideColumn(this.editingCol.isHideColumn());
            variables[index] = variable;
        }
        ArrayList<BRLConditionVariableColumn> variableList = new ArrayList<BRLConditionVariableColumn>();
        for (BRLConditionVariableColumn variable : variables) {
            variableList.add(variable);
        }
        return variableList;
    }

    private Optional<BRLConditionVariableColumn> getChildEditingCol(String varName) {
        for (BRLConditionVariableColumn childColumn : this.editingCol().getChildColumns()) {
            if (!Objects.equals(varName, childColumn.getVarName())) continue;
            return Optional.of(childColumn);
        }
        return Optional.empty();
    }

    public BRLConditionColumn editingCol() {
        return this.editingCol;
    }

    @Override
    public String getHeader() {
        return this.editingCol().getHeader();
    }

    @Override
    public void setHeader(String header) {
        this.editingCol().setHeader(header);
        this.fireChangeEvent(this.additionalInfoPage);
    }

    @Override
    public Set<String> getAlreadyUsedColumnHeaders() {
        List conditions = this.getModel().getConditions();
        HashSet<String> columnNames = new HashSet<String>();
        for (CompositeColumn condition : conditions) {
            List headers = condition.getChildColumns().stream().map(BaseColumn::getHeader).collect(Collectors.toList());
            columnNames.addAll(headers);
        }
        return columnNames;
    }

    private GuidedDecisionTable52 getModel() {
        return this.getPresenter().getModel();
    }

    @Override
    public boolean isHideColumn() {
        return this.editingCol().isHideColumn();
    }

    @Override
    public void setHideColumn(boolean hideColumn) {
        this.editingCol().setHideColumn(hideColumn);
    }

    @Override
    public void setInsertLogical(Boolean value) {
    }

    @Override
    public void setUpdate(Boolean value) {
    }

    @Override
    public boolean showUpdateEngineWithChanges() {
        return false;
    }

    @Override
    public boolean showLogicallyInsert() {
        return false;
    }

    @Override
    public boolean isLogicallyInsert() {
        return false;
    }

    @Override
    public boolean isUpdateEngine() {
        return false;
    }

    @Override
    public RuleModel getRuleModel() {
        this.ruleModel = Optional.ofNullable(this.ruleModel).orElse(this.newRuleModel());
        return this.ruleModel;
    }

    @Override
    public Collection<RuleModellerActionPlugin> getRuleModellerActionPlugins() {
        return Collections.emptyList();
    }

    private RuleModel newRuleModel() {
        BRLRuleModel ruleModel = new BRLRuleModel(this.getModel());
        List definition = this.editingCol.getDefinition();
        ruleModel.lhs = definition.toArray(new IPattern[definition.size()]);
        return ruleModel;
    }

    @Override
    public RuleModellerConfiguration getRuleModellerConfiguration() {
        return new RuleModellerConfiguration(false, true, true, true);
    }

    @Override
    public String getRuleModellerDescription() {
        return this.translate("RuleModellerPage.InsertAConditionBRLFragment", new Object[0]);
    }

    @Override
    public void setRuleModellerPageAsCompleted() {
        if (!this.isRuleModellerPageCompleted().booleanValue()) {
            this.setRuleModellerPageCompleted();
            this.fireChangeEvent(this.ruleModellerPage);
        }
    }

    void setupEditingCol() {
        this.editingCol = this.isNewColumn() != false ? this.newBRLCondition() : this.clone(this.getOriginalColumnConfig52());
    }

    BRLConditionColumn clone(DTColumnConfig52 column) {
        LimitedEntryBRLConditionColumn clone;
        BRLConditionColumn brlConditionColumn = (BRLConditionColumn)column;
        if (this.tableFormat() == GuidedDecisionTable52.TableFormat.LIMITED_ENTRY) {
            clone = new LimitedEntryBRLConditionColumn();
        } else {
            clone = new BRLConditionColumn();
            clone.setChildColumns(this.cloneVariables(brlConditionColumn.getChildColumns()));
        }
        clone.setHeader(column.getHeader());
        clone.setHideColumn(column.isHideColumn());
        clone.setDefinition(this.cloneDefinition(brlConditionColumn.getDefinition()));
        clone.setOperator(brlConditionColumn.getOperator());
        return clone;
    }

    List<BRLConditionVariableColumn> cloneVariables(List<BRLConditionVariableColumn> variables) {
        return variables.stream().map(this::cloneVariable).collect(Collectors.toList());
    }

    BRLConditionVariableColumn cloneVariable(BRLConditionVariableColumn variable) {
        BRLConditionVariableColumn clone = new BRLConditionVariableColumn(variable.getVarName(), variable.getFieldType(), variable.getFactType(), variable.getFactField());
        if (variable.getDefaultValue() != null) {
            clone.setDefaultValue(variable.getDefaultValue().cloneDefaultValueCell());
        }
        clone.setHeader(variable.getHeader());
        clone.setHideColumn(variable.isHideColumn());
        clone.setWidth(variable.getWidth());
        clone.setOperator(variable.getOperator());
        return clone;
    }

    private List<IPattern> cloneDefinition(List<IPattern> definition) {
        RuleModelCloneVisitor visitor = new RuleModelCloneVisitor();
        RuleModel rm = new RuleModel();
        definition.forEach(arg_0 -> ((RuleModel)rm).addLhsItem(arg_0));
        ArrayList<IPattern> clone = new ArrayList<IPattern>();
        Collections.addAll(clone, visitor.visitRuleModel((RuleModel)rm).lhs);
        return clone;
    }

    void setupRuleModellerEvents() {
        this.registration = this.presenter.getEventBus().addHandler(TemplateVariablesChangedEvent.TYPE, (EventHandler)this);
    }

    void teardownRuleModellerEvents() {
        this.registration.removeHandler();
    }

    void setRuleModellerPageCompleted() {
        this.ruleModellerPageCompleted = Boolean.TRUE;
    }

    @Override
    public Boolean isRuleModellerPageCompleted() {
        return this.ruleModellerPageCompleted;
    }

    private BRLConditionColumn newBRLCondition() {
        switch (this.tableFormat()) {
            case EXTENDED_ENTRY: {
                return new BRLConditionColumn();
            }
            case LIMITED_ENTRY: {
                return new LimitedEntryBRLConditionColumn();
            }
        }
        throw new UnsupportedOperationException("Unsupported table format: " + this.tableFormat());
    }

    @Override
    public GuidedDecisionTable52.TableFormat tableFormat() {
        return this.getModel().getTableFormat();
    }

    private AdditionalInfoPage additionalInfoPage() {
        return AdditionalInfoPageInitializer.init(this.additionalInfoPage, this);
    }

    public void onTemplateVariablesChanged(TemplateVariablesChangedEvent event) {
        if (event.getSource() == this.getRuleModel()) {
            this.setupDefinedVariables(event.getModel());
        }
    }
}

