/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.editor;

import com.google.gwt.core.client.Scheduler;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.enterprise.event.Event;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.screens.guided.dtable.client.editor.BaseGuidedDecisionTableEditorPresenter;
import org.drools.workbench.screens.guided.dtable.client.editor.BaseGuidedDecisionTablePresenterTest;
import org.drools.workbench.screens.guided.dtable.client.editor.GuidedDecisionTableDocksHandler;
import org.drools.workbench.screens.guided.dtable.client.editor.GuidedDecisionTableGraphEditorPresenter;
import org.drools.workbench.screens.guided.dtable.client.editor.menu.InsertMenuBuilder;
import org.drools.workbench.screens.guided.dtable.client.editor.menu.RadarMenuBuilder;
import org.drools.workbench.screens.guided.dtable.client.editor.menu.ViewMenuBuilder;
import org.drools.workbench.screens.guided.dtable.client.type.GuidedDTableGraphResourceType;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableModellerView;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTablePresenter;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableView;
import org.drools.workbench.screens.guided.dtable.client.widget.table.events.cdi.DecisionTableSelectedEvent;
import org.drools.workbench.screens.guided.dtable.client.wizard.NewGuidedDecisionTableWizardHelper;
import org.drools.workbench.screens.guided.dtable.model.GuidedDecisionTableEditorContent;
import org.drools.workbench.screens.guided.dtable.model.GuidedDecisionTableEditorGraphContent;
import org.drools.workbench.screens.guided.dtable.model.GuidedDecisionTableEditorGraphModel;
import org.drools.workbench.screens.guided.dtable.service.GuidedDecisionTableEditorService;
import org.drools.workbench.screens.guided.dtable.service.GuidedDecisionTableGraphEditorService;
import org.drools.workbench.screens.guided.dtable.service.GuidedDecisionTableGraphSaveAndRenameService;
import org.guvnor.common.services.project.categories.Decision;
import org.guvnor.common.services.project.client.context.WorkspaceProjectContext;
import org.guvnor.common.services.project.client.security.ProjectController;
import org.guvnor.common.services.project.model.Package;
import org.guvnor.common.services.project.model.WorkspaceProject;
import org.guvnor.common.services.shared.metadata.model.Metadata;
import org.guvnor.common.services.shared.metadata.model.Overview;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.soup.project.datamodel.imports.Imports;
import org.kie.workbench.common.services.shared.project.KieModuleService;
import org.kie.workbench.common.services.verifier.reporting.client.panel.AnalysisReportScreen;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracle;
import org.kie.workbench.common.widgets.client.menu.FileMenuBuilder;
import org.kie.workbench.common.widgets.client.search.common.SearchPerformedEvent;
import org.kie.workbench.common.widgets.client.source.ViewDRLSourceWidget;
import org.kie.workbench.common.widgets.configresource.client.widget.bound.ImportsWidgetPresenter;
import org.kie.workbench.common.widgets.metadata.client.KieDocument;
import org.kie.workbench.common.widgets.metadata.client.KieMultipleDocumentEditorWrapperView;
import org.kie.workbench.common.widgets.metadata.client.menu.RegisteredDocumentsMenuBuilder;
import org.kie.workbench.common.widgets.metadata.client.widget.OverviewWidgetPresenter;
import org.kie.workbench.common.workbench.client.docks.AuthoringWorkbenchDocks;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.backend.vfs.ObservablePath;
import org.uberfire.backend.vfs.Path;
import org.uberfire.backend.vfs.PathFactory;
import org.uberfire.backend.vfs.impl.ObservablePathImpl;
import org.uberfire.client.callbacks.Callback;
import org.uberfire.client.mvp.LockManager;
import org.uberfire.client.mvp.LockTarget;
import org.uberfire.client.mvp.PerspectiveManager;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.mvp.SaveInProgressEvent;
import org.uberfire.client.mvp.UpdatedLockStatusEvent;
import org.uberfire.client.workbench.events.ChangeTitleWidgetEvent;
import org.uberfire.ext.editor.commons.client.file.popups.SavePopUpPresenter;
import org.uberfire.ext.editor.commons.client.history.VersionRecordManager;
import org.uberfire.ext.editor.commons.client.menu.BasicFileMenuBuilder;
import org.uberfire.ext.editor.commons.client.menu.common.SaveAndRenameCommandBuilder;
import org.uberfire.ext.editor.commons.client.resources.i18n.CommonConstants;
import org.uberfire.ext.editor.commons.client.validation.Validator;
import org.uberfire.ext.editor.commons.version.events.RestoreEvent;
import org.uberfire.ext.editor.commons.version.impl.PortableVersionRecord;
import org.uberfire.ext.widgets.common.client.common.HasBusyIndicator;
import org.uberfire.ext.wires.core.grids.client.widget.layer.impl.GridLienzoPanel;
import org.uberfire.java.nio.base.version.VersionRecord;
import org.uberfire.mocks.CallerMock;
import org.uberfire.mocks.EventSourceMock;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.ParameterizedCommand;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.PathPlaceRequest;
import org.uberfire.workbench.events.NotificationEvent;
import org.uberfire.workbench.model.menu.MenuItem;

@RunWith(value=GwtMockitoTestRunner.class)
public class GuidedDecisionTableGraphEditorPresenterTest
extends BaseGuidedDecisionTablePresenterTest<GuidedDecisionTableGraphEditorPresenter> {
    private static final int INITIAL_HASH_CODE = 100;
    private static final int EDITOR_HASH_CODE = 200;
    @Mock
    private LockManager lockManager;
    @Mock
    private GuidedDecisionTableGraphEditorService dtGraphService;
    private Caller<GuidedDecisionTableGraphEditorService> dtGraphServiceCaller;
    @Mock
    private KieModuleService moduleService;
    private Caller<KieModuleService> moduleServiceCaller;
    @Mock
    private GuidedDecisionTableGraphSaveAndRenameService graphSaveAndRenameService;
    private Caller<GuidedDecisionTableGraphSaveAndRenameService> graphSaveAndRenameServiceCaller;
    @Mock
    private NewGuidedDecisionTableWizardHelper helper;
    @Mock
    private Package activePackage;
    @Mock
    private Path activePackageResourcesPath;
    @Mock
    private SaveAndRenameCommandBuilder<List<GuidedDecisionTableEditorContent>, Metadata> saveAndRenameCommandBuilder;
    @Captor
    private ArgumentCaptor<ParameterizedCommand<KieDocument>> activateDocumentCommandCaptor;
    @Captor
    private ArgumentCaptor<ParameterizedCommand<KieDocument>> removeDocumentCommandCaptor;
    @Captor
    private ArgumentCaptor<Command> newDocumentCommandCaptor;
    @Captor
    private ArgumentCaptor<DecisionTableSelectedEvent> dtSelectedEventCaptor;
    @Captor
    private ArgumentCaptor<Path> dtPathCaptor;
    @Captor
    private ArgumentCaptor<List<Path>> dtPathsCaptor;
    @Captor
    private ArgumentCaptor<ObservablePath> dtObservablePathCaptor;
    @Captor
    private ArgumentCaptor<PathPlaceRequest> dtPathPlaceRequestCaptor;
    @Captor
    private ArgumentCaptor<LockTarget> lockTargetCaptor;
    @Captor
    private ArgumentCaptor<ParameterizedCommand<String>> commitMessageCommandCaptor;
    @Captor
    private ArgumentCaptor<Callback<VersionRecord>> versionRecordCallbackCaptor;
    @Captor
    private ArgumentCaptor<RemoteCallback<Path>> onSaveSuccessCallbackCaptor;
    @Mock
    protected AuthoringWorkbenchDocks docks;
    @Mock
    private EventSourceMock<SearchPerformedEvent> searchPerformed;
    @Mock
    private AnalysisReportScreen analysisReportScreen;
    private Event<SaveInProgressEvent> saveInProgressEvent = (Event)Mockito.spy((Object)new EventSourceMock<SaveInProgressEvent>(){

        public void fire(SaveInProgressEvent event) {
        }
    });
    private GuidedDTableGraphResourceType dtGraphResourceType = new GuidedDTableGraphResourceType(new Decision());

    @Override
    @Before
    public void setup() {
        this.dtGraphServiceCaller = new CallerMock((Object)this.dtGraphService);
        this.moduleServiceCaller = new CallerMock((Object)this.moduleService);
        this.graphSaveAndRenameServiceCaller = new CallerMock((Object)this.graphSaveAndRenameService);
        Mockito.when((Object)this.view.asWidget()).thenReturn(Mockito.mock(Widget.class));
        Mockito.when((Object)this.moduleService.resolvePackage((Path)Mockito.any())).thenReturn((Object)this.activePackage);
        Mockito.when((Object)this.activePackage.getPackageMainResourcesPath()).thenReturn((Object)this.activePackageResourcesPath);
        Mockito.when((Object)this.alertsButtonMenuItemBuilder.build()).thenReturn((Object)this.alertsButtonMenuItem);
        super.setup();
    }

    @Override
    protected GuidedDecisionTableGraphEditorPresenter getPresenter() {
        return new GuidedDecisionTableGraphEditorPresenter(this.view, this.dtServiceCaller, this.docks, (PerspectiveManager)Mockito.mock(PerspectiveManager.class), (Caller)this.dtGraphServiceCaller, (Caller)this.moduleServiceCaller, (Caller)this.graphSaveAndRenameServiceCaller, this.notification, (Event)this.saveInProgressEvent, this.decisionTableSelectedEvent, (GuidedDecisionTableDocksHandler)Mockito.mock(GuidedDecisionTableDocksHandler.class), this.analysisReportScreen, this.validationPopup, this.dtGraphResourceType, this.editMenuBuilder, this.viewMenuBuilder, this.insertMenuBuilder, this.radarMenuBuilder, this.modeller, this.helper, this.beanManager, this.placeManager, this.lockManager, this.columnsPage, (SaveAndRenameCommandBuilder)this.saveAndRenameCommandBuilder, this.alertsButtonMenuItemBuilder, this.downloadMenuItemBuilder, this.editorSearchIndex, this.searchBarComponent, this.searchableElementFactory, (Event)this.searchPerformed){
            {
                this.workbenchContext = GuidedDecisionTableGraphEditorPresenterTest.this.workbenchContext;
                this.projectController = GuidedDecisionTableGraphEditorPresenterTest.this.projectController;
                this.promises = GuidedDecisionTableGraphEditorPresenterTest.this.promises;
            }

            protected Command getSaveAndRenameCommand() {
                return (Command)Mockito.mock(Command.class);
            }

            PathPlaceRequest getPathPlaceRequest(Path path) {
                PathPlaceRequest pathPlaceRequest = new PathPlaceRequest(path){

                    protected ObservablePath createObservablePath(Path path) {
                        ObservablePath op = new ObservablePathImpl().wrap(path);
                        return op;
                    }
                };
                return pathPlaceRequest;
            }
        };
    }

    @Test
    public void analysisScreenIsSetForModeller() {
        ((GuidedDecisionTableModellerView.Presenter)Mockito.verify((Object)this.modeller)).analysisReportScreen(this.analysisReportScreen);
    }

    @Test
    public void checkInit() {
        ((ViewMenuBuilder)Mockito.verify((Object)this.viewMenuBuilder, (VerificationMode)Mockito.times((int)1))).setModeller((GuidedDecisionTableModellerView.Presenter)Mockito.eq((Object)this.modeller));
        ((InsertMenuBuilder)Mockito.verify((Object)this.insertMenuBuilder, (VerificationMode)Mockito.times((int)1))).setModeller((GuidedDecisionTableModellerView.Presenter)Mockito.eq((Object)this.modeller));
        ((RadarMenuBuilder)Mockito.verify((Object)this.radarMenuBuilder, (VerificationMode)Mockito.times((int)1))).setModeller((GuidedDecisionTableModellerView.Presenter)Mockito.eq((Object)this.modeller));
        ((BaseGuidedDecisionTableEditorPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setModellerView((GuidedDecisionTableModellerView)Mockito.eq((Object)this.modellerView));
        ((RegisteredDocumentsMenuBuilder)Mockito.verify((Object)this.registeredDocumentsMenuBuilder, (VerificationMode)Mockito.times((int)1))).setActivateDocumentCommand((ParameterizedCommand)Mockito.any(ParameterizedCommand.class));
        ((RegisteredDocumentsMenuBuilder)Mockito.verify((Object)this.registeredDocumentsMenuBuilder, (VerificationMode)Mockito.times((int)1))).setRemoveDocumentCommand((ParameterizedCommand)Mockito.any(ParameterizedCommand.class));
        ((RegisteredDocumentsMenuBuilder)Mockito.verify((Object)this.registeredDocumentsMenuBuilder, (VerificationMode)Mockito.times((int)1))).setNewDocumentCommand((Command)Mockito.any(Command.class));
    }

    @Test
    public void testGetCurrentHashCode() {
        GuidedDecisionTableView.Presenter activeDocument1 = (GuidedDecisionTableView.Presenter)Mockito.mock(GuidedDecisionTableView.Presenter.class);
        GuidedDecisionTableView.Presenter activeDocument2 = (GuidedDecisionTableView.Presenter)Mockito.mock(GuidedDecisionTableView.Presenter.class);
        Integer activeDocument1Hashcode = 123;
        Integer activeDocument2Hashcode = 456;
        Integer expectedHashcode = 789;
        ((GuidedDecisionTableGraphEditorPresenter)Mockito.doReturn(this.asSet(activeDocument1, activeDocument2)).when((Object)this.presenter)).getAvailableDecisionTables();
        ((GuidedDecisionTableGraphEditorPresenter)Mockito.doReturn((Object)123).when((Object)this.presenter)).currentHashCode(activeDocument1);
        ((GuidedDecisionTableGraphEditorPresenter)Mockito.doReturn((Object)456).when((Object)this.presenter)).currentHashCode(activeDocument2);
        ((GuidedDecisionTableGraphEditorPresenter)Mockito.doReturn((Object)expectedHashcode).when((Object)this.presenter)).combineHashCodes(Arrays.asList(activeDocument1Hashcode, activeDocument2Hashcode));
        ((GuidedDecisionTableGraphEditorPresenter)Mockito.doReturn((Object)expectedHashcode).when((Object)this.presenter)).combineHashCodes(Arrays.asList(activeDocument2Hashcode, activeDocument1Hashcode));
        Integer actualHashcode = (Integer)((GuidedDecisionTableGraphEditorPresenter)this.presenter).getCurrentHashCodeSupplier().get();
        Assert.assertEquals((Object)expectedHashcode, (Object)actualHashcode);
    }

    @Test
    public void checkInitActivateDocumentFromRegisteredDocumentMenu() {
        ((RegisteredDocumentsMenuBuilder)Mockito.verify((Object)this.registeredDocumentsMenuBuilder, (VerificationMode)Mockito.times((int)1))).setActivateDocumentCommand((ParameterizedCommand)this.activateDocumentCommandCaptor.capture());
        GuidedDecisionTablePresenter dtPresenter = (GuidedDecisionTablePresenter)Mockito.mock(GuidedDecisionTablePresenter.class);
        ParameterizedCommand activeDocumentCommand = (ParameterizedCommand)this.activateDocumentCommandCaptor.getValue();
        Assert.assertNotNull((Object)activeDocumentCommand);
        activeDocumentCommand.execute((Object)dtPresenter);
        ((Event)Mockito.verify((Object)this.decisionTableSelectedEvent, (VerificationMode)Mockito.times((int)1))).fire(this.dtSelectedEventCaptor.capture());
        Assert.assertNotNull((Object)this.dtSelectedEventCaptor.getValue());
        Assert.assertEquals((Object)dtPresenter, ((DecisionTableSelectedEvent)this.dtSelectedEventCaptor.getValue()).getPresenter().get());
    }

    @Test
    public void checkInitRemoveDocumentFromRegisteredDocumentMenu() {
        ((RegisteredDocumentsMenuBuilder)Mockito.verify((Object)this.registeredDocumentsMenuBuilder, (VerificationMode)Mockito.times((int)1))).setRemoveDocumentCommand((ParameterizedCommand)this.removeDocumentCommandCaptor.capture());
        GuidedDecisionTablePresenter dtPresenter = (GuidedDecisionTablePresenter)Mockito.mock(GuidedDecisionTablePresenter.class);
        ((GuidedDecisionTableGraphEditorPresenter)Mockito.doReturn((Object)true).when((Object)this.presenter)).mayClose((GuidedDecisionTableView.Presenter)Mockito.eq((Object)dtPresenter));
        ((GuidedDecisionTableGraphEditorPresenter)Mockito.doNothing().when((Object)this.presenter)).removeDocument((GuidedDecisionTableView.Presenter)Mockito.any(GuidedDecisionTablePresenter.class));
        ParameterizedCommand removeDocumentCommand = (ParameterizedCommand)this.removeDocumentCommandCaptor.getValue();
        Assert.assertNotNull((Object)removeDocumentCommand);
        removeDocumentCommand.execute((Object)dtPresenter);
        ((GuidedDecisionTableGraphEditorPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.times((int)1))).mayClose((GuidedDecisionTableView.Presenter)Mockito.eq((Object)dtPresenter));
        ((GuidedDecisionTableGraphEditorPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.times((int)1))).removeDocument((GuidedDecisionTableView.Presenter)Mockito.eq((Object)dtPresenter));
    }

    @Test
    public void checkInitNewDocumentFromRegisteredDocumentMenu() {
        ((RegisteredDocumentsMenuBuilder)Mockito.verify((Object)this.registeredDocumentsMenuBuilder, (VerificationMode)Mockito.times((int)1))).setNewDocumentCommand((Command)this.newDocumentCommandCaptor.capture());
        Command newDocumentCommand = (Command)this.newDocumentCommandCaptor.getValue();
        Assert.assertNotNull((Object)newDocumentCommand);
        newDocumentCommand.execute();
        ((GuidedDecisionTableGraphEditorPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.times((int)1))).onNewDocument();
        ((NewGuidedDecisionTableWizardHelper)Mockito.verify((Object)this.helper, (VerificationMode)Mockito.times((int)1))).createNewGuidedDecisionTable((Path)Mockito.eq((Object)this.activePackageResourcesPath), (String)Mockito.eq((Object)""), (GuidedDecisionTable52.TableFormat)Mockito.eq((Object)GuidedDecisionTable52.TableFormat.EXTENDED_ENTRY), (GuidedDecisionTable52.HitPolicy)Mockito.eq((Object)GuidedDecisionTable52.HitPolicy.NONE), (HasBusyIndicator)Mockito.eq((Object)this.view), (RemoteCallback)this.onSaveSuccessCallbackCaptor.capture());
        Path dtPath = (Path)Mockito.mock(Path.class);
        RemoteCallback onSaveSuccessCallback = (RemoteCallback)this.onSaveSuccessCallbackCaptor.getValue();
        Assert.assertNotNull((Object)onSaveSuccessCallback);
        ((GuidedDecisionTableGraphEditorPresenter)Mockito.doNothing().when((Object)this.presenter)).onOpenDocumentsInEditor((List)Mockito.any(List.class));
        onSaveSuccessCallback.callback((Object)dtPath);
        ((GuidedDecisionTableGraphEditorPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.times((int)1))).onOpenDocumentsInEditor((List)this.dtPathsCaptor.capture());
        List dtPaths = (List)this.dtPathsCaptor.getValue();
        Assert.assertNotNull((Object)dtPaths);
        Assert.assertEquals((long)1L, (long)dtPaths.size());
        Assert.assertEquals((Object)dtPath, dtPaths.get(0));
    }

    @Test
    public void testSetupMenuBar() {
        ((FileMenuBuilder)Mockito.verify((Object)this.fileMenuBuilder)).addSave((MenuItem)Mockito.any(MenuItem.class));
        ((FileMenuBuilder)Mockito.verify((Object)this.fileMenuBuilder)).addCopy((BasicFileMenuBuilder.PathProvider)Mockito.any(BasicFileMenuBuilder.PathProvider.class), (Validator)Mockito.eq((Object)this.assetUpdateValidator));
        ((FileMenuBuilder)Mockito.verify((Object)this.fileMenuBuilder)).addRename((Command)Mockito.any(Command.class));
        ((FileMenuBuilder)Mockito.verify((Object)this.fileMenuBuilder)).addDelete((BasicFileMenuBuilder.PathProvider)Mockito.any(BasicFileMenuBuilder.PathProvider.class), (Validator)Mockito.eq((Object)this.assetUpdateValidator));
        ((FileMenuBuilder)Mockito.verify((Object)this.fileMenuBuilder)).addValidate((Command)Mockito.any(Command.class));
        ((FileMenuBuilder)Mockito.verify((Object)this.fileMenuBuilder)).addNewTopLevelMenu((MenuItem)Mockito.eq((Object)this.editMenuItem));
        ((FileMenuBuilder)Mockito.verify((Object)this.fileMenuBuilder)).addNewTopLevelMenu((MenuItem)Mockito.eq((Object)this.viewMenuItem));
        ((FileMenuBuilder)Mockito.verify((Object)this.fileMenuBuilder)).addNewTopLevelMenu((MenuItem)Mockito.eq((Object)this.insertMenuItem));
        ((FileMenuBuilder)Mockito.verify((Object)this.fileMenuBuilder)).addNewTopLevelMenu((MenuItem)Mockito.eq((Object)this.radarMenuItem));
        ((FileMenuBuilder)Mockito.verify((Object)this.fileMenuBuilder)).addNewTopLevelMenu((MenuItem)Mockito.eq((Object)this.versionManagerMenuItem));
        ((FileMenuBuilder)Mockito.verify((Object)this.fileMenuBuilder)).addNewTopLevelMenu((MenuItem)Mockito.eq((Object)this.registeredDocumentsMenuItem));
        ((FileMenuBuilder)Mockito.verify((Object)this.fileMenuBuilder)).addNewTopLevelMenu(this.alertsButtonMenuItem);
        ((FileMenuBuilder)Mockito.verify((Object)this.fileMenuBuilder)).addNewTopLevelMenu(this.downloadMenuItemButton);
    }

    @Test
    public void testMakeMenuBarWithoutUpdateProjectPermission() {
        Mockito.reset((Object[])new FileMenuBuilder[]{this.fileMenuBuilder});
        ((WorkspaceProjectContext)Mockito.doReturn(Optional.of(Mockito.mock(WorkspaceProject.class))).when((Object)this.workbenchContext)).getActiveWorkspaceProject();
        ((ProjectController)Mockito.doReturn((Object)this.promises.resolve((Object)false)).when((Object)this.projectController)).canUpdateProject((WorkspaceProject)Mockito.any());
        ((GuidedDecisionTableGraphEditorPresenter)this.presenter).makeMenuBar();
        ((FileMenuBuilder)Mockito.verify((Object)this.fileMenuBuilder, (VerificationMode)Mockito.never())).addSave((MenuItem)Mockito.any(MenuItem.class));
        ((FileMenuBuilder)Mockito.verify((Object)this.fileMenuBuilder, (VerificationMode)Mockito.never())).addCopy((BasicFileMenuBuilder.PathProvider)Mockito.any(BasicFileMenuBuilder.PathProvider.class), (Validator)Mockito.eq((Object)this.assetUpdateValidator));
        ((FileMenuBuilder)Mockito.verify((Object)this.fileMenuBuilder, (VerificationMode)Mockito.never())).addRename((BasicFileMenuBuilder.PathProvider)Mockito.any(BasicFileMenuBuilder.PathProvider.class), (Validator)Mockito.eq((Object)this.assetUpdateValidator));
        ((FileMenuBuilder)Mockito.verify((Object)this.fileMenuBuilder, (VerificationMode)Mockito.never())).addDelete((BasicFileMenuBuilder.PathProvider)Mockito.any(BasicFileMenuBuilder.PathProvider.class), (Validator)Mockito.eq((Object)this.assetUpdateValidator));
        ((FileMenuBuilder)Mockito.verify((Object)this.fileMenuBuilder, (VerificationMode)Mockito.times((int)1))).addNewTopLevelMenu(this.alertsButtonMenuItem);
    }

    @Test
    public void checkOnStartupBasicInitialisation() {
        ObservablePath dtGraphPath = (ObservablePath)Mockito.mock(ObservablePath.class);
        PlaceRequest dtGraphPlaceRequest = (PlaceRequest)Mockito.mock(PlaceRequest.class);
        GuidedDecisionTableEditorGraphContent dtGraphContent = this.makeDecisionTableGraphContent(100);
        Mockito.when((Object)dtGraphPath.toURI()).thenReturn((Object)"dtGraphPath");
        Mockito.when((Object)this.dtGraphService.loadContent((Path)Mockito.eq((Object)dtGraphPath))).thenReturn((Object)dtGraphContent);
        Mockito.when((Object)this.versionRecordManager.getCurrentPath()).thenReturn((Object)dtGraphPath);
        Mockito.when((Object)dtGraphPath.getFileName()).thenReturn((Object)"filename");
        ((GuidedDecisionTableGraphEditorPresenter)this.presenter).onStartup(dtGraphPath, dtGraphPlaceRequest);
        Assert.assertEquals((Object)dtGraphPath, (Object)((GuidedDecisionTableGraphEditorPresenter)this.presenter).editorPath);
        Assert.assertEquals((Object)dtGraphPlaceRequest, (Object)((GuidedDecisionTableGraphEditorPresenter)this.presenter).editorPlaceRequest);
        Assert.assertEquals((long)100L, (long)((GuidedDecisionTableGraphEditorPresenter)this.presenter).originalGraphHash.intValue());
        ((GuidedDecisionTableGraphEditorPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.times((int)1))).initialiseEditor((ObservablePath)Mockito.eq((Object)dtGraphPath), (PlaceRequest)Mockito.eq((Object)dtGraphPlaceRequest));
        ((GuidedDecisionTableGraphEditorPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.times((int)1))).initialiseVersionManager();
        ((GuidedDecisionTableGraphEditorPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.times((int)1))).addFileChangeListeners((ObservablePath)Mockito.eq((Object)dtGraphPath));
        ((LockManager)Mockito.verify((Object)this.lockManager, (VerificationMode)Mockito.times((int)1))).init((LockTarget)this.lockTargetCaptor.capture());
        LockTarget lockTarget = (LockTarget)this.lockTargetCaptor.getValue();
        Assert.assertNotNull((Object)lockTarget);
        Assert.assertEquals((Object)dtGraphPath, (Object)lockTarget.getPath());
        Assert.assertEquals((Object)dtGraphPlaceRequest, (Object)lockTarget.getPlace());
        Assert.assertNotNull((Object)lockTarget.getTitle());
    }

    @Test
    public void checkOnStartupLoadGraphEntries() {
        ObservablePath dtGraphPath = (ObservablePath)Mockito.mock(ObservablePath.class);
        PlaceRequest dtGraphPlaceRequest = (PlaceRequest)Mockito.mock(PlaceRequest.class);
        GuidedDecisionTableEditorGraphContent dtGraphContent = this.makeDecisionTableGraphContent(100);
        Path dtPath = (Path)Mockito.mock(Path.class);
        GuidedDecisionTableEditorContent dtContent = this.makeDecisionTableContent();
        GuidedDecisionTableView.Presenter dtPresenter = this.makeDecisionTable(dtPath, dtGraphPath, dtGraphPlaceRequest, dtContent);
        GuidedDecisionTableEditorGraphModel.GuidedDecisionTableGraphEntry dtGraphEntry = new GuidedDecisionTableEditorGraphModel.GuidedDecisionTableGraphEntry(dtPath, dtPath);
        dtGraphContent.getModel().getEntries().add(dtGraphEntry);
        Mockito.when((Object)dtPath.toURI()).thenReturn((Object)"dtPath");
        Mockito.when((Object)dtGraphPath.toURI()).thenReturn((Object)"dtGraphPath");
        Mockito.when((Object)dtGraphPath.getFileName()).thenReturn((Object)"filename");
        Mockito.when((Object)this.dtService.loadContent((Path)Mockito.eq((Object)dtPath))).thenReturn((Object)dtContent);
        Mockito.when((Object)this.dtGraphService.loadContent((Path)Mockito.eq((Object)dtGraphPath))).thenReturn((Object)dtGraphContent);
        Mockito.when((Object)this.versionRecordManager.getCurrentPath()).thenReturn((Object)dtGraphPath);
        ((GuidedDecisionTableGraphEditorPresenter)Mockito.doReturn((Object)this.makeDecisionTableGraphContent(200).getModel()).when((Object)this.presenter)).buildModelFromEditor();
        Mockito.when((Object)this.modeller.addDecisionTable((ObservablePath)Mockito.any(ObservablePath.class), (PlaceRequest)Mockito.any(PlaceRequest.class), (GuidedDecisionTableEditorContent)Mockito.any(GuidedDecisionTableEditorContent.class), ((Boolean)Mockito.any(Boolean.class)).booleanValue(), (Double)Mockito.any(), (Double)Mockito.any())).thenReturn((Object)dtPresenter);
        ((GuidedDecisionTableGraphEditorPresenter)this.presenter).onStartup(dtGraphPath, dtGraphPlaceRequest);
        ((BaseGuidedDecisionTableEditorPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).showLoading();
        ((GuidedDecisionTableGraphEditorPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.times((int)1))).loadDocumentGraph((ObservablePath)Mockito.eq((Object)dtGraphPath));
        ((GuidedDecisionTableEditorService)Mockito.verify((Object)this.dtService, (VerificationMode)Mockito.times((int)1))).loadContent((Path)Mockito.eq((Object)dtPath));
        ((GuidedDecisionTableModellerView.Presenter)Mockito.verify((Object)this.modeller, (VerificationMode)Mockito.times((int)1))).addDecisionTable((ObservablePath)this.dtObservablePathCaptor.capture(), (PlaceRequest)this.dtPathPlaceRequestCaptor.capture(), (GuidedDecisionTableEditorContent)Mockito.eq((Object)dtContent), ((Boolean)Mockito.any(Boolean.class)).booleanValue(), (Double)Mockito.eq(null), (Double)Mockito.eq(null));
        ObservablePath dtObservablePath = (ObservablePath)this.dtObservablePathCaptor.getValue();
        PathPlaceRequest dtPathPlaceRequest = (PathPlaceRequest)this.dtPathPlaceRequestCaptor.getValue();
        Assert.assertNotNull((Object)dtObservablePath);
        Assert.assertNotNull((Object)dtPathPlaceRequest);
        Assert.assertEquals((Object)dtPath.toURI(), (Object)dtObservablePath.toURI());
        Assert.assertEquals((Object)dtPath.toURI(), (Object)dtPathPlaceRequest.getPath().toURI());
        Assert.assertEquals((long)200L, (long)((GuidedDecisionTableGraphEditorPresenter)this.presenter).originalGraphHash.intValue());
        ((GuidedDecisionTableGraphEditorPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.times((int)1))).registerDocument((KieDocument)Mockito.eq((Object)dtPresenter));
        ((BaseGuidedDecisionTableEditorPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).hideBusyIndicator();
        ((Event)Mockito.verify((Object)this.decisionTableSelectedEvent, (VerificationMode)Mockito.times((int)1))).fire(this.dtSelectedEventCaptor.capture());
        DecisionTableSelectedEvent dtSelectedEvent = (DecisionTableSelectedEvent)this.dtSelectedEventCaptor.getValue();
        Assert.assertNotNull((Object)dtSelectedEvent);
        Assert.assertTrue((boolean)dtSelectedEvent.getPresenter().isPresent());
        Assert.assertEquals((Object)dtPresenter, dtSelectedEvent.getPresenter().get());
        ((GridLienzoPanel)Mockito.verify((Object)this.modellerGridPanel)).setFocus(Mockito.eq((boolean)true));
        ((LockManager)Mockito.verify((Object)this.lockManager, (VerificationMode)Mockito.never())).acquireLock();
    }

    @Test
    public void testLoadDocumentGraphEmptyModel() throws Exception {
        ObservablePath documentPath = (ObservablePath)Mockito.mock(ObservablePath.class);
        Overview overview = (Overview)Mockito.mock(Overview.class);
        GuidedDecisionTableEditorGraphModel graphModel = (GuidedDecisionTableEditorGraphModel)Mockito.mock(GuidedDecisionTableEditorGraphModel.class);
        GuidedDecisionTableEditorGraphContent graphContent = (GuidedDecisionTableEditorGraphContent)Mockito.mock(GuidedDecisionTableEditorGraphContent.class);
        Mockito.when((Object)documentPath.getFileName()).thenReturn((Object)"GDT");
        Mockito.when((Object)this.versionRecordManager.getCurrentPath()).thenReturn((Object)documentPath);
        Mockito.when((Object)this.dtGraphService.loadContent((Path)documentPath)).thenReturn((Object)graphContent);
        Mockito.when((Object)this.versionRecordManager.getPathToLatest()).thenReturn((Object)documentPath);
        Mockito.when((Object)graphContent.getOverview()).thenReturn((Object)overview);
        Mockito.when((Object)graphContent.getModel()).thenReturn((Object)graphModel);
        ((GuidedDecisionTableGraphEditorPresenter)this.presenter).loadDocumentGraph(documentPath);
        ((BaseGuidedDecisionTableEditorPresenter.View)Mockito.verify((Object)this.view)).showLoading();
        ((BaseGuidedDecisionTableEditorPresenter.View)Mockito.verify((Object)this.view)).hideBusyIndicator();
        ((BaseGuidedDecisionTableEditorPresenter.View)Mockito.verify((Object)this.view)).refreshTitle(Matchers.startsWith((String)"GDT"));
        ((MenuItem)Mockito.verify((Object)this.editMenuItem)).setEnabled(false);
        ((MenuItem)Mockito.verify((Object)this.viewMenuItem)).setEnabled(false);
        ((MenuItem)Mockito.verify((Object)this.insertMenuItem)).setEnabled(false);
        ((MenuItem)Mockito.verify((Object)this.radarMenuItem)).setEnabled(false);
        ((KieMultipleDocumentEditorWrapperView)Mockito.verify((Object)this.kieEditorWrapperView)).clear();
        ((KieMultipleDocumentEditorWrapperView)Mockito.verify((Object)this.kieEditorWrapperView)).addMainEditorPage((IsWidget)this.view);
        ((KieMultipleDocumentEditorWrapperView)Mockito.verify((Object)this.kieEditorWrapperView)).addOverviewPage((OverviewWidgetPresenter)Mockito.eq((Object)this.overviewWidget), (com.google.gwt.user.client.Command)Mockito.any(com.google.gwt.user.client.Command.class));
        ((OverviewWidgetPresenter)Mockito.verify((Object)this.overviewWidget)).setContent(overview, documentPath);
    }

    @Test
    public void checkMayCloseWithCleanDecisionTableGraph() {
        this.checkMayClose(0, () -> Assert.assertTrue((boolean)((GuidedDecisionTableGraphEditorPresenter)this.presenter).mayClose()));
    }

    @Test
    public void checkMayCloseWithDirtyDecisionTableGraph() {
        this.checkMayClose(1, () -> Assert.assertFalse((boolean)((GuidedDecisionTableGraphEditorPresenter)this.presenter).mayClose()));
    }

    private void checkMayClose(int uiModelHashCode, Command assertion) {
        ObservablePath dtGraphPath = (ObservablePath)Mockito.mock(ObservablePath.class);
        PlaceRequest dtGraphPlaceRequest = (PlaceRequest)Mockito.mock(PlaceRequest.class);
        GuidedDecisionTableEditorGraphContent dtGraphContent = this.makeDecisionTableGraphContent(0);
        Mockito.when((Object)dtGraphPath.toURI()).thenReturn((Object)"dtGraphPath");
        Mockito.when((Object)dtGraphPath.getFileName()).thenReturn((Object)"filename");
        Mockito.when((Object)this.dtGraphService.loadContent((Path)Mockito.eq((Object)dtGraphPath))).thenReturn((Object)dtGraphContent);
        Mockito.when((Object)this.versionRecordManager.getCurrentPath()).thenReturn((Object)dtGraphPath);
        ((GuidedDecisionTableGraphEditorPresenter)Mockito.doReturn((Object)this.makeDecisionTableGraphContent(uiModelHashCode).getModel()).when((Object)this.presenter)).buildModelFromEditor();
        ((GuidedDecisionTableGraphEditorPresenter)this.presenter).onStartup(dtGraphPath, dtGraphPlaceRequest);
        assertion.execute();
    }

    @Test
    public void checkMayCloseWithCleanDecisionTableGraphEntries() {
        this.checkMayCloseWithDecisionTableGraphEntries(0, () -> Assert.assertTrue((boolean)((GuidedDecisionTableGraphEditorPresenter)this.presenter).mayClose()));
    }

    @Test
    public void checkMayCloseWithCleanDecisionTableGraphEntriesButDirtyGraphOverview() {
        Mockito.when((Object)this.overviewWidget.isDirty()).thenReturn((Object)true);
        this.checkMayCloseWithDecisionTableGraphEntries(0, () -> Assert.assertFalse((boolean)((GuidedDecisionTableGraphEditorPresenter)this.presenter).mayClose()));
    }

    @Test
    public void checkMayCloseWithDirtyDecisionTableGraphEntries() {
        this.checkMayCloseWithDecisionTableGraphEntries(1, () -> Assert.assertFalse((boolean)((GuidedDecisionTableGraphEditorPresenter)this.presenter).mayClose()));
    }

    private void checkMayCloseWithDecisionTableGraphEntries(int uiModelHashCode, Command assertion) {
        ObservablePath dtGraphPath = (ObservablePath)Mockito.mock(ObservablePath.class);
        PlaceRequest dtGraphPlaceRequest = (PlaceRequest)Mockito.mock(PlaceRequest.class);
        GuidedDecisionTableEditorGraphContent dtGraphContent = this.makeDecisionTableGraphContent();
        ObservablePath dtPath = (ObservablePath)Mockito.mock(ObservablePath.class);
        PlaceRequest dtPlaceRequest = (PlaceRequest)Mockito.mock(PlaceRequest.class);
        GuidedDecisionTableEditorContent dtContent = this.makeDecisionTableContent(0);
        final GuidedDecisionTableView.Presenter dtPresenter = this.makeDecisionTable((Path)dtPath, dtPath, dtPlaceRequest, dtContent);
        GuidedDecisionTableEditorGraphModel.GuidedDecisionTableGraphEntry dtGraphEntry = new GuidedDecisionTableEditorGraphModel.GuidedDecisionTableGraphEntry((Path)dtPath, (Path)dtPath);
        dtGraphContent.getModel().getEntries().add(dtGraphEntry);
        Mockito.when((Object)dtPath.toURI()).thenReturn((Object)"dtPath");
        Mockito.when((Object)dtGraphPath.toURI()).thenReturn((Object)"dtGraphPath");
        Mockito.when((Object)dtGraphPath.getFileName()).thenReturn((Object)"filename");
        Mockito.when((Object)this.dtService.loadContent((Path)Mockito.eq((Object)dtPath))).thenReturn((Object)dtContent);
        Mockito.when((Object)this.dtGraphService.loadContent((Path)Mockito.eq((Object)dtGraphPath))).thenReturn((Object)dtGraphContent);
        Mockito.when((Object)this.versionRecordManager.getCurrentPath()).thenReturn((Object)dtGraphPath);
        Mockito.when((Object)dtPresenter.getOriginalHashCode()).thenReturn((Object)uiModelHashCode);
        ((GuidedDecisionTableGraphEditorPresenter)Mockito.doReturn((Object)this.makeDecisionTableGraphContent(uiModelHashCode).getModel()).when((Object)this.presenter)).buildModelFromEditor();
        Mockito.when((Object)this.modeller.addDecisionTable((ObservablePath)Mockito.any(ObservablePath.class), (PlaceRequest)Mockito.any(PlaceRequest.class), (GuidedDecisionTableEditorContent)Mockito.any(GuidedDecisionTableEditorContent.class), ((Boolean)Mockito.any(Boolean.class)).booleanValue(), (Double)Mockito.any(), (Double)Mockito.any())).thenReturn((Object)dtPresenter);
        Mockito.when((Object)this.modeller.getAvailableDecisionTables()).thenReturn((Object)new HashSet<GuidedDecisionTableView.Presenter>(){
            {
                this.add(dtPresenter);
            }
        });
        ((GuidedDecisionTableGraphEditorPresenter)this.presenter).onStartup(dtGraphPath, dtGraphPlaceRequest);
        assertion.execute();
    }

    @Test
    public void checkBuildModelFromEditor() {
        ObservablePath dtPath1 = (ObservablePath)Mockito.mock(ObservablePath.class);
        PlaceRequest dtPlaceRequest1 = (PlaceRequest)Mockito.mock(PlaceRequest.class);
        GuidedDecisionTableEditorContent dtContent1 = this.makeDecisionTableContent(0);
        final GuidedDecisionTableView.Presenter dtPresenter1 = this.makeDecisionTable((Path)dtPath1, dtPath1, dtPlaceRequest1, dtContent1);
        ObservablePath dtPath2 = (ObservablePath)Mockito.mock(ObservablePath.class);
        PlaceRequest dtPlaceRequest2 = (PlaceRequest)Mockito.mock(PlaceRequest.class);
        GuidedDecisionTableEditorContent dtContent2 = this.makeDecisionTableContent(0);
        final GuidedDecisionTableView.Presenter dtPresenter2 = this.makeDecisionTable((Path)dtPath2, dtPath2, dtPlaceRequest2, dtContent2);
        Mockito.when((Object)dtPresenter1.getView().getX()).thenReturn((Object)100.0);
        Mockito.when((Object)dtPresenter1.getView().getY()).thenReturn((Object)110.0);
        Mockito.when((Object)dtPresenter2.getView().getX()).thenReturn((Object)200.0);
        Mockito.when((Object)dtPresenter2.getView().getY()).thenReturn((Object)220.0);
        Mockito.when((Object)this.modeller.getAvailableDecisionTables()).thenReturn((Object)new HashSet<GuidedDecisionTableView.Presenter>(){
            {
                this.add(dtPresenter1);
                this.add(dtPresenter2);
            }
        });
        GuidedDecisionTableEditorGraphModel model = ((GuidedDecisionTableGraphEditorPresenter)this.presenter).buildModelFromEditor();
        Assert.assertNotNull((Object)model);
        Assert.assertNotNull((Object)model.getEntries());
        Assert.assertEquals((long)2L, (long)model.getEntries().size());
        this.assertContains(model.getEntries(), dtPath1, 100.0, 110.0);
        this.assertContains(model.getEntries(), dtPath2, 200.0, 220.0);
    }

    private void assertContains(Set<GuidedDecisionTableEditorGraphModel.GuidedDecisionTableGraphEntry> entries, ObservablePath path, Double x, Double y) {
        if (entries.stream().filter(e -> e.getPathHead().equals(path) && x.equals(e.getX()) && y.equals(e.getY())).collect(Collectors.toList()).isEmpty()) {
            Assert.fail((String)("Path [" + path.toURI() + " not found in GuidedDecisionTableEditorGraphModel.entries()"));
        }
    }

    @Test
    public void checkOnClose() {
        ((GuidedDecisionTableGraphEditorPresenter)this.presenter).onClose();
        ((GuidedDecisionTableModellerView.Presenter)Mockito.verify((Object)this.modeller, (VerificationMode)Mockito.times((int)1))).onClose();
        ((LockManager)Mockito.verify((Object)this.lockManager, (VerificationMode)Mockito.times((int)1))).releaseLock();
    }

    @Test
    public void checkOnDecisionTableSelectedReadOnly() {
        this.checkOnDecisionTableSelected((ParameterizedCommand<PlaceRequest>)((ParameterizedCommand)dtGraphPlaceRequest -> Mockito.when((Object)dtGraphPlaceRequest.getParameter((String)Mockito.eq((Object)"readOnly"), (String)Mockito.any())).thenReturn((Object)Boolean.toString(true))), () -> ((LockManager)Mockito.verify((Object)this.lockManager, (VerificationMode)Mockito.never())).acquireLock());
    }

    @Test
    public void checkOnDecisionTableSelectedNotReadOnly() {
        this.checkOnDecisionTableSelected((ParameterizedCommand<PlaceRequest>)((ParameterizedCommand)dtGraphPlaceRequest -> {}), () -> ((LockManager)Mockito.verify((Object)this.lockManager, (VerificationMode)Mockito.times((int)1))).acquireLock());
    }

    @Test
    public void testOnDecisionTableSelectedWhenPresenterIsNull() {
        DecisionTableSelectedEvent event = (DecisionTableSelectedEvent)Mockito.mock(DecisionTableSelectedEvent.class);
        ((DecisionTableSelectedEvent)Mockito.doReturn(Optional.empty()).when((Object)event)).getPresenter();
        ((GuidedDecisionTableGraphEditorPresenter)Mockito.doNothing().when((Object)this.presenter)).initialiseEditorTabsWhenNoDocuments();
        ((GuidedDecisionTableGraphEditorPresenter)this.presenter).onDecisionTableSelected(event);
        ((GuidedDecisionTableGraphEditorPresenter)Mockito.verify((Object)this.presenter)).initialiseEditorTabsWhenNoDocuments();
    }

    @Test
    public void testOnDecisionTableSelectedWhenPresenterIsNotNull() {
        GuidedDecisionTableView.Presenter dtPresenter = (GuidedDecisionTableView.Presenter)Mockito.mock(GuidedDecisionTableView.Presenter.class);
        Overview overview = (Overview)Mockito.mock(Overview.class);
        AsyncPackageDataModelOracle oracle = (AsyncPackageDataModelOracle)Mockito.mock(AsyncPackageDataModelOracle.class);
        GuidedDecisionTable52 model = new GuidedDecisionTable52();
        GuidedDecisionTablePresenter.Access access = new GuidedDecisionTablePresenter.Access();
        DecisionTableSelectedEvent event = new DecisionTableSelectedEvent(dtPresenter);
        ObservablePath path = (ObservablePath)Mockito.mock(ObservablePath.class);
        ((GuidedDecisionTableGraphEditorPresenter)Mockito.doNothing().when((Object)this.presenter)).initialiseKieEditorTabs(dtPresenter, overview, oracle, model.getImports(), false);
        ((GuidedDecisionTableGraphEditorPresenter)Mockito.doNothing().when((Object)this.presenter)).initialiseEditorTabsWhenNoDocuments();
        ((GuidedDecisionTableModellerView.Presenter)Mockito.doReturn((Object)true).when((Object)this.modeller)).isDecisionTableAvailable(dtPresenter);
        ((GuidedDecisionTableModellerView.Presenter)Mockito.doReturn(Optional.of(dtPresenter)).when((Object)this.modeller)).getActiveDecisionTable();
        ((GuidedDecisionTableView.Presenter)Mockito.doReturn((Object)overview).when((Object)dtPresenter)).getOverview();
        ((GuidedDecisionTableView.Presenter)Mockito.doReturn((Object)oracle).when((Object)dtPresenter)).getDataModelOracle();
        ((GuidedDecisionTableView.Presenter)Mockito.doReturn((Object)model).when((Object)dtPresenter)).getModel();
        ((GuidedDecisionTableView.Presenter)Mockito.doReturn((Object)access).when((Object)dtPresenter)).getAccess();
        ((GuidedDecisionTableView.Presenter)Mockito.doReturn((Object)path).when((Object)dtPresenter)).getLatestPath();
        ((GuidedDecisionTableGraphEditorPresenter)this.presenter).registerDocument((KieDocument)dtPresenter);
        ((GuidedDecisionTableGraphEditorPresenter)this.presenter).onDecisionTableSelected(event);
        ((GuidedDecisionTableGraphEditorPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.never())).initialiseEditorTabsWhenNoDocuments();
        ((GuidedDecisionTableGraphEditorPresenter)Mockito.verify((Object)this.presenter)).addColumnsTab();
        ((GuidedDecisionTableGraphEditorPresenter)Mockito.verify((Object)this.presenter)).enableColumnsTab(dtPresenter);
    }

    private void checkOnDecisionTableSelected(ParameterizedCommand<PlaceRequest> setup, Command assertion) {
        ObservablePath dtGraphPath = (ObservablePath)Mockito.mock(ObservablePath.class);
        PlaceRequest dtGraphPlaceRequest = (PlaceRequest)Mockito.mock(PlaceRequest.class);
        GuidedDecisionTableEditorGraphContent dtGraphContent = this.makeDecisionTableGraphContent();
        ObservablePath dtPath = (ObservablePath)Mockito.mock(ObservablePath.class);
        PlaceRequest dtPlaceRequest = (PlaceRequest)Mockito.mock(PlaceRequest.class);
        GuidedDecisionTableEditorContent dtContent = this.makeDecisionTableContent(0);
        final GuidedDecisionTableView.Presenter dtPresenter = this.makeDecisionTable((Path)dtPath, dtPath, dtPlaceRequest, dtContent);
        GuidedDecisionTableEditorGraphModel.GuidedDecisionTableGraphEntry dtGraphEntry = new GuidedDecisionTableEditorGraphModel.GuidedDecisionTableGraphEntry((Path)dtPath, (Path)dtPath);
        dtGraphContent.getModel().getEntries().add(dtGraphEntry);
        Mockito.when((Object)dtPath.toURI()).thenReturn((Object)"dtPath");
        Mockito.when((Object)dtGraphPath.toURI()).thenReturn((Object)"dtGraphPath");
        Mockito.when((Object)dtGraphPath.getFileName()).thenReturn((Object)"filename");
        Mockito.when((Object)this.dtService.loadContent((Path)Mockito.eq((Object)dtPath))).thenReturn((Object)dtContent);
        Mockito.when((Object)this.dtGraphService.loadContent((Path)Mockito.eq((Object)dtGraphPath))).thenReturn((Object)dtGraphContent);
        Mockito.when((Object)this.versionRecordManager.getCurrentPath()).thenReturn((Object)dtGraphPath);
        Mockito.when((Object)this.modeller.addDecisionTable((ObservablePath)Mockito.any(ObservablePath.class), (PlaceRequest)Mockito.any(PlaceRequest.class), (GuidedDecisionTableEditorContent)Mockito.any(GuidedDecisionTableEditorContent.class), ((Boolean)Mockito.any(Boolean.class)).booleanValue(), (Double)Mockito.any(), (Double)Mockito.any())).thenReturn((Object)dtPresenter);
        Mockito.when((Object)this.modeller.getAvailableDecisionTables()).thenReturn((Object)new HashSet<GuidedDecisionTableView.Presenter>(){
            {
                this.add(dtPresenter);
            }
        });
        setup.execute((Object)dtGraphPlaceRequest);
        ((GuidedDecisionTableGraphEditorPresenter)this.presenter).onStartup(dtGraphPath, dtGraphPlaceRequest);
        DecisionTableSelectedEvent event = new DecisionTableSelectedEvent(dtPresenter);
        ((GuidedDecisionTableGraphEditorPresenter)this.presenter).onDecisionTableSelected(event);
        assertion.execute();
    }

    @Test
    public void checkEnableMenus() {
        ((GuidedDecisionTableGraphEditorPresenter)this.presenter).enableMenus(true);
        this.checkMenuItems(true);
    }

    @Test
    public void checkDisableMenus() {
        ((GuidedDecisionTableGraphEditorPresenter)this.presenter).enableMenus(false);
        this.checkMenuItems(false);
    }

    private void checkMenuItems(boolean enabled) {
        ((MenuItem)Mockito.verify((Object)this.saveMenuItem, (VerificationMode)Mockito.times((int)1))).setEnabled(Mockito.eq((boolean)enabled));
        ((MenuItem)Mockito.verify((Object)this.versionManagerMenuItem, (VerificationMode)Mockito.times((int)1))).setEnabled(Mockito.eq((boolean)enabled));
        ((MenuItem)Mockito.verify((Object)this.editMenuItem, (VerificationMode)Mockito.times((int)1))).setEnabled(Mockito.eq((boolean)enabled));
        ((MenuItem)Mockito.verify((Object)this.viewMenuItem, (VerificationMode)Mockito.times((int)1))).setEnabled(Mockito.eq((boolean)enabled));
        ((MenuItem)Mockito.verify((Object)this.insertMenuItem, (VerificationMode)Mockito.times((int)1))).setEnabled(Mockito.eq((boolean)enabled));
        ((MenuItem)Mockito.verify((Object)this.radarMenuItem, (VerificationMode)Mockito.times((int)1))).setEnabled(Mockito.eq((boolean)enabled));
        ((MenuItem)Mockito.verify((Object)this.registeredDocumentsMenuItem, (VerificationMode)Mockito.times((int)1))).setEnabled(Mockito.eq((boolean)enabled));
    }

    @Test
    public void checkGetAvailableDocumentPaths() {
        Mockito.when((Object)this.dtGraphService.listDecisionTablesInPackage((Path)Mockito.eq((Object)((GuidedDecisionTableGraphEditorPresenter)this.presenter).editorPath))).thenReturn((Object)new ArrayList<Path>(){
            {
                this.add(PathFactory.newPath((String)"file1", (String)"file1Url"));
            }
        });
        ((GuidedDecisionTableGraphEditorPresenter)this.presenter).getAvailableDocumentPaths(result -> {
            Assert.assertNotNull((Object)result);
            Assert.assertEquals((long)1L, (long)result.size());
            Assert.assertEquals((Object)"file1", (Object)((Path)result.get(0)).getFileName());
            Assert.assertEquals((Object)"file1Url", (Object)((Path)result.get(0)).toURI());
        });
        ((BaseGuidedDecisionTableEditorPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).showLoading();
        ((GuidedDecisionTableGraphEditorService)Mockito.verify((Object)this.dtGraphService, (VerificationMode)Mockito.times((int)1))).listDecisionTablesInPackage((Path)Mockito.eq((Object)((GuidedDecisionTableGraphEditorPresenter)this.presenter).editorPath));
        ((BaseGuidedDecisionTableEditorPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).hideBusyIndicator();
    }

    @Test
    public void checkOnOpenDocumentsInEditor() {
        final Path dtPath1 = PathFactory.newPath((String)"file1", (String)"file1Url");
        final Path dtPath2 = PathFactory.newPath((String)"file2", (String)"file2Url");
        ArrayList<Path> dtPaths = new ArrayList<Path>(){
            {
                this.add(dtPath1);
                this.add(dtPath2);
            }
        };
        ObservablePath dtPath = (ObservablePath)Mockito.mock(ObservablePath.class);
        PlaceRequest dtPlaceRequest = (PlaceRequest)Mockito.mock(PlaceRequest.class);
        GuidedDecisionTableEditorContent dtContent = this.makeDecisionTableContent(0);
        GuidedDecisionTableView.Presenter dtPresenter = this.makeDecisionTable((Path)dtPath, dtPath, dtPlaceRequest, dtContent);
        Mockito.when((Object)this.modeller.addDecisionTable((ObservablePath)Mockito.any(ObservablePath.class), (PlaceRequest)Mockito.any(PlaceRequest.class), (GuidedDecisionTableEditorContent)Mockito.any(), ((Boolean)Mockito.any(Boolean.class)).booleanValue(), (Double)Mockito.any(), (Double)Mockito.any())).thenReturn((Object)dtPresenter);
        ((GuidedDecisionTableGraphEditorPresenter)this.presenter).onOpenDocumentsInEditor((List)dtPaths);
        ((GuidedDecisionTableEditorService)Mockito.verify((Object)this.dtService, (VerificationMode)Mockito.times((int)2))).loadContent((Path)this.dtPathCaptor.capture());
        List dtLoadedPaths = this.dtPathCaptor.getAllValues();
        Assert.assertNotNull((Object)dtLoadedPaths);
        Assert.assertEquals((long)2L, (long)dtLoadedPaths.size());
        this.assertContains(dtLoadedPaths, dtPath1);
        this.assertContains(dtLoadedPaths, dtPath2);
    }

    private void assertContains(List<Path> paths, Path path) {
        if (paths.stream().filter(p -> p.toURI().equals(path.toURI())).collect(Collectors.toList()).isEmpty()) {
            Assert.fail((String)("Document for path [" + path.toURI() + "] not loaded by GuidedDecisionTableGraphEditorPresenter.loadDocument()."));
        }
    }

    @Test
    public void checkDoSaveWhenReadOnlyWithLatestPath() {
        Mockito.when((Object)this.versionRecordManager.isCurrentLatest()).thenReturn((Object)true);
        this.checkDoSave((ParameterizedCommand<OnSaveSetupDataHolder>)((ParameterizedCommand)setup -> {
            Mockito.when((Object)setup.getDecisionTableGraphPlaceRequest().getParameter((String)Mockito.eq((Object)"readOnly"), (String)Mockito.any())).thenReturn((Object)Boolean.toString(true));
            ((GuidedDecisionTableGraphEditorPresenter)this.presenter).onStartup(setup.getDecisionTableGraphPath(), setup.getDecisionTableGraphPlaceRequest());
        }), () -> ((BaseGuidedDecisionTableEditorPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).alertReadOnly());
    }

    @Test
    public void checkDoSaveWhenReadOnlyWithHistoricPath() {
        this.checkDoSave((ParameterizedCommand<OnSaveSetupDataHolder>)((ParameterizedCommand)setup -> {
            Mockito.when((Object)setup.getDecisionTableGraphPlaceRequest().getParameter((String)Mockito.eq((Object)"readOnly"), (String)Mockito.any())).thenReturn((Object)Boolean.toString(true));
            ((GuidedDecisionTableGraphEditorPresenter)this.presenter).onStartup(setup.getDecisionTableGraphPath(), setup.getDecisionTableGraphPlaceRequest());
        }), () -> ((VersionRecordManager)Mockito.verify((Object)this.versionRecordManager, (VerificationMode)Mockito.times((int)1))).restoreToCurrentVersion(((Boolean)Mockito.any(Boolean.class)).booleanValue()));
    }

    @Test
    public void checkDoSaveWithConcurrentModificationOfGraph() {
        ((GuidedDecisionTableGraphEditorPresenter)Mockito.doNothing().when((Object)this.presenter)).showConcurrentUpdatesPopup();
        this.checkDoSave((ParameterizedCommand<OnSaveSetupDataHolder>)((ParameterizedCommand)dtGraphPlaceRequest -> {
            ((GuidedDecisionTableGraphEditorPresenter)this.presenter).concurrentUpdateSessionInfo = (ObservablePath.OnConcurrentUpdateEvent)Mockito.mock(ObservablePath.OnConcurrentUpdateEvent.class);
        }), () -> ((GuidedDecisionTableGraphEditorPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.times((int)1))).showConcurrentUpdatesPopup());
    }

    private void checkDoSave(ParameterizedCommand<OnSaveSetupDataHolder> setup, Command assertion) {
        ObservablePath dtGraphPath = (ObservablePath)Mockito.mock(ObservablePath.class);
        PlaceRequest dtGraphPlaceRequest = (PlaceRequest)Mockito.mock(PlaceRequest.class);
        GuidedDecisionTableEditorGraphContent dtGraphContent = this.makeDecisionTableGraphContent();
        Mockito.when((Object)dtGraphPath.toURI()).thenReturn((Object)"dtGraphPath");
        Mockito.when((Object)dtGraphPath.getFileName()).thenReturn((Object)"filename");
        Mockito.when((Object)this.dtGraphService.loadContent((Path)Mockito.eq((Object)dtGraphPath))).thenReturn((Object)dtGraphContent);
        Mockito.when((Object)this.versionRecordManager.getCurrentPath()).thenReturn((Object)dtGraphPath);
        setup.execute((Object)new OnSaveSetupDataHolder(dtGraphPath, dtGraphPlaceRequest));
        ((GuidedDecisionTableGraphEditorPresenter)this.presenter).doSave();
        assertion.execute();
    }

    @Test
    public void checkDoSaveWithConcurrentModificationOfGraphEntry() {
        ((GuidedDecisionTableGraphEditorPresenter)Mockito.doNothing().when((Object)this.presenter)).showConcurrentUpdatesPopup();
        this.checkDoSaveWithGraphEntry((ParameterizedCommand<OnSaveSetupDataHolder>)((ParameterizedCommand)setup -> {
            Mockito.when((Object)setup.getDecisionTablePresenter().getConcurrentUpdateSessionInfo()).thenReturn(Mockito.mock(ObservablePath.OnConcurrentUpdateEvent.class));
            ((GuidedDecisionTableGraphEditorPresenter)this.presenter).onStartup(setup.getDecisionTableGraphPath(), setup.getDecisionTableGraphPlaceRequest());
        }), () -> ((GuidedDecisionTableGraphEditorPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.times((int)1))).showConcurrentUpdatesPopup());
    }

    @Test
    public void checkDoSaveWithGraphEntry() {
        ((GuidedDecisionTableGraphEditorPresenter)Mockito.doNothing().when((Object)this.presenter)).saveDocumentGraphEntries();
        this.checkDoSaveWithGraphEntry((ParameterizedCommand<OnSaveSetupDataHolder>)((ParameterizedCommand)setup -> ((GuidedDecisionTableGraphEditorPresenter)this.presenter).onStartup(setup.getDecisionTableGraphPath(), setup.getDecisionTableGraphPlaceRequest())), () -> ((GuidedDecisionTableGraphEditorPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.times((int)1))).saveDocumentGraphEntries());
    }

    private void checkDoSaveWithGraphEntry(ParameterizedCommand<OnSaveSetupDataHolder> setup, Command assertion) {
        ObservablePath dtGraphPath = (ObservablePath)Mockito.mock(ObservablePath.class);
        PathPlaceRequest dtGraphPlaceRequest = (PathPlaceRequest)Mockito.mock(PathPlaceRequest.class);
        GuidedDecisionTableEditorGraphContent dtGraphContent = this.makeDecisionTableGraphContent();
        ObservablePath dtPath = (ObservablePath)Mockito.mock(ObservablePath.class);
        PlaceRequest dtPlaceRequest = (PlaceRequest)Mockito.mock(PlaceRequest.class);
        GuidedDecisionTableEditorContent dtContent = this.makeDecisionTableContent(0);
        final GuidedDecisionTableView.Presenter dtPresenter = this.makeDecisionTable((Path)dtPath, dtPath, dtPlaceRequest, dtContent);
        GuidedDecisionTableEditorGraphModel.GuidedDecisionTableGraphEntry dtGraphEntry = new GuidedDecisionTableEditorGraphModel.GuidedDecisionTableGraphEntry((Path)dtPath, (Path)dtPath);
        dtGraphContent.getModel().getEntries().add(dtGraphEntry);
        Mockito.when((Object)dtPath.toURI()).thenReturn((Object)"dtPath");
        Mockito.when((Object)dtGraphPath.toURI()).thenReturn((Object)"dtGraphPath");
        Mockito.when((Object)dtGraphPath.getFileName()).thenReturn((Object)"filename");
        Mockito.when((Object)this.dtService.loadContent((Path)Mockito.eq((Object)dtPath))).thenReturn((Object)dtContent);
        Mockito.when((Object)this.dtGraphService.loadContent((Path)Mockito.eq((Object)dtGraphPath))).thenReturn((Object)dtGraphContent);
        Mockito.when((Object)this.versionRecordManager.getCurrentPath()).thenReturn((Object)dtGraphPath);
        Mockito.when((Object)this.modeller.addDecisionTable((ObservablePath)Mockito.any(ObservablePath.class), (PlaceRequest)Mockito.any(PlaceRequest.class), (GuidedDecisionTableEditorContent)Mockito.any(GuidedDecisionTableEditorContent.class), ((Boolean)Mockito.any(Boolean.class)).booleanValue(), (Double)Mockito.any(), (Double)Mockito.any())).thenReturn((Object)dtPresenter);
        Mockito.when((Object)this.modeller.getAvailableDecisionTables()).thenReturn((Object)new HashSet<GuidedDecisionTableView.Presenter>(){
            {
                this.add(dtPresenter);
            }
        });
        setup.execute((Object)new OnSaveSetupDataHolder(dtGraphPath, (PlaceRequest)dtGraphPlaceRequest, dtPresenter));
        ((GuidedDecisionTableGraphEditorPresenter)this.presenter).doSave();
        assertion.execute();
    }

    @Test
    public void checkSaveDocumentGraphEntries() {
        ObservablePath dtGraphPath = (ObservablePath)Mockito.mock(ObservablePath.class);
        PathPlaceRequest dtGraphPlaceRequest = (PathPlaceRequest)Mockito.mock(PathPlaceRequest.class);
        GuidedDecisionTableEditorGraphContent dtGraphContent = this.makeDecisionTableGraphContent();
        ObservablePath dtPath1 = (ObservablePath)Mockito.mock(ObservablePath.class);
        PlaceRequest dtPlaceRequest1 = (PlaceRequest)Mockito.mock(PlaceRequest.class);
        GuidedDecisionTableEditorContent dtContent1 = this.makeDecisionTableContent();
        final GuidedDecisionTableView.Presenter dtPresenter1 = this.makeDecisionTable((Path)dtPath1, dtPath1, dtPlaceRequest1, dtContent1);
        ObservablePath dtPath2 = (ObservablePath)Mockito.mock(ObservablePath.class);
        PlaceRequest dtPlaceRequest2 = (PlaceRequest)Mockito.mock(PlaceRequest.class);
        GuidedDecisionTableEditorContent dtContent2 = this.makeDecisionTableContent();
        final GuidedDecisionTableView.Presenter dtPresenter2 = this.makeDecisionTable((Path)dtPath2, dtPath2, dtPlaceRequest2, dtContent2);
        Mockito.when((Object)dtPath1.toURI()).thenReturn((Object)"dtPath1");
        Mockito.when((Object)dtPath2.toURI()).thenReturn((Object)"dtPath2");
        Mockito.when((Object)dtGraphPath.toURI()).thenReturn((Object)"dtGraphPath");
        Mockito.when((Object)dtGraphPath.getFileName()).thenReturn((Object)"filename");
        Mockito.when((Object)this.dtService.loadContent((Path)Mockito.eq((Object)dtPath1))).thenReturn((Object)dtContent1);
        Mockito.when((Object)this.dtService.loadContent((Path)Mockito.eq((Object)dtPath2))).thenReturn((Object)dtContent2);
        Mockito.when((Object)this.dtGraphService.loadContent((Path)Mockito.eq((Object)dtGraphPath))).thenReturn((Object)dtGraphContent);
        Mockito.when((Object)this.versionRecordManager.getCurrentPath()).thenReturn((Object)dtGraphPath);
        Mockito.when((Object)this.modeller.addDecisionTable((ObservablePath)Mockito.any(ObservablePath.class), (PlaceRequest)Mockito.any(PlaceRequest.class), (GuidedDecisionTableEditorContent)Mockito.eq((Object)dtContent1), ((Boolean)Mockito.any(Boolean.class)).booleanValue(), (Double)Mockito.any(), (Double)Mockito.any())).thenReturn((Object)dtPresenter1);
        Mockito.when((Object)this.modeller.addDecisionTable((ObservablePath)Mockito.any(ObservablePath.class), (PlaceRequest)Mockito.any(PlaceRequest.class), (GuidedDecisionTableEditorContent)Mockito.eq((Object)dtContent2), ((Boolean)Mockito.any(Boolean.class)).booleanValue(), (Double)Mockito.any(), (Double)Mockito.any())).thenReturn((Object)dtPresenter2);
        Mockito.when((Object)this.modeller.getAvailableDecisionTables()).thenReturn((Object)new HashSet<GuidedDecisionTableView.Presenter>(){
            {
                this.add(dtPresenter1);
                this.add(dtPresenter2);
            }
        });
        ((GuidedDecisionTableGraphEditorPresenter)this.presenter).onStartup(dtGraphPath, (PlaceRequest)dtGraphPlaceRequest);
        ((GuidedDecisionTableGraphEditorPresenter)this.presenter).saveDocumentGraphEntries();
        ((SavePopUpPresenter)Mockito.verify((Object)this.savePopUpPresenter, (VerificationMode)Mockito.times((int)1))).show((Path)Mockito.any(Path.class), (ParameterizedCommand)this.commitMessageCommandCaptor.capture());
        ParameterizedCommand commitMessageCommand = (ParameterizedCommand)this.commitMessageCommandCaptor.getValue();
        Assert.assertNotNull((Object)commitMessageCommand);
        commitMessageCommand.execute((Object)"message");
        ((BaseGuidedDecisionTableEditorPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).showSaving();
        ((Event)Mockito.verify(this.saveInProgressEvent, (VerificationMode)Mockito.times((int)2))).fire(Mockito.any(SaveInProgressEvent.class));
        ((GuidedDecisionTableGraphEditorService)Mockito.verify((Object)this.dtGraphService, (VerificationMode)Mockito.times((int)1))).save((Path)Mockito.eq((Object)dtGraphPath), Mockito.any(GuidedDecisionTableEditorGraphModel.class), (Metadata)Mockito.any(), (String)Mockito.eq((Object)"message"));
        ((GuidedDecisionTableEditorService)Mockito.verify((Object)this.dtService, (VerificationMode)Mockito.times((int)1))).save((Path)Mockito.eq((Object)dtPath2), Mockito.any(GuidedDecisionTable52.class), Mockito.any(Metadata.class), (String)Mockito.eq((Object)"message"));
        ((GuidedDecisionTableEditorService)Mockito.verify((Object)this.dtService, (VerificationMode)Mockito.times((int)1))).save((Path)Mockito.eq((Object)dtPath2), Mockito.any(GuidedDecisionTable52.class), Mockito.any(), (String)Mockito.eq((Object)"message"));
        ((EventSourceMock)Mockito.verify((Object)this.notificationEvent, (VerificationMode)Mockito.times((int)1))).fire(Mockito.any(NotificationEvent.class));
        ((GuidedDecisionTableView.Presenter)Mockito.verify((Object)dtPresenter1, (VerificationMode)Mockito.times((int)1))).setConcurrentUpdateSessionInfo((ObservablePath.OnConcurrentUpdateEvent)Mockito.eq(null));
        ((GuidedDecisionTableView.Presenter)Mockito.verify((Object)dtPresenter2, (VerificationMode)Mockito.times((int)1))).setConcurrentUpdateSessionInfo((ObservablePath.OnConcurrentUpdateEvent)Mockito.eq(null));
        Assert.assertNull((Object)((GuidedDecisionTableGraphEditorPresenter)this.presenter).concurrentUpdateSessionInfo);
    }

    @Test
    public void checkSaveDocumentGraphEntriesEmptyGraph() {
        ObservablePath dtGraphPath = (ObservablePath)Mockito.mock(ObservablePath.class);
        PathPlaceRequest dtGraphPlaceRequest = (PathPlaceRequest)Mockito.mock(PathPlaceRequest.class);
        GuidedDecisionTableEditorGraphContent dtGraphContent = this.makeDecisionTableGraphContent();
        Mockito.when((Object)dtGraphPath.toURI()).thenReturn((Object)"dtGraphPath");
        Mockito.when((Object)dtGraphPath.getFileName()).thenReturn((Object)"filename");
        Mockito.when((Object)this.dtGraphService.loadContent((Path)Mockito.eq((Object)dtGraphPath))).thenReturn((Object)dtGraphContent);
        Mockito.when((Object)this.versionRecordManager.getCurrentPath()).thenReturn((Object)dtGraphPath);
        Mockito.when((Object)this.modeller.getAvailableDecisionTables()).thenReturn(new HashSet());
        ((GuidedDecisionTableGraphEditorPresenter)this.presenter).onStartup(dtGraphPath, (PlaceRequest)dtGraphPlaceRequest);
        ((GuidedDecisionTableGraphEditorPresenter)this.presenter).saveDocumentGraphEntries();
        ((SavePopUpPresenter)Mockito.verify((Object)this.savePopUpPresenter, (VerificationMode)Mockito.times((int)1))).show((Path)Mockito.any(ObservablePath.class), (ParameterizedCommand)this.commitMessageCommandCaptor.capture());
        ParameterizedCommand commitMessageCommand = (ParameterizedCommand)this.commitMessageCommandCaptor.getValue();
        Assert.assertNotNull((Object)commitMessageCommand);
        commitMessageCommand.execute((Object)"message");
        ((BaseGuidedDecisionTableEditorPresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).showSaving();
        ((Event)Mockito.verify(this.saveInProgressEvent, (VerificationMode)Mockito.never())).fire(Mockito.any(SaveInProgressEvent.class));
        ((GuidedDecisionTableGraphEditorService)Mockito.verify((Object)this.dtGraphService, (VerificationMode)Mockito.times((int)1))).save((Path)Mockito.eq((Object)dtGraphPath), Mockito.any(GuidedDecisionTableEditorGraphModel.class), (Metadata)Mockito.any(), (String)Mockito.eq((Object)"message"));
        ArgumentCaptor notification = ArgumentCaptor.forClass(NotificationEvent.class);
        ((EventSourceMock)Mockito.verify((Object)this.notificationEvent, (VerificationMode)Mockito.times((int)1))).fire(notification.capture());
        Assert.assertEquals((Object)CommonConstants.INSTANCE.ItemSavedSuccessfully(), (Object)((NotificationEvent)notification.getValue()).getNotification());
        Assert.assertNull((Object)((GuidedDecisionTableGraphEditorPresenter)this.presenter).concurrentUpdateSessionInfo);
    }

    @Test
    public void checkInitialiseVersionManager() {
        ((GuidedDecisionTableGraphEditorPresenter)Mockito.doNothing().when((Object)this.presenter)).reload();
        Mockito.when((Object)this.versionRecordManager.isLatest((VersionRecord)Mockito.any(VersionRecord.class))).thenReturn((Object)true);
        ((GuidedDecisionTableGraphEditorPresenter)this.presenter).initialiseVersionManager();
        ((VersionRecordManager)Mockito.verify((Object)this.versionRecordManager, (VerificationMode)Mockito.times((int)1))).init((String)Mockito.eq(null), (ObservablePath)Mockito.eq((Object)((GuidedDecisionTableGraphEditorPresenter)this.presenter).editorPath), (Callback)this.versionRecordCallbackCaptor.capture());
        Callback versionRecordCallback = (Callback)this.versionRecordCallbackCaptor.getValue();
        Assert.assertNotNull((Object)versionRecordCallback);
        versionRecordCallback.callback((Object)new PortableVersionRecord("id", "author", "email", "comment", (Date)Mockito.mock(Date.class), "uri"));
        ((VersionRecordManager)Mockito.verify((Object)this.versionRecordManager, (VerificationMode)Mockito.times((int)1))).setVersion((String)Mockito.eq((Object)"id"));
        ((RegisteredDocumentsMenuBuilder)Mockito.verify((Object)this.registeredDocumentsMenuBuilder, (VerificationMode)Mockito.times((int)1))).setReadOnly(Mockito.eq((boolean)false));
        ((GuidedDecisionTableGraphEditorPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.times((int)1))).reload();
        Assert.assertFalse((boolean)((GuidedDecisionTableGraphEditorPresenter)this.presenter).access.isReadOnly());
    }

    @Test
    public void checkInitialiseKieEditorTabs() {
        ObservablePath dtGraphPath = (ObservablePath)Mockito.mock(ObservablePath.class);
        PlaceRequest dtGraphPlaceRequest = (PlaceRequest)Mockito.mock(PlaceRequest.class);
        GuidedDecisionTableEditorGraphContent dtGraphContent = this.makeDecisionTableGraphContent(0);
        Mockito.when((Object)dtGraphPath.toURI()).thenReturn((Object)"dtGraphPath");
        Mockito.when((Object)dtGraphPath.getFileName()).thenReturn((Object)"filename");
        Mockito.when((Object)this.dtGraphService.loadContent((Path)Mockito.eq((Object)dtGraphPath))).thenReturn((Object)dtGraphContent);
        Mockito.when((Object)this.versionRecordManager.getCurrentPath()).thenReturn((Object)dtGraphPath);
        Mockito.when((Object)this.versionRecordManager.getVersion()).thenReturn((Object)"version");
        ((GuidedDecisionTableGraphEditorPresenter)this.presenter).onStartup(dtGraphPath, dtGraphPlaceRequest);
        ((KieMultipleDocumentEditorWrapperView)Mockito.verify((Object)this.kieEditorWrapperView, (VerificationMode)Mockito.times((int)1))).clear();
        GuidedDecisionTableView.Presenter document = (GuidedDecisionTableView.Presenter)Mockito.mock(GuidedDecisionTableView.Presenter.class);
        AsyncPackageDataModelOracle dmo = (AsyncPackageDataModelOracle)Mockito.mock(AsyncPackageDataModelOracle.class);
        Imports imports = (Imports)Mockito.mock(Imports.class);
        boolean isReadOnly = true;
        ArgumentCaptor onFocusCommandCaptor = ArgumentCaptor.forClass(com.google.gwt.user.client.Command.class);
        ((GuidedDecisionTableGraphEditorPresenter)this.presenter).initialiseKieEditorTabs(document, dtGraphContent.getOverview(), dmo, imports, true);
        ((KieMultipleDocumentEditorWrapperView)Mockito.verify((Object)this.kieEditorWrapperView, (VerificationMode)Mockito.times((int)2))).clear();
        ((KieMultipleDocumentEditorWrapperView)Mockito.verify((Object)this.kieEditorWrapperView, (VerificationMode)Mockito.times((int)2))).addMainEditorPage((IsWidget)this.view);
        ((KieMultipleDocumentEditorWrapperView)Mockito.verify((Object)this.kieEditorWrapperView, (VerificationMode)Mockito.times((int)2))).addOverviewPage((OverviewWidgetPresenter)Mockito.eq((Object)this.overviewWidget), (com.google.gwt.user.client.Command)onFocusCommandCaptor.capture());
        ((OverviewWidgetPresenter)Mockito.verify((Object)this.overviewWidget, (VerificationMode)Mockito.times((int)2))).setContent((Overview)Mockito.eq((Object)dtGraphContent.getOverview()), (ObservablePath)Mockito.any());
        ((KieMultipleDocumentEditorWrapperView)Mockito.verify((Object)this.kieEditorWrapperView, (VerificationMode)Mockito.times((int)1))).addSourcePage((ViewDRLSourceWidget)Mockito.any(ViewDRLSourceWidget.class));
        ((KieMultipleDocumentEditorWrapperView)Mockito.verify((Object)this.kieEditorWrapperView, (VerificationMode)Mockito.times((int)1))).addImportsTab((IsWidget)Mockito.eq((Object)this.importsWidget));
        ((ImportsWidgetPresenter)Mockito.verify((Object)this.importsWidget, (VerificationMode)Mockito.times((int)1))).setContent((AsyncPackageDataModelOracle)Mockito.eq((Object)dmo), (Imports)Mockito.eq((Object)imports), Mockito.eq((boolean)true));
        com.google.gwt.user.client.Command onFocusCommand = (com.google.gwt.user.client.Command)onFocusCommandCaptor.getValue();
        Assert.assertNotNull((Object)onFocusCommand);
        onFocusCommand.execute();
        ((OverviewWidgetPresenter)Mockito.verify((Object)this.overviewWidget, (VerificationMode)Mockito.times((int)1))).refresh((String)Mockito.eq((Object)"version"));
    }

    @Test
    public void checkOnDelete() {
        PlaceRequest placeRequest;
        ((GuidedDecisionTableGraphEditorPresenter)this.presenter).editorPlaceRequest = placeRequest = (PlaceRequest)Mockito.mock(PlaceRequest.class);
        ((GuidedDecisionTableGraphEditorPresenter)this.presenter).onDelete();
        ArgumentCaptor commandCaptor = ArgumentCaptor.forClass(Scheduler.ScheduledCommand.class);
        ((GuidedDecisionTableGraphEditorPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.times((int)1))).scheduleClosure((Scheduler.ScheduledCommand)commandCaptor.capture());
        Scheduler.ScheduledCommand command = (Scheduler.ScheduledCommand)commandCaptor.getValue();
        Assert.assertNotNull((Object)command);
        command.execute();
        ((PlaceManager)Mockito.verify((Object)this.placeManager, (VerificationMode)Mockito.times((int)1))).forceClosePlace((PlaceRequest)Mockito.eq((Object)placeRequest));
    }

    @Test
    public void checkOnRename() {
        ((GuidedDecisionTableGraphEditorPresenter)Mockito.doNothing().when((Object)this.presenter)).reload();
        Mockito.when((Object)this.versionRecordManager.getCurrentPath()).thenReturn(Mockito.mock(ObservablePath.class));
        ((GuidedDecisionTableGraphEditorPresenter)this.presenter).onRename();
        ((GuidedDecisionTableGraphEditorPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.times((int)1))).reload();
        ((EventSourceMock)Mockito.verify((Object)this.changeTitleEvent, (VerificationMode)Mockito.times((int)1))).fire(Mockito.any(ChangeTitleWidgetEvent.class));
    }

    @Test
    public void checkReload() {
        ObservablePath dtGraphPath = (ObservablePath)Mockito.mock(ObservablePath.class);
        PathPlaceRequest dtGraphPlaceRequest = (PathPlaceRequest)Mockito.mock(PathPlaceRequest.class);
        GuidedDecisionTableEditorGraphContent dtGraphContent = this.makeDecisionTableGraphContent();
        ObservablePath dtPath = (ObservablePath)Mockito.mock(ObservablePath.class);
        PlaceRequest dtPlaceRequest = (PlaceRequest)Mockito.mock(PlaceRequest.class);
        GuidedDecisionTableEditorContent dtContent = this.makeDecisionTableContent(0);
        final GuidedDecisionTableView.Presenter dtPresenter = this.makeDecisionTable((Path)dtPath, dtPath, dtPlaceRequest, dtContent);
        GuidedDecisionTableEditorGraphModel.GuidedDecisionTableGraphEntry dtGraphEntry = new GuidedDecisionTableEditorGraphModel.GuidedDecisionTableGraphEntry((Path)dtPath, (Path)dtPath);
        dtGraphContent.getModel().getEntries().add(dtGraphEntry);
        Mockito.when((Object)dtPath.toURI()).thenReturn((Object)"dtPath");
        Mockito.when((Object)dtGraphPath.toURI()).thenReturn((Object)"dtGraphPath");
        Mockito.when((Object)dtGraphPath.getFileName()).thenReturn((Object)"filename");
        Mockito.when((Object)this.dtService.loadContent((Path)Mockito.eq((Object)dtPath))).thenReturn((Object)dtContent);
        Mockito.when((Object)this.dtGraphService.loadContent((Path)Mockito.eq((Object)dtGraphPath))).thenReturn((Object)dtGraphContent);
        Mockito.when((Object)this.versionRecordManager.getCurrentPath()).thenReturn((Object)dtGraphPath);
        Mockito.when((Object)this.modeller.addDecisionTable((ObservablePath)Mockito.any(ObservablePath.class), (PlaceRequest)Mockito.any(PlaceRequest.class), (GuidedDecisionTableEditorContent)Mockito.any(GuidedDecisionTableEditorContent.class), ((Boolean)Mockito.any(Boolean.class)).booleanValue(), (Double)Mockito.any(), (Double)Mockito.any())).thenReturn((Object)dtPresenter);
        Mockito.when((Object)this.modeller.getAvailableDecisionTables()).thenReturn((Object)new HashSet<GuidedDecisionTableView.Presenter>(){
            {
                this.add(dtPresenter);
            }
        });
        ((GuidedDecisionTableGraphEditorPresenter)this.presenter).onStartup(dtGraphPath, (PlaceRequest)dtGraphPlaceRequest);
        ((GuidedDecisionTableGraphEditorPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.times((int)1))).loadDocumentGraph(dtGraphPath);
        ((GuidedDecisionTableGraphEditorPresenter)this.presenter).reload();
        ((GuidedDecisionTableGraphEditorPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.times((int)1))).deregisterDocument((KieDocument)Mockito.eq((Object)dtPresenter));
        ((GuidedDecisionTableGraphEditorPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.times((int)2))).loadDocumentGraph(dtGraphPath);
        ((GuidedDecisionTableModellerView.Presenter)Mockito.verify((Object)this.modeller, (VerificationMode)Mockito.times((int)1))).releaseDecisionTables();
        ((GuidedDecisionTableModellerView)Mockito.verify((Object)this.modellerView, (VerificationMode)Mockito.times((int)1))).clear();
    }

    @Test
    public void checkOnRestore() {
        ObservablePath dtGraphPath = (ObservablePath)Mockito.mock(ObservablePath.class);
        PathPlaceRequest dtGraphPlaceRequest = (PathPlaceRequest)Mockito.mock(PathPlaceRequest.class);
        GuidedDecisionTableEditorGraphContent dtGraphContent = this.makeDecisionTableGraphContent();
        RestoreEvent event = new RestoreEvent(dtGraphPath);
        Mockito.when((Object)dtGraphPath.toURI()).thenReturn((Object)"dtGraphPath");
        Mockito.when((Object)dtGraphPath.getFileName()).thenReturn((Object)"filename");
        Mockito.when((Object)this.dtGraphService.loadContent((Path)Mockito.eq((Object)dtGraphPath))).thenReturn((Object)dtGraphContent);
        Mockito.when((Object)this.versionRecordManager.getCurrentPath()).thenReturn((Object)dtGraphPath);
        Mockito.when((Object)this.versionRecordManager.getPathToLatest()).thenReturn((Object)dtGraphPath);
        ((GuidedDecisionTableGraphEditorPresenter)this.presenter).onStartup(dtGraphPath, (PlaceRequest)dtGraphPlaceRequest);
        ((GuidedDecisionTableGraphEditorPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.times((int)1))).initialiseEditor((ObservablePath)Mockito.eq((Object)dtGraphPath), (PlaceRequest)Mockito.eq((Object)dtGraphPlaceRequest));
        ((GuidedDecisionTableGraphEditorPresenter)this.presenter).onRestore(event);
        ((GuidedDecisionTableGraphEditorPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.times((int)2))).initialiseEditor((ObservablePath)Mockito.eq((Object)dtGraphPath), (PlaceRequest)Mockito.eq((Object)dtGraphPlaceRequest));
        ((Event)Mockito.verify((Object)this.notification, (VerificationMode)Mockito.times((int)1))).fire(Mockito.any(NotificationEvent.class));
    }

    @Test
    public void checkOnUpdatedLockStatusEventWithNullPath() {
        Mockito.when((Object)this.modeller.getActiveDecisionTable()).thenReturn(Optional.empty());
        this.checkOnUpdatedLockStatusEvent(null, false, false, () -> Assert.assertEquals((Object)GuidedDecisionTablePresenter.Access.LockedBy.NOBODY, (Object)((GuidedDecisionTableGraphEditorPresenter)this.presenter).access.getLock()));
    }

    @Test
    public void checkOnUpdatedLockStatusEventNotLocked() {
        Mockito.when((Object)this.modeller.getActiveDecisionTable()).thenReturn(Optional.empty());
        this.checkOnUpdatedLockStatusEvent((ObservablePath)Mockito.mock(ObservablePath.class), false, false, () -> Assert.assertEquals((Object)GuidedDecisionTablePresenter.Access.LockedBy.NOBODY, (Object)((GuidedDecisionTableGraphEditorPresenter)this.presenter).access.getLock()));
    }

    @Test
    public void checkOnUpdatedLockStatusEventLockedByOtherUser() {
        Mockito.when((Object)this.modeller.getActiveDecisionTable()).thenReturn(Optional.empty());
        this.checkOnUpdatedLockStatusEvent((ObservablePath)Mockito.mock(ObservablePath.class), true, false, () -> Assert.assertEquals((Object)GuidedDecisionTablePresenter.Access.LockedBy.OTHER_USER, (Object)((GuidedDecisionTableGraphEditorPresenter)this.presenter).access.getLock()));
    }

    @Test
    public void checkOnUpdatedLockStatusEventLockedByCurrentUser() {
        Mockito.when((Object)this.modeller.getActiveDecisionTable()).thenReturn(Optional.empty());
        this.checkOnUpdatedLockStatusEvent((ObservablePath)Mockito.mock(ObservablePath.class), true, true, () -> Assert.assertEquals((Object)GuidedDecisionTablePresenter.Access.LockedBy.CURRENT_USER, (Object)((GuidedDecisionTableGraphEditorPresenter)this.presenter).access.getLock()));
    }

    @Test
    public void testGetSaveAndRenameCommand() {
        Command expectedCommand = (Command)Mockito.mock(Command.class);
        GuidedDecisionTableGraphEditorPresenter presenter = this.makePresenter();
        ((SaveAndRenameCommandBuilder)Mockito.doReturn(this.saveAndRenameCommandBuilder).when(this.saveAndRenameCommandBuilder)).addPathSupplier((Supplier)Mockito.any());
        ((SaveAndRenameCommandBuilder)Mockito.doReturn(this.saveAndRenameCommandBuilder).when(this.saveAndRenameCommandBuilder)).addValidator((Validator)Mockito.any());
        ((SaveAndRenameCommandBuilder)Mockito.doReturn(this.saveAndRenameCommandBuilder).when(this.saveAndRenameCommandBuilder)).addValidator((Supplier)Mockito.any(Supplier.class));
        ((SaveAndRenameCommandBuilder)Mockito.doReturn(this.saveAndRenameCommandBuilder).when(this.saveAndRenameCommandBuilder)).addRenameService((Caller)Mockito.any());
        ((SaveAndRenameCommandBuilder)Mockito.doReturn(this.saveAndRenameCommandBuilder).when(this.saveAndRenameCommandBuilder)).addMetadataSupplier((Supplier)Mockito.any());
        ((SaveAndRenameCommandBuilder)Mockito.doReturn(this.saveAndRenameCommandBuilder).when(this.saveAndRenameCommandBuilder)).addContentSupplier((Supplier)Mockito.any());
        ((SaveAndRenameCommandBuilder)Mockito.doReturn(this.saveAndRenameCommandBuilder).when(this.saveAndRenameCommandBuilder)).addIsDirtySupplier((Supplier)Mockito.any());
        ((SaveAndRenameCommandBuilder)Mockito.doReturn(this.saveAndRenameCommandBuilder).when(this.saveAndRenameCommandBuilder)).addSuccessCallback((ParameterizedCommand)Mockito.any());
        ((SaveAndRenameCommandBuilder)Mockito.doReturn((Object)expectedCommand).when(this.saveAndRenameCommandBuilder)).build();
        Command actualCommand = presenter.getSaveAndRenameCommand();
        Assert.assertEquals((Object)expectedCommand, (Object)actualCommand);
    }

    @Test
    public void testGetMetadataSupplier() {
        GuidedDecisionTableView.Presenter document = (GuidedDecisionTableView.Presenter)Mockito.mock(GuidedDecisionTableView.Presenter.class);
        Overview overview = (Overview)Mockito.mock(Overview.class);
        Metadata expectedMetadata = (Metadata)Mockito.mock(Metadata.class);
        ((GuidedDecisionTableGraphEditorPresenter)Mockito.doReturn((Object)document).when((Object)this.presenter)).getActiveDocument();
        ((GuidedDecisionTableView.Presenter)Mockito.doReturn((Object)overview).when((Object)document)).getOverview();
        ((Overview)Mockito.doReturn((Object)expectedMetadata).when((Object)overview)).getMetadata();
        Metadata actualMetadata = (Metadata)((GuidedDecisionTableGraphEditorPresenter)this.presenter).getMetadataSupplier().get();
        Assert.assertEquals((Object)expectedMetadata, (Object)actualMetadata);
    }

    @Test
    public void testGetContentSupplier() {
        GuidedDecisionTableView.Presenter presenter = (GuidedDecisionTableView.Presenter)Mockito.mock(GuidedDecisionTableView.Presenter.class);
        GuidedDecisionTable52 model = (GuidedDecisionTable52)Mockito.mock(GuidedDecisionTable52.class);
        Overview overview = (Overview)Mockito.mock(Overview.class);
        ObservablePath currentPath = (ObservablePath)Mockito.mock(ObservablePath.class);
        ObservablePath latestPath = (ObservablePath)Mockito.mock(ObservablePath.class);
        ((GuidedDecisionTableView.Presenter)Mockito.doReturn((Object)model).when((Object)presenter)).getModel();
        ((GuidedDecisionTableView.Presenter)Mockito.doReturn((Object)overview).when((Object)presenter)).getOverview();
        ((GuidedDecisionTableView.Presenter)Mockito.doReturn((Object)currentPath).when((Object)presenter)).getCurrentPath();
        ((GuidedDecisionTableView.Presenter)Mockito.doReturn((Object)latestPath).when((Object)presenter)).getLatestPath();
        ((GuidedDecisionTableGraphEditorPresenter)Mockito.doReturn(this.asSet(presenter)).when((Object)this.presenter)).getAvailableDecisionTables();
        List content = (List)((GuidedDecisionTableGraphEditorPresenter)this.presenter).getContentSupplier().get();
        GuidedDecisionTableEditorContent firstContent = (GuidedDecisionTableEditorContent)content.get(0);
        Assert.assertEquals((long)1L, (long)content.size());
        Assert.assertEquals((Object)model, (Object)firstContent.getModel());
        Assert.assertEquals((Object)overview, (Object)firstContent.getOverview());
        Assert.assertEquals((Object)currentPath, (Object)firstContent.getCurrentPath());
        Assert.assertEquals((Object)latestPath, (Object)firstContent.getLatestPath());
    }

    @Test
    public void testIsGuidedDecisionTablesDirtyWhenItIsDirty() {
        GuidedDecisionTableView.Presenter presenter = (GuidedDecisionTableView.Presenter)Mockito.mock(GuidedDecisionTableView.Presenter.class);
        GuidedDecisionTable52 model = (GuidedDecisionTable52)Mockito.mock(GuidedDecisionTable52.class);
        HashSet<GuidedDecisionTableView.Presenter> availableDecisionTables = this.asSet(presenter);
        int currentHash = 456;
        int originalHash = 123;
        ((GuidedDecisionTableGraphEditorPresenter)Mockito.doReturn((Object)456).when((Object)this.presenter)).currentHashCode(presenter);
        ((GuidedDecisionTableGraphEditorPresenter)Mockito.doReturn((Object)123).when((Object)this.presenter)).originalHashCode(presenter);
        ((GuidedDecisionTableView.Presenter)Mockito.doReturn((Object)model).when((Object)presenter)).getModel();
        ((GuidedDecisionTableGraphEditorPresenter)Mockito.doReturn(availableDecisionTables).when((Object)this.presenter)).getAvailableDecisionTables();
        boolean isDirty = ((GuidedDecisionTableGraphEditorPresenter)this.presenter).isGuidedDecisionTablesDirty();
        Assert.assertTrue((boolean)isDirty);
    }

    @Test
    public void testIsGuidedDecisionTablesDirtyWhenItIsNotDirty() {
        GuidedDecisionTableView.Presenter presenter = (GuidedDecisionTableView.Presenter)Mockito.mock(GuidedDecisionTableView.Presenter.class);
        GuidedDecisionTable52 model = (GuidedDecisionTable52)Mockito.mock(GuidedDecisionTable52.class);
        HashSet<GuidedDecisionTableView.Presenter> availableDecisionTables = this.asSet(presenter);
        int currentHash = 123;
        int originalHash = 123;
        ((GuidedDecisionTableGraphEditorPresenter)Mockito.doReturn((Object)123).when((Object)this.presenter)).currentHashCode(presenter);
        ((GuidedDecisionTableGraphEditorPresenter)Mockito.doReturn((Object)123).when((Object)this.presenter)).originalHashCode(presenter);
        ((GuidedDecisionTableView.Presenter)Mockito.doReturn((Object)model).when((Object)presenter)).getModel();
        ((GuidedDecisionTableGraphEditorPresenter)Mockito.doReturn(availableDecisionTables).when((Object)this.presenter)).getAvailableDecisionTables();
        boolean isDirty = ((GuidedDecisionTableGraphEditorPresenter)this.presenter).isGuidedDecisionTablesDirty();
        Assert.assertFalse((boolean)isDirty);
    }

    @Test
    public void testIsGraphDirtyWhenItIsDirty() {
        ((GuidedDecisionTableGraphEditorPresenter)this.presenter).originalGraphHash = 123;
        ((GuidedDecisionTableGraphEditorPresenter)Mockito.doReturn((Object)456).when((Object)this.presenter)).getCurrentHashCode();
        boolean isDirty = ((GuidedDecisionTableGraphEditorPresenter)this.presenter).isGraphDirty();
        Assert.assertTrue((boolean)isDirty);
    }

    @Test
    public void testIsGraphDirtyWhenItIsNotDirty() {
        ((GuidedDecisionTableGraphEditorPresenter)this.presenter).originalGraphHash = 123;
        ((GuidedDecisionTableGraphEditorPresenter)Mockito.doReturn((Object)123).when((Object)this.presenter)).getCurrentHashCode();
        boolean isDirty = ((GuidedDecisionTableGraphEditorPresenter)this.presenter).isGraphDirty();
        Assert.assertFalse((boolean)isDirty);
    }

    @Test
    public void testIsOverviewWidgetDirtyWhenItIsDirty() {
        OverviewWidgetPresenter overviewWidget = (OverviewWidgetPresenter)Mockito.mock(OverviewWidgetPresenter.class);
        ((OverviewWidgetPresenter)Mockito.doReturn((Object)true).when((Object)overviewWidget)).isDirty();
        ((GuidedDecisionTableGraphEditorPresenter)Mockito.doReturn((Object)overviewWidget).when((Object)this.presenter)).getOverviewWidget();
        boolean isDirty = ((GuidedDecisionTableGraphEditorPresenter)this.presenter).isOverviewWidgetDirty();
        Assert.assertTrue((boolean)isDirty);
    }

    @Test
    public void testIsOverviewWidgetDirtyWhenItIsNotDirty() {
        OverviewWidgetPresenter overviewWidget = (OverviewWidgetPresenter)Mockito.mock(OverviewWidgetPresenter.class);
        ((OverviewWidgetPresenter)Mockito.doReturn((Object)false).when((Object)overviewWidget)).isDirty();
        ((GuidedDecisionTableGraphEditorPresenter)Mockito.doReturn((Object)overviewWidget).when((Object)this.presenter)).getOverviewWidget();
        boolean isDirty = ((GuidedDecisionTableGraphEditorPresenter)this.presenter).isOverviewWidgetDirty();
        Assert.assertFalse((boolean)isDirty);
    }

    @Test
    public void testGetIsDirtySupplierWhenGuidedDecisionTablesIsDirty() {
        ((GuidedDecisionTableGraphEditorPresenter)Mockito.doReturn((Object)true).when((Object)this.presenter)).isGuidedDecisionTablesDirty();
        ((GuidedDecisionTableGraphEditorPresenter)Mockito.doReturn((Object)false).when((Object)this.presenter)).isGraphDirty();
        ((GuidedDecisionTableGraphEditorPresenter)Mockito.doReturn((Object)false).when((Object)this.presenter)).isOverviewWidgetDirty();
        Supplier isDirtySupplier = ((GuidedDecisionTableGraphEditorPresenter)this.presenter).getIsDirtySupplier();
        Assert.assertTrue((boolean)((Boolean)isDirtySupplier.get()));
    }

    @Test
    public void testGetIsDirtySupplierWhenGraphIsDirty() {
        ((GuidedDecisionTableGraphEditorPresenter)Mockito.doReturn((Object)false).when((Object)this.presenter)).isGuidedDecisionTablesDirty();
        ((GuidedDecisionTableGraphEditorPresenter)Mockito.doReturn((Object)true).when((Object)this.presenter)).isGraphDirty();
        ((GuidedDecisionTableGraphEditorPresenter)Mockito.doReturn((Object)false).when((Object)this.presenter)).isOverviewWidgetDirty();
        Supplier isDirtySupplier = ((GuidedDecisionTableGraphEditorPresenter)this.presenter).getIsDirtySupplier();
        Assert.assertTrue((boolean)((Boolean)isDirtySupplier.get()));
    }

    @Test
    public void testGetIsDirtySupplierWhenOverviewWidgetIsDirty() {
        ((GuidedDecisionTableGraphEditorPresenter)Mockito.doReturn((Object)false).when((Object)this.presenter)).isGuidedDecisionTablesDirty();
        ((GuidedDecisionTableGraphEditorPresenter)Mockito.doReturn((Object)false).when((Object)this.presenter)).isGraphDirty();
        ((GuidedDecisionTableGraphEditorPresenter)Mockito.doReturn((Object)true).when((Object)this.presenter)).isOverviewWidgetDirty();
        Supplier isDirtySupplier = ((GuidedDecisionTableGraphEditorPresenter)this.presenter).getIsDirtySupplier();
        Assert.assertTrue((boolean)((Boolean)isDirtySupplier.get()));
    }

    @Test
    public void testGetIsDirtySupplierWhenItIsNotDirty() {
        ((GuidedDecisionTableGraphEditorPresenter)Mockito.doReturn((Object)false).when((Object)this.presenter)).isGuidedDecisionTablesDirty();
        ((GuidedDecisionTableGraphEditorPresenter)Mockito.doReturn((Object)false).when((Object)this.presenter)).isGraphDirty();
        ((GuidedDecisionTableGraphEditorPresenter)Mockito.doReturn((Object)false).when((Object)this.presenter)).isOverviewWidgetDirty();
        Supplier isDirtySupplier = ((GuidedDecisionTableGraphEditorPresenter)this.presenter).getIsDirtySupplier();
        Assert.assertFalse((boolean)((Boolean)isDirtySupplier.get()));
    }

    private HashSet<GuidedDecisionTableView.Presenter> asSet(final GuidedDecisionTableView.Presenter ... presenter) {
        return new HashSet<GuidedDecisionTableView.Presenter>(){
            {
                this.addAll(Arrays.asList(presenter));
            }
        };
    }

    private void checkOnUpdatedLockStatusEvent(ObservablePath path, boolean locked, boolean lockedByCurrentUser, Command assertion) {
        ((GuidedDecisionTableGraphEditorPresenter)this.presenter).editorPath = path;
        ((GuidedDecisionTableGraphEditorPresenter)this.presenter).access.setLock(GuidedDecisionTablePresenter.Access.LockedBy.NOBODY);
        UpdatedLockStatusEvent event = new UpdatedLockStatusEvent((Path)path, locked, lockedByCurrentUser);
        ((GuidedDecisionTableGraphEditorPresenter)this.presenter).onUpdatedLockStatusEvent(event);
        assertion.execute();
    }

    protected GuidedDecisionTableEditorGraphContent makeDecisionTableGraphContent() {
        return this.makeDecisionTableGraphContent(0);
    }

    protected GuidedDecisionTableEditorGraphContent makeDecisionTableGraphContent(final int hashCode) {
        GuidedDecisionTableEditorGraphModel model = new GuidedDecisionTableEditorGraphModel(){

            public int hashCode() {
                return hashCode;
            }

            public boolean equals(Object o) {
                return super.equals(o);
            }
        };
        return new GuidedDecisionTableEditorGraphContent(model, (Overview)Mockito.mock(Overview.class));
    }

    private GuidedDecisionTableGraphEditorPresenter makePresenter() {
        return new GuidedDecisionTableGraphEditorPresenter(this.view, this.dtServiceCaller, this.docks, (PerspectiveManager)Mockito.mock(PerspectiveManager.class), this.dtGraphServiceCaller, this.moduleServiceCaller, this.graphSaveAndRenameServiceCaller, this.notification, this.saveInProgressEvent, this.decisionTableSelectedEvent, (GuidedDecisionTableDocksHandler)Mockito.mock(GuidedDecisionTableDocksHandler.class), (AnalysisReportScreen)Mockito.mock(AnalysisReportScreen.class), this.validationPopup, this.dtGraphResourceType, this.editMenuBuilder, this.viewMenuBuilder, this.insertMenuBuilder, this.radarMenuBuilder, this.modeller, this.helper, this.beanManager, this.placeManager, this.lockManager, this.columnsPage, this.saveAndRenameCommandBuilder, this.alertsButtonMenuItemBuilder, this.downloadMenuItemBuilder, this.editorSearchIndex, this.searchBarComponent, this.searchableElementFactory, this.searchPerformed);
    }

    private static class OnSaveSetupDataHolder {
        private ObservablePath dtGraphPath;
        private PlaceRequest dtGraphPlaceRequest;
        private GuidedDecisionTableView.Presenter dtPresenter;

        public OnSaveSetupDataHolder(ObservablePath dtGraphPath, PlaceRequest dtGraphPlaceRequest) {
            this(dtGraphPath, dtGraphPlaceRequest, null);
        }

        public OnSaveSetupDataHolder(ObservablePath dtGraphPath, PlaceRequest dtGraphPlaceRequest, GuidedDecisionTableView.Presenter dtPresenter) {
            this.dtGraphPath = dtGraphPath;
            this.dtGraphPlaceRequest = dtGraphPlaceRequest;
            this.dtPresenter = dtPresenter;
        }

        public ObservablePath getDecisionTableGraphPath() {
            return this.dtGraphPath;
        }

        public PlaceRequest getDecisionTableGraphPlaceRequest() {
            return this.dtGraphPlaceRequest;
        }

        public GuidedDecisionTableView.Presenter getDecisionTablePresenter() {
            return this.dtPresenter;
        }
    }
}

