/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.editor.menu;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.drools.workbench.models.guided.dtable.shared.model.ConditionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.DTCellValue52;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.models.guided.dtable.shared.model.MetadataCol52;
import org.drools.workbench.models.guided.dtable.shared.model.Pattern52;
import org.drools.workbench.screens.guided.dtable.client.editor.clipboard.Clipboard;
import org.drools.workbench.screens.guided.dtable.client.editor.clipboard.impl.DefaultClipboard;
import org.drools.workbench.screens.guided.dtable.client.editor.menu.EditMenuBuilder;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTablePresenter;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableView;
import org.drools.workbench.screens.guided.dtable.client.widget.table.events.cdi.DecisionTableSelectedEvent;
import org.drools.workbench.screens.guided.dtable.client.widget.table.events.cdi.DecisionTableSelectionsChangedEvent;
import org.drools.workbench.screens.guided.dtable.client.widget.table.events.cdi.RefreshMenusEvent;
import org.drools.workbench.screens.guided.dtable.client.widget.table.model.GuidedDecisionTableUiModel;
import org.drools.workbench.screens.guided.dtable.client.widget.table.model.synchronizers.ModelSynchronizer;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.common.DecisionTablePopoverUtils;
import org.gwtbootstrap3.client.ui.constants.IconType;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.widgets.common.client.menu.MenuItemFactory;
import org.uberfire.ext.widgets.common.client.menu.MenuItemView;
import org.uberfire.ext.widgets.common.client.menu.MenuItemWithIconView;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridRow;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridColumn;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridRow;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.columns.GridColumnRenderer;

@RunWith(value=GwtMockitoTestRunner.class)
public class EditMenuBuilderTest {
    private EditMenuBuilder builder;
    private GuidedDecisionTable52 model;
    private GuidedDecisionTableUiModel uiModel;
    private Clipboard clipboard;
    private GuidedDecisionTablePresenter.Access access = new GuidedDecisionTablePresenter.Access();
    @Mock
    private TranslationService ts;
    @Mock
    private ManagedInstance<MenuItemView> menuItemViewProducer;
    @Mock
    private MenuItemWithIconView menuItemWithIconView;
    @Mock
    private HTMLElement menuItemHTMLElement;
    @Mock
    private GuidedDecisionTableView.Presenter dtPresenter;
    @Mock
    private GridColumnRenderer<String> gridColumnRenderer;
    @Mock
    private GridColumn.HeaderMetaData headerMetaData;
    @Mock
    private GuidedDecisionTableView dtPresenterView;
    @Mock
    private DecisionTablePopoverUtils popoverUtils;

    @Before
    public void setup() {
        this.model = new GuidedDecisionTable52();
        this.uiModel = new GuidedDecisionTableUiModel((ModelSynchronizer)Mockito.mock(ModelSynchronizer.class));
        this.clipboard = new DefaultClipboard();
        MenuItemFactory menuItemFactory = new MenuItemFactory(this.menuItemViewProducer);
        Mockito.when((Object)this.dtPresenter.hasEditableColumns()).thenReturn((Object)true);
        Mockito.when((Object)this.dtPresenter.getView()).thenReturn((Object)this.dtPresenterView);
        Mockito.when((Object)this.dtPresenter.getModel()).thenReturn((Object)this.model);
        Mockito.when((Object)this.dtPresenter.getAccess()).thenReturn((Object)this.access);
        Mockito.when((Object)this.dtPresenterView.getModel()).thenReturn((Object)this.uiModel);
        Mockito.when((Object)this.ts.getTranslation((String)Mockito.any(String.class))).thenReturn((Object)"i18n");
        Mockito.when((Object)this.menuItemViewProducer.select(new Annotation[]{(Annotation)Mockito.any(Annotation.class)})).thenReturn(this.menuItemViewProducer);
        Mockito.when((Object)this.menuItemViewProducer.get()).thenReturn((Object)this.menuItemWithIconView);
        Mockito.when((Object)this.menuItemWithIconView.getElement()).thenReturn((Object)this.menuItemHTMLElement);
        this.uiModel.appendColumn((GridColumn)new BaseGridColumn(this.headerMetaData, this.gridColumnRenderer, 100.0));
        this.uiModel.appendColumn((GridColumn)new BaseGridColumn(this.headerMetaData, this.gridColumnRenderer, 100.0));
        this.uiModel.appendColumn((GridColumn)new BaseGridColumn(this.headerMetaData, this.gridColumnRenderer, 100.0));
        this.uiModel.appendColumn((GridColumn)new BaseGridColumn(this.headerMetaData, this.gridColumnRenderer, 100.0));
        this.uiModel.appendRow((GridRow)new BaseGridRow());
        this.builder = (EditMenuBuilder)Mockito.spy((Object)new EditMenuBuilder(this.clipboard, this.ts, menuItemFactory, this.popoverUtils));
        this.builder.setup();
    }

    @Test
    public void testPopoverSetup() {
        ((DecisionTablePopoverUtils)Mockito.verify((Object)this.popoverUtils)).setupPopover((HTMLElement)Mockito.eq((Object)this.menuItemHTMLElement), Matchers.anyString());
    }

    @Test
    public void testOnDecisionTableSelectedEventWithNoSelections() {
        this.builder.onDecisionTableSelectedEvent(new DecisionTableSelectedEvent(this.dtPresenter));
        Assert.assertFalse((boolean)this.builder.miCut.getMenuItem().isEnabled());
        Assert.assertFalse((boolean)this.builder.miCopy.getMenuItem().isEnabled());
        Assert.assertFalse((boolean)this.builder.miPaste.getMenuItem().isEnabled());
        Assert.assertFalse((boolean)this.builder.miDeleteSelectedCells.getMenuItem().isEnabled());
        Assert.assertFalse((boolean)this.builder.miDeleteSelectedColumns.getMenuItem().isEnabled());
        Assert.assertFalse((boolean)this.builder.miDeleteSelectedRows.getMenuItem().isEnabled());
        Assert.assertFalse((boolean)this.builder.miOtherwiseCell.getMenuItem().isEnabled());
    }

    @Test
    public void testOnDecisionTableSelectedEventWithNonOtherwiseColumnSelectedAndItHasEditableColumnsAndItHasEditableColumns() {
        this.model.getMetadataCols().add(new MetadataCol52());
        this.model.getData().add(this.makeDTCellValue52());
        this.uiModel.selectCell(0, 3);
        this.builder.onDecisionTableSelectedEvent(new DecisionTableSelectedEvent(this.dtPresenter));
        Assert.assertTrue((boolean)this.builder.miCut.getMenuItem().isEnabled());
        Assert.assertTrue((boolean)this.builder.miCopy.getMenuItem().isEnabled());
        Assert.assertFalse((boolean)this.builder.miPaste.getMenuItem().isEnabled());
        Assert.assertTrue((boolean)this.builder.miDeleteSelectedCells.getMenuItem().isEnabled());
        Assert.assertTrue((boolean)this.builder.miDeleteSelectedColumns.getMenuItem().isEnabled());
        Assert.assertTrue((boolean)this.builder.miDeleteSelectedRows.getMenuItem().isEnabled());
        Assert.assertFalse((boolean)this.builder.miOtherwiseCell.getMenuItem().isEnabled());
        ((MenuItemWithIconView)Mockito.verify((Object)this.builder.miOtherwiseCell.getMenuItemView(), (VerificationMode)Mockito.times((int)1))).setIconType((IconType)Mockito.eq(null));
    }

    @Test
    public void testOnDecisionTableSelectedEventWithNonOtherwiseColumnSelectedAndItHasEditableColumnsAndItDoesNotHaveEditableColumns() {
        Mockito.when((Object)this.dtPresenter.hasEditableColumns()).thenReturn((Object)false);
        this.model.getMetadataCols().add(new MetadataCol52());
        this.model.getData().add(this.makeDTCellValue52());
        this.uiModel.selectCell(0, 3);
        this.builder.onDecisionTableSelectedEvent(new DecisionTableSelectedEvent(this.dtPresenter));
        Assert.assertTrue((boolean)this.builder.miCut.getMenuItem().isEnabled());
        Assert.assertTrue((boolean)this.builder.miCopy.getMenuItem().isEnabled());
        Assert.assertFalse((boolean)this.builder.miPaste.getMenuItem().isEnabled());
        Assert.assertTrue((boolean)this.builder.miDeleteSelectedCells.getMenuItem().isEnabled());
        Assert.assertFalse((boolean)this.builder.miDeleteSelectedColumns.getMenuItem().isEnabled());
        Assert.assertTrue((boolean)this.builder.miDeleteSelectedRows.getMenuItem().isEnabled());
        Assert.assertFalse((boolean)this.builder.miOtherwiseCell.getMenuItem().isEnabled());
        ((MenuItemWithIconView)Mockito.verify((Object)this.builder.miOtherwiseCell.getMenuItemView(), (VerificationMode)Mockito.times((int)1))).setIconType((IconType)Mockito.eq(null));
    }

    @Test
    public void testOnDecisionTableSelectedEventWithOtherwiseColumnSelectedAndItHasEditableColumns() {
        this.model.getConditions().add(this.makePattern52());
        this.model.getData().add(this.makeDTCellValue52());
        this.uiModel.selectCell(0, 3);
        this.builder.onDecisionTableSelectedEvent(new DecisionTableSelectedEvent(this.dtPresenter));
        Assert.assertTrue((boolean)this.builder.miCut.getMenuItem().isEnabled());
        Assert.assertTrue((boolean)this.builder.miCopy.getMenuItem().isEnabled());
        Assert.assertFalse((boolean)this.builder.miPaste.getMenuItem().isEnabled());
        Assert.assertTrue((boolean)this.builder.miDeleteSelectedCells.getMenuItem().isEnabled());
        Assert.assertTrue((boolean)this.builder.miDeleteSelectedColumns.getMenuItem().isEnabled());
        Assert.assertTrue((boolean)this.builder.miDeleteSelectedRows.getMenuItem().isEnabled());
        Assert.assertTrue((boolean)this.builder.miOtherwiseCell.getMenuItem().isEnabled());
        ((MenuItemWithIconView)Mockito.verify((Object)this.builder.miOtherwiseCell.getMenuItemView(), (VerificationMode)Mockito.times((int)1))).setIconType((IconType)Mockito.eq(null));
    }

    @Test
    public void testOnDecisionTableSelectedEventWithOtherwiseColumnSelectedAndItDoesNotHaveEditableColumns() {
        Mockito.when((Object)this.dtPresenter.hasEditableColumns()).thenReturn((Object)false);
        this.model.getConditions().add(this.makePattern52());
        this.model.getData().add(this.makeDTCellValue52());
        this.uiModel.selectCell(0, 3);
        this.builder.onDecisionTableSelectedEvent(new DecisionTableSelectedEvent(this.dtPresenter));
        Assert.assertTrue((boolean)this.builder.miCut.getMenuItem().isEnabled());
        Assert.assertTrue((boolean)this.builder.miCopy.getMenuItem().isEnabled());
        Assert.assertFalse((boolean)this.builder.miPaste.getMenuItem().isEnabled());
        Assert.assertTrue((boolean)this.builder.miDeleteSelectedCells.getMenuItem().isEnabled());
        Assert.assertFalse((boolean)this.builder.miDeleteSelectedColumns.getMenuItem().isEnabled());
        Assert.assertTrue((boolean)this.builder.miDeleteSelectedRows.getMenuItem().isEnabled());
        Assert.assertTrue((boolean)this.builder.miOtherwiseCell.getMenuItem().isEnabled());
        ((MenuItemWithIconView)Mockito.verify((Object)this.builder.miOtherwiseCell.getMenuItemView(), (VerificationMode)Mockito.times((int)1))).setIconType((IconType)Mockito.eq(null));
    }

    @Test
    public void testOnDecisionTableSelectedEventWithOtherwiseCellSelectedAndItHasEditableColumns() {
        this.model.getConditions().add(this.makePattern52());
        this.model.getData().add(this.makeDTCellValue52ListWithOtherwise());
        this.uiModel.selectCell(0, 3);
        this.builder.onDecisionTableSelectedEvent(new DecisionTableSelectedEvent(this.dtPresenter));
        Assert.assertTrue((boolean)this.builder.miCut.getMenuItem().isEnabled());
        Assert.assertTrue((boolean)this.builder.miCopy.getMenuItem().isEnabled());
        Assert.assertFalse((boolean)this.builder.miPaste.getMenuItem().isEnabled());
        Assert.assertTrue((boolean)this.builder.miDeleteSelectedCells.getMenuItem().isEnabled());
        Assert.assertTrue((boolean)this.builder.miDeleteSelectedColumns.getMenuItem().isEnabled());
        Assert.assertTrue((boolean)this.builder.miDeleteSelectedRows.getMenuItem().isEnabled());
        Assert.assertTrue((boolean)this.builder.miOtherwiseCell.getMenuItem().isEnabled());
        ((MenuItemWithIconView)Mockito.verify((Object)this.builder.miOtherwiseCell.getMenuItemView(), (VerificationMode)Mockito.times((int)1))).setIconType((IconType)Mockito.eq((Object)IconType.CHECK));
    }

    @Test
    public void testOnDecisionTableSelectedEventWithOtherwiseCellSelectedAndItDoesNotHaveEditableColumns() {
        Mockito.when((Object)this.dtPresenter.hasEditableColumns()).thenReturn((Object)false);
        this.model.getConditions().add(this.makePattern52());
        this.model.getData().add(this.makeDTCellValue52ListWithOtherwise());
        this.uiModel.selectCell(0, 3);
        this.builder.onDecisionTableSelectedEvent(new DecisionTableSelectedEvent(this.dtPresenter));
        Assert.assertTrue((boolean)this.builder.miCut.getMenuItem().isEnabled());
        Assert.assertTrue((boolean)this.builder.miCopy.getMenuItem().isEnabled());
        Assert.assertFalse((boolean)this.builder.miPaste.getMenuItem().isEnabled());
        Assert.assertTrue((boolean)this.builder.miDeleteSelectedCells.getMenuItem().isEnabled());
        Assert.assertFalse((boolean)this.builder.miDeleteSelectedColumns.getMenuItem().isEnabled());
        Assert.assertTrue((boolean)this.builder.miDeleteSelectedRows.getMenuItem().isEnabled());
        Assert.assertTrue((boolean)this.builder.miOtherwiseCell.getMenuItem().isEnabled());
        ((MenuItemWithIconView)Mockito.verify((Object)this.builder.miOtherwiseCell.getMenuItemView(), (VerificationMode)Mockito.times((int)1))).setIconType((IconType)Mockito.eq((Object)IconType.CHECK));
    }

    @Test
    public void testOnDecisionTableSelectedEventWithSelectionsWithClipboardPopulated() {
        this.model.getMetadataCols().add(new MetadataCol52());
        this.model.getData().add(this.makeDTCellValue52());
        this.uiModel.selectCell(0, 3);
        this.clipboard.setData(this.makeClipboardHashSetData());
        this.builder.onDecisionTableSelectedEvent(new DecisionTableSelectedEvent(this.dtPresenter));
        Assert.assertTrue((boolean)this.builder.miCut.getMenuItem().isEnabled());
        Assert.assertTrue((boolean)this.builder.miCopy.getMenuItem().isEnabled());
        Assert.assertTrue((boolean)this.builder.miPaste.getMenuItem().isEnabled());
        Assert.assertTrue((boolean)this.builder.miDeleteSelectedCells.getMenuItem().isEnabled());
        Assert.assertTrue((boolean)this.builder.miDeleteSelectedColumns.getMenuItem().isEnabled());
        Assert.assertTrue((boolean)this.builder.miDeleteSelectedRows.getMenuItem().isEnabled());
        Assert.assertFalse((boolean)this.builder.miOtherwiseCell.getMenuItem().isEnabled());
        ((MenuItemWithIconView)Mockito.verify((Object)this.builder.miOtherwiseCell.getMenuItemView(), (VerificationMode)Mockito.times((int)1))).setIconType((IconType)Mockito.eq(null));
    }

    @Test
    public void testOnDecisionTableSelectionsChangedEventWithNoSelections() {
        this.builder.onDecisionTableSelectionsChangedEvent(new DecisionTableSelectionsChangedEvent(this.dtPresenter));
        Assert.assertFalse((boolean)this.builder.miCut.getMenuItem().isEnabled());
        Assert.assertFalse((boolean)this.builder.miCopy.getMenuItem().isEnabled());
        Assert.assertFalse((boolean)this.builder.miPaste.getMenuItem().isEnabled());
        Assert.assertFalse((boolean)this.builder.miDeleteSelectedCells.getMenuItem().isEnabled());
        Assert.assertFalse((boolean)this.builder.miDeleteSelectedColumns.getMenuItem().isEnabled());
        Assert.assertFalse((boolean)this.builder.miDeleteSelectedRows.getMenuItem().isEnabled());
        Assert.assertFalse((boolean)this.builder.miOtherwiseCell.getMenuItem().isEnabled());
    }

    @Test
    public void testOnDecisionTableSelectionsChangedEventWithNonOtherwiseColumnSelectedAndItHasEditableColumns() {
        this.model.getMetadataCols().add(new MetadataCol52());
        this.model.getData().add(this.makeDTCellValue52());
        this.uiModel.selectCell(0, 3);
        this.builder.onDecisionTableSelectionsChangedEvent(new DecisionTableSelectionsChangedEvent(this.dtPresenter));
        Assert.assertTrue((boolean)this.builder.miCut.getMenuItem().isEnabled());
        Assert.assertTrue((boolean)this.builder.miCopy.getMenuItem().isEnabled());
        Assert.assertFalse((boolean)this.builder.miPaste.getMenuItem().isEnabled());
        Assert.assertTrue((boolean)this.builder.miDeleteSelectedCells.getMenuItem().isEnabled());
        Assert.assertTrue((boolean)this.builder.miDeleteSelectedColumns.getMenuItem().isEnabled());
        Assert.assertTrue((boolean)this.builder.miDeleteSelectedRows.getMenuItem().isEnabled());
        Assert.assertFalse((boolean)this.builder.miOtherwiseCell.getMenuItem().isEnabled());
        ((MenuItemWithIconView)Mockito.verify((Object)this.builder.miOtherwiseCell.getMenuItemView(), (VerificationMode)Mockito.times((int)1))).setIconType((IconType)Mockito.eq(null));
    }

    @Test
    public void testOnDecisionTableSelectionsChangedEventWithNonOtherwiseColumnSelectedAndItDoesNotHaveEditableColumns() {
        Mockito.when((Object)this.dtPresenter.hasEditableColumns()).thenReturn((Object)false);
        this.model.getMetadataCols().add(new MetadataCol52());
        this.model.getData().add(this.makeDTCellValue52());
        this.uiModel.selectCell(0, 3);
        this.builder.onDecisionTableSelectionsChangedEvent(new DecisionTableSelectionsChangedEvent(this.dtPresenter));
        Assert.assertTrue((boolean)this.builder.miCut.getMenuItem().isEnabled());
        Assert.assertTrue((boolean)this.builder.miCopy.getMenuItem().isEnabled());
        Assert.assertFalse((boolean)this.builder.miPaste.getMenuItem().isEnabled());
        Assert.assertTrue((boolean)this.builder.miDeleteSelectedCells.getMenuItem().isEnabled());
        Assert.assertFalse((boolean)this.builder.miDeleteSelectedColumns.getMenuItem().isEnabled());
        Assert.assertTrue((boolean)this.builder.miDeleteSelectedRows.getMenuItem().isEnabled());
        Assert.assertFalse((boolean)this.builder.miOtherwiseCell.getMenuItem().isEnabled());
        ((MenuItemWithIconView)Mockito.verify((Object)this.builder.miOtherwiseCell.getMenuItemView(), (VerificationMode)Mockito.times((int)1))).setIconType((IconType)Mockito.eq(null));
    }

    @Test
    public void testOnDecisionTableSelectionsChangedEventWithOtherwiseColumnSelectedAndItHasEditableColumns() {
        this.model.getConditions().add(this.makePattern52());
        this.model.getData().add(this.makeDTCellValue52());
        this.uiModel.selectCell(0, 3);
        this.builder.onDecisionTableSelectionsChangedEvent(new DecisionTableSelectionsChangedEvent(this.dtPresenter));
        Assert.assertTrue((boolean)this.builder.miCut.getMenuItem().isEnabled());
        Assert.assertTrue((boolean)this.builder.miCopy.getMenuItem().isEnabled());
        Assert.assertFalse((boolean)this.builder.miPaste.getMenuItem().isEnabled());
        Assert.assertTrue((boolean)this.builder.miDeleteSelectedCells.getMenuItem().isEnabled());
        Assert.assertTrue((boolean)this.builder.miDeleteSelectedColumns.getMenuItem().isEnabled());
        Assert.assertTrue((boolean)this.builder.miDeleteSelectedRows.getMenuItem().isEnabled());
        Assert.assertTrue((boolean)this.builder.miOtherwiseCell.getMenuItem().isEnabled());
        ((MenuItemWithIconView)Mockito.verify((Object)this.builder.miOtherwiseCell.getMenuItemView(), (VerificationMode)Mockito.times((int)1))).setIconType((IconType)Mockito.eq(null));
    }

    @Test
    public void testOnDecisionTableSelectionsChangedEventWithOtherwiseColumnSelectedAndItDoesNotHaveEditableColumns() {
        Mockito.when((Object)this.dtPresenter.hasEditableColumns()).thenReturn((Object)false);
        this.model.getConditions().add(this.makePattern52());
        this.model.getData().add(this.makeDTCellValue52());
        this.uiModel.selectCell(0, 3);
        this.builder.onDecisionTableSelectionsChangedEvent(new DecisionTableSelectionsChangedEvent(this.dtPresenter));
        Assert.assertTrue((boolean)this.builder.miCut.getMenuItem().isEnabled());
        Assert.assertTrue((boolean)this.builder.miCopy.getMenuItem().isEnabled());
        Assert.assertFalse((boolean)this.builder.miPaste.getMenuItem().isEnabled());
        Assert.assertTrue((boolean)this.builder.miDeleteSelectedCells.getMenuItem().isEnabled());
        Assert.assertFalse((boolean)this.builder.miDeleteSelectedColumns.getMenuItem().isEnabled());
        Assert.assertTrue((boolean)this.builder.miDeleteSelectedRows.getMenuItem().isEnabled());
        Assert.assertTrue((boolean)this.builder.miOtherwiseCell.getMenuItem().isEnabled());
        ((MenuItemWithIconView)Mockito.verify((Object)this.builder.miOtherwiseCell.getMenuItemView(), (VerificationMode)Mockito.times((int)1))).setIconType((IconType)Mockito.eq(null));
    }

    @Test
    public void testOnDecisionTableSelectionsChangedEventWithOtherwiseCellSelectedAndItHasEditableColumns() {
        this.model.getConditions().add(this.makePattern52());
        this.model.getData().add(this.makeDTCellValue52ListWithOtherwise());
        this.uiModel.selectCell(0, 3);
        this.builder.onDecisionTableSelectionsChangedEvent(new DecisionTableSelectionsChangedEvent(this.dtPresenter));
        Assert.assertTrue((boolean)this.builder.miCut.getMenuItem().isEnabled());
        Assert.assertTrue((boolean)this.builder.miCopy.getMenuItem().isEnabled());
        Assert.assertFalse((boolean)this.builder.miPaste.getMenuItem().isEnabled());
        Assert.assertTrue((boolean)this.builder.miDeleteSelectedCells.getMenuItem().isEnabled());
        Assert.assertTrue((boolean)this.builder.miDeleteSelectedColumns.getMenuItem().isEnabled());
        Assert.assertTrue((boolean)this.builder.miDeleteSelectedRows.getMenuItem().isEnabled());
        Assert.assertTrue((boolean)this.builder.miOtherwiseCell.getMenuItem().isEnabled());
        ((MenuItemWithIconView)Mockito.verify((Object)this.builder.miOtherwiseCell.getMenuItemView(), (VerificationMode)Mockito.times((int)1))).setIconType((IconType)Mockito.eq((Object)IconType.CHECK));
    }

    @Test
    public void testOnDecisionTableSelectionsChangedEventWithOtherwiseCellSelectedAndItDoesNotHaveEditableColumns() {
        Mockito.when((Object)this.dtPresenter.hasEditableColumns()).thenReturn((Object)false);
        this.model.getConditions().add(this.makePattern52());
        this.model.getData().add(this.makeDTCellValue52ListWithOtherwise());
        this.uiModel.selectCell(0, 3);
        this.builder.onDecisionTableSelectionsChangedEvent(new DecisionTableSelectionsChangedEvent(this.dtPresenter));
        Assert.assertTrue((boolean)this.builder.miCut.getMenuItem().isEnabled());
        Assert.assertTrue((boolean)this.builder.miCopy.getMenuItem().isEnabled());
        Assert.assertFalse((boolean)this.builder.miPaste.getMenuItem().isEnabled());
        Assert.assertTrue((boolean)this.builder.miDeleteSelectedCells.getMenuItem().isEnabled());
        Assert.assertFalse((boolean)this.builder.miDeleteSelectedColumns.getMenuItem().isEnabled());
        Assert.assertTrue((boolean)this.builder.miDeleteSelectedRows.getMenuItem().isEnabled());
        Assert.assertTrue((boolean)this.builder.miOtherwiseCell.getMenuItem().isEnabled());
        ((MenuItemWithIconView)Mockito.verify((Object)this.builder.miOtherwiseCell.getMenuItemView(), (VerificationMode)Mockito.times((int)1))).setIconType((IconType)Mockito.eq((Object)IconType.CHECK));
    }

    @Test
    public void testOnDecisionTableSelectionsChangedEventWithSelectionsWithClipboardPopulatedAndItHasEditableColumns() {
        this.model.getMetadataCols().add(new MetadataCol52());
        this.model.getData().add(this.makeDTCellValue52());
        this.uiModel.selectCell(0, 3);
        this.clipboard.setData(this.makeClipboardHashSetData());
        this.builder.onDecisionTableSelectionsChangedEvent(new DecisionTableSelectionsChangedEvent(this.dtPresenter));
        Assert.assertTrue((boolean)this.builder.miCut.getMenuItem().isEnabled());
        Assert.assertTrue((boolean)this.builder.miCopy.getMenuItem().isEnabled());
        Assert.assertTrue((boolean)this.builder.miPaste.getMenuItem().isEnabled());
        Assert.assertTrue((boolean)this.builder.miDeleteSelectedCells.getMenuItem().isEnabled());
        Assert.assertTrue((boolean)this.builder.miDeleteSelectedColumns.getMenuItem().isEnabled());
        Assert.assertTrue((boolean)this.builder.miDeleteSelectedRows.getMenuItem().isEnabled());
        Assert.assertFalse((boolean)this.builder.miOtherwiseCell.getMenuItem().isEnabled());
        ((MenuItemWithIconView)Mockito.verify((Object)this.builder.miOtherwiseCell.getMenuItemView(), (VerificationMode)Mockito.times((int)1))).setIconType((IconType)Mockito.eq(null));
    }

    @Test
    public void testOnDecisionTableSelectionsChangedEventWithSelectionsWithClipboardPopulatedAndItDoesNotHaveEditableColumns() {
        Mockito.when((Object)this.dtPresenter.hasEditableColumns()).thenReturn((Object)false);
        this.model.getMetadataCols().add(new MetadataCol52());
        this.model.getData().add(this.makeDTCellValue52());
        this.uiModel.selectCell(0, 3);
        this.clipboard.setData(this.makeClipboardHashSetData());
        this.builder.onDecisionTableSelectionsChangedEvent(new DecisionTableSelectionsChangedEvent(this.dtPresenter));
        Assert.assertTrue((boolean)this.builder.miCut.getMenuItem().isEnabled());
        Assert.assertTrue((boolean)this.builder.miCopy.getMenuItem().isEnabled());
        Assert.assertTrue((boolean)this.builder.miPaste.getMenuItem().isEnabled());
        Assert.assertTrue((boolean)this.builder.miDeleteSelectedCells.getMenuItem().isEnabled());
        Assert.assertFalse((boolean)this.builder.miDeleteSelectedColumns.getMenuItem().isEnabled());
        Assert.assertTrue((boolean)this.builder.miDeleteSelectedRows.getMenuItem().isEnabled());
        Assert.assertFalse((boolean)this.builder.miOtherwiseCell.getMenuItem().isEnabled());
        ((MenuItemWithIconView)Mockito.verify((Object)this.builder.miOtherwiseCell.getMenuItemView(), (VerificationMode)Mockito.times((int)1))).setIconType((IconType)Mockito.eq(null));
    }

    @Test
    public void testOnDecisionTableSelectedEventReadOnly() {
        this.dtPresenter.getAccess().setReadOnly(true);
        this.builder.onDecisionTableSelectedEvent(new DecisionTableSelectedEvent(this.dtPresenter));
        Assert.assertFalse((boolean)this.builder.miCut.getMenuItem().isEnabled());
        Assert.assertFalse((boolean)this.builder.miCopy.getMenuItem().isEnabled());
        Assert.assertFalse((boolean)this.builder.miPaste.getMenuItem().isEnabled());
        Assert.assertFalse((boolean)this.builder.miDeleteSelectedCells.getMenuItem().isEnabled());
        Assert.assertFalse((boolean)this.builder.miDeleteSelectedColumns.getMenuItem().isEnabled());
        Assert.assertFalse((boolean)this.builder.miDeleteSelectedRows.getMenuItem().isEnabled());
        Assert.assertFalse((boolean)this.builder.miOtherwiseCell.getMenuItem().isEnabled());
    }

    @Test
    public void testOnRefreshMenusEvent() {
        this.builder.onRefreshMenusEvent(new RefreshMenusEvent());
        ((EditMenuBuilder)Mockito.verify((Object)this.builder)).initialise();
    }

    private HashSet<Clipboard.ClipboardData> makeClipboardHashSetData() {
        return new HashSet<Clipboard.ClipboardData>(){
            {
                this.add(EditMenuBuilderTest.this.makeDefaultClipboard());
            }
        };
    }

    private DefaultClipboard.ClipboardDataImpl makeDefaultClipboard() {
        DTCellValue52 dtCellValue52 = (DTCellValue52)((List)this.model.getData().get(0)).get(3);
        return new DefaultClipboard.ClipboardDataImpl(0, 3, dtCellValue52);
    }

    private Pattern52 makePattern52() {
        return new Pattern52(){
            {
                this.setFactType("Fact");
                this.getChildColumns().add(new ConditionCol52(){
                    {
                        this.setFactType("Fact");
                        this.setFactField("field1");
                        this.setFieldType("String");
                        this.setOperator("==");
                    }
                });
            }
        };
    }

    private List<DTCellValue52> makeDTCellValue52() {
        return new ArrayList<DTCellValue52>(){
            {
                this.add(new DTCellValue52(Integer.valueOf(1)));
                this.add(new DTCellValue52(""));
                this.add(new DTCellValue52("descr"));
                this.add(new DTCellValue52("md"));
            }
        };
    }

    private List<DTCellValue52> makeDTCellValue52ListWithOtherwise() {
        return new ArrayList<DTCellValue52>(){
            {
                this.add(new DTCellValue52(Integer.valueOf(1)));
                this.add(new DTCellValue52(""));
                this.add(new DTCellValue52("descr"));
                this.add(new DTCellValue52(){
                    {
                        this.setOtherwise(true);
                    }
                });
            }
        };
    }
}

