/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.handlers;

import com.google.gwtmockito.GwtMockitoTestRunner;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.screens.guided.dtable.client.handlers.GuidedDecisionTableOptions;
import org.drools.workbench.screens.guided.dtable.client.handlers.HitPolicySelector;
import org.drools.workbench.screens.guided.dtable.client.resources.HitPolicyInternationalizer;
import org.gwtbootstrap3.client.ui.Heading;
import org.gwtbootstrap3.client.ui.html.Paragraph;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.uberfire.client.callbacks.Callback;

@RunWith(value=GwtMockitoTestRunner.class)
public class GuidedDecisionTableOptionsTest {
    @Mock
    private HitPolicySelector selector;
    @Captor
    private ArgumentCaptor<Callback<GuidedDecisionTable52.HitPolicy>> callback;
    private GuidedDecisionTableOptions options;

    @Before
    public void setUp() throws Exception {
        this.options = new GuidedDecisionTableOptions(this.selector);
        this.options.hitPolicyDescriptionHeading = (Heading)Mockito.mock(Heading.class);
        this.options.hitPolicyDescriptionText = (Paragraph)Mockito.mock(Paragraph.class);
    }

    @Test
    public void testNoneHitPolicyDescription() throws Exception {
        this.testHitPolicy(GuidedDecisionTable52.HitPolicy.NONE);
    }

    @Test
    public void testResolvedHitPolicyDescription() throws Exception {
        this.testHitPolicy(GuidedDecisionTable52.HitPolicy.RESOLVED_HIT);
    }

    @Test
    public void testRuleOrderHitPolicyDescription() throws Exception {
        this.testHitPolicy(GuidedDecisionTable52.HitPolicy.RULE_ORDER);
    }

    @Test
    public void testUniqueHitPolicyDescription() throws Exception {
        this.testHitPolicy(GuidedDecisionTable52.HitPolicy.UNIQUE_HIT);
    }

    @Test
    public void testFirstHitPolicyDescription() throws Exception {
        this.testHitPolicy(GuidedDecisionTable52.HitPolicy.FIRST_HIT);
    }

    private void testHitPolicy(GuidedDecisionTable52.HitPolicy hitPolicy) {
        ((HitPolicySelector)Mockito.verify((Object)this.selector)).addValueChangeHandler((Callback)this.callback.capture());
        ((Callback)this.callback.getValue()).callback((Object)hitPolicy);
        ((Heading)Mockito.verify((Object)this.options.hitPolicyDescriptionHeading)).setText(HitPolicyInternationalizer.internationalize((GuidedDecisionTable52.HitPolicy)hitPolicy));
        ((Paragraph)Mockito.verify((Object)this.options.hitPolicyDescriptionText)).setText(HitPolicyInternationalizer.internationalizeDescription((GuidedDecisionTable52.HitPolicy)hitPolicy));
    }
}

