/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.analysis;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.drools.workbench.models.guided.dtable.shared.model.ActionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.BRLActionColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BRLActionVariableColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BRLConditionColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BRLConditionVariableColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BaseColumn;
import org.drools.workbench.models.guided.dtable.shared.model.ConditionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.models.guided.dtable.shared.model.Pattern52;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.DTableUpdateManager;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.DecisionTableAnalyzer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.services.verifier.reporting.client.analysis.VerifierWebWorkerConnection;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;

@RunWith(value=GwtMockitoTestRunner.class)
public class DecisionTableAnalyzerTest {
    private List<ActionCol52> actionColumns;
    private List<ConditionCol52> conditionColumns;
    private List<Pattern52> patterns;
    private Pattern52 pattern;
    private VerifierWebWorkerConnection connection;
    private DTableUpdateManager updateManager;
    private GuidedDecisionTable52 model;
    private DecisionTableAnalyzer decisionTableAnalyzer;

    @Before
    public void setUp() throws Exception {
        this.actionColumns = new ArrayList<ActionCol52>();
        this.conditionColumns = new ArrayList<ConditionCol52>();
        this.patterns = new ArrayList<Pattern52>();
        this.pattern = new Pattern52();
        this.connection = (VerifierWebWorkerConnection)Mockito.mock(VerifierWebWorkerConnection.class);
        this.updateManager = (DTableUpdateManager)Mockito.mock(DTableUpdateManager.class);
        this.model = new GuidedDecisionTable52();
        this.decisionTableAnalyzer = new DecisionTableAnalyzer(this.model, this.updateManager, this.connection);
    }

    @Test
    public void testOnFocus() throws Exception {
        List updates = Collections.emptyList();
        this.decisionTableAnalyzer.analyze(updates);
        ArgumentCaptor argumentCaptor = ArgumentCaptor.forClass(List.class);
        ((DTableUpdateManager)Mockito.verify((Object)this.updateManager)).update((GuidedDecisionTable52)Mockito.eq((Object)this.model), (List)argumentCaptor.capture());
        Assert.assertTrue((boolean)((List)argumentCaptor.getValue()).isEmpty());
        this.decisionTableAnalyzer.activate();
        ((VerifierWebWorkerConnection)Mockito.verify((Object)this.connection)).activate();
    }

    @Test
    public void testInsertConditionColumn() throws Exception {
        ConditionCol52 a = new ConditionCol52();
        ConditionCol52 b = new ConditionCol52();
        this.conditionColumns.add(a);
        this.conditionColumns.add(b);
        this.pattern.setChildColumns(this.conditionColumns);
        this.patterns.add(this.pattern);
        this.model.getConditions().addAll(this.patterns);
        this.decisionTableAnalyzer.insertColumn((BaseColumn)a);
        ((DTableUpdateManager)Mockito.verify((Object)this.updateManager)).newColumn(this.model, 3);
    }

    @Test
    public void testInsertActionColumn() throws Exception {
        ActionCol52 a = new ActionCol52();
        a.setHeader("A");
        ActionCol52 b = new ActionCol52();
        b.setHeader("B");
        this.actionColumns.add(a);
        this.actionColumns.add(b);
        this.model.setActionCols(this.actionColumns);
        this.decisionTableAnalyzer.insertColumn((BaseColumn)b);
        ((DTableUpdateManager)Mockito.verify((Object)this.updateManager)).newColumn(this.model, 4);
    }

    @Test
    public void testInsertBRLConditionColumn() throws Exception {
        BRLConditionColumn brlConditionOne = new BRLConditionColumn();
        BRLConditionVariableColumn a = new BRLConditionVariableColumn();
        a.setHeader("A");
        BRLConditionVariableColumn b = new BRLConditionVariableColumn();
        b.setHeader("B");
        BRLConditionColumn brlConditionTwo = new BRLConditionColumn();
        BRLConditionVariableColumn c = new BRLConditionVariableColumn();
        BRLConditionVariableColumn d = new BRLConditionVariableColumn();
        brlConditionOne.setChildColumns(Arrays.asList(a, b));
        brlConditionTwo.setChildColumns(Arrays.asList(c, d));
        this.model.getConditions().addAll(Arrays.asList(brlConditionOne, brlConditionTwo));
        this.decisionTableAnalyzer.insertColumn((BaseColumn)brlConditionTwo);
        ((DTableUpdateManager)Mockito.verify((Object)this.updateManager)).newColumn(this.model, 5);
    }

    @Test
    public void testInsertBRLActionColumn() throws Exception {
        BRLActionColumn brlActionOne = new BRLActionColumn();
        BRLActionVariableColumn a = new BRLActionVariableColumn();
        BRLActionVariableColumn b = new BRLActionVariableColumn();
        BRLActionColumn brlActionTwo = new BRLActionColumn();
        BRLActionVariableColumn c = new BRLActionVariableColumn();
        BRLActionVariableColumn d = new BRLActionVariableColumn();
        brlActionOne.setChildColumns(Arrays.asList(a, b));
        brlActionTwo.setChildColumns(Arrays.asList(c, d));
        this.model.setActionCols(Arrays.asList(brlActionOne, brlActionTwo));
        this.decisionTableAnalyzer.insertColumn((BaseColumn)brlActionOne);
        ((DTableUpdateManager)Mockito.verify((Object)this.updateManager)).newColumn(this.model, 3);
    }

    @Test
    public void testInsertBRLVariableColumn() throws Exception {
        ConditionCol52 a = new ConditionCol52();
        a.setHeader("A");
        ConditionCol52 b = new ConditionCol52();
        b.setHeader("B");
        this.pattern.setChildColumns(Arrays.asList(a, b));
        BRLConditionColumn brlCondition = new BRLConditionColumn();
        BRLConditionVariableColumn c = new BRLConditionVariableColumn();
        c.setHeader("C");
        BRLConditionVariableColumn d = new BRLConditionVariableColumn();
        d.setHeader("D");
        brlCondition.setChildColumns(Arrays.asList(c, d));
        this.model.getConditions().addAll(Arrays.asList(this.pattern, brlCondition));
        this.decisionTableAnalyzer.insertColumn((BaseColumn)d);
        ((DTableUpdateManager)Mockito.verify((Object)this.updateManager)).newColumn(this.model, 6);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInsertNonExistingColumn() throws Exception {
        ConditionCol52 a = new ConditionCol52();
        a.setHeader("A");
        ConditionCol52 b = new ConditionCol52();
        b.setHeader("B");
        this.pattern.setChildColumns(Arrays.asList(a));
        BRLConditionColumn brlCondition = new BRLConditionColumn();
        BRLConditionVariableColumn c = new BRLConditionVariableColumn();
        BRLConditionVariableColumn d = new BRLConditionVariableColumn();
        brlCondition.setChildColumns(Arrays.asList(c, d));
        this.model.getConditions().addAll(Arrays.asList(this.pattern, brlCondition));
        this.decisionTableAnalyzer.insertColumn((BaseColumn)b);
    }
}

