/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.table.columns;

import com.ait.lienzo.client.core.shape.Text;
import com.ait.lienzo.test.LienzoMockitoTestRunner;
import com.google.gwt.i18n.client.DateTimeFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.drools.workbench.screens.guided.dtable.client.widget.table.columns.BaseSingletonDOMElementUiColumn;
import org.drools.workbench.screens.guided.dtable.client.widget.table.columns.DateUiColumn;
import org.drools.workbench.screens.guided.dtable.client.widget.table.columns.dom.datepicker.DatePickerDOMElement;
import org.drools.workbench.screens.guided.dtable.client.widget.table.columns.dom.datepicker.DatePickerSingletonDOMElementFactory;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.services.shared.preferences.ApplicationPreferences;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.uberfire.ext.widgets.common.client.common.DatePicker;
import org.uberfire.ext.wires.core.grids.client.widget.context.GridBodyCellRenderContext;

@RunWith(value=LienzoMockitoTestRunner.class)
public class DateUiColumnTest {
    private static final String TEST_DATE_FORMAT = "MM-dd-yyyy HH:mm:ss Z";
    @Mock
    private DatePickerSingletonDOMElementFactory factory;

    @BeforeClass
    public static void setup() {
        System.setProperty("user.timezone", "Europe/Vilnius");
        ApplicationPreferences.setUp((Map)new HashMap<String, String>(){
            {
                this.put("kie_timezone_offset", "10800000");
                this.put("drools.dateformat", DateUiColumnTest.TEST_DATE_FORMAT);
            }
        });
    }

    @Test
    public void testDateUiColumnTextFormat() {
        Text text = (Text)Mockito.mock(Text.class);
        GridBodyCellRenderContext context = (GridBodyCellRenderContext)Mockito.mock(GridBodyCellRenderContext.class);
        String clientDate = "05-01-2018 00:00:00 -0300";
        String clientFormattedWithServerTimeZoneDate = "05-01-2018 06:00:00 +0300";
        this.renderer().doRenderCellContent(text, (Object)this.date("05-01-2018 00:00:00 -0300"), context);
        ((Text)Mockito.verify((Object)text)).setText("05-01-2018 06:00:00 +0300");
    }

    private BaseSingletonDOMElementUiColumn.CellRenderer<Date, DatePicker, DatePickerDOMElement> renderer() {
        return DateUiColumn.makeColumnRenderer((DatePickerSingletonDOMElementFactory)this.factory);
    }

    private Date date(String dateString) {
        return DateTimeFormat.getFormat((String)TEST_DATE_FORMAT).parse(dateString);
    }
}

